/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       vipimage.c
**     SYSTEM   NAME:       VIP
**     ORIGINAL AUTHOR(S):  Alfred Kayser
**     VERSION  NUMBER:     1.00
**     CREATION DATE:       1992/5/29
**
** DESCRIPTION: Module with Image Handling Functions
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision$
** WORKFILE:    $Workfile$
** LOGINFO:     $Log$
*************************************************************************/
#include "vipinc.h"

IMPORT VIPIMAGE *imageList;
IMPORT HAB hab;

/**************************************************************
** NAME:        VipCreateImage
** SYNOPSIS:    EXPORT VIPIMAGE *VipCreateImage
**               (int depth, int xSize, int ySize, BYTE *data);
** DESCRIPTION: Creates an image instance.
**              The image has <depth> bits per pixel and is
**              <xSize> by <ySize> large.
**              <depth> can only be 1.
**              When <depth> is 1, the bits are packed into a
**              byte, the highest bit, is the leftmost pixel.
**              When <xSize> is not a multiple of eight, the
**              byte of each line is padded with 0's.
** RETURNS:     Pointer to image instance.
**************************************************************/
EXPORT VIPIMAGE *
VipCreateImage(int depth, int xSize, int ySize, BYTE *data)
{
    VIPIMAGE *pt;
    pt = VipMalloc(sizeof(VIPIMAGE));
    if (!pt) return NULL;
    pt->depth=depth;
    pt->cx=xSize;
    pt->cy=ySize;
    pt->data=data;
    pt->next=imageList;
    imageList=pt;
    return pt;
}


/**************************************************************
** NAME:        VipDestroyImage
** SYNOPSIS:    EXPORT BOOLEAN VipDestroyImage(VIPIMAGE *pt)
** DESCRIPTION: Destroys the image instance, wont
**              free the bitmap data.
** RETURNS:     void
**************************************************************/
EXPORT BOOLEAN
VipDestroyImage(VIPIMAGE *pt)
{
    VIPIMAGE **pl;

    if (!pt) return FALSE;
    for (pl=&imageList;*pl;pl=&((*pl)->next))
        if (*pl==pt)
        {
            *pl=pt->next;
            DnpapFree(pt);
            return TRUE;
        }
    DnpapMessage(DMC_ERROR, VIPERR_IMAGE,"VipDestroyImage: image not found!");
    return FALSE;
}

