/*
 * NUKESPY      Small program meant to run in a background window, monitors  
 *              incoming ICMP packets and reports on them.  Displays the 
 *              date/time, source and type of any packets received.
 *
 * Version:	nukespy.c v1.0 10/22/95
 *
 * Authors:	Mike McLagan, <mmclagan@invlogic.com>
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 */

#define INCL_DOS
#include <os2.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <types.h>
#include <ctype.h>
#include <time.h>

#include <nerrno.h>
#include <netdb.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/select.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include <utils.h>

int sock_nuke;

unsigned long nuke_check(void)
{
   struct sockaddr_in addr;
   int                len, hlen, bytes;
   char               buf[BUFSIZ + 1], *type, line[20], *ts;
   struct ip          *hdr, *data;
   struct icmp        *icmp;
   struct in_addr     in_addr;
   int                x;
   struct hostent     *he;
   time_t             now;
   struct tm         *breakdown;

   while (1)
   {
      memset(&addr, 0, sizeof(addr));
      addr.sin_family = AF_INET;
      bytes = recvfrom(sock_nuke, buf, sizeof(buf), 0, (struct sockaddr *) (void *) &addr, &len);

      if (bytes > 0)
      {
          hdr = (struct ip *) buf;
          hlen = hdr->ip_hl << 2;

          if (bytes >= hlen + ICMP_MINLEN)
          {
             in_addr.s_addr = hdr->ip_src.s_addr;
             bytes -= hlen + 4;
             icmp = (struct icmp *)(buf + hlen + 4);
             if (icmp->icmp_type == ICMP_UNREACH)
             {
                switch(icmp->icmp_code)
                {
                   case ICMP_UNREACH_NET:
                      type = "Network unreachable";
                      break;
                   case ICMP_UNREACH_HOST:
                      type = "Host unreachable";
                      break;
                   case ICMP_UNREACH_PROTOCOL:
                      type = "Invalid protocol";
                      break;
                   case ICMP_UNREACH_PORT:
                      type = "Invalid port";
                      break;
                   case ICMP_UNREACH_NEEDFRAG:
                      type = "Need fragmenting";
                      break;
                   case ICMP_UNREACH_SRCFAIL:
                      type = "Source route failure";
                      break;
                   default: 
                      sprintf(line, "Unknown #%i", icmp->icmp_code);
                      type = line;
                      break;
                }

                time(&now);
                breakdown = localtime(&now);

                x = 0;
                while(((he=gethostbyaddr((char *)&hdr->ip_src, sizeof(hdr->ip_src), AF_INET)) == NULL) && 
                      (h_errno == TRY_AGAIN) && 
                      (x++ < 4))
                   DosSleep(1);

                if (he)
                   printf("%02i/%02i %02i:%02i - UNREACH packet from %s(%s): %s\n", 
                          breakdown->tm_mon + 1, breakdown->tm_mday, breakdown->tm_hour, breakdown->tm_min,
                          he->h_name, inet_ntoa(in_addr), type);
                else
                   printf("%02i/%02i %02i:%02i - UNREACH packet from %s: %s\n", 
                          breakdown->tm_mon + 1, breakdown->tm_mday, breakdown->tm_hour, breakdown->tm_min,
                          inet_ntoa(in_addr), type);
             }
          }
      }
   }
}

void nukewatch(void)
{
   struct protoent    *proto;
   struct sockaddr_in addr;
   int                sock, p_proto;
   int                dontblock;

   sock_nuke = 0;

   proto = getprotobyname("icmp");
   if (!proto)
      p_proto = 1;
   else
      p_proto = proto->p_proto;

   sock = socket(AF_INET, SOCK_RAW, p_proto);

   addr.sin_family = AF_INET;
   addr.sin_port = INADDR_ANY;
   addr.sin_addr.s_addr = INADDR_ANY;

   sock_nuke = sock;
}

void main (void)
{
   printf("Nuke Spy v1.0, Copyright @1995, Innovative Logic Corp\n");
   nukewatch();
   nuke_check();
}
