/***************************************************************************
****************************************************************************/
call RxFuncAdd 'SysSleep','RexxUtil','SysSleep'
call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs
call RxFuncAdd 'FtpLoadFuncs','rxFtp','FtpLoadFuncs'
call FtpLoadFuncs

/**************************************************************************/
/*                                                                        */
/*      there are some commands which vcan be send to 'isdnPm' over      */
/*      a named PIPE ("\PIPE\ISDNPM.CMD") .                               */
/*                                                                        */
/*                                                                        */
/*                                                                        */
/*       'FIRSTUSER' returns the first Userentry                          */
/*       'NEXTUSER'  returns the following Userentries                    */
/*                                                                        */
/*       'CHANNELSTATUS <n>' returns the state of the channel <n>         */
/*       'CHANNELSTATUS <u>' returns the state of the user    <u>         */
/*                                                                        */
/*       'CONNECT <u>' connects to the user <u>                           */
/*       'DISCONNECT <u>' disconnects the user <u>                        */
/*       'DISCONNECT <n>' disconnects the the channel <n>                 */
/*                                                                        */
/*       'CHANGEUSER <u> AUTODIAL ON'  turns the AUTODIAL on for <u>      */
/*       'CHANGEUSER <u> AUTODIAL OFF' turns the AUTODIAL off for <u>     */
/*                                                                        */
/*                                                                        */
/**************************************************************************/


/**************************************************************************/
/*  this example shows the usage of this commands                         */
/*       this example connects to the user 'test'                         */
/*       waits for a connection                                           */
/*       transfers a file                                                 */
/*       and disconnect                                                   */
/**************************************************************************/


PIPE = "\PIPE\ISDNPM.CMD"

    say
    say "Read the 1st 2nd and 3rd Userentry"
    say

    say SendCommandAndWAit("FIRSTUSER")
    say SendCommandAndWAit("NEXTUSER")
    say SendCommandAndWAit("NEXTUSER")

    say
    say "show the state of channel 0 and channel 1 "
    say

    say SendCommandAndWAit("CHANNELSTATUS 0")
    say SendCommandAndWAit("CHANNELSTATUS 1")


    say
    say "connect to user test"
    say

    say SendCommandAndWAit("CONNECT test")

    status = 'R'

    do while status <> 'G'

        call SysSleep(1)
        cs = SendCommandAndWAit("CHANNELSTATUS test")

        parse var CS cmd ch usr status  txc txp rxc rxp dur charge dis l3err
        say status

    end

    say
    say "wait 5 seconds an then get a file"
    say

    call SysSleep(5)

    rc = FtpSetUser('ftp.uni-freiburg.de','anonymous','mywi')
    if rc = 1 then do

        rc = FtpChdir('pub/pc/os2/isdn')
        rc = Ftpget('isdnpm27.zip','isdnpm27.zip','BINARY')

        rc = FtpLogOff()

        call SysSleep(10)

    end
    say
    say 'now disconnect test'
    say
    say SendCommandAndWAit("DISCONNECT test")



exit 0
/**************************************************************************/
/* send a command to the PIPE and wait for an answer                      */
/**************************************************************************/
SendCommandAndWait:
parse arg Command

    rc = SysWaitNamedPipe(PIPE,5000)
    if( rc = 0 )then do

        rc = charout(PIPE,Command)
        cnt = 0
        do while cnt == 0
          cnt = chars(PIPE)
        end
        in  = charin(PIPE,,100)
        return in
    end
    else
        return "TIMEOUT"

