/* Ansi_Say.CMD */

        /****************************************************************************************/
        /* Version 1.     29 dec 95      General mainstream.                                    */
        /*                               Define lay-out of .RSC file.                           */
        /*--------------------------------------------------------------------------------------*/
        /* Version 2.     30 dec 95      Read .RSC completely into memory.                      */
        /*                               This allows the Ansi Topics to be in any order.        */
        /*--------------------------------------------------------------------------------------*/
        /* Version 3.      2 jan 96      Remember the last Ansi Color sequence.                 */
        /*                               This allows control over the Variable's color          */
        /*                               to be stored inside the .RSC file.                     */
        /****************************************************************************************/


        /****************************************************************************************/
        /* Needs :      parameter 1 = name of .RSC file, containing the Ansi Message Topics.    */
        /*--------------------------------------------------------------------------------------*/
        /* Needs :      parameter 2+= name(s) of the Topic(s) to be displayed from .RSC file.   */
        /*--------------------------------------------------------------------------------------*/
        /* Optional :   parameter 2+= debug-switch : /Debug     Full trace for supervisor       */
        /* Optional :   parameter 2+= debug-switch : /Verbatim  Partial trace for administrator */
        /****************************************************************************************/

        /****************************************************************************************/
        /* Needs External Rexx : RgUtil.CMD, available via PATH= (to register the RexxUtil.DLL) */
        /****************************************************************************************/


        /**************************************/
        /* Start recording the elapsed time : */
        /**************************************/
        Call Time('R');

        /*************************************/
        /* Register the RexxUtil Functions : */
        /*************************************/
        Call RgUtil '/M';

        /****************/
        /* ? who am I ? */
        /****************/
        Parse SOURCE . . Who_Am_I .;
        Who_Am_I_Drive=FileSpec('Drive',Who_Am_I);
        Who_Am_I_Path=FileSpec('Path',Who_Am_I);
        Who_Am_I_Name=Reverse(SubStr(Reverse(FileSpec('Name',Who_Am_I)),5));

        /****************/
        /* Initialize : */
        /****************/
        Parse VALUE SysTextScreenSize() WITH On_The_Screen_ROW On_The_Screen_COL;
        On_The_Screen_Max=Min(40,On_The_Screen_ROW) - 3;
        On_The_Screen_N=0;
        N_Errors=0;
        Variable_Indicator='~';

        /************************************************/
        /* Accept the name of the ANSI Resources File : */
        /************************************************/
        Parse ARG Name_Of_Resource_File The_Rest;

        /***************************/
        /* Hey dude, do it right ! */
        /***************************/
        If Strip(Name_Of_Resource_File) = ''
        Then Do;
             Call Something_Was_Wrong;
             Call Say_This ' The name of the "RSC" file was not specified.';
             Call Say_This ' Check the call syntax and try again.';
             Call Say_This Center('ABORT',79,'*');
             Call Clean_Up_And_Go_Home;
             Return '';
             End;

        /*******************************************************/
        /* Accept the other parameters from the command line : */
        /*******************************************************/
        i=0;
        Do Forever;
           If The_Rest = ""
           Then Do;
                Arg_Topic.0=i;
                Leave;
                End;
           Else Do;
                i=i+1;
                Parse VAR The_Rest Arg_Topic.i The_Rest;
                /*******************************************/
                /* Isolate the command line DEBUG switch : */
                /*******************************************/
                If Left(Arg_Topic.i,1) = '/'
                Then Do;
                     RENTOKIL=Arg_Topic.i;
                     i=i-1;
                     End;
                Else Do;
                     Arg_Topic.i=Translate(Arg_Topic.i);
                     End;
                End;
           End;

        /********************************************************/
        /* Accept the /DEBUG or /VERBATIM command line switch : */
        /********************************************************/
        RENTOKIL=Left(Translate(RENTOKIL||'x'),2);

        /**************************************/
        /* Analyse the name of the RSC File : */
        /**************************************/
        RSC_File_Drive=FileSpec('Drive',Name_Of_Resource_File);
        RSC_File_Path=FileSpec('Path',Name_Of_Resource_File);
        RSC_File_Name=FileSpec('Name',Name_Of_Resource_File);
        RSC_File_Ext=Pos('.',RSC_File_Name);
        If RSC_File_Ext = 0
        Then Do;
             Qualified_Name=RSC_File_Drive || RSC_File_Path || RSC_File_Name || '.RSC';
             End;
        Else Do;
             Qualified_Name=RSC_File_Drive || RSC_File_Path || RSC_File_Name;
             End;

        /*************************************************************************************/
        /* Verify existence of the RSC File : (F) Files only, (O) only names, all attributes */
        /*************************************************************************************/
        Sys_RC=SysFileTree(Qualified_Name,'Sys_File_Tree','FO','*****','*****');
        If Sys_RC \= 0
        Then Do;
             Call Something_Was_Wrong;
             Call Say_This ' Invalid returncode "' || Sys_RC || '" from SysFileTree.';
             Call Say_This ' The "RSC" file "' || Qualified_Name || '" can not be found.';
             Call Say_This ' Check the file name and try again.';
             Call Say_This Center('ABORT',79,'*');
             Call Clean_Up_And_Go_Home;
             Return '';
             End;
        If Sys_File_Tree.0 = 0
        Then Do;
             Call Something_Was_Wrong;
             Call Say_This ' The "RSC" file "' || Qualified_Name || '" can not be found.';
             Call Say_This ' Check the file name and try again.';
             Call Say_This Center('ABORT',79,'*');
             Call Clean_Up_And_Go_Home;
             Return '';
             End;

        /*****************************************/
        /* When the RSC is empty... what to do ? */
        /*****************************************/
        If \Lines(Qualified_Name)
        Then Do;
             Call Something_Was_Wrong;
             Call Say_This ' The "RSC" file "' || Qualified_Name || '" is empty.';
             Call Say_This ' Check the file and try again.';
             Call Say_This Center('ABORT',79,'*');
             Call Clean_Up_And_Go_Home;
             Return '';
             End;

        /*****************************/
        /* Analyse the topics list : */
        /*****************************/
        If Arg_Topic.0=0
        Then Do;
             Call Something_Was_Wrong;
             Call Say_This ' No topic names were specified.';
             Call Say_This ' Check the call syntax and try again.';
             Call Say_This Center('ABORT',79,'*');
             Call Clean_Up_And_Go_Home;
             Return '';
             End;

        /***********************************/
        /* Read all lines in the .RSC file */
        /***********************************/
        i=0;
        j=0;
        Do While Lines(Qualified_Name);
           RSC_Line=LineIn(Qualified_Name);
           /**********************/
           /* Pick up position 1 */
           /**********************/
           Parse VAR RSC_Line Delim +1 RSC_Rest;
           /******************************************/
           /* When it is a comment line, forget it : */
           /******************************************/
           If Delim = '*'
           Then Do;
                Iterate;
                End;
           /********************************************************/
           /* When it is a Topic Identification Line, analyze it : */
           /********************************************************/
           If Delim = '['
           Then Do;
                Parse VAR RSC_Rest Topic ']' .;
                i=i+1;
                RSC_Topic.i=Translate(Topic);
                RSC_Topic_First.i=0;
                RSC_Topic_Last.i=0;
                Iterate;
                End;
           /**********************************************************/
           /* Otherwise, it is an Ansi Message Line for this topic : */
           /**********************************************************/
           j=j+1;
           RSC_Line.j=RSC_Line;
           If RSC_Topic_First.i=0
           Then Do;
                RSC_Topic_First.i=j;
                End;
           RSC_Topic_Last.i=j;

           End;                                         /* do while lines()*/

        RSC_Topic.0=i;
        RSC_Line.0=j;

        /***********************/
        /* Close the .RSC file */
        /***********************/
        CL_RC=Stream(Qualified_Name,'Command','CLOSE');
        If CL_RC \='READY:'
        Then Do;
             Call Something_Was_Wrong;
             Call Say_This ' *** Fatal Error "' || CL_RC || '"';
             Call Say_This ' *** during Close of "' || Qualified_Name || '"';
             Call Say_This Center('ABORT',79,'*');
             Call Clean_Up_And_Go_Home;
             Return '';
             End;


        /**************************************************/
        /* The Ansi Message to be shown to the end user : */
        /**************************************************/
        Ansi_Message='';
        /********************************************************/
        /* Remember the relative row of the Ansi Message Line : */
        /********************************************************/
        Parse VALUE SysCurPos() WITH Variable_Row Variable_Column;
        /***************************************************/
        /* The Result to be returned to the calling Rexx : */
        /***************************************************/
        To_Be_Returned='';

        /*******************************/
        /* Scan all Requested Topics : */
        /*******************************/
        Do a=1 To Arg_Topic.0;
           /******************************************/
           /* Search this Topic in the .RSC Topics : */
           /******************************************/
           Do b=1 To RSC_Topic.0;
              If RSC_Topic.b=Arg_Topic.a
              Then Do;
                   Vars_Found=0;
                   /*******************************/
                   /* Fetch the Requested Lines : */
                   /*******************************/
                   Do c=RSC_Topic_First.b To RSC_Topic_Last.b;
                      /********************************/
                      /* Construct the Ansi Message : */
                      /********************************/
                      Ansi_Message=Ansi_Message || '0A0D'x || RSC_Line.c;
                      /********************************************************/
                      /* Remember the relative row of the Ansi Message Line : */
                      /********************************************************/
                      Variable_Row=Variable_Row+1;
                      If Pos('1B'x || '[2J',RSC_Line.c) > 0
                      Then Do;
                           Variable_Row=0;
                           End;
                      /*******************************************************/
                      /* Check for the presence of a Variable in this line : */
                      /*******************************************************/
                      Somewhere=Pos(Variable_Indicator,RSC_Line.c);
                      If Somewhere=0
                      Then Do;
                           Iterate;
                           End;
                      /*******************************************************/
                      /* Search for the place of the Variable in this line : */
                      /*******************************************************/
                      Variable_Color='';
                      Variable_Column=0;
                      Line_Length=Length(RSC_Line.c);
                      Do d=1 To Line_Length;
                         /****************************************************************/
                         /* Forget the Ansi Escape Sequence while counting the Columns : */
                         /****************************************************************/
                         If Substr(RSC_Line.c,d,1)='1B'x
                         Then Do;
                              Do e=d+1 To Line_Length;
                                 If Translate(Substr(RSC_Line.c,e,1))>'Z'
                                 Then Do;
                                      Iterate;
                                      End;
                                 If Translate(Substr(RSC_Line.c,e,1))<'A'
                                 Then Do;
                                      Iterate;
                                      End;
                                 Leave;
                                 End;
                              /**********************************************************************/
                              /* Remember the last Ansi Color Escape sequence before the variable : */
                              /**********************************************************************/
                              If Substr(RSC_Line.c,e,1)='m'
                              Then Do;
                                   /**********************************************************/
                                   /* Return the Ansi Color Escape sequence in HexaDecimal : */
                                   /**********************************************************/
                                   Variable_Color=c2x(Substr(RSC_Line.c,d,e-d)||'m');
                                   End;
                              d=e;
                              End;
                         Else Do;
                              If Substr(RSC_Line.c,d,1)=Variable_Indicator
                              Then Do;
                                   /***************************************************/
                                   /* The Result to be returned to the calling Rexx : */
                                   /***************************************************/
                                   Vars_Found=Vars_Found+1;
                                   To_Be_Returned=To_Be_Returned || Arg_Topic.a || ';' || Vars_Found || ';' || Variable_Row ||  ';' || Variable_Column || ';' || Variable_Color || ';';
                                   End;
                              Variable_Column=Variable_Column+1;
                              End;
                         End;                                          /* d*/
                      End;                                             /* c*/
                   /*************************************************************************/
                   /* When this Topic found was in the .RSC Topics, leave the Search loop : */
                   /*************************************************************************/
                   Leave;
                   End;
              End;                                                     /* b*/
           End;                                                        /* a*/

        /***************************************************/
        /* The Result to be returned to the calling Rexx : */
        /***************************************************/
        If RENTOKIL = '/D'
        Then Do;
             Call Say_This('****************** result returning to caller :');
             Call Say_This(To_Be_Returned);
             End;

        /**********/
        /* Bye... */
        /**********/
        Call Clean_Up_And_Go_Home;

        /***********************************************************/
        /* Put the Ansi Message in one quick flash on the screen : */
        /***********************************************************/
        Say Ansi_Message;

        /*****************************************************************/
        /* Give the Variable(s)'s Coordinates back to the Calling Rexx : */
        /*****************************************************************/
        Return To_Be_Returned;

/*************************************************************************************************/

   Clean_Up_And_Go_Home:

        /**************************************/
        /* Compute the overall elapsed time : */
        /**************************************/
        If (RENTOKIL = '/V' | RENTOKIL = '/D')
        Then Do;
             Call Say_This Center('Total Time : ' || Time('E'),79,'');
             Call SysSleep 5;
             If N_Errors > 0
             Then Do;
                  Call SysSleep 5;
                  End;
             End;

        Return 0;

/*************************************************************************************************/


   Something_Was_Wrong:

        If N_Errors = 0
        Then Do;
             Call Say_This Right(' Error Message from "' || Who_Am_I_Name || '" ',79,'');
             End;
        N_Errors=N_Errors+1;

        Return 0;

/*************************************************************************************************/

   Say_This:

        Parse ARG What_Is_There_To_Say;

        If On_The_Screen_N > On_The_Screen_Max
        Then Do;
             '@Pause';
             Say '1B'x || '[A' || '1B'x || '[K' || '1B'x || '[A';
             On_The_Screen_N=0;
             End;

        Say What_Is_There_To_Say;
        On_The_Screen_N=On_The_Screen_N+1;

        If Length(What_Is_There_To_Say) > 79
        Then On_The_Screen_N=On_The_Screen_N+1;
        If Length(What_Is_There_To_Say) > 79+80
        Then On_The_Screen_N=On_The_Screen_N+1;
        If Length(What_Is_There_To_Say) > 79+80+80
        Then On_The_Screen_N=On_The_Screen_N+1;
        If Length(What_Is_There_To_Say) > 79+80+80+80
        Then On_The_Screen_N=On_The_Screen_N+1;
        If Length(What_Is_There_To_Say) > 79+80+80+80+80
        Then On_The_Screen_N=On_The_Screen_N+1;
        If Length(What_Is_There_To_Say) > 79+80+80+80+80+80
        Then On_The_Screen_N=On_The_Screen_N+1;
        If Length(What_Is_There_To_Say) > 79+80+80+80+80+80+80
        Then On_The_Screen_N=On_The_Screen_N+1;
        If Length(What_Is_There_To_Say) > 79+80+80+80+80+80+80+80
        Then On_The_Screen_N=On_The_Screen_N+1;
        If Length(What_Is_There_To_Say) > 79+80+80+80+80+80+80+80+80
        Then On_The_Screen_N=On_The_Screen_N+1;

        Return 0;

/*************************************************************************************************/

/************************************************************************************************/
/* This code is freeware.                                                                       */
/*                              Intellectual Copyright : Marcel Hendrickx  BEEBEL06@IBMMAIL.COM */
/************************************************************************************************/

