/*---------------------------------------------------------------------------*\
|   GET all access control lists of all aliases definEnd on a server          |
|   LS 3.0 and higher and dump into an ASCII file.                            |
|       (C) Alain Rykaert IBM Belgium & Hermann Pauli IBM Germany SEP95-MAY96 |
|                                                                 OCT97       |
\*---------------------------------------------------------------------------*/

    LUserId = 8                    /* max.length of any user ID in your Dom*/
                                   /* LS 2.0 and 3.0 LID <= 8, LS 4.0 <= 15 */
    Parse Arg Option

    Call Init                     /* Initalisation of DLL's and other stuff*/
    Call ChkOpt                          /* Check Options & display Welcome*/
    Call ChkPWS                               /* Check the PWS & Admin name*/
    Call Main                                            /* Do the main job*/
    Call Quit                                                       /* Quit*/

 MAIN:/* ------------------------------------------------------ MAIN: -------*/

    Call Time('R')
   'If exist' OUTF 'del' OUTF
    Call LineOut OUTF, '* List of all ACLs of existing Aliases,',
                       || ' allowed Options U=update D=delete'

 /* Prepare the output tables banner */

    Call GetBanner
    Comment = '* type of alias :'

    Call LineOut OutF, GULst
    NumAlias  = 0

    Call RxStemSort 'ALIASFiles'
    Do i = 1 to ALIASFiles.0
      Call Status 'F' ALIASFiles.i i
      Call GetInfo ALIASFiles.i
    End
    Say

    Call RxStemSort 'ALIASPrint'
    Do i = 1 to ALIASPrint.0
      Call Status 'P' ALIASPrint.i i
      Call GetInfo ALIASPrint.i
    End
    Say

    Call RxStemSort 'ALIASSerial'
    Do i = 1 to ALIASSerial.0
      Call Status 'S' ALIASSerial.i i
      Call GetInfo ALIASSerial.i
    End

    If \MUTE Then Say '0909'x ' Total Time  =' Trunc(Time('E'),2)

    Call Stream OutF, 'C', 'Close'

    Call SysSetObjectData OutF, 'ICONFILE='Directory()'\ACL.Ico'

    Return

 GetInfo:/* --------------------------------------------------- GetInfo: ----*/

    Parse Arg W_Alias
    OUT = EmptyLst
    OUT = OVERLAY(W_ALIAS,OUT,5)

    /* Retrieve info about all Aliases (we need server and resource info)   */
    RC = NetGetInfo(NETALIAS, 'AliasInfo', '\\'SRVNAME, W_Alias)
    If RC = 0
     Then Nop
     Else Do
            Call LOGIT 'NetGetInfo Alias', W_Alias ,RC
            Call Quit
          End

    /* find the correct ressource, depEndEnd on alias type  */
    Select
      When AliasInfo.type = 'Files'   Then Alias_Res = AliasInfo.path
      When AliasInfo.type = 'Printer' Then Alias_Res = '\print\'AliasInfo.queue
      When AliasInfo.type = 'Serial'  Then Alias_Res = '\comm\'AliasInfo.queue
      Otherwise nop
    End

    /* Get ACP for alias */
    RC = NetGetInfo(NETACCESS, 'ACP', '\\' || AliasInfo.server, Alias_Res)
    If RC = 0
      Then Do
             NumAlias = NumAlias + 1
             If NumAlias // MAXLINES = 0
               Then Call Lineout OUTF, GULst
               Else nop

             Do k = 1 to ACP.count
               UserGroup = ACP.k.ugname
               If GUPos.UserGroup = 0
                 Then nop                               /* user not in list*/
                 Else Do               /* add found ACP info to output line*/
                        OUT = OVERLAY(Strip(ACP.audit),OUT,LPre_Banner-6)
                        LCol = POS(';',GULst,GUPos.UserGroup)-GUPos.UserGroup
                        LACPT = CENTER(ACP.k.access,Max(LCol,LENGTH(ACP.k.access)))
                        OUT = OVERLAY(LACPT,OUT,GUPos.UserGroup)
                      End
             End
              Call LineOut OUTF, OUT
          End

      Else If Left(strip(RC),4) = '2222'                     /* no ACP found*/
           Then Do
                   NumAlias = NumAlias + 1
                   If NumAlias // MAXLINES = 0
                    Then Call Lineout OUTF, GULst
                    Else nop

                   Call Lineout OUTF, OUT
                End

           Else Call LOGIT 'NetGetInfo Access', W_User ||'/'|| W_Alias, RC
    Return

 Status:/* ---------------------------------------------------- Status: -----*/

    Parse ARG S_Typ S_ALIAS S_Number
    Select
      When S_Typ = 'F' Then S_Text = 'File  '
      When S_Typ = 'P' Then S_Text = 'Print '
      When S_Typ = 'S' Then S_Text = 'Serial'
      Otherwise nop
    End

    Do
       Say '0909'x ESC'[K' S_Text S_Number '=' S_ALIAS
       If \MUTE
          Then Do
                  Call SysCurState OFF
                  parse value SysCurPos() with row col
                  row = row - 1
                  Call SysCurPos row,0
               End
          Else Nop
    End
    Return

 GetBanner:/* ------------------------------------------------- GetBanner:---*/

    /* get defined groups */
    RC = NetEnumerate(70, 'GROUP', '\\'SRVNAME)

    If RC <> 0
     Then Do
             Call LOGIT 'NetEnum. Group' , 'Server \\' || SRVNAME, RC
             Call Quit
          End
     Else    Call RxStemSort 'GROUP'

    /* get defined userids */
    RC = NetEnumerate(280, 'USERID', '\\'SRVNAME)

    If RC <> 0
     Then Do
             Call LOGIT 'NetEnum. User' , 'Server \\' || SRVNAME, RC
             Call Quit
          End
     Else    Call RxStemSort 'USERID'

    /* Get list of all aliases definEnd on server */
    RC = NetEnumerate(NETALIAS, 'ALIASFiles' , '\\'SRVNAME,1)
    If RC <> 0 & substr(RC,1,3) <> '234 '       /* 234 = no File Alias def.*/
     Then Do
             Call LOGIT 'NetEnum. F-Alias' , 'Server \\' || SRVNAME , RC
             Call Quit
          End
     Else    Call RxStemSort 'ALIASFiles'

    RC = NetEnumerate(NETALIAS, 'ALIASPrint' , '\\'SRVNAME,2)
    If RC <> 0 & substr(RC,1,3) <> '234 '       /* 234 = no File Alias def.*/
     Then Do
             Call LOGIT 'NetEnum. P-Alias' , 'Server \\' || SRVNAME , RC
             Call Quit
          End
     Else    Call RxStemSort 'ALIASPrint'

    RC = NetEnumerate(NETALIAS, 'ALIASSerial', '\\'SRVNAME,4)
    If RC <> 0 & substr(RC,1,3) <> '234 '       /* 234 = no File Alias def.*/
     Then Do
             Call LOGIT 'NetEnum. S-Alias' , 'Server \\' || SRVNAME , RC
             Call Quit
          End
     Else    Call RxStemSort 'ALIASSerial'

    /* prepare first non user/group columns of the banner */
    Pre_Banner  = Left('OPT'||';'||'ALIAS',LAlias + 4,' ')
    EmptyLst    = Left('   '||';',length(Pre_Banner),' ')
    Pre_Banner  = Pre_Banner || ';' || 'AUDIT ;'
    EmptyLst    = EmptyLst   || ';' || '      ' || ';'
    LPRe_Banner = length(Pre_Banner)

    GULst       = Pre_Banner

    GUPos.      = 0                            /* initialize all GUPos to 0*/

 /* build banner using the groups */
    Do i=1 to GROUP.0
       GU       = Group.i
       GUPos.GU = length(GULst) + 1
       GULst    = GULst || Left(GU,max(8,length(GU)), ' ') || ';'
       EmptyLst = EmptyLst || Left(' ',max(8,Length(GU)),' ') || ';'
    End

 /* build banner using the users */
    Do i=1 to USERID.0
       GU       = USERID.i
       GUPos.GU = length(GULst) + 1
       GULst    = GULst || Left(GU,max(8,length(GU)), ' ') || ';'
       EmptyLst = EmptyLst || Left(' ',max(8,Length(GU)),' ') || ';'
    End

    Return


 CHKOPT:/* ---------------------------------------------------- CHKOPT: -----*/

    SRVNAME = '';
    OUTF    = 'ACL.CSV';
    LOGF    = 'LSMT.LOG';
    PIPE    = '';
    TRACE   = 0;
    MUTE    = 0;

    OPTION = Translate(OPTION)
    Do While OPTION <> ''
       Parse value OPTION with ARGUMENT ' ' OPTION
       Select
        When Left(ARGUMENT,5) = '/SRV:'  Then SRVNAME = Substr(ARGUMENT,6)
        When Left(ARGUMENT,5) = '/OUT:'  Then OUTF    = Substr(ARGUMENT,6)
        When Left(ARGUMENT,5) = '/LOG:'  Then LOGF    = Substr(ARGUMENT,6)
        When Left(ARGUMENT,5) = '/PIP:'  Then PIPE    = Substr(ARGUMENT,6)
        When Left(ARGUMENT,2) = '/M'     Then MUTE    = 1
        When Left(ARGUMENT,2) = '/T'     Then TRACE   = 1
        otherwise Nop
       End
    End

    If SRVNAME = '' Then signal GETHELP

    If \MUTE
     Then Do
             Topic1 = 'GETWELCOME'
             Topic_String.Topic1.1 = SRVNAME;
             Topic_String.Topic1.2 = OUTF;
             Topic_String.Topic1.3 = LOGF;
             Topic_String.Topic1.4 = PIPE' ';
             Topic_List = 'WELCOMELOGO' Topic1 'GETACL';
             Call GETANS
             Parse VALUE SysCurPos() With Old_R Old_C; 'Pause';
             Call SysCurPos Old_R, Old_C; Say ESC'[K';
          End
     Else Do
             Say 'ServerName =' SRVNAME
             Say 'OutputFile =' OUTF
             Say 'LogFile    =' LOGF
          End
    Return

 CHKPWS:/* ---------------------------------------------------- CHKPWS: -----*/

    RC = NetGetInfo(350, 'WKSTAINFO','')
    If RC = 0
     Then Do
             ADMNAME = WKSTAINFO.UserName
             PWSNAME = WKSTAINFO.ComputerName
          End
     Else Do
            Call LOGIT 'Get PWS Info', ,RC
            Call Quit
          End
    Return

 INIT:/* ------------------------------------------------------ INIT: -------*/

    Call RgUtil   '/m'                                    /* Rexx Utilities*/
    Call RgUtils  '/m'                                    /* Rexx Utilities*/
    Call RgNPipes '/m'                                       /* Named Pipes*/
    Call RgLSRXUT '/m'                             /* Lan Server Rexx Utils*/

    Parse Upper Source . . P_NAME
    PRGN = Filespec('N', Left(P_NAME, Length(P_NAME) -4))

   '@echo off'
    ESC     = '1B'x
    REDIR   = '>NUL 2>NUL'
    MAXLINES = 20              /* Number of Lines to separate with a header*/

    LMinAss = 5                     /* min. length for logon assignment col*/
    LAlias  = 9                                  /* max.length of alias col*/
                                 /* 9 entries per alias posible           */

    NETACCESS   = 10                                 /* code for LSREXX API*/
    NETALIAS    = 20
    NETWKSTA    = 350

    NumAlias  = 0                            /* number of aliases processed*/


    Resource_File = 'LSMT.RSC'
    Call CHKFILE Resource_File

    Return

 GETANS:/* ---------------------------------------------------- GETANS: -----*/

    Vars_List =Ansi_Say(Resource_File Topic_List);
    Parse VALUE SysCurPos() With Old_R Old_C;
    Do While Vars_List <> '';
       Parse VALUE Vars_List With Topic_Id ';' Var_Id ';' Row ';' Column ';' Color ';' Vars_List;
       Call SysCurPos Row, Column;
       Say x2c(Color) || Topic_String.Topic_Id.Var_Id || '1B'x || '[0m';
       End;
    Call SysCurPos Old_R, Old_C;

    Return

 GETHELP:/* --------------------------------------------------- GETHELP: ----*/

    If \MUTE
     Then Do
             Topic1='GETHELP'
             Topic_String.Topic1.1=PRGN;
             Topic_List=Topic1;
             Call GETANS
          End
     Else Say 'Incorrect options.'

    Call QUIT

    Return

 CHKFILE:/* --------------------------------------------------- CHKFILE: ----*/

    Parse Arg FILE
    RC = Stream(FILE, 'C', 'QUERY EXIST')
    If RC = ''
     Then Do
             Say ' File' FILE 'not found.'
             Call QUIT
          End
     Else Nop
    Call Stream FILE, 'C', 'CLOSE'

    Return

 LOGIT:/* ----------------------------------------------------- LOGIT: ------*/

    FUNC = ARG(1); INFO = ARG(2); RCOD = ARG(3)
    RC = LLOGIT(LOGF, PIPE, ADMNAME, PRGN, FUNC, INFO, RCOD)

    Return

 QUIT:/* ------------------------------------------------------ QUIT: -------*/

    Call LineOut 'LSMT.End', PRGN, 1
    Call Stream  'LSMT.End', 'C', 'CLOSE'

    Call Stream LOGF, 'C', 'CLOSE'
    Call Stream OUTF, 'C', 'CLOSE'

    Exit

 /*--------------------------------------------------------------------------*/
