/*---------------------------------------------------------------------------*\
|   Get Configuration from all servers        (C) Alain Rykaert - AUG98-APR00 |
\*---------------------------------------------------------------------------*/
    Version = '1.07b (C) AR - DEC2000'
    Say '* LSCONFIG Version' Version

    Call Init                                 /* init dll's and other stuff*/

   'if not exist' LSRDrive'\ibmlan\tmp md' LSRDrive'\ibmlan\tmp'
    TempFile = LSRDrive'\ibmlan\tmp\lsconfig.tmp'         /* Temporary file*/

    Parse Upper Arg DCName OutFileName

    If DCName = '' | OutFileName = ''
      Then Do
             Say '*'
             Say '* Get LAN Server Config'
             Say '*'
             Say '* Usage: LSCONFIG {DCName} {OutputFileName}'
             Say '*'
             Say '* Sample: LSCONFIG \\DC01 LSCONFIG.CSV'
             Say '*'
             Exit X2D('1600')
           End
      Else Nop

    DCName = Strip(DCName,'L','\')
    Say '* Server Name:' '\\'DCName
    Say '* Output FileName:' OutFileName

    RC = NetGetInfo(370, 'ServerModalInfo', '\\'DCName)  /* get server role*/
    If RC = 0
      Then Do
             ServerRole = ServerModalInfo.Role
             If WordPos('Primary', ServerRole) > 0     /* check server role*/
               Then Nop
               Else Do
                      Say '! This is not a Primary Domain Controller' '07'x
                      Exit X2D('1600')
                    End
           End
      Else Say RC

    RC = NetGetInfo(340, 'ServerName', '\\'DCName, 'Servers')/* get all servers*/
    If RC = 0
      Then Do
            'if exist' OutFileName 'del' OutFileName
             OutText = '***' Date() Time() '*** LSCONFIG Version:' Version
             Call Logit OutFileName OutText
             Call Logit OutFileName ' '
             Call RxStemSort 'ServerName'
             Say '* Total defined servers:' ServerName.0
         /*  Counter = Left('COUNTER', (Length(ServerName.0) * 2)+3) */

             Text = Left('SERVER ',8)      ';',
                    Left('IPADDRESS',15)   ';',
                    Left('NETMASK',15)     ';',
                    Left('HOSTNAME',8)     ';',
                    Left('MACADDRESS',12)  ';',
                    Left('XID',8)          ';',
                    Left('DESTINATION',12) ';',
                    Left('ADSMNAME',8)     ';',
                    Left('ADSMSERV',12)    ';',
                    Left('NIC',3)          ';',
                    Left('NICTYPE',8)      ';'

             Call Logit OutFileName Text

             Do i = 1 to ServerName.0
               Counter = '('Right(i,Length(ServerName.0))'/'Right(ServerName.0,Length(ServerName.0))')'
               Call CharOut,'* ServerName:' Counter ServerName.i
               Text = Left(ServerName.i,9) || ';'
               If NetGetInfo(370, 'ServerModalInfo', '\\'ServerName.i) = 0
                 Then Do
                        Say
                        Call GetInfo ServerName.i
                      End
                 Else Say ' > not found'
               Call Logit OutFileName Text
             End
           End
      Else Say RC

    Exit

 GETINFO:/* ----------------------------------------------------------------*/

    Parse Arg ServerName
    IPAddress = ''
    NetMask = ''
    HostName = ''
    MACAddress = ''
    NicCount = ''
    XID = ''
    TIC = ''
    AdsmName = ''
    AdsmServ = ''

   'net admin \\'ServerName '/c set >' TempFile
    Call Stream TempFile, 'C', 'Close'
    If Stream(TempFile, 'C', 'Query Size') > 0
      Then Nop
      Else Do
             Say '! Error: tempfile' TempFile 'is not valid' '07'x
             Return
           End

    Call SysFileSearch 'COMSPEC=', TempFile, 'Stem'
    If Stem.0 = 1
      Then Do
             Parse Var Stem.1 . '=' ServerBootDrive ':' .
             If Trace Then Say '> Boot Drive:' ServerBootDrive
             LibPath = ''
             Call SysFileSearch 'LIBPATH=', '\\'ServerName'\'ServerBootDrive'$\config.sys', 'Stem'
             Do j = 1 to Stem.0
               Stem.j = Translate(Stem.j)
               If Left(Strip(Stem.j), 8) = 'LIBPATH='
                 Then Parse Var Stem.j . '=' LibPath
                 Else Nop
             End
             If LibPath = ''
               Then Do
                      Say '! Error: could not determine LibPath' '07'x
                      Return
                    End
               Else If Trace Then Say '> LibPath:' LibPath
           End
      Else Do
             Say '! Error: could not determine ComSpec' '07'x
             Return
           End

    DRV_OS2 = ''
    DRV_LSR = ''
    DRV_CM2 = ''
    DRV_MPTS = ''
    DRV_PCOM = ''

    Do While LibPath <> ''
      DriveLetter = ''
      Parse Upper Value LibPath With QPath ';' LibPath
      If Pos(':',QPath) > 0
        Then Parse Value QPath With DriveLetter ':' QPath
        Else Nop
      Select
       When QPath = '\IBMLAN\NETLIB'                          /* Lan Server*/
         Then DRV_LSR = '\\'ServerName'\'DriveLetter'$'
       When QPath = '\IBMCOM\DLL'                                   /* MPTS*/
         Then DRV_MPTS = '\\'ServerName'\'DriveLetter'$'
       When QPath = '\TCPIP\DLL'                                  /* TCP/IP*/
         Then DRV_TCP = '\\'ServerName'\'DriveLetter'$'
       When QPath = '\CMLIB\DLL'                                    /* CM/2*/
         Then DRV_CM2 = '\\'ServerName'\'DriveLetter'$'
       When QPath = '\PCOMOS2'                                     /* PCOMM*/
         Then DRV_PCOM = '\\'ServerName'\'DriveLetter'$'
       OtherWise Nop
      End
    End
 /*
    DRV_OS2 = ''
    DRV_LSR = ''
    DRV_CM2 = ''
    DRV_MPTS = ''
    DRV_PCOM = ''
                  */
  /* Get IP */
     ConfigFile = '\\'ServerName'\'ServerBootDrive'$\mptn\bin\setup.cmd'
     If Stream(ConfigFile, 'C', 'Query Exists') <> ''
       Then Do
              Call SysFileSearch 'ifconfig lan0', ConfigFile, 'Stem'
              If Stem.0 = 1
                Then Parse Var Stem.1 . . IPAddress . NetMask .
                Else Nop
            End
       Else Nop

  /* Get HostName */
     ConfigFile = '\\'ServerName'\'ServerBootDrive'$\config.sys'
     Call SysFileSearch 'SET HOSTNAME=', ConfigFile, 'Stem'
     If Stem.0 = 1
       Then Parse Var Stem.1 . '=' HostName
       Else Nop

  /* Get MAC */
     ConfigFile = '\\'ServerName'\'ServerBootDrive'$\ibmcom\protocol.ini'
     Call SysFileSearch 'NetAddress =', ConfigFile, 'Stem'
     If Stem.0 > 0
       Then Do
              Parse Var Stem.1 . '=' MacAddress .
              MacAddress = Strip(MacAddress,,'"')
              MacAddress = Strip(MacAddress,,'T')
            End
       Else Nop

  /* Get Number of Network Adapters */
     ConfigFile = '\\'ServerName'\'ServerBootDrive'$\config.sys'
     Call SysFileSearch '\macs\', ConfigFile, 'Found'
     If Found.0 > 0
       Then Do n = 1 to Found.0
              If Pos('rem',Found.n) > 0
                Then Nop
                Else Do
                       Parse Var Found.n . '\' . '\' . '\' NicType '.' .
                       Look = '['NicType'_NIF'
                       ConfigFile = '\\'ServerName'\'ServerBootDrive'$\ibmcom\protocol.ini'
                       Call SysFileSearch Look, ConfigFile, 'NifFound'
                       If NifFound.0 = 0
                         Then Call SysFileSearch '[IBMTRPO2_NIF', ConfigFile, 'NifFound'
                         Else Nop
                       NicCount = NifFound.0
                     End
            End
       Else NicCount = ''

  /* Get CM/2 NDF */
     ConfigFile = '\\'ServerName'\'ServerBootDrive'$\cmlib\cm.ini'
     If Stream(ConfigFile, 'C', 'Query Exists') <> ''
       Then Do
              Call SysFileSearch 'CMDefaultCFG=', ConfigFile, 'Stem'
              If Stem.0 = 1
                Then Do
                       Parse Var Stem.1 . '=' NDF .
                       NDFFile = '\\'ServerName'\'ServerBootDrive'$\cmlib\'NDF'.ndf'
                       Call SysFileSearch 'NODE_ID', NDFFile, 'Found'
                       Parse Var Found.1 . "'" XID "'"
                       Call SysFileSearch 'DESTINATION_ADDRESS', NDFFile, 'Found'
                       Parse Var Found.1 . "'" TIC "'"
                     End
                Else Nop
            End
       Else Nop

  /* Get ADSM Config */
     ConfigFile = '\\'ServerName'\'ServerBootDrive'$\adsm\dsm.opt'
     If Stream(ConfigFile, 'C', 'Query Exists') <> ''
       Then Do
              Call SysFileSearch 'NODENAME', ConfigFile, 'Stem'
              If Stem.0 = 1
                Then Parse Var Stem.1 . AdsmName .
                Else Nop
              Call SysFileSearch 'TCPSERVERADDRESS', ConfigFile, 'Stem'
              If Stem.0 = 1
                Then Parse Var Stem.1 . AdsmServ .
                Else Nop
            End
       Else Nop

     ConfigFile = '\\'ServerName'\'ServerBootDrive'$\pgms\adsm\dsm.opt'
     If Stream(ConfigFile, 'C', 'Query Exists') <> ''
       Then Do
              Call SysFileSearch 'NODENAME', ConfigFile, 'Stem'
              If Stem.0 = 1
                Then Parse Var Stem.1 . AdsmName .
                Else Nop
              Call SysFileSearch 'TCPSERVERADDRESS', ConfigFile, 'Stem'
              If Stem.0 = 1
                Then Parse Var Stem.1 . AdsmServ .
                Else Nop
            End
       Else Nop

    AdsmName = Strip(AdsmName)
    AdsmName = Strip(AdsmName,,'09'x)
    AdsmServ = Strip(AdsmServ)
    AdsmServ = Strip(AdsmServ,,'09'x)

    Text = Left(ServerName.i,8) ';',
           Left(IPAddress,15)   ';',
           Left(NetMask,15)     ';',
           Left(HostName,8)     ';',
           Left(MacAddress,12)  ';',
           Left(XID,8)          ';',
           Left(TIC,12)         ';',
           Left(AdsmName,8)     ';',
           Left(AdsmServ,12)    ';',
           Center(NicCount,3)   ';',
           Left(NicType,8)      ';'

    If Trace Then Say '>' Text

   'net use \\'ServerName'\c$ /d >nul 2>nul'
   'net use \\'ServerName'\d$ /d >nul 2>nul'
   'net use \\'ServerName'\ipc$ /d >nul 2>nul'
   'net use \\'ServerName'\ibmlan$ /d >nul 2>nul'

    Return

 INIT:/* --------------------------------------------------------------------*/

   '@echo off'

    If Value('TREES',,'OS2Environment') = ''           /* Check for Tracing*/
      Then Trace = 0
      Else Trace = 1

    BootDrive = Left(Value('Comspec',,'OS2Environment'),2)

    Redir = '>nul'

    If RxFuncQuery('SysLoadFuncs')
      Then Do
             Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
             Call SysLoadFuncs
           End
      Else Nop

    LSRDrive = Left(SysSearchPath('PATH', 'NET.EXE'), 2)    /* IBMLAN Drive*/
    If LSRDrive <> ''
      Then Nop
      Else Do
             Say '! Could not determine the Lan Requester path' '07'x
             Exit X2D('1604')
           End

    Call ChkFile LSRDrive'\ibmlan\netlib\lsrxut.dll'
    If RxFuncQuery('LoadLSRXUTFuncs')
      Then Do
             Call RxFuncAdd 'LoadLsRxutFuncs', 'LSRXUT', 'LoadLsRxutFuncs'
             Call LoadLsRxutFuncs
           End
      Else Nop

    Call ChkFile BootDrive'\os2\dll\rxutils.dll'
    If RxFuncQuery('RxLoadFuncs')
      Then Do
             Call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
             Call RxLoadFuncs
           End
      Else Nop

    Return

 CHKFILE:/* -----------------------------------------------------------------*/

    Parse Arg File_To_Check

    If Stream(File_To_Check, 'C', 'Query Exists') = ''
      Then Do
             Say '! File not found:' File_To_Check
             Exit X2D('0800')
           End
      Else Nop

    Return

 LOGIT:/* -------------------------------------------------------------------*/

    Parse Arg OutFileName OutText

    If LineOut(OutFileName, OutText) = 0
      Then Call Stream OutFileName, 'C', 'Close'
      Else Say '! Error while writing:' OutFileName '07'x

    Return

