/*---------------------------------------------------------------------------*\
|   Get DiskInformation from servers          (C) Alain Rykaert - NOV98-DEC99 |
\*---------------------------------------------------------------------------*/
    Version = '1.02a (C) AR - DEC99'
    Say '* LSDISK Version' Version

    Signal On Halt Name Quit

    Call Init                                 /* init dll's and other stuff*/

    Parse Upper Arg DCName OutFileName

    If DCName = '' | OutFileName = ''
      Then Do
             Say '*'
             Say '* Get Disk Information from Servers'
             Say '*'
             Say '* Usage: LSDISK {DCName} {OutputFileName}'
             Say '*'
             Say '* Sample: LSDISK \\BEDDC01 LSDISK.CSV'
             Say '*'
             Exit
           End
      Else Nop

    DCName = Strip(DCName,'L','\')
    Say '* Server Name:' '\\'DCName
    Say '* Output FileName:' OutFileName

    RC = NetGetInfo(370, 'ServerModalInfo', '\\'DCName)  /* get server role*/
    If RC = 0
      Then Do
             ServerRole = ServerModalInfo.Role
             If WordPos('Primary', ServerRole) > 0     /* check server role*/
               Then Nop
               Else Do
                      Say '! This is not a Primary Domain Controller' '07'x
                      Exit
                    End
           End
      Else Say RC

    RC = NetGetInfo(340, 'ServerName', '\\'DCName, 'Servers')/* get all servers*/
    If RC = 0
      Then Do
            'if exist' OutFileName 'del' OutFileName
             OutText = '***' Date() Time() '*** LSDISK Version:' Version
             Call Logit OutFileName OutText
             Call RxStemSort 'ServerName'
             Say '* Total defined servers:' ServerName.0

             Do i = 1 to ServerName.0
               OutText = Copies('-',75)
               Call Logit OutFileName OutText
               Counter = '('Right(i,Length(ServerName.0))'/'Right(ServerName.0,Length(ServerName.0))')'
               OutText = '* ServerName:' Counter Left(ServerName.i,8)
               Call CharOut ,OutText
               Call Logit OutFileName OutText
               If NetGetInfo(370, 'ServerModalInfo', '\\'ServerName.i) = 0 &,
                 Stream('\\'ServerName.i'\ibmlan$\ibmlan.ini', 'C', 'Query Exists') <> ''
                 Then Call GetDisk ServerName.i
                 Else Say '> not found'
             End
             OutText = Copies('-',75)
             Call Logit OutFileName OutText

             Say '* Done. File' OutFileName 'created'
           End
      Else Say RC

    Exit

 GETDISK:/* ---------------------------------------------------------------*/

    Parse Arg ServerName

   'if not exist' LSRDrive'\ibmlan\tmp md' LSRDrive'\ibmlan\tmp'
    TempFile = LSRDrive'\ibmlan\tmp\lsdisk.tmp'           /* Temporary file*/

    If Stream('\\'ServerName'\ibmlan$\netprog\free.exe', 'C', 'Query Exists') = ''
      Then 'copy free.exe \\'ServerName'\ibmlan$\netprog\ >nul'
      Else Nop

   'net admin \\'ServerName '/c free.exe >' TempFile
    Call Stream TempFile, 'C', 'Close'

    LogText = ''
    If Stream(TempFile, 'C', 'Query Size') > 0
      Then Do While Lines(TempFile)
             LLine = LineIn(TempFile)
             If Left(LLine, 4) = 'FREE' | Left(LLine,1) = '='
               Then Nop
               Else Do
                      LogText = LLine
                   /* Say LogText */
                      Call Logit OutFileName LogText
                    End
           End
      Else Do
             Say '! Error: tempfile' TempFile 'is not valid' '07'x
             Return
           End
    Call Stream TempFile, 'C', 'Close'

   'net use \\'ServerName'\c$      /d >nul 2>nul'
   'net use \\'ServerName'\d$      /d >nul 2>nul'
   'net use \\'ServerName'\ipc$    /d >nul 2>nul'
   'net use \\'ServerName'\ibmlan$ /d >nul 2>nul'

    Say '* OK'

    Return

 INIT:/* --------------------------------------------------------------------*/

   '@echo off'

    BootDrive = Left(Value('Comspec',,'OS2Environment'),2)

    If RxFuncQuery('SysLoadFuncs')
      Then Do
             Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
             Call SysLoadFuncs
           End
      Else Nop

    LSRDrive = ''                      /* Check for Lan Server Drive Letter*/
    PPath = Translate(Value('PATH',,'OS2Environment'))
    x = Pos('\IBMLAN\NETPROG;', PPath) -2
    If x > 0
      Then LSRDrive = SubStr(PPath, x, 2)
      Else Do
             Say '* Could not determine the Lan Requester path'
             Exit
           End

    Call ChkFile LSRDrive'\ibmlan\netlib\lsrxut.dll'
    If RxFuncQuery('LoadLSRXUTFuncs')
      Then Do
             Call RxFuncAdd 'LoadLsRxutFuncs', 'LSRXUT', 'LoadLsRxutFuncs'
             Call LoadLsRxutFuncs
           End
      Else Nop

    Call ChkFile BootDrive'\os2\dll\rxutils.dll'
    If RxFuncQuery('RxLoadFuncs')
      Then Do
             Call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
             Call RxLoadFuncs
           End
      Else Nop

    Return

 CHKFILE:/* -----------------------------------------------------------------*/

    Parse Arg File_To_Check

    If Stream(File_To_Check, 'C', 'Query Exists') = ''
      Then Do
             Say '! File not found:' File_To_Check
             Exit
           End
      Else Nop

    Return

 LOGIT:/* -------------------------------------------------------------------*/

    Parse Arg OutFileName OutText

    If LineOut(OutFileName, OutText) = 0
      Then Call Stream OutFileName, 'C', 'Close'
      Else Say '! Error while writing:' OutFileName '07'x

    Return

 QUIT:/* --------------------------------------------------------------------*/

    Say '...Interupted by User...'

    Exit X2D('1604')

