/*---------------------------------------------------------------------------*\
|   Check LAN Server Time                                (C) AR - DEC99-JAN00 |
\*---------------------------------------------------------------------------*/
    Version = '1.03 (C) AR - JAN2000'
    Say '* LSTIME Version' Version

    Signal On Halt Name Quit
    Call Init                                 /* Init DLL's and other stuff*/

    Parse Upper Arg DCName MaxTime

    If DCName = ''
      Then Do
             Say '*'
             Say '* Check all Time clocks'
             Say '*'
             Say '* Usage: LSTIME {DCName} {MaxTime}'
             Say '*'
             Say '* Sample: LSTIME \\DC01 60'
             Say '*'
             Exit
           End
      Else Nop

    DCName = Strip(DCName,'L','\')
    Say '* Server Name:' '\\'DCName

    RC = NetGetInfo(370, 'ServerModalInfo', '\\'DCName)  /* Get server role*/
    If RC = 0 & Stream('\\'DCName'\ibmlan$\ibmlan.ini', 'C', 'Query Exists') <> ''
      Then Do
             ServerRole = ServerModalInfo.Role
             If WordPos('Primary', ServerRole) > 0
               Then Nop
               Else Do
                      Say '! This is not a Primary Domain Controller' '07'x
                      Exit
                    End
           End
      Else Do
             Say '! Error:' RC
             Exit
           End

    If MaxTime < 0 | MaxTime > 9999
      Then Do
             Say '* Scanning with the default MaxTime of 60'
             MaxTime = 60
           End
      Else Nop

    RC = NetGetInfo(340, 'ServerName', '\\'DCName, 'Servers')/* get servers*/
    If RC = 0
      Then Do
             Call RxStemSort 'ServerName'
             Say '* Total defined servers:' ServerName.0
             Do i = 1 to ServerName.0
               Counter = '('Right(i,Length(ServerName.0))'/'Right(ServerName.0,Length(ServerName.0))')'
               Call Charout ,'* ServerName:' Counter Left(ServerName.i,9)
               RC = NetMisc(700, 'SrvTime', '\\'ServerName.i)
               If RC = 0
                 Then Do
                        ActTime = SrvTime.Tod_Year               || '-' ||,
                                  Right(SrvTime.Tod_Month,2,'0') || '-' ||,
                                  Right(SrvTime.Tod_Day,2,'0'),
                                  SrvTime.Tod_Hours || ':' ||,
                                  Right(SrvTime.Tod_Mins,2,'0') || ':' ||,
                                  Right(SrvTime.Tod_Secs,2,'0')

                        Call NetMisc 700, 'PdcTime', '\\'DCName/* Time on PDC*/

                        DeltaTime = ABS(PdcTime.Tod_ElapsedT-SrvTime.Tod_ElapsedT)
                        If ABS(DeltaTime) > MaxTime
                          Then Say ':' ActTime '-' Right(DeltaTime,3,' '),
                                   '<--- Attention ---'
                          Else Say ':' ActTime '-' Right(DeltaTime,3,' ')
                      End
                 Else Say '> not found'
             End
           End
      Else Say RC

    Exit

 INIT:/* --------------------------------------------------------------------*/

   '@echo off'

    BootDrive = Left(Value('Comspec',,'OS2Environment'),2)

    If RxFuncQuery('SysLoadFuncs')
      Then Do
             Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
             Call SysLoadFuncs
           End
      Else Nop

    LSRDrive = Left(SysSearchPath('PATH', 'NET.EXE'), 2)    /* IBMLAN Drive*/
    If LSRDrive <> ''
      Then Nop
      Else Do
             Say '! Could not determine the Lan Requester path' '07'x
             Exit X2D('1604')
           End

    Call ChkFile LSRDrive'\ibmlan\netlib\lsrxut.dll'
    If RxFuncQuery('LoadLSRxutFuncs')
      Then Do
             Call RxFuncAdd 'LoadLsRxutFuncs', 'LSRXUT', 'LoadLsRxutFuncs'
             Call LoadLsRxutFuncs
           End
      Else Nop

    Call ChkFile BootDrive'\os2\dll\rxutils.dll'
    If RxFuncQuery('RxLoadFuncs')
      Then Do
             Call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
             Call RxLoadFuncs
           End
      Else Nop

    Return

 CHKFILE:/* -----------------------------------------------------------------*/

    Parse Arg File_To_Check

    If Stream(File_To_Check, 'C', 'Query Exists') = ''
      Then Do
             Say '! File not found:' File_To_Check
             Exit
           End
      Else Nop

    Return

 LOGIT:/* -------------------------------------------------------------------*/

    Parse Arg OutFileName OutText

    If LineOut(OutFileName, OutText) = 0
      Then Call Stream OutFileName, 'C', 'Close'
      Else Say '! Error while writing:' OutFileName '07'x

    Return

 QUIT:/* --------------------------------------------------------------------*/

    Say
    Say '...Interupted by User...'

    Exit X2D('1604')

