/*---------------------------------------------------------------------------*\
|   Copy Tools & SrvTools to servers          (C) Alain Rykaert - OCT98-OCT98 |
\*---------------------------------------------------------------------------*/
    Version = '1.01'
    Say '* LSTOOLS Version' Version

    Call Init                                 /* init dll's and other stuff*/

    Parse Upper Arg DCName

    If DCName = ''
      Then Do
             Say '*'
             Say '* Copy Tools & SrvTools to Servers'
             Say '*'
             Say '* Usage: LSTOOLS {DCName}'
             Say '*'
             Say '* Sample: LSTOOLS \\BEDDC01'
             Say '*'
             Exit
           End
      Else Nop

    DCName = Strip(DCName,'L','\')
    Say '* Server Name:' '\\'DCName

    RC = NetGetInfo(370, 'ServerModalInfo', '\\'DCName)  /* get server role*/
    If RC = 0
      Then Do
             ServerRole = ServerModalInfo.Role
             If WordPos('Primary', ServerRole) > 0     /* check server role*/
               Then Nop
               Else Do
                      Say '! This is not a Primary Domain Controller' '07'x
                      Exit
                    End
           End
      Else Say RC

    RC = NetGetInfo(340, 'ServerName', '\\'DCName, 'Servers')/* get all servers*/
    If RC = 0
      Then Do
             Call RxStemSort 'ServerName'
             Say '* Total defined servers:' ServerName.0
             Do i = 1 to ServerName.0
               Counter = '('Right(i,Length(ServerName.0))'/'Right(ServerName.0,Length(ServerName.0))')'
               Say '* ServerName:' Counter ServerName.i
               If NetGetInfo(370, 'ServerModalInfo', '\\'ServerName.i) = 0 &,
                 Stream('\\'ServerName.i'\ibmlan$\ibmlan.ini', 'C', 'Query Exists') <> ''
                 Then Call CCopy ServerName.i
                 Else Say '09'x '> not found'
             End
           End
      Else Say RC

    Exit

 CCOPY: /* ----------------------------------------------------------------*/

    Parse Arg ServerName
    If Stream('\\'ServerName'\c$\os2\install\ipl.log', 'C', 'Query Exist') <> ''
      Then Do
            'net use s: /d >nul 2>nul'
            'net use s: \\'ServerName'\c$ >nul'
            'ccp -sf \\m_cidsrv\f$\sharea\mir\tools s:\'
            'ccp -sf \\m_cidsrv\f$\sharea\mir\srvtools s:\ibmlan'
            'net use s: /d >nul'
           End
      Else Say '09'x '> No New Installed CID Server'

   'net use \\'ServerName'\c$ /d >nul 2>nul'
   'net use \\'ServerName'\ipc$ /d >nul 2>nul'
   'net use \\'ServerName'\ibmlan$ /d >nul 2>nul'

    Return

 INIT:/* --------------------------------------------------------------------*/

   '@echo off'

    If Value('TREES',,'OS2Environment') = ''           /* Check for Tracing*/
      Then Trace = 0
      Else Trace = 1

    BootDrive = Left(Value('Comspec',,'OS2Environment'),2)

    Redir = '>nul'

    If RxFuncQuery('SysLoadFuncs')
      Then Do
             Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
             Call SysLoadFuncs
           End
      Else Nop

    LSRDrive = ''                      /* Check for Lan Server Drive Letter*/
    PPath = Translate(Value('PATH',,'OS2Environment'))
    x = Pos('\IBMLAN\NETPROG;', PPath) -2
    If x > 0
      Then LSRDrive = SubStr(PPath, x, 2)
      Else Do
             Say '* Could not determine the Lan Requester path'
             Exit
           End

    Call ChkFile LSRDrive'\ibmlan\netlib\lsrxut.dll'
    If RxFuncQuery('LoadLSRXUTFuncs')
      Then Do
             Call RxFuncAdd 'LoadLsRxutFuncs', 'LSRXUT', 'LoadLsRxutFuncs'
             Call LoadLsRxutFuncs
           End
      Else Nop

    Call ChkFile BootDrive'\os2\dll\rxutils.dll'
    If RxFuncQuery('RxLoadFuncs')
      Then Do
             Call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
             Call RxLoadFuncs
           End
      Else Nop

    TempFile = LSRDrive'\ibmlan\lstools.tmp'              /* Temporary file*/

    Return

 CHKFILE:/* -----------------------------------------------------------------*/

    Parse Arg File_To_Check

    If Stream(File_To_Check, 'C', 'Query Exists') = ''
      Then Do
             Say '! File not found:' File_To_Check
             Exit
           End
      Else Nop

    Return

 LOGIT:/* -------------------------------------------------------------------*/

    Parse Arg OutFileName OutText

    If LineOut(OutFileName, OutText) = 0
      Then Call Stream OutFileName, 'C', 'Close'
      Else Say '! Error while writing:' OutFileName '07'x

    Return

