/*---------------------------------------------------------------------------*\
|   Refresh all Server Objects found into the Domain                          |
|                                             (C) Alain Rykaert - NOV98-MAY01 |
\*---------------------------------------------------------------------------*/
    Version = '1.04'
    Say '* refresh version:' Version

    Parse Upper Arg DCName

    Call Init                    /* Initialisation of DLL's and other stuff*/

    If DCName = ''
      Then Do
             Say '*'
             Say '* refresh all servers objects'
             Say '*'
             Say '* usage: refresh {servername}'
             Say '*'
             Say '* sample: refresh \\dc01'
             Say '*'
             Exit
           End
      Else Nop

    RC = NetGetInfo(370, 'ServerModalInfo', '\\'DCName)
    If RC = 0
      Then Do
             ServerRole = ServerModalInfo.Role
             If WordPos('Primary', ServerRole) > 0     /* check server role*/
               Then Nop
               Else Do
                      Say '! this is not a primary domain controller' '07'x
                      Exit
                    End
           End
      Else Call ChkError RC

 /* Get the Domain name from the DC-PR */
    Call SysFileSearch 'DOMAIN =', '\\'DCName'\ibmlan$\ibmlan.ini', 'File.'
    If File.0 > 0
      Then Do i = 1 to File.0
             If Pos(';', File.i) = 0
               Then Parse Upper Value File.i With . '=' DomainName .
               Else Nop
           End
       Else Do
              Say '! unable to determine the domain name' '07'x
              Say '! from the primary domain controller' DCName
              Say '  (or not logon as an administrator)'
              Say '* press any key to exit'
              Pull
              Exit
           End
    Say '> the name of the domain is:' DomainName

 /* Make a subdirectory with the Domain name*/
    Call ChkDir Directory()'\'DomainName

    Say '* getting all servers member of the domain'
    If NetGetInfo(340, 'ServerName', '\\'DCName, 'Servers') = 0
      Then Do
             Call RxStemSort 'ServerName'
             Do i = 1 to ServerName.0
               Call ChkDir Directory()'\'DomainName'\'ServerName.i
               Counter = '('Right(i,Length(ServerName.0))'/'Right(ServerName.0,Length(ServerName.0))')'
               Parse Value SysCurPos() With Row Col
               Call Time('R')
               If NetGetInfo(160, 'ServerNameInfo', '\\'ServerName.i) = 0
                 Then Do
                        RC = NetGetInfo(370, 'ServerModalInfo', '\\'ServerName.i)
                        ServerRole = ServerModalInfo.Role
                        Say '>' Counter Left(ServerName.i,8) 'found:' Trunc(Time('E'),2) '- comment:' ServerNameInfo.Comment
                     /* Say '  > role:' ServerRole */
                        Call GetInfo ServerName.i        /* Get the details*/
                      End
                 Else
               Say '!' Counter Left(ServerName.i,8) '-not found-'
             End
           End
      Else Say '! can not get netgetinfo from \\'DCName '07'x

    Say '* done. press any key to exit'
    Pull

    Exit

 GETINFO:/* -----------------------------------------------------------------*/

    Parse Arg ServerName

    UNC_OS2    = ''                                           /* Drive OS/2*/
    UNC_MPTS   = ''                                   /* Drive MPTS or LAPS*/
    UNC_LSR    = ''                                     /* Drive Lan Server*/
    UNC_CM2    = ''                                           /* Drive CM/2*/
    DRV_NETFIN = ''                         /* Drive Netfinity or Systemvie*/
    UNC_NETFIN = ''
    DRV_ADSM   = ''                                           /* Drive ADSM*/
    UNC_ADSM   = ''
    DRV_SD     = ''                                             /* Drive SD*/
    UNC_SD     = ''

 /* Execute the batch file on the server */
   'net admin \\'ServerName '/c set >' TempFile
    Call Stream  TempFile, 'C', 'Close'
    If Stream(TempFile, 'C', 'Query Size') > 0
      Then Nop
      Else Do
             Say '! error: tempfile' TempFile 'is not valid' '07'x
             Return
           End

    Call SysFileSearch 'COMSPEC=', TempFile, 'Stem'
    If Stem.0 = 1
      Then Do
             Parse Value Stem.1 With . '=' ServerBootDrive ':' .
             If Trace Then Say '> boot drive:' ServerBootDrive
             UNC_OS2 = '\\'ServerName'\'ServerBootDrive'$'
             LibPath = ''
             Call SysFileSearch 'LIBPATH=', '\\'ServerName'\'ServerBootDrive'$\config.sys', 'Stem'
             Do j = 1 to Stem.0
               Stem.j = Translate(Stem.j)
               If Left(Strip(Stem.j), 8) = 'LIBPATH='
                 Then Parse Value Stem.j With . '=' LibPath
                 Else Nop
             End
             If LibPath = ''
               Then Do
                      Say '! error: could not determine LibPath' '07'x
                      Return
                    End
               Else If Trace Then Say '> libpath:' LibPath
           End
      Else Do
             Say '! error: could not determine comspec' '07'x
             Return
           End

    If Pos('IBMCOM', LibPath) > 0                                   /* MPTS*/
      Then Do
             x = Pos('IBMCOM', LibPath) - 3
             UNC_MPTS = '\\'ServerName'\'SubStr(LibPath, x, 1)'$'
           End

    If Pos('IBMLAN', LibPath) > 0                             /* Lan Server*/
      Then Do
             x = Pos('IBMLAN', LibPath) - 3
             UNC_LSR = '\\'ServerName'\'SubStr(LibPath, x, 1)'$'
           End

    If Pos('TCPIP', LibPath) > 0                                  /* TCP/IP*/
      Then Do
             x = Pos('TCPIP', LibPath) - 3
             UNC_TCP = '\\'ServerName'\'SubStr(LibPath, x, 1)'$'
           End

    If Pos('CMLIB', LibPath) > 0                                    /* CM/2*/
      Then Do
             x = Pos('CMLIB', LibPath) - 3
             UNC_CM2 = '\\'ServerName'\'SubStr(LibPath, x, 1)'$'
           End

    If Pos('NETFIN', LibPath) > 0                              /* NetFinity*/
      Then Do
             x = Pos('NETFIN', LibPath) - 3
             UNC_NETFIN = '\\'ServerName'\'SubStr(LibPath, x, 1)'$'
             DRV_NETFIN = UNC_NETFIN'\NETFIN'
           End

    If Pos('SYSVIEW2', LibPath) > 0                           /* SystemView*/
      Then Do
             x = Pos('SYSVIEW2', LibPath) - 3
             UNC_NETFIN = '\\'ServerName'\'SubStr(LibPath, x, 1)'$'
             DRV_NETFIN = UNC_NETFIN'\SYSVIEW2'
           End

    If Pos('SOFTDIST', LibPath) > 0                                   /* SD*/
      Then Do
             x = Pos('SOFTDIST', LibPath) - 3
             UNC_SD = '\\'ServerName'\'SubStr(LibPath, x, 1)'$'
             DRV_SD = UNC_SD'\SOFTDIST'
           End

    If Pos('PGMS\NETFIN', LibPath) > 0               /* NetFinity at Morgan*/
      Then Do
             x = Pos('PGMS\NETFIN', LibPath) - 3
             UNC_NETFIN = '\\'ServerName'\'SubStr(LibPath, x, 1)'$'
             DRV_NETFIN = UNC_NETFIN'\PGMS\NETFIN'
           End

    If Pos('PGMS\SYSVIEW2', LibPath) > 0            /* SystemView at Morgan*/
      Then Do
             x = Pos('PGMS\SYSVIEW2', LibPath) - 3
             UNC_NETFIN = '\\'ServerName'\'SubStr(LibPath, x, 1)'$'
             DRV_NETFIN = UNC_NETFIN'\PGMS\SYSVIEW2'
           End

    If Pos('ADSM', LibPath) > 0                                     /* ADSM*/
      Then Do
             x = Pos('\ADSM', LibPath) - 3
             UNC_ADSM = '\\'ServerName'\'Left(LibPath,1)'$'
             DRV_ADSM = UNC_ADSM'\ADSM'
           End

    If Pos('ADSMCV3', LibPath) > 0                        /* ADSM version 3*/
      Then Do
             x = Pos('\ADSMCV3', LibPath) - 3
             UNC_ADSM = '\\'ServerName'\'Left(LibPath,1)'$'
             DRV_ADSM = UNC_ADSM'\ADSMCV3'
           End

    If Pos('PGMS\ADSM', LibPath) > 0                      /* ADSM at Morgan*/
      Then Do
             x = Pos('PGMS\ADSM', LibPath) - 3
             UNC_ADSM = '\\'ServerName'\'Left(LibPath,1)'$'
             DRV_ADSM = UNC_ADSM'\PGMS\ADSM'
           End

    If Pos('PGMS\SOFTDIST', LibPath) > 0                    /* SD at Morgan*/
      Then Do
             x = Pos('PGMS\SOFTDIST', LibPath) - 3
             UNC_SD = '\\'ServerName'\'SubStr(LibPath, x, 1)'$'
             DRV_SD = UNC_SD'\PGMS\SOFTDIST'
           End

    If Trace
      Then Do
             Say 'unc_os2    =' UNC_os2
             Say 'unc_mpts   =' UNC_mpts
             Say 'unc_lsr    =' UNC_lsr
             Say 'unc_cm2    =' UNC_cm2
             Say 'unc_netfin =' UNC_netfin
             Say 'unc_adsm   =' UNC_adsm
           End
      Else Nop

 /* make a folder of the server and link to crucial files*/
    Call MakeObjects

   'net use \\'ServerName'\'Left(ServerBootDrive,1)'$ /d >nul 2>nul'
   'net use \\'ServerName'\ipc$ /d >nul 2>nul'
   'net use \\'ServerName'\ibmlan$ /d >nul 2>nul'

    Return

 MAKEOBJECTS:/* -------------------------------------------------------------*/

    Select                                           /* Get the folder icon*/
      When ServerRole = 'Primary server in the domain'
        Then IconFile = Directory()'\pdc.ico'
      When ServerRole = 'Backup server in the domain'
        Then IconFile = Directory()'\bdc.ico'
      Otherwise IconFile = Directory()'\os2res63.ico'
    End

    Class    = 'WPFolder'
    Title    =  ServerName || '^' || ServerNameInfo.Comment
    Location = '<LSMT_SERVERS_'DomainName'>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_'ServerName'>;' ||,
               'ICONVIEW=FLOWED;'                                   ||,
               'ICONVIEWPOS=40,20,55,65;'                           ||,
               'ICONFONT=10.System VIO;'                            ||,
               'ICONFILE='IconFile';'                               ||,
               'ALWAYSSORT=YES'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = 'CONFIG.SYS'
    Location = '<LSMT_SERVERS_'DomainName'_'ServerName'>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_'ServerName'_CONFIG>;'  ||,
               'ICONFILE='Directory()'\1000.ico;'                           ||,
               'PROGTYPE=PM;'                                               ||,
               'EXENAME=e.exe;'                                             ||,
               'PARAMETERS='UNC_OS2'\config.sys'
    Update   = 'Update'
    Call CreateObj

    Call Compit UNC_OS2'\config.sys',
                  Directory()'\'DomainName'\'ServerName'\config.sys'

    Class    = 'WPProgram'
    Title    = 'STARTUP.CMD'
    Location = '<LSMT_SERVERS_'DomainName'_'ServerName'>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_'ServerName'_STARTUP>;' ||,
               'ICONFILE='Directory()'\train.ico;'                          ||,
               'PROGTYPE=PM;'                                               ||,
               'EXENAME=e.exe;'                                             ||,
               'PARAMETERS='UNC_OS2'\startup.cmd'
    Update   = 'Update'
    Call CreateObj

    Call Compit UNC_OS2'\startup.cmd',
                  Directory()'\'DomainName'\'ServerName'\startup.cmd'

    If Stream(UNC_OS2'\timexec.adm', 'C', 'Query Exists') = ''
      Then Nop
      Else Do
             Class    = 'WPProgram'
             Title    = 'TIMEXEC.ADM'
             Location = '<LSMT_SERVERS_'DomainName'_'ServerName'>'
             Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_'ServerName'_TIMEXEC>;' ||,
                        'ICONFILE='Directory()'\timer.ico;'                          ||,
                        'PROGTYPE=PM;'                                               ||,
                        'EXENAME=e.exe;'                                             ||,
                        'PARAMETERS='UNC_OS2'\timexec.adm'
             Update   = 'Update'
             Call CreateObj

             Call Compit UNC_OS2'\timexec.adm',
                           Directory()'\'DomainName'\'ServerName'\timexec.adm'
           End

    If Stream(UNC_OS2'\os2\install\ipl.log', 'C', 'Query Exists') = ''
      Then Nop
      Else Do
             Class    = 'WPProgram'
             Title    = 'IPL.LOG'
             Location = '<LSMT_SERVERS_'DomainName'_'ServerName'>'
             Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_'ServerName'_IPLLOG>;' ||,
                        'ICONFILE='Directory()'\logfile.ico;'                       ||,
                        'PROGTYPE=PM;'                                              ||,
                        'EXENAME=e.exe;'                                            ||,
                        'PARAMETERS='UNC_OS2'\os2\install\ipl.log'
             Update   = 'Update'
             Call CreateObj
             Call Compit UNC_OS2'\os2\install\ipl.log',
                         Directory()'\'DomainName'\'ServerName'\ipl.log'
           End

    Class    = 'WPProgram'
    Title    = 'PROTOCOL.INI'
    Location = '<LSMT_SERVERS_'DomainName'_'ServerName'>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_'ServerName'_PROTOCOL>;' ||,
               'ICONFILE='Directory()'\1018.ico;'                            ||,
               'PROGTYPE=PM;'                                                ||,
               'EXENAME=e.exe;'                                              ||,
               'PARAMETERS='UNC_MPTS'\ibmcom\protocol.ini'
    Update   = 'Update'
    Call CreateObj

    Call Compit UNC_MPTS'\ibmcom\protocol.ini',
                Directory()'\'DomainName'\'ServerName'\protocol.ini'

    If Stream(UNC_MPTS'\ibmcom\rfcnames.lst', 'C', 'Query Exists') = ''
      Then Nop
      Else Do
             Class    = 'WPProgram'
             Title    = 'RFCNAMES.LST'
             Location = '<LSMT_SERVERS_'DomainName'_'ServerName'>'
             Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_'ServerName'_RFCNAMES>;' ||,
                        'PROGTYPE=PM;'                                                ||,
                        'EXENAME=e.exe;'                                              ||,
                        'PARAMETERS='UNC_MPTS'\ibmcom\rfcnames.lst'
             Update   = 'Update'
             Call CreateObj
             Call Compit UNC_MPTS'\ibmcom\rfcnames.lst',
                         Directory()'\'DomainName'\'ServerName'\rfcnames.lst'
           End

    If Stream(UNC_MPTS'\ibmcom\rfcbcst.lst', 'C', 'Query Exists') = ''
      Then Nop
      Else Do
             Class    = 'WPProgram'
             Title    = 'RFCBCST.LST'
             Location = '<LSMT_SERVERS_'DomainName'_'ServerName'>'
             Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_'ServerName'_RFCBCST>;'  ||,
                        'PROGTYPE=PM;'                                                ||,
                        'EXENAME=e.exe;'                                              ||,
                        'PARAMETERS='UNC_MPTS'\ibmcom\rfcbcst.lst'
             Update   = 'Update'
             Call CreateObj
             Call Compit UNC_MPTS'\ibmcom\rfcbcst.lst',
                         Directory()'\'DomainName'\'ServerName'\rfcbcst.lst'
           End

    Class    = 'WPProgram'
    Title    = 'LANTRAN.LOG'
    Location = '<LSMT_SERVERS_'DomainName'_'ServerName'>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_'ServerName'_LANTRAN>;' ||,
               'ICONFILE='Directory()'\netinfo.ico;'                        ||,
               'PROGTYPE=PM;'                                               ||,
               'EXENAME=e.exe;'                                             ||,
               'PARAMETERS='UNC_MPTS'\ibmcom\lantran.log'
    Update   = 'Update'
    Call CreateObj

    Call Compit UNC_MPTS'\ibmcom\lantran.log',
                  Directory()'\'DomainName'\'ServerName'\lantran.log'

    Class    = 'WPProgram'
    Title    = 'IBMLAN.INI'
    Location = '<LSMT_SERVERS_'DomainName'_'ServerName'>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_'ServerName'_IBMLAN>;' ||,
               'ICONFILE='Directory()'\1055.ico;'                          ||,
               'PROGTYPE=PM;'                                              ||,
               'EXENAME=e.exe;'                                            ||,
               'PARAMETERS='UNC_LSR'\ibmlan\ibmlan.ini'
    Update   = 'Update'
    Call CreateObj

    Call Compit UNC_LSR'\ibmlan\ibmlan.ini',
                  Directory()'\'DomainName'\'ServerName'\ibmlan.ini'

    If Stream(UNC_LSR'\IBM386FS\HPFS386.INI', 'C', 'Query Exists') = ''
      Then Nop
      Else Do
             Class    = 'WPProgram'
             Title    = 'HPFS386.INI'
             Location = '<LSMT_SERVERS_'DomainName'_'ServerName'>'
             Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_'ServerName'_HPFS386>;' ||,
                        'ICONFILE='Directory()'\hpfs386.ico;'                       ||,
                        'PROGTYPE=PM;'                                               ||,
                        'EXENAME=e.exe;'                                             ||,
                        'PARAMETERS='UNC_LSR'\ibm386fs\hpfs386.ini'
             Update   = 'Update'
             Call CreateObj
             Call Compit UNC_LSR'\ibm386fs\hpfs386.ini',
                         Directory()'\'DomainName'\'ServerName'\hpfs386.ini'
           End

    If Stream(DRV_ADSM'\dsm.opt', 'C', 'Query Exists') = ''
      Then Nop
      Else Do
             Class    = 'WPProgram'
             Title    = 'DSM.OPT'
             Location = '<LSMT_SERVERS_'DomainName'_'ServerName'>'
             Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_'ServerName'_DSMOPT>;' ||,
                        'ICONFILE='Directory()'\adsm.ico;'                        ||,
                        'PROGTYPE=PM;'                                              ||,
                        'EXENAME=e.exe;'                                            ||,
                        'PARAMETERS='DRV_ADSM'\dsm.opt'
             Update   = 'Update'
             Call CreateObj
             Call Compit DRV_ADSM'\dsm.opt',
                         Directory()'\'DomainName'\'ServerName'\dsm.opt'
           End

    If Stream(DRV_ADSM'\dsmp.opt', 'C', 'Query Exists') = ''
      Then Nop
      Else Do
             Class    = 'WPProgram'
             Title    = 'DSMP.OPT'
             Location = '<LSMT_SERVERS_'DomainName'_'ServerName'>'
             Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_'ServerName'_DSMPOPT>;' ||,
                        'ICONFILE='Directory()'\adsm.ico;'                         ||,
                        'PROGTYPE=PM;'                                               ||,
                        'EXENAME=e.exe;'                                             ||,
                        'PARAMETERS='DRV_ADSM'\dsmp.opt'
             Update   = 'Update'
             Call CreateObj
             Call Compit DRV_ADSM'\dsmp.opt',
                         Directory()'\'DomainName'\'ServerName'\dsmp.opt'
           End

    If UNC_CM2 = ''
      Then Nop
      Else Do
             Call SysFileSearch 'CMDefaultCFG', UNC_CM2'\CMLIB\CM.INI', 'File.'
             If File.0 = 1
              Then Do
                      Parse Value File.1 With '=' CM2NDF
                      CM2NDF = Strip(CM2NDF)

                      Class    = 'WPProgram'
                      Title    = CM2NDF'.NDF'
                      Location = '<LSMT_SERVERS_'DomainName'_'ServerName'>'
                      Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_'ServerName'_CM2NDF>;' ||,
                                 'ICONFILE='Directory()'\cm2.ico;'                           ||,
                                 'PROGTYPE=PM;'                                              ||,
                                 'EXENAME=e.exe;'                                            ||,
                                 'PARAMETERS='UNC_CM2'\cmlib\'CM2NDF'.NDF'
                      Update   = 'Update'
                      Call CreateObj
                      Call Compit UNC_CM2'\cmlib\'CM2NDF'.ndf',
                                  Directory()'\'DomainName'\'ServerName'\'CM2NDF'.ndf'
                   End
              Else Nop
           End

    Call SysFileSearch 'SET ETC=', UNC_OS2'\CONFIG.SYS', 'File.'
    If File.0 > 0                  /* Check for older tcp/ip implementation*/
      Then Do j = 1 to File.0
             If Pos('REM', Translate(File.j)) = 0
              Then Do
                     Parse Value File.j With . '=' Drive ':\' ETC_Location '\' .

                     UNC_ETC = '\\'ServerName'\'Drive'$\'ETC_Location'\BIN'

                     If Stream(UNC_ETC'\Setup.cmd', 'C', 'Query Exists') <> ''
                       Then Do
                              Class    = 'WPProgram'
                              Title    = 'TCP/IP^Setup.CMD'
                              Location = '<LSMT_SERVERS_'DomainName'_'ServerName'>'
                              Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_'ServerName'_SETUP>;'      ||,
                                         'ICONFILE='Directory()'\tcpcfg.ico;'              ||,
                                         'PROGTYPE=PM;'                                      ||,
                                         'EXENAME=e.exe;'                                    ||,
                                         'PARAMETERS='UNC_ETC'\setup.cmd'
                              Update   = 'Update'
                              Call CreateObj
                              Call Compit UNC_ETC'\setup.cmd',
                                   Directory()'\'DomainName'\'ServerName'\setup.cmd'
                            End
                        Else Nop
                   End
              Else Nop
          End
     Else Nop

    If Stream(DRV_SD'\nvdm.cfg', 'C', 'Query Exists') = ''
      Then Nop
      Else Do
             Class    = 'WPProgram'
             Title    = 'NVDM.CFG'
             Location = '<LSMT_SERVERS_'DomainName'_'ServerName'>'
             Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_'ServerName'_NVDM>;'   ||,
                        'ICONFILE='Directory()'\swfold.ico;'                        ||,
                        'PROGTYPE=PM;'                                              ||,
                        'EXENAME=e.exe;'                                            ||,
                        'PARAMETERS='DRV_SD'\nvdm.cfg'
             Update   = 'Update'
             Call CreateObj
             Call Compit DRV_SD'\nvdm.cfg',
                         Directory()'\'DomainName'\'ServerName'\nvdm.cfg'
           End

    Class    = 'WPProgram'
    Title    = '<System Info>'
    Location = '<LSMT_SERVERS_'DomainName'_'ServerName'>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_'ServerName'_QSYSTEM>;' ||,
               'ICONFILE='Directory()'\sysinfo.ico;'                        ||,
               'PROGTYPE=windowablevio;'                                    ||,
               'EXENAME='Directory()'\q_system.cmd;'                        ||,
               'PARAMETERS='ServerName
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = '<Check>'
    Location = '<LSMT_SERVERS_'DomainName'_'ServerName'>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_'ServerName'_CHECK>;' ||,
               'ICONFILE='Directory()'\watson.ico;'                       ||,
               'PROGTYPE=windowablevio;'                                  ||,
               'EXENAME='Directory()'\q_lsc.cmd;'                         ||,
               'MINIMIZED=Yes;'                                           ||,
               'PARAMETERS='ServerName Directory()'\'DomainName'\'ServerName'\lsc.out 0'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = '<Statistics>'
    Location = '<LSMT_SERVERS_'DomainName'_'ServerName'>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_'ServerName'_STATISTICS>;' ||,
               'ICONFILE='Directory()'\1054.ico;'                              ||,
               'PROGTYPE=windowablevio;'                                       ||,
               'EXENAME='Directory()'\q_lsc.cmd;'                              ||,
               'MINIMIZED=Yes;'                                                ||,
               'PARAMETERS='ServerName Directory()'\'DomainName'\'ServerName'\stats.out 1'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = '<Printer Queues>'
    Location = '<LSMT_SERVERS_'DomainName'_'ServerName'>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_'ServerName'_QUEUES>;' ||,
               'ICONFILE='Directory()'\dotmprn.ico;'                       ||,
               'PROGTYPE=windowablevio;'                                   ||,
               'EXENAME='Directory()'\q_print.cmd;'                        ||,
               'MINIMIZED=Yes;'                                            ||,
               'PARAMETERS='ServerName Directory()'\'DomainName'\'ServerName'\qprint.out'
    Update   = 'Update'
    Call CreateObj
/*
    Call Compit '\\'ServerName'\ibmlan$\netprog\qsystem.out',
                  Directory()'\'DomainName'\'ServerName'\qsystem.out'  */

    Class    = 'WPProgram'
    Title    = '<LS Audit>'
    Location = '<LSMT_SERVERS_'DomainName'_'ServerName'>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_'ServerName'_LSAUDIT>;' ||,
               'ICONFILE='Directory()'\message.ico;'                        ||,
               'PROGTYPE=PM;'                                               ||,
               'EXENAME='Directory()'\lsaudit.exe;'                         ||,
               'PARAMETERS='ServerName
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = '<LS Error>'
    Location = '<LSMT_SERVERS_'DomainName'_'ServerName'>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_'ServerName'_LSERROR>;' ||,
               'ICONFILE='Directory()'\log.ico;'                            ||,
               'PROGTYPE=PM;'                                               ||,
               'EXENAME='Directory()'\lserror.exe;'                         ||,
               'PARAMETERS='ServerName
    Update   = 'Update'
    Call CreateObj

    Return

 CREATEOBJ:/* ---------------------------------------------------------------*/

 /* Say ' Title    =' Title
    Say ' Location =' Location
    Say ' Setup    =' Setup */

    If SysCreateObject(Class, Title, Location, Setup, Update) = 1
      Then Nop
      Else Say '! error: while creating object' Title '07'x

    Parse Value Setup With 'OBJECTID=' ObjectID ';' .
    Call SysSetObjectData ObjectID, 'Title='Title

    Return

 CHKERROR:/* ----------------------------------------------------------------*/

    Parse Arg RCode

    Say '! error:' RCode '07'x
    Exit

    Return

 INIT:/* --------------------------------------------------------------------*/

   '@echo off'

    If Value('TREES',,'OS2Environment') = ''           /* Check for Tracing*/
      Then Trace = 0
      Else Trace = 1

    BootDrive = Left(Value('Comspec',,'OS2Environment'),2)

    Redir = '>nul'

    If RxFuncQuery('SysLoadFuncs')
      Then Do
             Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
             Call SysLoadFuncs
           End
      Else Nop

    LSRDrive = ''                      /* Check for Lan Server Drive Letter*/
    LibPath = Translate(Value('PATH',,'OS2Environment'))
    x = Pos('\IBMLAN\NETPROG;', LibPath) -2
    If x > 0
      Then LSRDrive = SubStr(LibPath, x, 2)
      Else Do
             Say '* could not determine the lan requester path'
             Exit
           End

    Call ChkFile LSRDrive'\ibmlan\netlib\lsrxut.dll'
    If RxFuncQuery('LoadLSRXUTFuncs')
      Then Do
             Call RxFuncAdd 'LoadLsRxutFuncs', 'LSRXUT', 'LoadLsRxutFuncs'
             Call LoadLsRxutFuncs
           End
      Else Nop

    Call ChkFile BootDrive'\os2\dll\rxutils.dll'
    If RxFuncQuery('RxLoadFuncs')
      Then Do
             Call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
             Call RxLoadFuncs
           End
      Else Nop

    TempFile = LSRDrive'\ibmlan\refresh.tmp'              /* Temporary file*/

    Return

 CHKFILE:/* -----------------------------------------------------------------*/

    Parse Arg File

    If Stream(File, 'C', 'Query Exists') = ''
    Then Do
           Say '! file not found:' File '07'x
           Say '* press any key to exit'
           Exit
        End
    Else Nop

    Return

 CHKDIR:/* ----------------------------------------------------------------*/

    Parse Arg Dir_Name

    RCode = 0                                      /* Reset the Return Code*/

    If Stream(Dir_Name, 'C', 'Query Exists') <> ''      /* is this a file ?*/
      Then RCode = 1   /* Bad RC, there already exist a file With this name*/
      Else Do
             Call SysFileTree Dir_Name, 'DirExist', 'Do'/* Does this DIR exist ?*/
             If DirExist.0 = 0
               Then Do
                      RC = SysMKDir(Dir_Name)
                      If RC <> 0
                        Then RCode = 1
                        Else Nop
                    End
               Else Nop
           End

    If RCode = 1
      Then Do
             Say '! error while creating' Dir_Name '07'x
             Say '* press any key to exit'
             Pull
             Exit
           End
      Else Nop

    Return

 COMPIT:  /* ------------------------------------------------- COMPIT: ----*/

    Parse Arg Source Target

    If Source = '' | Source = '\' | Target = ''
      Then Return
      Else Nop

    If Stream(Source, 'C', 'Query Exists') <> ''
      Then Do
             Q1 = Stream(Source, 'C', 'Query DateTime')
             Q2 = Stream(Target, 'C', 'Query DateTime')
             If Q1 <> Q2
               Then Do
                  /*  Say '09'x ESC'[0;33m Copy' Source ESC'[0m' */
                     'copy' Source Target Redir
                      If RC <> 0
                        Then Do
                               Say '! error while coping' Source 'to' Target '07'x
                              'pause'
                               Return
                             End
                        Else Nop
                    End
               Else Nop
          End
      Else Nop

    Return

