/*---------------------------------------------------------------------------*\
|   SET all ALIAS to a LAN Server 3.0 and higher                              |
|   from an ASCII File                                                        |
|                                   (C) Alain Rykaert IBM Belgium SEP95-MAY96 |
\*---------------------------------------------------------------------------*/

    Parse Arg Option

    Call INIT                    /* Initialisation of DLL's and other stuff*/
    Call CHKOPT                          /* Check Options & display Welcome*/
    Call CHKPWS                               /* Check the PWS & Admin name*/
    Call MAIN                                            /* do the main job*/
    Call QUIT                                                       /* Quit*/

 MAIN:/* ------------------------------------------------------ MAIN: -------*/

    Call Time('R')
   'if exist' CHKF 'del' CHKF

    AC = 0
    DC = 0
    EC = 0
    ExitCode = X2D('FE00')                          /* Good CID Return code*/

    do while Lines(INPF)
       LLINE = LineIN(INPF)
       OLINE = LLINE
       parse value LLINE with OPT ';' LLINE
       select
        when OPT = '',
         | LLINE = '',
         | Left(Strip(OPT),1) = '*' then Iterate
        when Translate(OPT) = 'OPT' then Call COLUMNS
        when Translate(OPT) = 'A'   then Call ADDALIAS
        when Translate(OPT) = 'D'   then Call DELALIAS
        when Translate(OPT) = 'U'   then Call UPDALIAS
        otherwise Iterate
       end
       if EC
        then do
                 Call LineOut CHKF, OLINE
                 EC = 0
                 ExitCode = X2D('1604')              /* Bad CID return code*/
             end
        else Nop
    end
    say '0909'x 'Total Time  =' Trunc(Time('E'),2)

    if AC then do
                 Topic_List = 'CHKAPPL'
                 Call GETANS
                                       /* if an Alias is Added, Apply !     */
               end
    if DC then do
                 Topic_List = 'CHKASSGN'
                 Call GETANS
                                       /* if an Alias is delete, CHKASG     */
               end

    Return

 ADDALIAS:/* -------------------------------------------------- ADDALIAS: ---*/

    EC = 0                                                   /* Error Check*/
    RCode = 0          /* Return code can be set to 1 by the CHKDIR routine*/

    i  = 0
    do while LLINE <> ''
       i = i + 1
       COLNAME = Strip(COLNAME.i)
       parse value LLINE with VALUE ';' LLINE
       ALIASINFO.COLNAME = Strip(VALUE)
    end

    if TRACE
     then do j = 1 to COLT
             COLNAME = Strip(COLNAME.j)
             say '09'x '>'ALIASINFO.COLNAME'<' C2X(ALIASINFO.COLNAME)
          end
     else Nop

    Dest_Dir = ALIASINFO.PATH
    DRIVE  = Left(Dest_Dir,1)

    hi = 0
    do while Dest_Dir <> ''
       hi = hi + 1
       parse value Dest_Dir with DIR.hi '\' Dest_Dir /*                          */
    end

    if Left(ALIASINFO.SERVER,2) = '\\'              /* older LS 3.0 use this */
     then Dest_Dir =     ALIASINFO.SERVER'\'DRIVE'$'
     else Dest_Dir = '\\'ALIASINFO.SERVER'\'DRIVE'$'

    do hj = 2 to hi
       Dest_Dir = Dest_Dir'\'DIR.hj
       Call ChkDir Dest_Dir               /* Check the destination Directory */
    end

    if RCode           /* if an error occured while cheking the destination  */
     then Return       /*  leave the Add routine */
     else Nop

    RC = NetAdd(20, 'ALIASINFO', '\\'SRVNAME)
    if RC = 0
       then do
               RC = ''
               AC = 1
            end
       else EC = 1
    Call LOGIT 'Add Alias', ALIASINFO.NAME, RC

    Return

 DELALIAS: /*-------------------------------------------------- DELALIAS: ---*/

    EC = 0           /* Error Check */
    RCode = 0        /* Return code can be set to 1 by the CHKDIR routine */

    i  = 0
    do while LLINE <> ''
       i = i + 1
       COLNAME = Strip(COLNAME.i)
       parse value LLINE with VALUE ';' LLINE
       ALIASINFO.COLNAME = Strip(VALUE)
    end

    RC = NetDelete(20, '\\'SRVNAME, ALIASINFO.NAME)
    if RC = 0
       then do
               RC = ''
               DC = 1        /* if an ALIAS is delete, warn the ADMIN ! */
            end
       else EC = 1

    Call LOGIT 'Delete Alias', ALIASINFO.NAME, RC

    Return

 UPDALIAS: /*-------------------------------------------------- UPDALIAS: ---*/

    EC = 0           /* Error Check */
    RCode = 0        /* Return code can be set to 1 by the CHKDIR routine */

    i  = 0
    do while LLINE <> ''
       i = i + 1
       COLNAME = Strip(COLNAME.i)
       parse value LLINE with VALUE ';' LLINE
       ALIASINFO.COLNAME = Strip(VALUE)
    end

    if TRACE
     then do j = 1 to COLT
             COLNAME = Strip(COLNAME.j)
             say '09'x '>'ALIASINFO.COLNAME'<' C2X(ALIASINFO.COLNAME)
          end
     else Nop

    RC = NetGetInfo(20, 'OLDINFO', '\\'SRVNAME, ALIASINFO.NAME) /* Get OLD ALIAS setting */
    if RC = 0
       then Nop
       else do
               Call LOGIT 'Get Alias', ALIASINFO.NAME, RC
               Return
            end

    do j = 1 to COLT
       COLNAME = Strip(COLNAME.j)
       if OLDINFO.COLNAME <> ALIASINFO.COLNAME
        then do
                select
                 when COLNAME = 'NAME'     |,
                      COLNAME = 'SERVER'   |,
                      COLNAME = 'PATH'     |,
                      COLNAME = 'NETNAME'  |,
                      COLNAME = 'LOCATION'
                  then Call LOGIT 'Update Alias', ALIASINFO.COLNAME COLNAME '- Update not allowed', ''
                 otherwise Call SETINFO
                end
             end
        else Nop
    end

    Return

 CHKDIR: /*---------------------------------------------------- CHKDIR: ----*/

    Parse Arg Dir_Name

    RCode = 0   /* Reset the Return Code */

    if Stream(Dir_Name, 'C', 'QUERY EXIST') <> '' /* is this a file ? */
     then RCode = 1  /* Bad RC, there already exist a file with this name */
     else do
             Call SysFileTree Dir_Name, 'DIREXIST', 'DO' /* does this DIR exist ? */
             if DIREXIST.0 = 0
              then do
                      RC = SysMKDir(Dir_Name)
                      if RC <> 0
                       then RCode = 1
                       else Nop
                   end
              else Nop
          end

    if RCode = 1
     then do
             LOG_Text = 'Error while creating' Dir_Name
             Call Logit 'Create Directory', LOG_Text, RCode
          end
     else Nop

    Return

 SETINFO: /*--------------------------------------------------- SETINFO: ----*/

    RC = NetSetInfo(20, COLNAME, ALIASINFO.COLNAME, '\\'SRVNAME, ALIASINFO.NAME)
     if RC = 0
      then RC = ''
      else Nop
    Call LOGIT 'Update Alias', ALIASINFO.NAME '-' ALIASINFO.COLNAME, RC

    Return

 COLUMNS: /*--------------------------------------------------- COLUMNS: ----*/

    i = 0
    do while LLINE <> ''
       i = i + 1
       parse value LLINE with COLNAME.i ';' LLINE
       if OPTION = 1
          then say '09'x ESC'[0;1;35m' COLNAME.i ESC'[0m'
          else Nop
    end

    if COLNAME.1 <> 'NAME'
     then do
             OUT = 'Error reading' INPF ': Column 2 MUST be NAME, Column 3 MUST be PASSWORD'
             say ESC'[0;1;31m' OUT  ESC'[0m'
             Call LOGIT OUT
             Exit
          end
     else Nop

    COLT = i                      /* Total numbers of columns */

    Return

 CHKOPT: /*---------------------------------------------------- CHKOPT: -----*/

    SRVNAME = '';
    INPF = 'ALIAS.CSV';
    LOGF = 'LSMT.LOG';
    CHKF = 'ALIAS.CHK';
    PIPE = '';
    TRACE = 0;
    MUTE = 0;

    OPTION = Translate(OPTION)
    do while OPTION <> ''
       Parse value OPTION with ARGUMENT ' ' OPTION
       select
        when Left(ARGUMENT,5) = '/SRV:' then SRVNAME = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/INP:' then INPF    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/LOG:' then LOGF    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/CHK:' then CHKF    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/PIP:' then PIPE    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,2) = '/M'    then MUTE    = 1
        when Left(ARGUMENT,2) = '/T'    then TRACE   = 1
        otherwise Nop
       end
    end

    if SRVNAME = '' then signal GETHELP

    if \MUTE
     then do
             Topic1 = 'SETWELCOME'
             Topic_String.Topic1.1 = SRVNAME
             Topic_String.Topic1.2 = INPF
             Topic_String.Topic1.3 = LOGF
             Topic_String.Topic1.4 = CHKF
             Topic_String.Topic1.5 = PIPE' '
             Topic_List = 'WELCOMELOGO' Topic1 'SETALIAS'
             Call GETANS
             Parse VALUE SysCurPos() With Old_R Old_C; '@pause'
             Call SysCurPos Old_R, Old_C; say ESC'[K'
          end
     else do
             say 'ServerName =' SRVNAME
             say 'InputFile  =' INPF
             say 'LogFile    =' LOGF
             say 'CheckFile  =' CHKF
          end

    Return

 CHKPWS: /*---------------------------------------------------- CHKPWS: -----*/

    RC = NetGetInfo(350, 'WKSTAINFO','')
    if RC = 0
     then do
             ADMNAME = WKSTAINFO.UserName
             PWSNAME = WKSTAINFO.ComputerName
          end
     else do
            Call LOGIT 'Get PWS Info', ,RC
            Call Quit
          end

    Return

 INIT: /*------------------------------------------------------ INIT: -------*/

    Call RgUtil   '/m' /* Rexx Utilities        */
    Call RgUtils  '/m' /* Rexx Utilities        */
    Call RgLSRXUT '/m' /* Lan Server Rexx Utils */

    Parse Upper Source . . P_NAME
    PRGN = Filespec('N', Left(P_NAME, Length(P_NAME) -4))

   '@echo off'
    ESC   = '1B'x
    REDIR = '>NUL 2>NUL'

    Resource_File = 'LSMT.RSC'
    Call CHKFILE Resource_File

    Return

 GETANS: /*---------------------------------------------------- GETANS: -----*/

    Vars_List = Ansi_Say(Resource_File Topic_List)

    Parse VALUE SysCurPos() With Old_R Old_C

    Do While Vars_List <> ''
       Parse VALUE Vars_List With Topic_Id ';' Var_Id ';' Row ';' Column ';' Color ';' Vars_List
       Call SysCurPos Row, Column
       Say x2c(Color) || Topic_String.Topic_Id.Var_Id || '1B'x || '[0m'
       End
    Call SysCurPos Old_R, Old_C

    Return

 GETHELP: /*--------------------------------------------------- GETHELP: ----*/

    if \MUTE
     then do
             Topic1 = 'SETHELP'
             Topic_String.Topic1.1 = PRGN ;
             Topic_List = Topic1
             Call GETANS
          end
     else say 'Incorrect options.'

    Call QUIT

    Return

 CHKFILE: /*--------------------------------------------------- CHKFILE: ----*/

    Parse Arg FILE

    RC = Stream(FILE, 'C', 'QUERY EXIST')
    if RC = ''
     then do
             say ' File' FILE 'not found.'
             Call QUIT
          end
     else Nop
    Call Stream FILE, 'C', 'CLOSE'

    Return

 LOGIT: /*----------------------------------------------------- LOGIT: ------*/

    FUNC = ARG(1); INFO = ARG(2); RCOD = ARG(3)
    RC = LLOGIT(LOGF, PIPE, ADMNAME, PRGN, FUNC, INFO, RCOD)

    Return

 QUIT: /*------------------------------------------------------ QUIT: -------*/

    Call LineOut 'LSMT.END', PRGN, 1
    Call Stream  'LSMT.END', 'C', 'CLOSE'
    Call Stream   INPF,      'C', 'CLOSE'
    Call Stream   LOGF,      'C', 'CLOSE'
    Call Stream   CHKF,      'C', 'CLOSE'
    Exit ExitCode

 /*--------------------------------------------------------------------------*/
