/*---------------------------------------------------------------------------*\
|   SET all APPLICATION from LAN Server 3.0 and higher                        |
|   from an ASCII File                                                        |
|                                   (C) Alain Rykaert IBM-Belgium SEP95-MAY96 |
\*---------------------------------------------------------------------------*/

    Parse Arg Option

    Call INIT                    /* Initialisation of DLL's and other stuff*/
    Call CHKOPT                          /* Check Options & display Welcome*/
    Call CHKPWS                               /* Check the PWS & Admin name*/
    Call MAIN                                            /* do the main job*/
    Call QUIT                                                       /* Quit*/

 MAIN:/* ------------------------------------------------------ MAIN: -------*/

    Call Time('R')
   'if exist' CHKF 'del' CHKF
    EC = 0
    ExitCode = X2D('FE00')                          /* Good CID Return code*/

    do while Lines(INPF)
       LLINE = LineIN(INPF)
       OLINE = LLINE
       parse value LLINE with OPT ';' LLINE
       select
        when OPT = '',
         | LLINE = '',
         | Left(Strip(OPT),1) = '*' then Iterate
        when Translate(OPT) = 'OPT' then Call COLUMNS
        when Translate(OPT) = 'A'   then Call ADDAPPL
        when Translate(OPT) = 'D'   then Call DELAPPL
        when Translate(OPT) = 'U'   then Call UPDAPPL
        otherwise Iterate
       end
       if EC
        then do
                 Call LineOut CHKF, OLINE
                 EC = 0
                 ExitCode = X2D('1604')              /* Bad CID return code*/
             end
        else Nop
    end
    say '0909'x 'Total Time  =' Trunc(Time('E'),2)

    Return

 ADDAPPL:/* --------------------------------------------------- ADDAPPL: ----*/

    EC = 0
    i  = 0
    do while LLINE <> ''
       i = i + 1
       COLNAME = Strip(COLNAME.i)
       parse value LLINE with VALUE ';' LLINE
       APPLINFO.COLNAME = Strip(VALUE)
       if APPLINFO.COLNAME = '-none-' | APPLINFO.COLNAME = 'No Restriction'
        then APPLINFO.COLNAME = ''  /* Filters */
        else Nop
    end

    if TRACE
     then do j = 1 to COLT
             COLNAME = Strip(COLNAME.j)
             say '09'x '>'APPLINFO.COLNAME'<'
          end
     else Nop

    RC = NetAdd(30, 'APPLINFO', '\\'SRVNAME)
    if RC = 0
       then RC = ''
       else EC = 1
    Call LOGIT 'Add Application', APPLINFO.NAME, RC

    Return

 DELAPPL: /*--------------------------------------------------- DELAPPL: ----*/

    EC = 0
    i  = 0
    do while LLINE <> ''
       i = i + 1
       COLNAME = Strip(COLNAME.i)
       parse value LLINE with VALUE ';' LLINE
       APPLINFO.COLNAME = Strip(VALUE)
    end

    RC = NetDelete(30, '\\'SRVNAME, APPLINFO.NAME)
    if RC = 0
       then RC = ''
       else EC = 1
    Call LOGIT 'Delete Application', APPLINFO.NAME, RC

    Return

 UPDAPPL: /*--------------------------------------------------- UPDAPPL: ----*/

    EC = 0
    i  = 0
    do while LLINE <> ''
       i = i + 1
       COLNAME = Strip(COLNAME.i)
       parse value LLINE with VALUE ';' LLINE
       APPLINFO.COLNAME = Strip(VALUE)
    end

    if TRACE
     then do j = 1 to COLT
             COLNAME = Strip(COLNAME.j)
             say '09'x '>'APPLINFO.COLNAME'<'
          end
     else Nop

   /* Get OLD User settings */
    RC = NetGetInfo(30, 'OLDINFO', '\\'SRVNAME, APPLINFO.NAME)
    if RC = 0
       then RC = ''
       else do
               Call LOGIT 'Get Applications', APPLINFO.NAME, RC
               Return
            end

    do j = 1 to COLT
       COLNAME = Strip(COLNAME.j)
       if OLDINFO.COLNAME <> APPLINFO.COLNAME
        then Call SETINFO
        else Nop
    end

    Return

 SETINFO: /*--------------------------------------------------- SETINFO: ----*/

    RC = NetSetInfo(30, COLNAME, APPLINFO.COLNAME, '\\'SRVNAME, APPLINFO.NAME, '')
     if RC = 0
      then RC = ''
      else EC = 1
    Call LOGIT 'Update Application', APPLINFO.NAME '-' APPLINFO.COLNAME, RC

    Return

 COLUMNS: /*--------------------------------------------------- COLUMNS: ----*/

    BANNER = 'OPT'
    i = 0
    do while LLINE <> ''
       i = i + 1
       parse value LLINE with COLNAME.i ';' LLINE
       BANNER = BANNER';'COLNAME.i
    end
    if COLNAME.1 <> 'NAME'
     then do
             OUT = 'Error reading' INPF ': Column 2 MUST be NAME'
             Call LOGIT OUT
             Exit
          end
     else Nop
    COLT = i                      /* Total numbers of columns */

    Call LineOut CHKF, BANNER

    Return

 CHKOPT: /*---------------------------------------------------- CHKOPT: -----*/

    SRVNAME = '';
    INPF = 'APPL.CSV';
    LOGF = 'LSMT.LOG';
    CHKF = 'APPL.CHK';
    PIPE = '';
    TRACE = 0;
    MUTE = 0;

    OPTION = Translate(OPTION)
    do while OPTION <> ''
       Parse value OPTION with ARGUMENT ' ' OPTION
       select
        when Left(ARGUMENT,5) = '/SRV:' then SRVNAME = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/INP:' then INPF    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/LOG:' then LOGF    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/CHK:' then CHKF    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/PIP:' then PIPE    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,2) = '/M'    then MUTE    = 1
        when Left(ARGUMENT,2) = '/T'    then TRACE   = 1
        otherwise Nop
       end
    end

    if SRVNAME = '' then signal GETHELP

    if \MUTE
     then do
             Topic1='SETWELCOME'
             Topic_String.Topic1.1=SRVNAME;
             Topic_String.Topic1.2=INPF;
             Topic_String.Topic1.3=LOGF;
             Topic_String.Topic1.4=CHKF;
             Topic_String.Topic1.5=PIPE' ';
             Topic_List='WELCOMELOGO' Topic1 'SETAPPL';
             Call GETANS
             Parse VALUE SysCurPos() With Old_R Old_C; '@pause'
             Call SysCurPos Old_R, Old_C; say ESC'[K'
          end
     else do
             say 'ServerName =' SRVNAME
             say 'InputFile  =' INPF
             say 'LogFile    =' LOGF
             say 'CheckFile  =' CHKF
          end

    Return

 CHKPWS: /*---------------------------------------------------- CHKPWS: -----*/

    RC = NetGetInfo(350, 'WKSTAINFO','')
    if RC = 0
     then do
             ADMNAME = WKSTAINFO.UserName
             PWSNAME = WKSTAINFO.ComputerName
          end
     else do
            Call LOGIT 'Get PWS Info', ,RC
            Call Quit
          end
    Return

 INIT: /*------------------------------------------------------ INIT: -------*/

    Call RgUtil   '/m' /* Rexx Utilities        */
    Call RgUtils  '/m' /* Rexx Utilities        */
    Call RgLSRXUT '/m' /* Lan Server Rexx Utils */

    Parse Upper Source . . P_NAME
    PRGN = Filespec('N', Left(P_NAME, Length(P_NAME) -4))

   '@echo off'
    ESC   = '1B'x
    REDIR = '>NUL 2>NUL'

    Resource_File = 'LSMT.RSC'
    Call CHKFILE Resource_File

    Return

 GETANS: /*---------------------------------------------------- GETANS: -----*/

    Vars_List =Ansi_Say(Resource_File Topic_List);
    Parse VALUE SysCurPos() With Old_R Old_C;
    Do While Vars_List <> '';
       Parse VALUE Vars_List With Topic_Id ';' Var_Id ';' Row ';' Column ';' Color ';' Vars_List;
       Call SysCurPos Row, Column;
       Say x2c(Color) || Topic_String.Topic_Id.Var_Id || '1B'x || '[0m';
       End;
    Call SysCurPos Old_R, Old_C;

    Return

 GETHELP: /*--------------------------------------------------- GETHELP: ----*/

    if \MUTE
     then do
             Topic1='SETHELP'
             Topic_String.Topic1.1=PRGN;
             Topic_List=Topic1;
             Call GETANS
          end
     else say 'Incorrect options.'

    Call QUIT

    Return

 CHKFILE: /*--------------------------------------------------- CHKFILE: ----*/

    Parse Arg FILE
    RC = Stream(FILE, 'C', 'QUERY EXIST')
    if RC = ''
     then do
             say ' File' FILE 'not found.'
             Call QUIT
          end
     else Nop
    Call Stream FILE, 'C', 'CLOSE'

    Return

 LOGIT: /*----------------------------------------------------- LOGIT: ------*/

    FUNC = ARG(1); INFO = ARG(2); RCOD = ARG(3)
    RC = LLOGIT(LOGF, PIPE, ADMNAME, PRGN, FUNC, INFO, RCOD)

    Return

 QUIT: /*------------------------------------------------------ QUIT: -------*/

    Call LineOut 'LSMT.END', PRGN, 1
    Call Stream  'LSMT.END', 'C', 'CLOSE'
    Call Stream   INPF,      'C', 'CLOSE'
    Call Stream   LOGF,      'C', 'CLOSE'
    Call Stream   CHKF,      'C', 'CLOSE'
    Exit ExitCode

 /*--------------------------------------------------------------------------*/
