/*---------------------------------------------------------------------------*\
|  Set HomeDir Access Control Profiles created after 'SETUSERS.CMD'           |
|                                             (C) Alain Rykaert - MAY96-MAY98 |
\*---------------------------------------------------------------------------*/
    Version = '1.03'
    Say '* SetHome Version:' Version

    Parse Arg Option

    Call Init                    /* Initialisation of DLL's and other stuff*/
    Call ChkOpt                                            /* Check Options*/

    Call ChkFile 'Popup.Exe'               /* Check for Message Box program*/
    Call ChkFile InputFile                      /* Check if this file exist*/

    Call Chk4Users InputFile/* Check if the defined User exists on a server*/
                                              /* if not, put UserCheck to 1*/
    If UserCheck = 0
      Then Do
             RC = RXACL('/SET /SRV:'ServerName '/INP:'InputFile '/LOG:'LogFile '/M')
             Say '* ReturnCode =' RC
             If RC = 65024                              /* succesfully FE00*/
               Then Call SysFileDelete(InputFile)
               Else 'start popup "Verify the HomeACL.CSV file" "SetHome Message"'
           End
      Else 'Start Popup "Error NET2221, try again later" "Check 4 user Message"'

    Exit

 CHK4USERS:/* ---------------------------------------------------------------*/

    UserCheck = 0

    Parse Arg InputFile

    Do While Lines(InputFile)
      LLine = LineIn(InputFile)
      Parse Upper Value LLine With . ';\\' ServerName '\' . ';' UserID ';' .

      Say '* Checking for' UserID 'on' ServerName '...'
      Parse Value SysCurPos() With Row Col
      Call SysCurPos Row -1, 24 + Length(UserID) + Length(ServerName)

      RC = NetGetInfo(280, 'UserInfo', '\\'ServerName, UserID)
      If RC = 0
        Then Say 'OK'
        Else Do
               Say 'Not found'
               UserCheck = 1
             End
    End

    Call Stream InputFile, 'C', 'Close'

    Return

 INIT:/* --------------------------------------------------------------------*/

    Call RgUtil   '/m'                                    /* Rexx Utilities*/
    Call RgLSRXUT '/m'                             /* Lan Server Rexx Utils*/

   '@echo off'
    ESC = '1B'x

    Return

 CHKOPT:/* ------------------------------------------------------------------*/

    SRVNAME = ''
    INPF    = 'HOMEACL.CSV'
    LOGF    = 'LSMT.LOG'
    MUTE    = 0

    Do while Option <> ''
      Parse Upper Value Option With Argument ' ' Option
      Select
        When Left(Argument,5) = '/SRV:' Then ServerName = Substr(Argument,6)
        When Left(Argument,5) = '/INP:' Then InputFile  = Substr(Argument,6)
        When Left(Argument,5) = '/LOG:' Then LogFile    = Substr(Argument,6)
        When Left(Argument,2) = '/M'    Then Mute       = 1
        Otherwise Nop
      End
    End

    If ServerName = '' | FileName = '' | LogFile = ''
      Then Do
            'Start Popup "Invalid parameters" "SetHome Message"'
             Exit
           End
      Else Nop

    Say '* ServerName' ServerName
    Say '* InputFile ' InputFile
    Say '* LogFile   ' LogFile
    Say '* Mute      ' Mute

    Return

 CHKFILE:/* -----------------------------------------------------------------*/

    Parse Arg FileToCheck

    Say '* Checking for' FileToCheck

    If Stream(FileToCheck,'C','Query Exists') = ''
      Then Do
             Say '! Error: file' FileToCheck 'not found' '07'x
             Exit
           End
      Else Nop

    Return


