/* OS/2 REXX SCRIPT                             */
/* Adds, sets or deletes local DASD limits      */
/* (c) Steve Sharrad, 04/08/96                  */
/* (c) The HENLEY College 1996                  */
/* For information about the College, contact   */
/* info@henleycol.ac.uk, or visit               */
/* www.henleycol.ac.uk                          */                         

'@echo off'
version                 =           '1.00'              /* version number                       */
release_date            =       '04/08/96'              /* release date of version              */
delta                   =               0
thresh                  =               0
size                    =               0
rc                      =               ''
count                   =               0
fail                    =               0
mask                    =               ''
say 'SETDASD Version 'version'   Release 'release_date' (c) Steve Sharrad.'
say 'Internet e-mail: ssha@henleycol.ac.uk'
call time 'r'
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Signal on Syntax Name util_load
call SysLoadFuncs 
Signal on Syntax Name bad_problem
Signal on Error Name bad_problem
parse upper arg params 
if params = '?' then signal help
if params = '/?' then signal help
if params = 'HELP' then signal help
if params \= '' then signal no_switches
say ' '
say 'SETDASD  1.00      -  Copyright 1996, Steve Sharrad.'
say '                      Copyright 1996, The HENLEY College.'
say 'All rights reserved. This program may be freely copied as'
say 'long as it is not modified or sold for profit.'
say 'For further information, view help file.'
say ' '
say 'You need to be logged on as an administrator.'
say ' '
say 'Do you wish to Add, Set or Delete DASD Limits ?'
say ' '
say '1          Add new limits'
say '2          Set existing limits'
say '3          Delete existing limits'
say '4          EXIT'
say ' '
do forever;
	pull opt
	if opt=4 then leave
	if opt=1 | opt=2 | opt=3 then signal next1
	end
signal end

next1:

if opt=1 then go='add'
if opt=3 then go='delete'
if opt=2 then go='set'

say ' '
say 'Directory to 'go' DASD limits ? '
pull dirdo
dirdo=translate(dirdo)
call sysfiletree dirdo,'tree','D'
if tree.0 = 0 then do
	say 'Path 'dirdo' not found. '
	signal next1:
	end
dirdo=strip(dirdo,,'"') 
if right(dirdo,1) = '"' then dirdo=strip(dirdo,,'"')
basedir=dirdo

signal next2

next2:
say ' '
say 'What do you want processed ? '
say ' '
say '1          Just this directory'
say '2          All sub-directories below this directory'
say '3          Sub-directories down to one level below'
say '4          EXIT'
do forever;
	pull recur
	if recur=4 then leave
	if recur=1 | recur=2 | recur=3 then signal next3
	end
signal end

next3:
if mask = '' & recur = '2' then do
	say ' '
	say 'Directory mask (e.g. USERS*.*, or just press enter for *.*'
	say 'USERS*.* would process directory(s) 'dirdo'\USERS*.*'
	say ' '
	pull mask
	if mask='' then mask = '*.*'
	dirdo=dirdo'\'mask
	end

if recur=1 then param='DO'
if recur=2 then param='DOS'
if recur=3 then do
	dirdo=dirdo'\'
	param='DO'
	end

if opt=2 | opt=1 then do
	say ' '
	say 'What size DASD limit to you want to 'go' ?'
	pull size
	if size ='' | datatype(size,'W') \= 1 then do
		say 'Invalid figure.'
		signal next3
		end

	say ' '
	say "What threshold percentage to "go" ? (0 if none req'd)"
	pull thresh
	if thresh ='' | datatype(thresh,'W') \= 1 then do
		say 'Invalid figure.'
		signal next3
		end
	if thresh \= '0' then do
		say ' '
		say "What delta percentage to "go" ? (0 if none req'd)"
		pull delta
		if delta ='' | datatype(delta,'W') \= 1 then do
			say 'Invalid figure.'
			signal next3
			end
		end
	end
signal next4

next4:
say ' '
say 'Summary information: '
say ' '
say go 'limits'
say  ' '
say 'Directory(s) to process 'dirdo
if recur=1 then say 'Process no sub-directories'
if recur=2 then say 'Process all sub-directories'
if recur=3 then say 'Process sub-directories down one level'
if opt=1 | opt=2 then say 'DASD limit: 'size' Threshold: 'thresh' Delta: 'delta
say ' '
say 'Press'
say '1          Continue and perform the above'
say '2          EXIT'
do forever;
	pull yesno
	if yesno=2 then leave
	if yesno=1 then signal doit
	end

doit:
drop tree
say ' '
say 'Please Wait while your request is performed...'
say ' '
if recur = '1' then do
	count=1
	say 'Directory: 'dirdo
	if go='add' then do
		Signal off Syntax
		Signal off Error
		call on error name didnot
		cline='net dasd "'dirdo'" /add /max:'size' /threshold:'thresh' /increment:'delta' /validate:n >nul'
		cline
		Signal on Syntax Name bad_problem
		Signal on Error Name bad_problem
		signal end
		end
	if go='set' then do
		Signal off Syntax
		Signal off Error
		call on error name didnot
		cline='net dasd "'dirdo'" /max:'size' /threshold:'thresh' /increment:'delta' /validate:n >nul'
		cline
		Signal on Syntax Name bad_problem
		Signal on Error Name bad_problem
		signal end
		end
	if go='delete' then do
		Signal off Syntax
		Signal off Error
		call on error name didnot
		cline='net dasd "'dirdo'" /delete >nul'
		cline
		Signal on Syntax Name bad_problem
		Signal on Error Name bad_problem
		signal end
		end
	end

if recur = '2' | recur = '3' then do
	call sysfiletree dirdo,'tree',param
	if tree.0 = 0 then do
		say 'No directories found! '
		signal end
		end
	do i=1 to tree.0
		say 'Directory: 'tree.i
		count=count+1
		if go='add' then do
			Signal off Syntax
			Signal off Error
			call on error name didnot
			cline='net dasd "'tree.i'" /add /max:'size' /threshold:'thresh' /increment:'delta' /validate:n >nul'
			cline
			Signal on Syntax Name bad_problem
			Signal on Error Name bad_problem
			end
		if go='set' then do
			Signal off Syntax
			Signal off Error
			call on error name didnot
			cline='net dasd "'tree.i'" /max:'size' /threshold:'thresh' /increment:'delta' /validate:n >nul'
			cline
			Signal on Syntax Name bad_problem
			Signal on Error Name bad_problem
			end
		if go='delete' then do
			Signal off Syntax
			Signal off Error
			call on error name didnot
			cline='net dasd "'tree.i'" /delete '
			cline
			Signal on Syntax Name bad_problem
			Signal on Error Name bad_problem
			end
		end
	end
signal end

util_load:
If rc=43 Then Do
	say ' '
	say 'SETDASD failed to correctly initialise the'
	say 'advanced REXX function module, REXXUTIL.DLL'
	say ' '
	say 'Please check that the file REXXUTIL.DLL resides in any sub-'
	say 'directory pointed to the LIBPATH statement in your CONFIG.SYS'
	say ' '
	signal end
	end
else signal bad_problem
end

didnot:
say 'Could not change DASD information for resource 'dirdo
fail=fail+1
return

help:
say ' '
say 'SETDASD has no command line options. All actions are set within the'
say 'program. View the help file SETDASD.TXT for more information.'
say ' '
signal end

bad_problem:
say ' '
say rc
say 'SETDASD has encountered an unknown problem. Try again. If the problem'
say 'persists, record how the problem is reproduceable and e-mail to:'
say 'ssha@henleycol.ac.uk'
say ' '
signal end

end:
say ' '
if count \= '0' then say count-fail' limit(s) changed, 'fail' failed.'
say 'SETDASD ends'

