
#undef accept
#undef bind
#undef bsdselect
#undef connect
#undef getsockname
#undef ioctl
#undef listen
#undef recv
#undef recvfrom
#undef send
#undef sendto
#undef setsockopt
#undef socket
#undef soclose

#define  BSD_SELECT  1
#include <stdio.h>
#include <errno.h>
#include <sys/socket.h>
#include <sys/select.h>
#include <sys/time.h>
#include <sys/timeb.h>
#include <netdb.h>

/*
 * Fixed sockets
 */

char *os2_strerror(int error)
{
	static const char
		__badfilenumber[]	= "Bad file number",
		__Permission[]		= "Permission denied",
		__Invalidarg[]		= "Invalid argument",
		__Toomanyopen[]		= "Too many open files",
		__Interrupted[]		= "Interrupted system call",
		__NoSuchDevice[]	= "No such device or address",
		__NotOwner[]		= "Not owner",
		__BrokenPipe[]		= "Broken pipe",
		__NoProcess[]		= "No such process",
		__BadAddress[]		= "Bad address",
		__NameTooLong[]		= "File name too long",
		__DirNotEmpty[]		= "Directory not empty";

	static const struct myerrinfo {int code; const char *message;} table[] = {
		/* Common Errors == 1 .. 17 */
		ENOENT,				"No such file or directory",
		E2BIG,				"Arg list too big",
		ENOEXEC,			"Exec format error",
		EBADF,				__badfilenumber,
		ENOMEM,				"Not enough memory",
		EACCES,				__Permission,
		EEXIST,				"File exists",
		EXDEV,				"Cross-device link",
		EINVAL,				__Invalidarg,
		ENFILE,				"File table overflow",
		EMFILE,				__Toomanyopen,
		ENOSPC,				"No space left on device",
		EDOM,				"Argument too large",
		ERANGE,				"Result too large",
		EDEADLK,			"Resource deadlock would occur",
		EINTR,				__Interrupted,
		ECHILD,				"Child does not exist",
		/* POSIX errors == 18 and above */
		EAGAIN,				"Resource unavailable, try again",
		EBUSY,				"Device or resource busy",
		EFBIG,				"File too large",
		EIO,				"I/O error",
		EISDIR,				"Is a directory",
		ENOTDIR,			"Not a directory",
		EMLINK,				"Too many links",
		ENOTBLK,			"Block device required",
		ENOTTY,				"Not a character device",
		ENXIO,				__NoSuchDevice,
		EPERM,				__NotOwner,
		EPIPE,				__BrokenPipe,
		EROFS,				"Read-only file system",
		ESPIPE,				"Illegal seek",
		ESRCH,				__NoProcess,
		ETXTBSY,			"Text file busy",
		EFAULT,				__BadAddress,
		ENAMETOOLONG,		__NameTooLong,
		ENODEV,				"No such device",
		ENOLCK,				"No locks available in system",
		ENOSYS,				"Unknown system call",
		ENOTEMPTY,			__DirNotEmpty,

		/* OS/2 sockets errors */
		SOCEPERM,			__NotOwner,
		SOCESRCH,			__NoProcess,
		SOCEINTR,			__Interrupted,
		SOCENXIO,			__NoSuchDevice,
		SOCEBADF,			__badfilenumber,
		SOCEACCES,			__Permission,
		SOCEFAULT,			__BadAddress,
		SOCEINVAL,			__Invalidarg,
		SOCEMFILE,			__Toomanyopen,
		SOCEPIPE,			__BrokenPipe,
		SOCEWOULDBLOCK,		"Operation would block",
		SOCEINPROGRESS, 	"Operation now in progress",
		SOCEALREADY,		"Operation already in progress",
		SOCENOTSOCK,		"Socket operation on non-socket",
		SOCEDESTADDRREQ,	"Destination address required",
		SOCEMSGSIZE,		"Message too long",
		SOCEPROTOTYPE,		"Protocol wrong type for socket",
		SOCENOPROTOOPT,		"Protocol not available",
		SOCEPROTONOSUPPORT,	"Protocol not supported",
		SOCESOCKTNOSUPPORT,	"Socket type not supported",
		SOCEOPNOTSUPP,		"Operation not supported on socket",
		SOCEPFNOSUPPORT,	"Protocol family not supported",
		SOCEAFNOSUPPORT,	"Address family not supported by protocol family",
		SOCEADDRINUSE,		"Address already in use",
		SOCEADDRNOTAVAIL,	"Can't assign requested address",
		SOCENETDOWN,		"Network is down",
		SOCENETUNREACH,		"Network is unreachable",
		SOCENETRESET,		"Network dropped connection on reset",
		SOCECONNABORTED,	"Software caused connection abort",
		SOCECONNRESET,		"Connection reset by peer",
		SOCENOBUFS,			"No buffer space available",
		SOCEISCONN,			"Socket is already connected",
		SOCENOTCONN,		"Socket is not connected",
		SOCESHUTDOWN,		"Can't send after socket shutdown",
		SOCETOOMANYREFS,	"Too many references: can't splice",
		SOCETIMEDOUT,		"Connection timed out",
		SOCECONNREFUSED,	"Connection refused",
		SOCELOOP,			"Too many levels of symbolic links",
		SOCENAMETOOLONG,	__NameTooLong,
		SOCEHOSTDOWN,		"Host is down",
		SOCEHOSTUNREACH,	"No route to host",
		SOCENOTEMPTY,		__DirNotEmpty,
		SOCEOS2ERR,			"OS/2 Error",
		0,					NULL
	};
	struct myerrinfo const *p;
	const char *s;
	static char buf[32];

	for (s = NULL, p = &table; p->message; p++)
		if (p->code == error)
		{
			s = p->message;
			break;
		}
	if (s == NULL)
	{
		sprintf(buf, "Error %d", error);
		s = buf;
	}
	return (char *) s;
}

static int testerr(int code)
{
	int e;

	if (code == -1)
	{
		switch (e = sock_errno())
		{
		case SOCEPERM:	e = EPERM;		break;
		case SOCESRCH:	e = ESRCH;		break;
		case SOCEINTR:	e = EINTR;		break;
		case SOCENXIO:	e = ENXIO;		break;
		case SOCEBADF:	e = EBADF;		break;
		case SOCEACCES:	e = EACCES;		break;
		case SOCEFAULT: e = EFAULT;		break;
		case SOCEINVAL: e = EINVAL;     break;
		case SOCEMFILE: e = EMFILE;		break;
		case SOCEPIPE:	e = EPIPE;		break;
		case SOCENAMETOOLONG:	e = ENAMETOOLONG; break;
		case SOCENOTEMPTY:		e = ENOTEMPTY;	  break;
		}
		errno = e;
	}
	return code;
}

int _System os2_accept(int s, struct sockaddr *name, int *namelen)
{
	return testerr(accept(s, name, namelen));
}
int _System os2_bind(int s, struct sockaddr *name, int namelen)
{
	return testerr(bind(s, name, namelen));
}
int _System os2_bsdselect(int nfds, struct fd_set *readfds, struct fd_set *writefds, struct fd_set *exceptfds, struct timeval *timeout)
{
	return testerr(bsdselect(nfds, readfds, writefds, exceptfds, timeout));
}
int _System os2_connect(int s, struct sockaddr *name, int namelen)
{
	return testerr(connect(s, name, namelen));
}
int _System os2_getsockname(int s, struct sockaddr *name, int *p)
{
	return testerr(getsockname(s, name, p));
}
int _System os2_ioctl(int s, int code, char *data, int size)
{
	return testerr(ioctl(s, code, data, size));
}
int _System os2_listen(int s, int backlog)
{
	return testerr(listen(s, backlog));
}
int _System os2_recv(int s, char *msg, int len, int flags)
{
	return testerr(recv(s, msg, len, flags));
}
int _System os2_recvfrom(int s, char *msg, int len, int flags, struct sockaddr *soa, int *pn)
{
	return testerr(recvfrom(s, msg, len, flags, soa, pn));
}
int _System os2_send(int s, const char *msg, int len, int flags)
{
	return testerr(send(s, msg, len, flags));
}
int _System os2_sendto(int s, char *msg, int len, int flags, struct sockaddr *soa, int n)
{
	return testerr(sendto(s, msg, len, flags, soa, n));
}
int _System os2_setsockopt(int s, int level, int optname, char *optval, int optlen)
{
	return testerr(setsockopt(s, level, optname, optval, optlen));
}
int _System os2_socket(int domain, int type, int protocol)
{
	return testerr(socket(domain, type, protocol));
}
int _System os2_soclose(int s)
{
	return testerr(soclose(s));
}

int _System os2_gettimeofday(struct timeval *tp, struct timezone *tzp)
{
	struct timeb t;
	(void) tzp;

	ftime(&t);
	tp->tv_sec  = t.time;
	tp->tv_usec = t.millitm * 1000;
	return 0;
}
