/* ndc.c
   A C version of the ReXX version of ndc for the OS/2 port of bind
   using emxkill to send signals to named
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <process.h>

#if !defined(SIGWINCH)
#define SIGWINCH 20
#endif

#define KILL_PGM "emxkill.exe"

char sys_cmd[1024];

void usage(char *name)
{
  fprintf(stdout, "\nUsage: %s (status|dumpdb|reload"
	  "|stats|trace|notrace|qrylog|start|stop|restart)"
	  " [ETC]\n\n",
	  name);
}

void etcnotset(char *name)
{
  fprintf(stdout, "\n%s: getenv(ETC) failed. Cannot continue.\n\n",
	  name);
}

void notfound(char *name, char *pid_file)
{
  fprintf(stdout, "\n%s: PID file '%s' not found. Is named running?\n\n", 
	  name, pid_file);
}

void alreadyrunning(char * name, int pid)
{
  fprintf(stdout, "\n%s: start: named (pid %d) already running\n\n", 
	  name, pid);
}

void send_signal(int sig, int pid, char *text)
{
  int rc;
#if      defined(USE_SYSTEM)
  sprintf(sys_cmd, "%s %d %d", 
	  KILL_PGM, sig, pid);
  rc = system(sys_cmd);
  /*
    fprintf(stdout, "%s\n", sys_cmd);
    */
#else  /*defined(USE_SYSTEM)*/
#if      defined(USE_SPAWN)
  char sig_str[10], pid_str[10];
  sprintf(sig_str, "%d", sig);  
  sprintf(pid_str, "%d", pid);  
  rc = spawnl(P_WAIT, KILL_PGM, KILL_PGM, sig_str, pid_str, (char *)NULL);
  /*
    fprintf(stdout, "spawnl(%d, %s, %s, %s, %s)->%d\n",
    P_WAIT, KILL_PGM, KILL_PGM,sig_str, pid_str, rc);
    */
#else  /*defined(USE_SPAWN)*/
  rc = kill(pid, sig);
#endif /*defined(USE_SPAWN)*/
#endif /*defined(USE_SYSTEM)*/
  if (rc)
    perror("Strange rc from kill");
  fprintf(stdout, "%s(rc=%d)\n", text, rc);
}

int main (int argc, char *argv[])
{
  int pid_no=-1, rc=0;
  FILE *pid;
  char *etc, pid_file[_MAX_PATH+1], savecwd[_MAX_PATH+1];
  
  if ((etc = getenv("ETC")) == NULL)
    {
      if (argc < 3)
	{
	  etcnotset(argv[0]);
	  return 1;
	}
      else
	etc = argv[2];
    }
  
  strcpy(pid_file, etc);
  strcat(pid_file, "\\named.pid");
  
  if (argc < 2)
    {
      usage(argv[0]);
      return 1;
    }
  
  if (stricmp(argv[1], "HELP") == 0)
    {
      usage(argv[0]);
      return 1;
    }
  
  if ((pid = fopen(pid_file, "r")) != NULL)
    {
      fscanf(pid, "%d", &pid_no);
      fclose(pid);
    }
  
  if (stricmp(argv[1], "START") == 0) 
    {
      if (pid_no<1)
	{
	  _getcwd2(savecwd, _MAX_PATH+1);
	  _chdir2(etc);
	  sprintf(sys_cmd, "start /c /win /min named -c %s\\named.conf", 
		  etc);
	  rc = system(sys_cmd);
	  _chdir2(savecwd);
	  fprintf(stdout, "named started (rc=%d)\n", rc);
	  return 0;
	}
      else
	{
	  alreadyrunning(argv[0], pid_no);
	  return 1;
	}
      return 0;
    }
  
  if (stricmp(argv[1], "STATUS") == 0)
    {
      if (pid_no<1)
	fprintf(stdout, "named is not running\n");
      else
	fprintf(stdout, "named is running (PID %d)\n", 
		pid_no);
      return 0;
    }
  
  if (pid_no < 1)
    {
      notfound(argv[0], pid_file);
      return 1;
    }
  
  if (stricmp(argv[1], "STOP") == 0)
    send_signal(SIGKILL, pid_no, "named stopped");
        
  else if (stricmp(argv[1], "RESTART") == 0)
    { 
      /* Calling ourself to do the dirty work... */
      sprintf(sys_cmd, "%s stop", argv[0]);
      system(sys_cmd);
      sleep(5);
      sprintf(sys_cmd, "%s start", argv[0]);
      system(sys_cmd);
    }
  
  else if (stricmp(argv[1], "DUMPDB") == 0)
    send_signal(SIGINT, pid_no, "Dumping database");
            
  else if (stricmp(argv[1], "RELOAD") == 0)
    send_signal(SIGHUP, pid_no, "Reloading database");
        
  else if (stricmp(argv[1], "STATS") == 0)
    send_signal(SIGILL, pid_no, "Dumping statistics");
        
  else if (stricmp(argv[1], "TRACE") == 0)
    send_signal(SIGUSR1, pid_no, "Trace level incremented");
        
  else if (stricmp(argv[1], "NOTRACE") == 0)
    send_signal(SIGUSR2, pid_no, "Tracing cleared");
        
  else if (stricmp(argv[1], "QUERYLOG") == 0 ||
	   stricmp(argv[1], "QRYLOG") == 0)
    send_signal(SIGWINCH, pid_no, "Query logging toggled");
      
  else
    {
    usage(argv[0]);
    return 1;
    }
  
  return 0;
}

