/* ndc.cmd



   A ReXX version of ndc for the OS/2 port of BIND 8


   This program make the following assumptions
	emxkill.exe is in PATH
	named.exe is in PATH
	named.conf is in ETC
	named.pid is in ETC

   Please change the three variables kill, named, and PIDFILE as needed
   if you move any of these files to other locations.

   emxkill.exe is written by Garey Smiley <garey@slink.com>
   ndc.cmd is written by Bjrn Mork <bjorn@mork.no>
*/



kill  = '@emxkill'
named = '@detach named -c'||value('ETC',,'OS2ENVIRONMENT')||'\named.conf 2>nul'

PIDFILE = value('ETC',,'OS2ENVIRONMENT')||'\named.pid'

parse upper arg command
signal on halt

if (stream(PIDFILE,'c','query exist')\='') then do
	pid = strip(linein(PIDFILE))
	rc = stream(PIDFILE, 'c', 'close')
	do while (queued()>0)
		pull .				/* Empty the queue	*/
	end
	'@pstat /P:'||d2x(pid)||' 2>nul |find /i /c "named.exe"|rxqueue'
	pull tmp
	RUNNING=strip(tmp)
	if (RUNNING=0) then PS='named (pid 'pid'?) not running'
	else PS='named is running (pid 'pid')'
end
else do
	PS='named (no pid file) not running'
	RUNNING=0
end


if ((arg() = 0)|(strip(command) = '')) then signal USAGE

select
	when (command = 'START') then nop
	when (command = 'STOP') then nop
	when (command = 'RESTART') then nop
otherwise
	if (RUNNING=0) then do 
		say PS
		exit 1
	end
end  /* select */

call RxFuncAdd'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

select

	when (command = 'STATUS') then say PS
	when (command = 'DUMPDB')

		then do 

			kill '2' pid	/* SIGINT */

			say 'Dumping Database'

		end

	when (command = 'RELOAD')

		then do 

			kill '1' pid	/* SIGHUP */

			say 'Reloading Database'

		end

	when (command = 'STATS')

		then do 

			kill '4' pid	/* SIGILL */

			say 'Dumping Statistics'

		end

	when (command = 'TRACE')

		then do 

			kill '16' pid	/* SIGUSR1 */

			say 'Trace Level Incremented'

		end

	when (command = 'NOTRACE')

		then do 

			kill '17' pid	/* SIGUSR2 */

			say 'Tracing Cleared'

		end

	when (command = 'QUERYLOG')|(command = 'QRYLOG')

		then do 

			kill '20' pid	/* SIGWINCH */

			say 'Query Logging Toggled'

		end

	when (command = 'START')
    		then if (RUNNING=1) then
			say 'ndc: start: named (pid 'pid') already running'
		else do
			call SysFileDelete PIDFILE
			named
			call SysSleep 5
			say 'Name server started'
		end
	when (command = 'STOP')
		then if (RUNNING=0) then
			say 'ndc: stop: named not running'
		else do
			kill '15' pid	/* SIGTERM */
			call SysSleep 5
			call SysFileDelete PIDFILE
			say 'Name Server Stopped'
		end
	when (command = 'RESTART')
		then do
     			if (RUNNING=1) then do
				kill '15' pid	/* SIGTERM */
				call SysSleep 5
			end
			call SysFileDelete PIDFILE
			named
			call SysSleep 5
			say 'Name Server Restarted'
		end /* do */
	otherwise

		signal USAGE

end	/* select */


call SysDropFuncs
return 0


USAGE:
 say

 say 'usage: ndc (status|dumpdb|reload|stats|trace|notrace|qrylog|start|stop|restart)'

 say

 exit 1

halt:
 say 'ndc aborted'
 exit 1
