/*

  REXX Script to install the InJoy Firewall - and create a desktop folder

*/

if RxFuncQuery('SysLoadFuncs') then do
   call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   call SysLoadFuncs
end

say "Installing..."

dir = directory() || '\'

say "Creating folder"
call SysCreateObject "WPFolder", "InJoy Firewall", "<WP_DESKTOP>", "OBJECTID=<INJOYFIREFOLDER>;ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=NO;ICONFONT=10.Helv;BACKGROUND=" || dir || "back.bmp,T;ICONFILE=" || dir || "FOLDER.ICO", "replace"
call SysCreateObject "WPFolder", "Information", "<INJOYFIREFOLDER>", "OBJECTID=<INJOYFIREINFOFOLDER>;ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=NO;ICONFONT=8.Helv;BACKGROUND=" || dir || "back.bmp,T", "replace"
call SysCreateObject "WPFolder", "Different methods"|| d2c(10) || "of payment", "<INJOYFIREFOLDER>", "OBJECTID=<INJOYFIREPAYFOLDER>;ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=NO;ICONFONT=8.Helv;BACKGROUND=" || dir || "back.bmp,T", "replace"
call SysCreateObject "WPFolder", "Utility programs", "<INJOYFIREFOLDER>", "OBJECTID=<INJOYFIREUTILFOLDER>;ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=NO;ICONFONT=8.Helv;BACKGROUND=" || dir || "back.bmp,T", "replace"

say "Creating program objects"

call SysCreateObject "WPProgram", "BMT resellers", "<INJOYFIREPAYFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "DOCS\" || "ORDER.BMT", "replace"
call SysCreateObject "WPProgram", "Deutsche Bank" || d2c(10) || "money transfer", "<INJOYFIREPAYFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "DOCS\" || "ORDER.DE", "replace"
call SysCreateObject "WPProgram", "Payment via" || d2c(10) || "Phone/FAX (USA)", "<INJOYFIREPAYFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "DOCS\" || "ORDER.USA", "replace"

call SysCreateObject "WPProgram", "Reread firewall" || d2c(10) || "configuration", "<INJOYFIREUTILFOLDER>", "EXENAME=" || dir || "SYNC.EXE;PARAMETERS=" || "-firewall", "replace"
call SysCreateObject "WPProgram", "Reread filter" || d2c(10) || "configuration", "<INJOYFIREUTILFOLDER>", "EXENAME=" || dir || "SYNC.EXE;PARAMETERS=" || "-filter", "replace"
call SysCreateObject "WPProgram", "Kill Firewall", "<INJOYFIREUTILFOLDER>", "EXENAME=" || dir || "SYNC.EXE;PARAMETERS=" || "-kill", "replace"

call SysCreateObject "WPProgram", "License"  || d2c(10) || "Agreement", "<INJOYFIREINFOFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "DOCS\" || "LICENSE.TXT", "replace"
call SysCreateObject "WPProgram", "File_ID.DIZ", "<INJOYFIREINFOFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "FILE_ID.DIZ", "replace"
call SysCreateObject "WPProgram", "IPSec" || d2c(10) || "Plugin", "<INJOYFIREINFOFOLDER>", "EXENAME=NETSCAPE.EXE;PARAMETERS=" || "file:///" || dir || "docs\ipsec\welcome.htm", "replace"
call SysCreateObject "WPProgram", "Packet Filter" || d2c(10) || "Reference", "<INJOYFIREINFOFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "DOCS\" || "FILTER.TXT", "replace"
call SysCreateObject "WPProgram", "InJoy Firewall" || d2c(10) || "Reference", "<INJOYFIREINFOFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "DOCS\" || "FIREWALL.TXT", "replace"
call SysCreateObject "WPProgram", "InJoy Gateway" || d2c(10) || "Reference", "<INJOYFIREINFOFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "DOCS\" || "GATEWAY.TXT", "replace"
call SysCreateObject "WPProgram", "Firewall home page" || d2c(10) || "(www.fx.dk/firewall)", "<INJOYFIREINFOFOLDER>", "EXENAME=NETSCAPE.EXE;PARAMETERS=" || "http://www.fx.dk/firewall", "replace"

call SysCreateObject "WPProgram", "BMT Purchase" || d2c(10) || "Applet", "<INJOYFIREFOLDER>", "EXENAME=" || dir || "PURCHASE\" || "PURCHASE.EXE;STARTUPDIR=" || dir || "purchase\" || ";ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;"
call SysCreateObject "WPProgram", "Get legal and" || d2c(10) || "Register", "<INJOYFIREFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "DOCS\" || "REGISTER.TXT", "replace"
call SysCreateObject "WPProgram", "Uninstall" || d2c(10) || "Device Driver", "<INJOYFIREFOLDER>", "EXENAME=" || dir || "UNINSTAL.CMD;STARTUPDIR=" || dir || ";ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;"
call SysCreateObject "WPProgram", "InJoy Firewall (text)", "<INJOYFIREFOLDER>", "EXENAME=" || dir || "GATEWAY.EXE;STARTUPDIR=" || dir || ";ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;"
call SysCreateObject "WPProgram", "InJoy Firewall (PM)", "<INJOYFIREFOLDER>", "EXENAME=" || dir || "GWPM.EXE;STARTUPDIR=" || dir || ";ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;"
say "Installation completed - InJoy Firewall"
