/***************************************************************************/
call RxFuncAdd 'SysSleep','RexxUtil','SysSleep'

ARG Channel LocalIp HostIp Netmask DefaultIp

cr   = '0d'x
crlf = '0d0a'x
remain_buffer  = ''
waitfor_buffer = ''

say 'Line       ' Channel
say 'LocalIp    ' LocalIp
say 'HostIp     ' HostIp
say 'Netmask    ' Netmask
say 'DefaultIp  ' HostIp

password = READPASSWORD(Channel)

call waitfor 'e.V.' , 100
rc = ISDNWRITE(Channel,cr)
call waitfor 'inga login:' , 20
call SysSleep 1


rc = ISDNWRITE(Channel,'username'||cr)
call waitfor 'word:' , 20
call SysSleep 1
rc = ISDNWRITE(Channel,password||cr)

call SysSleep 1

/* must not be changed ! */

say 'REXX DATAMODE'
rc = ISDNDATAMODE(Channel)
say 'REXX DATAMODE END '


exit 0

/*----------------------------------------------------------------------*/
/*  waitfor( waitforstring , [timeout] )                                */
/*......................................................................*/
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*----------------------------------------------------------------------*/

waitfor:

    parse arg waitstring , timeout
    if timeout = '' then
        timeout = 20        /* wait 20 sec */

    timeout = timeout * 10 ;    /* ISDNREAD returns after 1/10 Sek */

    waitfor_buffer = '' ; done = -1 ; curpos = 1
    do while (( done = -1) & (timeout > 0))
        if (remain_buffer \= '') then do
            line = remain_buffer
            remain_buffer = ''
        end
        else do
            line = ISDNREAD(Channel)
            if Substr(line,1,1)<>'00'x then do
              say 'ISDNREAD-Fehler'
              signal failure
            end
            line=Substr(line,2)
        end
        waitfor_buffer = waitfor_buffer || line
        index = pos(waitstring,waitfor_buffer)
        if (index > 0 ) then do
            remain_buffer = substr(waitfor_buffer,index+length(waitstring))
            waitfor_buffer = delstr(waitfor_buffer,index+length(waitstring))
            done = 0
        end
        call charout,substr(waitfor_buffer,curpos)
        curpos = length(waitfor_buffer)+1
        timeout = timeout - 1
        call SysSleep 1
    end
    if (timeout = 0 ) then do
        say 'WAITFOR : timed out '
        done = 1
    end
    RC = done
return RC

/*----------------------------------------------------------------------*/
/*  flush_receive()                                                     */
/*......................................................................*/
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*----------------------------------------------------------------------*/
flush_receive:

    parse arg echo
    /* if echoing the flush - take care of waitfor remainig buffer */
    if( echo \= '' ) && (length(remain_buffer) > 0 ) then do
        call charout, remain_buffer
    end
    cx = 20
    line = ''
    do while (line \= '') & (cx > 0 )
        line = ISDNREAD(Channel)
        if Substr(line,1,1)<>'00'x then do
          say 'ISDNREAD-Fehler'
          signal failure
        end
        line=Substr(line,2)
        if echo \= '' then
            call charout,line
        cx = cx - 1
    end
    return
