/* REXX */

/*
 *  File     : TS_DNS
 *  Purpose  :
 *
 *
 *  Modification History:
 *
 *  --Date--- --By-- --Reason------------------------------------------------
 *  1997.06.17     TAB   Created script
 *
 */


/* ----- */

app = 'TS_DNS'
etc = VALUE('ETC',,      'OS2ENVIRONMENT')


/* load the REXX utility package */

CALL RXFuncAdd SysIni, RexxUtil, SysIni


/* see if we know where the InJoy code is */

profile = SysIni('USER', 'TS', 'PROFILE')
IF profile = 'ERROR:' THEN DO
   rc = status(app, 'ERROR', 'Tunnel configuration not found')
   EXIT 2
END


/* search for the resolv file */

rc = status(app, 'INFO', 'Searching RESOLV file')
resolv = etc||'\resolv'
IF \ exist(resolv) THEN resolv = resolv||'2'
IF \ exist(resolv) THEN DO
   rc = status(app, 'ERROR', 'Unable to find %ETC%\RESOLV or %ETC%\RESOLV2')
   EXIT 2
END


/* look up the DNS stuff */

DO QUEUED() ; PULL message ; END
'@type' resolv '| rxqueue'

dns = ''
DO QUEUED()

   PARSE PULL key data
   PARSE UPPER VAR key key

   IF key = 'DOMAIN'     THEN rc = SysIni(profile, 'DNS', 'DOMAIN', data)
   IF key = 'NAMESERVER' & LENGTH(dns) = 0 THEN DO
      rc = SysIni(profile, 'DNS', 'ADDRESS', data)
      dns = data
   END

END


RETURN 0
