/* REXX */

/*
 *  File    :   TS_LAUNCH
 *  Purpose :
 *
 *
 *  Modification History:
 *
 *  --Date--- --By-- --Reason------------------------------------------------
 *  1997.06.17     TAB   Created script
 *
 */


/* ----- */

app = 'TS_LAUNCH'


IF isrun('ts') THEN DO
   rc = status(app, 'INFO', 'Using cached information')
   rc = status(app, 'INFO', 'Reconnecting')
   '@settun /F'
END
ELSE DO

   /* extract the info from the profile */

   profile = SysIni('USER', 'TS', 'PROFILE')

   IF profile = 'ERROR:' THEN DO
      rc = status(app, 'ERROR', 'Tunnel configuration not found')
      EXIT 2
   END

   modem.phone_no  = SysIni(profile, 'MODEM',  'PHONE_NO')
   master.hostname = SysIni(profile, 'TM',     'HOSTNAME')
   master.netmask  = SysIni(profile, 'TM',     'NETMASK')
   master.password = SysIni(profile, 'TM',     'PASSWORD')
   slave.address   = SysIni(profile, 'TS',     'ADDRESS')


   /* check for fatal errors */

   IF master.hostname = 'ERROR:' THEN DO
      rc = status(app, 'ERROR', 'Unknown tunnel master host name')
      EXIT 2
   END

   IF slave.address = 'ERROR:' THEN DO
      rc = status(app, 'ERROR', 'Unknown tunnel slave address')
      EXIT 2
   END


   /* check for warnings */

   IF modem.phone_no  = 'ERROR:' THEN DO
      modem.phone_no  = ''
      rc = status(app, 'WARNING', 'No phone number was found for the local modem')
   END

   IF master.netmask  = 'ERROR:' THEN DO
      master.netmask  = '255.255.0.0'
      rc = status(app, 'WARNING', 'No netmask was found for the master.  Defaulting to:'||master.netmask)
   END

   IF master.password = 'ERROR:' THEN DO
      master.password = 'snoopy'
      rc = status(app, 'WARNING', 'No password was found for the master.  Defaulting.')
   END


   /* here is the actual launch */

   rc = status(app, 'INFO', 'Slave address   =' slave.address)
   rc = status(app, 'INFO', 'Master hostname =' master.hostname)
   rc = status(app, 'INFO', 'Master netmask  =' master.netmask)
   rc = status(app, 'INFO', 'Phone #         =' modem.phone_no)

   '@START /C /WIN /B "InJoy Tunnel Client" ts /P:'||modem.phone_no||' /M:'||master.hostname||' /R:'||slave.address||' /N:'||master.netmask||' /F /S:'||master.password
END


RETURN 0
