/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class TV3C
extends JApplet
implements ActionListener,
WindowListener,
StatusListener {
    private JFrame frame;
    private TV3Tree tree;
    private TV3Table table;
    private TV3Graph graph;
    private JSplitPane splitHPane;
    private JSplitPane splitVPane;
    private JMenuItem miProperties;
    private JMenuItem miRefreshNow;
    private JRadioButtonMenuItem miEdStatByte;
    private JRadioButtonMenuItem miEdStatKb;
    private JRadioButtonMenuItem miEdStatMb;
    private JRadioButtonMenuItem miEdStatGb;
    private JRadioButtonMenuItem miEdRatioByte;
    private JRadioButtonMenuItem miEdRatioKb;
    private JRadioButtonMenuItem miEdRatioMb;
    private JLabel statusLine;
    private TV3Config config;
    private boolean IsApplet;
    private JPanel pane;

    private JMenuBar createMenu() {
        JMenu jMenu;
        JMenuBar jMenuBar = new JMenuBar();
        if (!this.IsApplet) {
            jMenu = new JMenu("Client");
            jMenu.setMnemonic(67);
            jMenuBar.add(jMenu);
            this.miProperties = new JMenuItem("Properties...", 80);
            this.miProperties.addActionListener(this);
            jMenu.add(this.miProperties);
        }
        jMenu = new JMenu("View");
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("Statistics");
        ButtonGroup buttonGroup = new ButtonGroup();
        this.miEdStatByte = new JRadioButtonMenuItem("Bytes");
        this.miEdStatByte.setMnemonic(66);
        this.miEdStatByte.addActionListener(this);
        buttonGroup.add(this.miEdStatByte);
        jMenu2.add(this.miEdStatByte);
        this.miEdStatKb = new JRadioButtonMenuItem("Kb");
        this.miEdStatKb.setMnemonic(75);
        this.miEdStatKb.addActionListener(this);
        buttonGroup.add(this.miEdStatKb);
        jMenu2.add(this.miEdStatKb);
        this.miEdStatMb = new JRadioButtonMenuItem("Mb");
        this.miEdStatMb.setMnemonic(77);
        this.miEdStatMb.addActionListener(this);
        buttonGroup.add(this.miEdStatMb);
        jMenu2.add(this.miEdStatMb);
        this.miEdStatGb = new JRadioButtonMenuItem("Gb");
        this.miEdStatGb.setMnemonic(71);
        this.miEdStatGb.addActionListener(this);
        buttonGroup.add(this.miEdStatGb);
        jMenu2.add(this.miEdStatGb);
        jMenu.add(jMenu2);
        jMenu2 = new JMenu("Ratios");
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.miEdRatioByte = new JRadioButtonMenuItem("Bytes");
        this.miEdRatioByte.setMnemonic(66);
        this.miEdRatioByte.addActionListener(this);
        buttonGroup2.add(this.miEdRatioByte);
        jMenu2.add(this.miEdRatioByte);
        this.miEdRatioKb = new JRadioButtonMenuItem("Kb");
        this.miEdRatioKb.setMnemonic(75);
        this.miEdRatioKb.addActionListener(this);
        buttonGroup2.add(this.miEdRatioKb);
        jMenu2.add(this.miEdRatioKb);
        this.miEdRatioMb = new JRadioButtonMenuItem("Mb");
        this.miEdRatioMb.setMnemonic(77);
        this.miEdRatioMb.addActionListener(this);
        buttonGroup2.add(this.miEdRatioMb);
        jMenu2.add(this.miEdRatioMb);
        jMenu.add(jMenu2);
        jMenu.addSeparator();
        this.miRefreshNow = new JMenuItem("Refresh now", 78);
        this.miRefreshNow.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.miRefreshNow.addActionListener(this);
        jMenu.add(this.miRefreshNow);
        return jMenuBar;
    }

    private JPanel createPane() {
        JRadioButtonMenuItem jRadioButtonMenuItem;
        this.graph = new TV3Graph();
        this.table = new TV3Table(this.graph);
        this.tree = new TV3Tree(this.table);
        this.statusLine = new JLabel("starting...");
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        JScrollPane jScrollPane2 = new JScrollPane(this.table);
        JScrollPane jScrollPane3 = new JScrollPane(this.graph);
        this.splitHPane = new JSplitPane(0, jScrollPane2, jScrollPane3);
        this.splitHPane.setOneTouchExpandable(true);
        this.splitVPane = new JSplitPane(1, jScrollPane, this.splitHPane);
        this.splitVPane.setOneTouchExpandable(true);
        this.pane = new JPanel(new BorderLayout());
        this.pane.add((Component)this.createMenu(), "North");
        this.pane.add(this.splitVPane);
        this.pane.add((Component)this.statusLine, "South");
        int n = 0;
        int n2 = this.config.getEdStat();
        switch (n2) {
            case 1: {
                jRadioButtonMenuItem = this.miEdStatKb;
                break;
            }
            case 2: {
                jRadioButtonMenuItem = this.miEdStatMb;
                break;
            }
            case 3: {
                jRadioButtonMenuItem = this.miEdStatGb;
                break;
            }
            default: {
                jRadioButtonMenuItem = this.miEdStatByte;
                n2 = 0;
            }
        }
        jRadioButtonMenuItem.setSelected(true);
        this.table.setEd(n, n2);
        n = 1;
        n2 = this.config.getEdRatio();
        switch (n2) {
            case 1: {
                jRadioButtonMenuItem = this.miEdRatioKb;
                break;
            }
            case 2: {
                jRadioButtonMenuItem = this.miEdRatioMb;
                break;
            }
            default: {
                jRadioButtonMenuItem = this.miEdRatioByte;
                n2 = 0;
            }
        }
        jRadioButtonMenuItem.setSelected(true);
        this.table.setEd(n, n2);
        this.table.setSortColumn(this.config.getSortColumn(), this.config.getSortForward() ? 0 : 1);
        int n3 = 0;
        while (n3 < this.table.getColumnCount()) {
            this.table.setColumnWidth(n3, this.config.getColWidth(n3));
            ++n3;
        }
        this.splitHPane.setDividerLocation(this.config.getHSplitLoc());
        this.splitHPane.setLastDividerLocation(this.config.getHSplitLastLoc());
        this.splitVPane.setDividerLocation(this.config.getVSplitLoc());
        this.splitVPane.setLastDividerLocation(this.config.getVSplitLastLoc());
        return this.pane;
    }

    private void StatInit(String string, int n, int n2) {
        Statistic.Init(string, n, n2);
        this.frame.setTitle("Traffic Visor III (" + string + ")");
    }

    public void BuildStatistic() {
        Statistic.setStatusListener(this);
        this.StatInit(this.config.getServerAddr(), this.config.getRefreshFreq(), this.config.getTimeScale());
        this.tree.expandRow(0);
    }

    public void displayStatus(String string, int n) {
        Color color;
        switch (n) {
            case 1: {
                color = Color.red;
                break;
            }
            case 2: {
                this.tree.setItems(Statistic.items);
                color = Color.black;
                break;
            }
            case 3: {
                this.tree.statUpdate();
                color = Color.black;
                break;
            }
            default: {
                color = Color.blue;
            }
        }
        this.statusLine.setForeground(color);
        this.statusLine.setText(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if ("properties".equals(actionEvent.getActionCommand())) {
            this.StatInit(((TV3PropertiesDlg)object).getServer(), ((TV3PropertiesDlg)object).getRefresh(), ((TV3PropertiesDlg)object).getTimeScale());
        } else if (object == this.miProperties) {
            TV3PropertiesDlg.showDialog(this.pane, Statistic.tv3url, Statistic.timeScale, Statistic.refreshFreq, this);
        } else if (object == this.miRefreshNow) {
            Statistic.Update();
        } else if (object == this.miEdStatByte) {
            this.table.setEd(0, 0);
        } else if (object == this.miEdStatKb) {
            this.table.setEd(0, 1);
        } else if (object == this.miEdStatMb) {
            this.table.setEd(0, 2);
        } else if (object == this.miEdStatGb) {
            this.table.setEd(0, 3);
        } else if (object == this.miEdRatioByte) {
            this.table.setEd(1, 0);
        } else if (object == this.miEdRatioKb) {
            this.table.setEd(1, 1);
        } else if (object == this.miEdRatioMb) {
            this.table.setEd(1, 2);
        }
    }

    public JFrame createFrame(TV3Config tV3Config) {
        this.IsApplet = false;
        this.frame = new JFrame("Traffic Visor III -- Client");
        this.config = tV3Config;
        this.frame.setDefaultCloseOperation(2);
        this.frame.addWindowListener(this);
        this.frame.setContentPane(this.createPane());
        this.frame.pack();
        ((Component)this.frame).setBounds(tV3Config.getPosX(), tV3Config.getPosY(), tV3Config.getWidth(), tV3Config.getHeight());
        ((Component)this.frame).setVisible(true);
        this.BuildStatistic();
        return this.frame;
    }

    public static void main(final String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TV3C tV3C = new TV3C();
                TV3Config tV3Config = stringArray.length == 0 ? new TV3Config("tv3client.cfg") : new TV3Config(stringArray[0]);
                tV3C.createFrame(tV3Config);
            }
        });
    }

    public void windowClosing(WindowEvent windowEvent) {
        JFrame jFrame = (JFrame)windowEvent.getWindow();
        this.config.setBounds(jFrame.getX(), jFrame.getY(), jFrame.getWidth(), jFrame.getHeight());
        this.config.setServerAddr(Statistic.tv3url);
        this.config.setEdStat(this.table.getEd(0));
        this.config.setEdRatio(this.table.getEd(1));
        this.config.setSort(this.table.getSortColumn(), this.table.getSortForward());
        int n = 0;
        while (n < this.table.getColumnCount()) {
            this.config.setColWidth(n, this.table.getColumnWidth(n));
            ++n;
        }
        this.config.setHSplit(this.splitHPane.getDividerLocation(), this.splitHPane.getLastDividerLocation());
        this.config.setVSplit(this.splitVPane.getDividerLocation(), this.splitVPane.getLastDividerLocation());
        this.config.setRefreshFreq(Statistic.refreshFreq);
        this.config.setTimeScale(Statistic.timeScale);
        this.config.store();
        System.exit(0);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void init() {
        this.config = new TV3Config(this);
        this.IsApplet = true;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    TV3C.this.setContentPane(TV3C.this.createPane());
                }
            });
        }
        catch (Exception exception) {
            System.err.println("createPane didn't successfully complete");
        }
    }

    public void start() {
        this.BuildStatistic();
    }

    public String getAppletInfo() {
        return "Traffic Visor III -- Client";
    }
}

