/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public class TV3Config {
    private final String CONFIG_FILE = "tv3client.cfg";
    private TV3Properties prop;

    public void setDefault() {
        Properties properties = new Properties();
        properties.setProperty("server", "http://localhost:5462/");
        properties.setProperty("ed_stat", "0");
        properties.setProperty("ed_ratio", "0");
        properties.setProperty("refresh", "3");
        properties.setProperty("time_scale", "240");
        properties.setProperty("sort_column", "0");
        properties.setProperty("sort_forward", "1");
        int n = 0;
        while (n < 6) {
            properties.setProperty("col_width_" + n, n == 0 ? "200" : "100");
            ++n;
        }
        properties.setProperty("pos_x", "50");
        properties.setProperty("pos_y", "50");
        properties.setProperty("width", "700");
        properties.setProperty("height", "450");
        properties.setProperty("split_h_loc", "250");
        properties.setProperty("split_h_last_loc", "0");
        properties.setProperty("split_v_loc", "150");
        properties.setProperty("split_v_last_loc", "0");
        this.prop = new TV3Properties(properties);
    }

    public TV3Config() {
        this.setDefault();
    }

    public TV3Config(String string) {
        FileInputStream fileInputStream;
        this.setDefault();
        try {
            fileInputStream = new FileInputStream("tv3client.cfg");
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        try {
            this.prop.load(fileInputStream);
        }
        catch (IOException iOException) {
            return;
        }
    }

    public TV3Config(Applet applet) {
        this.setDefault();
        String string = applet.getCodeBase().toExternalForm();
        int n = string.indexOf(47, 7);
        this.setServerAddr(string.substring(0, n + 1));
        Enumeration<?> enumeration = this.prop.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = applet.getParameter(string2);
            if (string3 == null) continue;
            this.prop.setProperty(string2, string3);
        }
    }

    public void store() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("tv3client.cfg");
            this.prop.store(fileOutputStream, "Traffic Visor III client");
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setServerAddr(String string) {
        this.prop.setProperty("server", string);
    }

    public String getServerAddr() {
        return this.prop.getProperty("server");
    }

    public int getEdStat() {
        return this.prop.getPropertyInt("ed_stat");
    }

    public int getEdRatio() {
        return this.prop.getPropertyInt("ed_ratio");
    }

    public int getRefreshFreq() {
        return this.prop.getPropertyInt("refresh");
    }

    public int getTimeScale() {
        return this.prop.getPropertyInt("time_scale");
    }

    public int getSortColumn() {
        return this.prop.getPropertyInt("sort_column");
    }

    public boolean getSortForward() {
        return this.prop.getPropertyInt("sort_forward") == 1;
    }

    public int getColWidth(int n) {
        if (n < 0 || n >= 6) {
            return 0;
        }
        return this.prop.getPropertyInt("col_width_" + n);
    }

    public int getPosX() {
        return this.prop.getPropertyInt("pos_x");
    }

    public int getPosY() {
        return this.prop.getPropertyInt("pos_y");
    }

    public int getWidth() {
        return this.prop.getPropertyInt("width");
    }

    public int getHeight() {
        return this.prop.getPropertyInt("height");
    }

    public int getHSplitLoc() {
        return this.prop.getPropertyInt("split_h_loc");
    }

    public int getHSplitLastLoc() {
        return this.prop.getPropertyInt("split_h_last_loc");
    }

    public int getVSplitLoc() {
        return this.prop.getPropertyInt("split_v_loc");
    }

    public int getVSplitLastLoc() {
        return this.prop.getPropertyInt("split_v_last_loc");
    }

    public void setRefreshFreq(int n) {
        this.prop.setPropertyInt("refresh", n);
    }

    public void setTimeScale(int n) {
        this.prop.setPropertyInt("time_scale", n);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.prop.setPropertyInt("pos_x", n);
        this.prop.setPropertyInt("pos_y", n2);
        this.prop.setPropertyInt("width", n3);
        this.prop.setPropertyInt("height", n4);
    }

    public void setEdStat(int n) {
        this.prop.setPropertyInt("ed_stat", n);
    }

    public void setEdRatio(int n) {
        this.prop.setPropertyInt("ed_ratio", n);
    }

    public void setSort(int n, boolean bl) {
        this.prop.setPropertyInt("sort_column", n);
        this.prop.setPropertyInt("sort_forward", bl ? 1 : 0);
    }

    public void setColWidth(int n, int n2) {
        if (n >= 0 || n < 6) {
            this.prop.setPropertyInt("col_width_" + n, n2);
        }
    }

    public void setHSplit(int n, int n2) {
        this.prop.setPropertyInt("split_h_loc", n);
        this.prop.setPropertyInt("split_h_last_loc", n2);
    }

    public void setVSplit(int n, int n2) {
        this.prop.setPropertyInt("split_v_loc", n);
        this.prop.setPropertyInt("split_v_last_loc", n2);
    }
}

