  var MSG_ASK_RESET = "Reset statistics?";
  var MSG_ERROR_SENT = "Invalid value (sent)";
  var MSG_ERROR_RECV = "Invalid value (received)";
  var MSG_UNKNOWN_ANSWER = "Unknown answer.";
  var MSG_NOT_FOUND = "Rules not found.";
  var http_request;

 function trim(sString)
  {
    while (sString.substring(0,1) == ' ')
      sString = sString.substring(1, sString.length);
    while (sString.substring(sString.length-1, sString.length) == ' ')
      sString = sString.substring(0,sString.length-1);
    return sString;
  }

  function SetConditions()
  {
    if ( document.getElementById('cond').checked )
    {
      document.getElementById('path').removeAttribute('disabled');
      document.getElementById('sent_pref').removeAttribute('disabled');
      document.getElementById('sent').removeAttribute('disabled');
      document.getElementById('sent_ed').removeAttribute('disabled');
      document.getElementById('recv_pref').removeAttribute('disabled');
      document.getElementById('recv').removeAttribute('disabled');
      document.getElementById('recv_ed').removeAttribute('disabled');
      document.getElementById('br').removeAttribute('disabled');
    }
    else {
      document.getElementById('path').setAttribute('disabled','1');
      document.getElementById('sent_pref').setAttribute('disabled','1');
      document.getElementById('sent').setAttribute('disabled','1');
      document.getElementById('sent_ed').setAttribute('disabled','1');
      document.getElementById('recv_pref').setAttribute('disabled','1');
      document.getElementById('recv').setAttribute('disabled','1');
      document.getElementById('recv_ed').setAttribute('disabled','1');
      document.getElementById('br').setAttribute('disabled','1');
    }
  }

  function SubmitReq(reset)
  {
    CloseMsgBox();

    if ( reset && !confirm(MSG_ASK_RESET) ) return;
    var req = '';

    if ( document.getElementById('cond').checked )
    {
      var path = trim(document.getElementById('path').value);
      if (path != '*')
        req = '?'+'path='+encodeURIComponent(path);
      var sent_pref = document.getElementById('sent_pref').value;
      var el = document.getElementById('sent');
      var sent = trim(el.value);
      var sent_ed = trim(document.getElementById('sent_ed').value);
      if ( sent != '' )
      {
        if ( !(sent = parseInt(sent)) ) {
          el.focus();
          alert(MSG_ERROR_SENT);
          return;
        }
        req = req + ( req == '' ? '?' : '&' ) + 'sent='+sent_pref+(sent*sent_ed);
      }
      var recv_pref = document.getElementById('recv_pref').value;
      var el = document.getElementById('recv');
      var recv = trim(el.value);
      var recv_ed = trim(document.getElementById('recv_ed').value);
      if ( recv != '' )
      {
        if ( !(recv = parseInt(recv)) ) {
          el.focus();
          alert(MSG_ERROR_RECV);
          return;
        }
        req = req + ( req == '' ? '?' : '&' ) + 'recv='+recv_pref+(recv*recv_ed);
      }
      if ( req != '' && document.getElementById('br').checked )
        req = req + '&' + 'branch_res=Y';
    }

    if ( !(http_request = HTTPMakeRequest()) )
      return;

    document.getElementById('btn_view').setAttribute('disabled','1');
    document.getElementById('btn_reset').setAttribute('disabled','1');

    var html_tbody = document.getElementById('list');
    while( html_tbody.childNodes.length )
      html_tbody.removeChild( html_tbody.firstChild );

    http_request.open(reset ? 'DELETE' : 'POST', 'statistic'+req, true);
    http_request.onreadystatechange = show_result;
    http_request.send(null);
  }

  function show_result()
  {
    if ( http_request.readyState != 4 ) return;
    document.getElementById('btn_view').removeAttribute('disabled');
    document.getElementById('btn_reset').removeAttribute('disabled');

    var ResXML = http_request.responseXML;
    var el = ResXML.documentElement;

    if ( el.nodeName=='statistic' )
      show_rules(ResXML);
    else if ( el.nodeName=='message' )
      MessageBoxXML(ResXML);
    else
      alert(MSG_UNKNOWN_ANSWER);
    return;
  }

  function show_rules(ResXML)
  {
    var xml_rules = ResXML.documentElement.getElementsByTagName('rule');

    if ( xml_rules.length == 0 )
    {
      alert(MSG_NOT_FOUND);
      return;
    }

    var html_tbody = document.getElementById('list');
    var xml_rule, rule_id, rule_path, rule_sent, rule_recv;
    var html_tr, html_td, add_td_style;
    for (var i=0; i<xml_rules.length; i++)
    { 
      xml_rule = xml_rules[i];
      rule_id = xml_rule.attributes.getNamedItem('id').nodeValue;
      rule_path = ''; rule_sent = 0; rule_recv = 0;
      for (var j=0; j<xml_rule.childNodes.length; j++)
      {
        sub_element = xml_rule.childNodes[j];
        if ( sub_element.nodeType==1 )
          switch ( sub_element.nodeName )
          {
            case "path":
              rule_path = sub_element.firstChild.nodeValue;
              break;
            case "sent":
              rule_sent = sub_element.firstChild.nodeValue;
              break;
            case "recv":
              rule_recv = sub_element.firstChild.nodeValue;
              break;
          }
      }

      add_td_style = i % 2 == 0 ? '' : 'background-color: #E9EAFF; ';

      html_tr = document.createElement('tr');
      html_td = document.createElement('td');
      HTMLSetStyle(html_td, add_td_style+'text-align: right');
      html_td.appendChild(document.createTextNode(rule_id));
      html_tr.appendChild(html_td);
      html_td = document.createElement('td');
      HTMLSetStyle(html_td, add_td_style+'text-align: left');
      html_td.appendChild(document.createTextNode(rule_path));
      html_tr.appendChild(html_td);
      html_td = document.createElement('td');
      HTMLSetStyle(html_td, add_td_style+'text-align: right');
      html_td.appendChild(document.createTextNode(rule_sent));
      html_tr.appendChild(html_td);
      html_td = document.createElement('td');
      HTMLSetStyle(html_td, add_td_style+'text-align: right');
      html_td.appendChild(document.createTextNode(rule_recv));
      html_tr.appendChild(html_td);
      html_tbody.appendChild(html_tr);
    }
  }
