/* REXX                                                              */
/* Allgemeine Installationsroutine                                   */
/* --- angepat an URLCOPY.EXE ---                                   */
/* Lothar Sns, 2000                                                 */
/* ----------------------------------------------------------------- */
/* Funktionen:                                                       */
/* - prfen, ob notwendige Dateien vorhanden                         */
/* - WPS-Programmsymbol erzeugen                                     */
/* Voraussetzung:                                                    */
/* - Dateien befinden sich im aktuellen Verzeichnis                  */
/* ----------------------------------------------------------------- */


/* RexxUtil-Funktionen laden                                         */
call RxFuncAdd 'SysLoadFuncs' , RexxUtil, 'SysLoadFuncs'
call SysLoadFuncs

/* Konstanten fr diese Installation (anpassen)                      */
Objid        = '<LSOE_URLCOPY_DE>'                        /* Pflicht */
ProgramTitle = 'URLCopy fr OS/2'                         /* Pflicht */
ExeFile      = 'urlcopy.exe'                              /* Pflicht */
HelpFile     = 'urlcopy.hlp'                              /* Kann    */
AddFile1     = ''                                         /* Kann    */
Applicn      = 'URLCopy'                                  /* Kann    */
InstallDir   = Directory()        /* Default = aktuelles Verzeichnis */

/* Weitere Optionen fr das Objekt                                   */
/* Parm = '%'   heit keine Parameter                                */
Parm         = ''
/* Zuordnungs-Angaben, mit Kommata trennen                           */
DateiTyp     = ''
DateiEndung  = ''


/* Optionen concatenieren (anpassen)                                 */
OptionString =  'OBJECTID='objid,
                ';EXENAME='InstallDir'\'ExeFile,
                ';STARTUPDIR='InstallDir,
                ';PARAMETERS='Parm,
/* +++++        ';ASSOCTYPE='DateiTyp,       +++++ */
/* +++++        ';ASSOCFILTER='DateiEndung,  +++++ */
                ''

/* Was soll passieren, wenn das Objekt schon existiert?              */
Action       = Update


/* ----------------------------------------------------------------- */
/* Jetzt geht's los                                                  */
/* ----------------------------------------------------------------- */
call SysCls

say ' Ŀ'
say '                   REXX Installationsroutine                    '
say ' '
say
say 'Auf der Arbeitsoberflche wird ein Programmobjekt mit folgendem'
say 'Namen erzeugt:'
say '    >>>' ProgramTitle '<<<'
say 'Anschlieend knnen Sie es in einen beliebigen Ordner verschieben.'
say
say 'Installationsverzeichnis:'
say '   ' InstallDir
say

/* Exe-File vorhanden?                                               */
say 'Suche die Datei:' ExeFile || '......'
if Stream(ExeFile,'C','Query Exists') = '' then do
        say 'Datei' ExeFile 'nicht gefunden in' InstallDir
        say ExeFile 'mu fr die Installation in diesem Verzeichnis liegen.'
        say 'Abgebrochen...'
        exit
   end
say '... gefunden.'

/* AddFile  vorhanden?                                               */
if AddFile1 <> '' then do
   say 'Suche die Datei:' AddFile1 || '......'
   if Stream(AddFile1,'C','Query Exists') = '' then do
        say 'Datei' AddFile1 'nicht gefunden in' InstallDir
        say AddFile1 'mu fr die Installation in diesem Verzeichnis liegen.'
        say 'Abgebrochen...'
        exit
        end
   say '... gefunden.'
   end

/* HelpFile vorhanden?                                                */
if HelpFile <> '%' then do
   say 'Suche die Datei:' HelpFile || '......'
   if Stream(HelpFile,'C','Query Exists') = '' then do
        say 'Datei' HelpFile 'nicht gefunden in' InstallDir
        say HelpFile 'mu fr die Installation in diesem Verzeichnis liegen.'
        say 'Abbrechen...'
        exit
        end
   say '... gefunden.'
   end


/* WPS-Objekt erzeugen (auf dem Desktop)                             */
say
say 'Erzeuge das Programmobjekt ......'
rc = SysCreateObject('WPProgram',,
                     ProgramTitle,,
                     '<WP_DESKTOP>',,
                     OptionString,,
                     Action)

/* erfolgreich?                                                       */
if rc = 0 then do
        say '... fehlgeschlagen !!!'
        end
else do
        say '... erfolgreich installiert.'
        if DateiTyp    \= '' then do
                say
                say 'Dem Programm sind folgende Dateitypen zugeordnet:'
                say DateiTyp
                say 'Doppelklick auf eine solche Datei ruft dieses Programm auf.'
                end
        if DateiEndung \= '' then do
                say
                say 'Dem Programm sind folgende Dateiendungen zugeordnet:'
                say DateiEndung
                say 'Doppelklick auf eine solche Datei ruft dieses Programm auf.'
                end
        end

/* Voreinstellungen initialisieren bzw. lschen */
ret = SysIni('USER',Applicn,'DELETE:')

say
say 'REXX Installationsroutine beendet.'




