/* Copyright (c)1997 Kari Jackson for InnoVal Systems Solutions, Inc. */

/*----------------------------------------------*/
/* Create NetExtra or WebWilly bookmarks        */
/* from the ASCII output of BKMK2ASC.CMD        */
/*----------------------------------------------*/
/* Instructions:                                */
/* Execute without command line arguments while */
/* the BOOKMARK.ASC file is in the session's    */
/* current directory.  ASC2BKMK.CMD will prompt */
/* you for which type of bookmarks you want to  */
/* create, and where you want to create the     */
/* bookmark folders.  If you create them in a   */
/* directory which already exists, that folder  */
/* title will be changed to the title you       */
/* specify, and the bookmarks will be added but */
/* the existing bookmarks will not be touched.  */
/* If you create them in any directory outside  */
/* the program's BOOKS subdirectory structure,  */
/* you will also have to create an entry for    */
/* that new folder, in your FLDINDEX.NIX file,  */
/* in order for WebWilly or NetExtra to know    */
/* that the new directory belongs to the        */
/* bookmark area.  See the end of this          */
/* ASC2BKMK.CMD file for the format of the      */
/* BOOKMARK.ASC file, if you need to edit it.   */
/*----------------------------------------------*/
call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
signal on syntax name NoREXX
call SysLoadFuncs
signal on syntax name Syntax
"@ECHO OFF"
infile="bookmark.asc"
if stream(infile,"c","query exists")="" then do
   say ""
   say "Input file ("infile") not found."
   exit
end
say ""
say "Please select an output format (1-5):"
say "1.  NetExtra 1.x"
say "2.  NetExtra 2.0"
say "3.  WebWilly for OS/2 3.0"
say "4.  WebWilly for Windows 2.0x"
say "5.  WebWilly for Windows 3.0"
do until answer="1" | answer="2" | answer="3" | answer="4" | answer="5"
   answer=sysgetkey()
end
if answer<4 then toprog="NETEXTRA"
else toprog="WEBWILLY"
if answer=2 | answer=3 |answer=5 then longdate=1
else longdate=0
do while lines(infile)
   line=linein(infile)
   select
      when strip(line)="" then do
         foldername=strip(linein(infile))
         directoryname=translate(strip(linein(infile)))
         if strip(linein(infile))<>copies("-",60) then do
            say ""
            say "Bookmark.asc file has been corrupted."
            exit
         end
         say ""
         say "The next folder's name was" foldername"."
         say "Press Enter to keep this name or type a new one:"
         parse pull answer
         answer=strip(answer)
         if answer<>"" then foldername=answer
         parse var directoryname . "\BOOKS\" subdirname
         if subdirname="" then subdirname=substr(directoryname,4)
         if subdirname="" then subdirname=left(space(foldername,0),8)
         drive=left(directory(),2)
         suggest=drive||"\"||toprog||"\BOOKS\"||subdirname
         say ""
         say "Press Enter to create these bookmarks in the"
         say suggest
         say "directory, or type a new directory name:"
         do forever
            parse pull answer
            answer=strip(answer)
            if answer<>"" then directoryname=answer
            else directoryname=suggest
            root=left(directoryname,3)
            if pos(":\",root)<>2 | length(directoryname)<4 then do
               say ""
               say "Please specify a full pathname which is not the root directory"
               say "of a drive....such as C:\"||toprog||"\BOOKS\DIRNAME"
               iterate
            end
            stepping=directoryname
            error=0
            do until stepping=""
               if error=1 then leave
               parse var stepping before "\" stepping
               if length(before)=2 & pos(":",before)=2 then iterate
               if right(root,1)<>"\" then root=root||"\"
               root=root||before
               call sysfiletree root,"EXISTS.","DO"
               if exists.0>1 then do
                  say ""
                  say "Directory name" root "not understood....Multiple"
                  say "directories by that name exist!  Please specify a"
                  say "non-ambiguous directory name."
                  error=1
               end
               if error=1 then leave
               if exists.0=1 then iterate
               if exists.0=0 then do
                  rc=sysmkdir(root)
                  if rc>0 then do
                     say ""
                     say "Unable to create" root "directory.  Please specify"
                     say "another target directory name."
                     error=1
                  end
               end
               if error=1 then leave
            end
            if error=0 then leave
         end
         if toprog="NETEXTRA" then call SysPutEA directoryname,"WEBEXFOLDERNAME",foldername
         else do
            titlefile=directoryname"\"substr(directoryname,lastpos("\",directoryname)+1)".ES"
            call sysfiledelete titlefile
            call charout titlefile,foldername
            call lineout titlefile
         end
      end
      otherwise do
         title="" ; url="" ; sticky="20"x ; userid="" ; password=""
         parse var line title "09"x url "09"x date "09"x time "09"x sticky "09"x userid "09"x password "09"x stickydate "09"x stickyfollowup "09"x stickytext
         if time="" then time=time("C")
         if length(time)=6 then time=0||time
         if date="" then date=insert("/",insert("/",date("S"),4),7)
         if longdate=0 then date=right(date,5)
         else if toprog="WEBWILLY" then do
            parse var date yy "/" mm "/" dd
            yy=right(yy,2)
            date=mm"/"dd"/"yy
         end
         string="17"x||title||"09"x||url||"09"x||date||"09"x||time||"09"x||sticky||"09"x||"09"x||userid||"09"x||password||"09"x
         if directoryname="DIRECTORYNAME" then directoryname=directory()
         filename=GetPopName(directoryname,"URL")
         if toprog="WEBWILLY" then do
            call lineout filename,string
            if result=0 then say "Created bookmark" filename "for" url
            else say "Error on" url
         end
         call lineout filename
         if toprog="NETEXTRA" then do
            if SysPutEA(filename,"URLFILEBUFFER",string)=0 then say "Created bookmark" filename "for" url
            else say "Error on" url
         end
         if sticky="01"x then do
            convert=stickytext
            final=""
            if toprog="NETEXTRA" then combine="0D0A"x
            else combine="0D0D0A"x
            do until convert=""
               parse var convert check "09"x convert
               if final="" then final=check
               else final=final || combine || check
            end
            stickytext=final
            if toprog="NETEXTRA" then do
               call SysPutEA filename,"STICKEYDATE",stickydate
               call SysPutEA filename,"STICKEYFOLLOWUP",stickyfollowup
               call SysPutEa filename,"STICKEYTEXT",stickytext
            end
            else do
               parse var filename root "." .
               filename=root||".STK"
               call lineout filename, stickydate||stickytext
               call lineout filename
            end
         end
         if stream(filename)<>"UNKNOWN" then call lineout filename
      end
   end
end
exit
GetPopName:procedure
/* Copyright (c)1996,1997 Kari Jackson for InnoVal Systems Solutions, Inc. */
/* Subroutine to produce a *.POP-style filename */
/* Returns d:\dirname\filename.ext or "error" */
parse arg directory,extension
if right(directory,1)='\' then directory=substr(directory,1,length(directory)-1)
if left(extension,1)='.' then extension=substr(extension,2)
characters='0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'
parse value date("O") with . 2 year "/" month "/" day
parse value time() with hour ":" minute ":" second
month=substr(characters,month+1,1)
day=substr(characters,day+1,1)
hour=substr(characters,hour+1,1)
fifth=minute%36
sixth=substr(characters,minute//36+1,1)
test=second//36
string=year||month||day||hour||fifth||sixth
do j=1 to 36
   test2=(test+j)//36
   if test2=0 then seventh=substr(characters,36,1)
   else seventh=substr(characters,test2,1)
   do i=1 to 36
      tryit=string||seventh||substr(characters,i,1)
      filename=directory||"\"||tryit||'.'||extension
      if stream(filename,'c','query exists')='' then return filename
   end
end
return "error"
Syntax:
  say "Error" rc": " errortext(rc)
  say "Line" sigl": " sourceline(sigl)
  exit
return
NoREXX:
   say "Unable to load the REXXUtil functions.  Either the REXXUTIL.DLL file"
   say "is not on the LIBPATH or REXX support is not installed on this system."
   exit
return
/*
                          The BOOKMARK.ASC file format

If you want to modify this file, you must use an ASCII text editor which does
not convert tab characters to spaces the way so many editors do!  OS/2's E.EXE
is safe for this purpose, as is Windows Notepad.

First folder in file:

  Line one:    blank
  Line two:    folder name
  Line three:  full pathname to the directory which is (was) that folder
  Line four:   ------------------------------------------------------------
  Line five:   the rest of the lines are the bookmark information, one
                  bookmark per line

Repeat, starting with the blank line, for any other folders.  Do not end the
file with a blank line.

The blank line is what tells the program that a new folder is starting.  Do not
leave out the blank line between one folder and the next, and do not leave any
blank lines anywhere else in the file.

The bookmark information lines contain the following items:

  Title of the web page
  a tab character
  The web page's URL (such as http://www.innoval.com/netextra)
  a tab character
  The date the bookmark was created (such as 1997/01/13)
  a tab character
  The time the bookmark was created (such as 09:26am)
  a tab character
  A hex 01 character if there is a sticky note, or hex 20 if there isn't
  a tab character
  Your userid if the web page is password-protected
  a tab character
  Your encrypted password if the web page is password-protected
  If the bookmark has a sticky note, its date (such as 01/13/97)
  a tab character
  If the bookmark has a sticky note, a 0 character
  a tab character
  If the bookmark has a sticky note, the text of the sticky note, with tab
     characters where the carriage returns belong
*/
