@echo off
rem ********************* The ULTIMATE WAD.BAT v4 ***************************
rem         * By Simon Howard 'Fraggle' * fraggle@gmail.com *
rem                 * http://www.soulsphere.org/ *

rem *************************** Variables ***********************************

rem                    ** User-configurable stuff **
rem * doom_exe: change doom2.exe to your exe file name. eg, doom3.exe
	set doom_exe=doom2.exe
rem * com_line: command line parameters you want to be passed. eg, -skill 3
	set com_line=-warp 1
rem * wad_dir: directory where your wad files are kept. eg, c:\doom\wads
rem     NB: MUST be "." if you use the current(doom) directory
	set wad_dir=.

rem                  ** internal stuff, do not touch **
	set wads=

rem ** check for command line parameters
	if "%1"=="" goto help
	if "%1"=="/?" goto help
	if "%1"=="/w" goto wadlist
	if "%1"=="/W" goto wadlist

rem **************************** Main Loop *******************************
rem ** loop until no more wads **
:mainloop
	if exist %1.wad goto foundwad
	if exist %wad_dir%\%1.wad goto dfoundwad
	if exist %1 goto foundnowad
	if exist %wad_dir%\%1 goto dfoundnowad
	rem ** no more specified
	if "%wads%"=="" goto nowads
	rem ** run doom
	goto rundoom

rem              ** found a wad without an extension **
:foundwad
	set wads=%wads% %1.wad
	shift
	goto mainloop

rem ** in wads directory
:dfoundwad
	set wads=%wads% %wad_dir%\%1.wad
	shift
	goto mainloop

rem             ** found a wad with the extension given **
:foundnowad
	set wads=%wads% %1
	shift
	goto mainloop

rem ** in wads directory
:dfoundnowad
	set wads=%wads% %wad_dir%\%1
	shift
	goto mainloop

rem                      ** no valid wads specified **
:nowads
	echo No (valid) wads specified!
	goto end

rem *************************** Run doom ************************************
:rundoom
	rem ** add all extra command lines
	set extras= 
	:extraloop
	set extras=%extras% %1
	shift
	if "%1"=="" goto xextraloop
	goto extraloop
	:xextraloop
	rem ** stuffbuf to press enter at modified game message
	stuffbuf !
	rem ** run it
	%doom_exe% %extras% -file %wads% %com_line%
	goto end

rem *********************** Command line parameters *************************
:help
	echo.
	echo Starts a Doom ][ WAD.
	echo.
	echo Usage:
	echo.
	echo WAD [drive:][path]filename[.wad] (...) [parameters]
	echo WAD /W [drive:][path]
	echo.
	echo  [drive:][path]    Specifies a location other than the current directory.
	echo  filename          Loads doom using this wadfile.
	echo  parameters        Command line parameters to pass to doom
	echo  /W                Displays a list of .WAD files
	echo.
	goto end

:wadlist
	if "%2"=="" goto wadlst0
	if exist %2*.wad goto wadlst1
	if exist %2\*.wad goto wadlst2
	
	echo Directory not found or contains no WAD files!
	goto end

	:wadlst0
		dir /b %wad_dir%\*.wad
		goto end
	:wadlst1
		dir /b %2*.wad
		goto end
	:wadlst2
		dir /b %2\*.wad
		goto end

:end
	set wads=
	set doom_exe=
	set com_line=
	set wad_dir=            
	set extras=
