//----------------------------------------------------------------------------
//    DOOM.DCL
//    (c) URBAN Reinhard, Graz 1995
//----------------------------------------------------------------------------
dcl_settings : default_dcl_settings { audit_level = 0; }

// pick Point
pick_point_button : button {
    label = "<";
    alignment = centered;
}
// pick Texture from List of Textures
// textures.lst
texture_list : popup_list {
	alignment = right;
//	fixed_width = true;
//	width = 12;
	tabs="1 10 13";
	list="-\nAASTINKY\nASHWALL\nBIGDOOR1\nBIGDOOR2";
}
// line types >linetyp.lst
action_types : popup_list {
//	width = 8;
	//tabs = "1 7 11 19";
    list="0\n1\n2\n3\n4\n5\n6\n7\n8\n9\n10\n11\n12\n13\n14\n15\n16\n17\n18\n19";
}
// things.lst
things : popup_list {
	width = 12;
	tabs = "1 4";
	//tabs = "1 4 38 42 46";
    //list = "0\tNothing\t5\t5\tD\n1\tPlayer 1\t32\t56\tP";
    list = "0\t\n1\tPlayer 1\n2\tPlayer 2";
}

// >sectypes.lst
sector_types : popup_list {
	width = 8;
	//tabs = "1 4 13";
	//list="0\t-\tnormal\n1\tHEALTH\tlight blinks random\n9\tSECRET\tcredit";
    list="0\n1\n2\n3\n4\n5\n6\n7\n8\n9\n10\n11\n12\n13\n14\n15\n16";
}

// EDITLINE in DOOM.LSP
DOOMEDITLINE : dialog {
	label="Edit Line";
	: column {	//untereinander
		children_alignment = right;
        : boxed_row {
			children_alignment = right;
        	label = "from";
            mnemonic = "f";
            : edit_box {
            	label = "   X:";
                key = "fromx";
                edit_width = 10;
            }
            : edit_box {
                label = "   Y:";
                key = "fromy";
                edit_width = 10;
			}
//			: pick_point_button { key = "frompick";}
		}
        : boxed_row {
			children_alignment = right;
        	label = "to  ";
            mnemonic = "t";
            : edit_box {
            	label = "   X:";
                key = "tox";
                edit_width = 10;
            }
            : edit_box {
                label = "   Y:";
                key = "toy";
                edit_width = 10;
			}
//			: pick_point_button { key = "topick";}
		}
		: edit_box {
			label = "belongs to sector:";
			key="secnum";
			edit_width = 5;
		}
//		spacer_0;
		: row {
			: list_box {
				key="linflag";
				label="flags";
	//			fixed_width=true;
	//			width=8;
				multiple_select=true;
				//list="Im\nMo\n2s\nUp\nLo\nSc\nBl\nIn\nMp";
				list="Impassable\nNo Monsters\n2-Sided\nUpper unpegged\nLower unpegged\nSecret\nBlock sound\nNot in Map\nOn Map";
			}
			: action_types {
				key="lintype";
				label="type";
			}
		}
		: edit_box {
			label = "tag";
			key="lintag";
			edit_width = 5;
		}
//		spacer_0;
		: boxed_row {
		    label = "Texture";
			: texture_list { key="texlo";   }
			: texture_list { key="texnorm"; }
			: texture_list { key="texup";   }
		}
		: row {
			children_alignment=top;
            : edit_box {
            	label = "   X:";
                key = "texx";
                edit_width = 3;
            }
            : edit_box {
                label = "   Y:";
                key = "texy";
                edit_width = 3;
			}
		}
	}
    spacer_1;
    ok_cancel_help;
    errtile;
}


// EDITSECTOR in DOOM.LSP
DOOMEDITSECTOR : dialog {
	label="Edit Sector";
	: column {	//untereinander
		children_alignment = right;
	    : concatenation {
	        : text_part {
	            label ="# lines:";
	        }
	        : text_part {
	            key = "sec-lines";
	            width = 3;
	        }
		}
		: boxed_row {
			alignment = right;
			label = "Height";
			: edit_box {
				label = "Floor";
				key="floor";
				edit_width = 5;
			}
			: edit_box {
				label = "Height";
				key="height";
				edit_width = 5;
			}
		}
		: boxed_column {
			alignment = right;
			label = "Textures";
			: texture_list {
				fixed_width=true;
				key="textfloor";
				label="Floor";
			}
			: texture_list {
				fixed_width=true;
				key="texceil";
				label="Ceiling";
			}
		}
//		spacer_1;
		: edit_box {
			label = "light";
			key="light";
			edit_width = 5;
		}
		: sector_types {
			key="sectype";
			label="type";
		}
		: edit_box {
			label = "tag";
			key="lintag";
			edit_width = 5;
		}
	}
    spacer_1;
    ok_cancel_help;
    errtile;
}


DOOMEDITTHING : dialog {
	label="Edit Thing";
	: column {	//untereinander
		: things {
			key="thngtype";
			label="type";
		}
	}
    spacer_1;
    ok_cancel_help;
    errtile;
}








