'("$Id: doomutil.lsp 1.1 1995/05/30 12:50:34 Reini Exp $")
;;;* DOOMUTIL.LSP
;;; (c) URBAN Reinhard, Graz 1991-95
;;;ͻ
;;; URBAN Utilities fr AutoCAD R12               V 2.9        
;;; (c) Reinhard URBAN, A-Graz, 1991-95                        
;;; Architekten Domenig - Eisenkck, Jahng. 9, 8010 Graz       
;;; E-Mail:     rurban@sbox.tu-graz.ac.at                      
;;; AutoCAD R12 int. + deutsch Zusatzprogramme, 1991-95        
;;;ͼ
;;;
;;;   Permission to modify and distribute this software
;;;   is not granted.
;;;
;;;   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED
;;;   WARRANTY.  ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR
;;;   PURPOSE AND OF MERCHANTABILITY ARE HEREBY DISCLAIMED.
;;;
;;;*************************************************************
;;;   Utility functions for DOOM.LSP
;;;   extracted automatically from several sources to
;;;   release the source for WADOUT to the public.
;;;   Permission to use only as utility functions for programs
;;;   in DOOM.LSP. May only be distributed along with DOOM.LSP
;;;
;;;   german and english messages are freely mixed
;;;*************************************************************

(defun ur_default (symb value)
  (if (and value (not (eval symb)))
    (set symb value)))

(defun ur_deftyplst (_$lst _$def / _$ele _$i _$n _$tmp)
  (if (/= (type _$lst) 'LIST)
    (princ "\nwrong type of first argument in deftype"))
  (setq _$n (length _$lst) _$i 0)
  (repeat _$n
    (setq _$ele (nth _$i _$lst))
    (if (= (type _$ele) 'SYM) (setq _$tmp _$ele _$ele (eval _$tmp)))
    (if (/= (type _$ele) (type (nth _$i _$def)))
      (progn
	(ur_breaks "deftype chk" '("_$lst" "_$def"))
        (setq _$lst (ur_rplace _$lst _$i (nth _$i _$def)))
    	(if _$tmp (set _$tmp (nth _$i _$def)))
      )
    )
    (setq _$i (1+ _$i))
  )
  _$lst
)

(defun ur_deftype (_$ele _$def / _$tmp)
  (if (= (type _$ele) 'SYM) (setq _$tmp _$ele _$ele (eval _$tmp)))
  (if (/= (type _$ele) (type _$def))
    (setq _$ele _$def)
  )
  (if _$tmp (set _$tmp _$ele) _$ele)
)

;;; only path of ur_filename
(defun ur_filepath (fname)
  (car (ur_fspfile fname))
)
;;; splittet fspec in path, filename und extension auf (->Uppercase)
;;; "c:\acad\lisp.doc" -> '("C:\ACAD\" "LISP" ".DOC")
;;; "I:XX" -> '("I:" "XX" "")
(defun ur_fspfile (fspec / l ext name path)
  (setq fspec (strcase (ur_strchg fspec "/" "\\")))
  (setq l (reverse (ur_s2l fspec)))
  (setq ext (member '"." l))
  (if ext
    (setq ext (substr (ur_l2s (reverse l)) (length ext))
          l (reverse (ur_s2l (substr fspec 1 (- (strlen fspec) (strlen ext))))))
    (setq ext  "")
  )
  (setq path (member '"\\" l))
  (if (not path) (setq path (member '":" l)))
  (setq path (if path (ur_l2s (reverse path)) ""))

  (setq name (substr (ur_l2s l) 1 (- (length l) (strlen path))))

  (list path (ur_l2s (reverse (ur_s2l name))) ext)
)
;;; ndert in String _$str jeden Substr _$old in _$new
(defun ur_strchg (_$str _$old _$new / _$i ls lold)
  (setq lold (strlen _$old)
        ls (1+ (- (strlen _$str) lold))
        _$i 1)
  (while (<= _$i ls)
    (if (= (substr _$str _$i lold) _$old)
      (setq _$str (strcat
        (if (> _$i 1) (substr _$str 1 (1- _$i)) "")              ; Kopf von _$str
        _$new                                              ; neuer String
        (if (< _$i ls) (substr _$str (+ _$i lold)) ""))          ; Rest von _$str
        _$i (+ _$i (strlen _$new))
      )
      (setq _$i (1+ _$i))
    )
  )
  _$str
)
;;; konvertiert string in list of char (type str)
(defun ur_s2l (_$str / _$l)
  (if (= (type _$str) 'STR)
    (while (/= _$str "")
      (setq _$l   (cons (substr _$str 1 1) _$l)
            _$str (substr _$str 2)))
  )
  (reverse _$l)
)
;;; erzeugt aus list of strings einen String
(defun ur_l2s (_$l / _$str)
  (setq _$str "")
  (while _$l
    (setq _$str (strcat _$str (car _$l))
          _$l (cdr _$l)))
  _$str
)
;;; UR_FPSLASH converts "\\"s or "/"s in path strings to whichever is
;;; needed by operating system (Unix or DOS and OS/2), and forces trailing "\\"
;;; or "/".
(defun ur_fpslash (path / slash inc wpath char)
  (setq inc 1  wpath ""                                ;initialize variables
        slash (if (getenv "COMSPEC") "\\"  "/")        ;set for DOS or OS/2, or Unix
  )
  (while (/= "" (setq char (substr path inc 1)))       ;test each char
    (setq wpath                                        ;append proper char back
      (strcat wpath (if (member char '("\\" "/")) slash char))
      inc (1+ inc)                                     ;increment counter
  ) )
  (if                                                  ;if last char isn't slash
    (and (/= wpath "") (/= (substr wpath (strlen wpath) 1) slash))
    (setq wpath (strcat wpath slash))                  ;make it a slash
  )
  wpath
)
;;; entfernt Z-Koordinate, bzw. letztes Listenelement
(defun ur_3to2d (p)
  (list (car p)(cadr p))
  ;; anstatt:
  ;; (reverse (cdr (reverse p)))
)
(defun ur_exit (_$str)
  (princ _$str)
  (terpri)
  (exit)
  ;;(ur_varres)
)
;;; UR_FFNAME formats a filename as "filename.ext" given input FNAME with or
;;; without extension, and EXT as "EXT". Using "" as EXT strips extensions.
(defun ur_ffname (fname ext / inc lngth pos)
  (setq inc -1  lngth (strlen fname))    ;initialize, lngth is ur_filename length
  (if (= (substr ext 1 1) ".") (setq ext (substr ext 2)))
  (while
    (not                                  ;loops until OR is non-NIL
      (or                                 ;eval 2nd AND only if 1st is NIL
        (and                              ;setq FNAME only if "." = non-NIL
          (/= lngth (setq inc (1+ inc)))
          (= "." (substr fname (- lngth inc) 1))      ;find "."
          (setq                           ;strip last char and append EXT
            fname (strcat (substr fname 1 (- lngth inc)) ext)
          )
        )
        (and                                        ;setq FNAME only if...
          (or (= inc 3) (= inc lngth) (<= lngth 2)) ;...if "." not found in last 3 char
          (setq fname (strcat fname "." ext))       ;then append EXT to whole fname
  ) ) ) )
  fname
);defun
;;; inspects variables, without ur_break (input evaluation)
;;; Usage: (ur_breakn "nach Ende:" '("b" "bl"))
(defun ur_breakn ($msg $var / $v)
  (if *BREAK*
    (progn
      (if $msg (princ (strcat "\nBREAKN> \"" $msg "\"")))
      (foreach $v $var (if $v (ur_varsho1 $v)))
      (terpri)
    )))
;;; tail recursive!
(defun ur_head (_$lst _$n) (ur_head1 _$lst nil _$n))
(defun ur_head1 (_$lst x _$n)
  (cond ((minusp _$n) (reverse x))
  (t (ur_head1 (cdr _$lst) (cons (car _$lst) x) (1- _$n)))))
;;; gibt Defaultwert _$str als String zurck, -> INSIDE (ur_getpoint)
;;; Strings, Zahlen, Listen
(defun ur_tostr (_$str / typ)
  (cond
    ((not _$str) "")			;"" = NIL
    ((= (setq typ (type _$str)) 'STR) _$str)	;String
    ((= typ 'INT)  (itoa _$str))		;Number
    ((= typ 'REAL) (rtos _$str 2))		;Float with few commas
    ((= typ 'LIST)			;Not empty list
      (strcat
        "("
        ;;(if (> (length _$str) 1)		;Comma delimited
	;;  (ur_strlstc (mapcar 'ur_tostr _$str))
	;;  (ur_tostr (car _$str))		;single entry within brackets
	;;)
	")"
      )
    )
    (T (ur_sym2str _$str))	;alle anderen Typen (FILE, ENAME, PICKSET, SUBR, ...)
  )
)
(defun ur_sym2str (_$sym / f str tmp)
  (setq tmp "$stos.ac$")
  (setq f (open tmp "w"))(princ _$sym f) (close f)
  (setq f (open tmp "r") str (read-line f) f (close f))
  str
)
;;; Teiliste von _$lst ab dem einschl. i-ten bis zum einschl. j-ten
;;;(ur_sublst '(0 1 2 3 4 5 6 7) 2 3) -> '(2 3)
(defun ur_sublst (_$lst _$i j)
  (ur_tail (ur_head _$lst j) (1- _$i))
)

;;; UR_REMOVE - Non-destructive way to remove an item from a list.
;;; rekursiv, doppelte Elemente erlaubt!
(defun ur_remove (item from)
  (cond
    ((atom from) from)
    ((equal (car from) item)
      (ur_remove item (cdr from))
    )
    (t (cons (car from) (ur_remove item (cdr from))))
  )
)
;;; ur_tail - Liste aller Elemente nach dem n-ten Element, Basis 0
(defun ur_tail (_$lst _$n)
  (cond ((minusp _$n) _$lst)
  (t (ur_tail (cdr _$lst) (- _$n 1)))))
(defun ur_dtr (dwin)    ; Winkelumrechnung
  (* pi (/ dwin 180.0)))              ; degree to radian
(defun ur_rtd (dwin)    ; Winkelumrechnung
  (/ (* dwin 180.0) pi))              ; radian to degree
;;; inspects variables, then ur_break (input evaluation)
;;; Usage: (ur_breaks "nach Ende:" '("b" "bl"))
(defun ur_breaks ($msg $var / $v)
  (if (and *BREAK* (not *CONT*))
    (progn
      (princ "\nBREAKS> continue with CONT")
      (if $msg (princ (strcat "\nBREAKS> \"" $msg "\"")))
      (foreach $v $var (if $v (ur_varsho1 $v)))
      (ur_break))))
;;; usage: (ur_varsho1 "fname") oder (ur_varsho1 "'b")
(defun ur_varsho1 ($s)
  (princ (strcat "\nEVAL> VAR " $s ": "))
  (prin1 (if (setq $s (read $s)) (eval $s) $s))    ;sonst Fehler bei (eval nil)
  (princ)
)
;;; evaluates input, weiter mit CONT
;;; Innerhalb von (BD4A)-Funktionen ist eine Evaluierung nicht mglich.
;;; Aber Test, ob man gerade in (BD4A)-Funktion ist, ist auch nicht mglich.
(defun ur_break (/ $s)
  (if (and *BREAK* (not *CONT*))
    (progn
      (initget 128)
      ;; Fehlermeldung nach Lispinput einfach ignorieren
      (while (and (not *CONT*) (/= (setq $s (getstring "\nBREAK> ")) ""))
        (cond
          ((= (strcase $s) "CONT") (setq *CONT* T))
          (T (print (eval (read $s))))
        )
        (if (not *BREAK*) (setvar "CMDECHO" 0))
        (initget 128)))))
;;; ur_filename only
(defun ur_fnameonly (fname)
  (cadr (ur_fspfile fname)))
;;; Lade Ext Subr "_$str" von File "file.exp"
(defun ur_xload? (_$str _$file)
  (cond
    ((= (type _$str) 'STR)
      (if (boundp (read _$str))
        T						;;Ext Subr okay
	(xload _$file)))
    ((= (type _$str) 'SYM)
      (if (boundp _$str)
        T
	(xload _$file)))
    ((not _$str)
      (xload _$file))))
;;; UR_RPLACE - ersetzt in der Liste _$lst das n-te Element durch new, Basis 0
;;;   Liste _$lst darf gequoted sein
(defun ur_rplace (_$lst _$n new / tmp)
  (if (= (type _$lst) 'SYM) (setq tmp _$lst _$lst (eval tmp)))
  (setq _$lst (append (ur_head _$lst (1- _$n)) (list new) (ur_tail _$lst _$n)))
  (if tmp (set tmp _$lst) _$lst))
;;; returns last main entity (no sub entity like attrib, attdef, seqend)
(defun ur_entmlast (/ l)
  (ur_mainentity (entlast))
)
;;; gib ENAME des Hauptelementes von Subelement b zurck
;;; b kann sein: (entget) Liste, (entsel) Liste oder 'ENAME
(defun ur_mainentity (b / e)
  (setq b (ur_entname b))
  (while (member (ur_gettyp b) '("ATTRIB" "ATTDEF" "VERTEX"))
    (setq b (entnext b))
  )
  (if (member (ur_gettyp b) '("SEQEND" "ENDBLK"))
    (ur_getval -2 b)
    b
  )
)
;;; Wert der Gruppe _$grp in Assoc Liste von Element b
;;; (Entsel-, Entget-Liste oder ENAME)
;;; -> (assocv) in MATH.LLB
(defun ur_getval (_$grp _$ele)
  (cond
    ((= (type _$ele) 'ENAME)
      (cdr (assoc _$grp (entget _$ele))))               ; ename
    ((not _$ele) nil)                               ; leere Liste
    ((not (listp _$ele)) nil)
    ((= (type (car _$ele)) 'ENAME)
      (cdr (assoc _$grp (entget (car _$ele)))))         ; (entsel) Objekt
    (t (cdr (assoc _$grp _$ele)))))                       ; normale Assoc-Liste

(defun ur_gettyp (b)    (ur_getval 0 b))
;;; Achtung: Konflikt mit INPUT.LSP!
;;;(defun ur_getname (b) (ur_getval 2 b))
(defun ur_getlay (b)    (ur_getval 8 b))
(defun ur_gethandle (b) (ur_getval 5 b))
(defun ur_getpt (b)     (ur_getval 10 b))
(defun ur_getendpt (b)  (ur_getval 11 b))
;;; POS - Position von pt in pts, -1 wenn nicht vorhanden
(defun ur_pos (pt pts / _$lst)
  (1- (length (member pt (reverse pts)))))
;;; UR_LST_SWAP - tausche i1 mit i2-tem Element in Liste lst
;;;   Liste _$lst darf gequoted sein
(defun ur_lst_swap (_$lst i1 i2 / tmp tmp1)
  (if (= (type _$lst) 'SYM) (setq tmp _$lst _$lst (eval tmp)))
  (if (= i1 i2)
    (if tmp (set tmp _$lst) _$lst)
    (progn
      (if (> i1 i2) (setq tmp1 i1 i1 i2 i2 tmp1))
      (setq tmp1 (nth i1 _$lst))
      (setq _$lst (ur_rplace _$lst i1 (nth i2 _$lst)))
      (setq _$lst (ur_rplace _$lst i2 tmp1))
      (if tmp (set tmp _$lst) _$lst))))
;;; (ur_string-not-empty _$str)   - is _$str a non-empty string?
(defun ur_string-not-empty (_$str)
  (and (stringp _$str) (/= _$str "")))
;;; konvertiert String mit Delimitern in Stringliste
;;; betrachtet Delim als Whitespace, dh. ",,2,3,," -> '("2" "3")
;;; zB: (ur_strdlst "f 1,3" ", ") -> ("f" "1" "3")
(defun ur_strdlst (_$str _$delim / tok _$l)
  (setq _$l (list (strtok _$str _$delim)))           ;init tokenizing
  (while (setq tok (strtok nil _$delim))       ;do tokenizing
    (setq _$l (cons tok _$l))
  )
  (reverse _$l)
)
;;; STRTOK -- Searches one string for tokens, which are separated by the
;;;           delimiters found in a second string.  String 1 contains the
;;;           string to be tokenized on the first call to strtok; thereafter
;;;           it should be nil for all subsequent calls to strtok for the
;;;           same string.
;;;
;;;           The first call to strtok returns the first token found in
;;;           the string, as a string, and sets the value of *STR_TOK*,
;;;           a global variable, to the remainder of the string passed in
;;;           as the first argument. Subsequent calls to strtok with a null
;;;           first argument will work through the string in *STR_TOK*
;;;           until no more tokens remain.
;;;
;;;           The separator string may be different on each call, if desired.
;;;
;;;           The following code fragment produces the output below.
;;;
;;;             (setq str "(defun strtok (_$str1 _$str2 / _$j _$s_l)") ;)
;;;             (print (strtok str " ()/"))
;;;             (while (setq _$temp (strtok nil " ()/")) (print _$temp))(princ)
;;;
;;;             "defun"
;;;             "strtok"
;;;             "_$str1"
;;;             "_$str2"
;;;             "_$j"
;;;             "_$s_l"
;;;
;;;           If the first argument isn't a string and the original string
;;;           has been fully tokenized, *ERRORNO* is set to -1.  If the second
;;;           argument isn't a string, *ERRORNO* is set to -2.  In either case
;;;           nil is returned.
;;;
;;;           Any changes made to this routine should be made in SCANF.llb
;;;           as well.  The code is duplicated there.
(defun strtok (_$str1 _$str2 / _$j _$strlst _$temp _$tokn _$tok _$sl _$ch)
  (setq *ERRORNO* nil)
  (if (or (= (type _$str1) 'STR) (= (type *STR_TOK*) 'STR))
    (if (= (type _$str2) 'STR)
      (if (> (setq _$sl (strlen (if _$str1 _$str1 *STR_TOK*))) 0)
        (progn
          (setq _$j 1)
          (repeat (strlen _$str2)
            (setq _$strlst (if _$strlst (append _$strlst (list (substr _$str2 _$j 1)))
                              (list (substr _$str2 _$j 1))
                      )
                  _$j   (1+ _$j)
            )
          )
          (setq _$j 1 _$tok "")
          (while (and (<= _$j _$sl)
                   (not (member (setq _$ch (substr (if _$str1 _$str1 *STR_TOK*)
                                                 _$j 1))
                              _$strlst)
                   )
                 )
            (setq _$tok (strcat _$tok _$ch)
                  _$j   (1+ _$j)
            )
          )
          (setq _$temp      (if _$str1 _$str1 *STR_TOK*)
                *STR_TOK* (substr _$temp (1+ _$j))
                _$tokn     (substr _$temp 1 (1- _$j))
          )
          (if (= (strlen _$tokn) 0)  ; If no token found
            (strtok nil _$str2)        ; Recurse through sucessive separators
            _$tokn                   ; Return _$new token
          )
        )
        (setq *STR_TOK* nil)
      )
      (progn
        (setq *ERRORNO* -2)
        nil
      )
    )
    (progn
      (setq *ERRORNO* -1)
      nil
    )
  )
)
;;; End of strtok defun
(defun ur_firstpolypt (poly / typ)
  (cond
    ((= (setq typ (ur_gettyp poly)) "POLYLINE")
      (ur_getpt (entnext (ur_entname poly))))
    ((member typ '("SEQEND" "VERTEX"))
      (ur_getpt (entnext (ur_mainentity poly))))
    (T nil)
  )
)
;;; gibt nchsten Polypunkt der Polylinie poly zurck
(defun ur_nextpolypt (poly)
  (setq poly (ur_entname poly))
  (cond
    ((or (= (ur_gettyp poly) "SEQEND")
         (= (ur_gettyp (entnext poly)) "SEQEND"))
      (ur_firstpolypt (ur_mainentity poly)))
    ((member (ur_gettyp poly) '("VERTEX" "POLYLINE"))
      (ur_getpt (entnext poly)))
    (T
      (princ "\nError: No POLYLINE element in (ur_nextpolypt)")
       nil
    )
  )
)
;;; ladet Lispprogramm str, wenn Funktion pro nicht definiert ist
;;; braucht Definition von ur_mrffile in URBAN.MNL
;;; Argument _$str: String oder Symbol
(defun ur_load (_$str _$file / fn)
  ;;(ur_xcheck)
  (if (not (setq fn (ur_mrffile _$file)))
    (if (member (strcase _$file) '("INIT" "STRING" "ACAD1" "INSIDE" "LIST"
        "TIMELIB" "FILELIB" "INI" "INCLUDE" "SSX"))
      (setq _$file (ur_mrffile "URBAN"))
      (ur_exit (strcat "Error: Program" _$file " nicht gefunden!"))
    )
  )
  (cond
    ((= (type _$str) 'STR)
      (if (boundp (read _$str))
        T
        (ur:load (ur_mrffile _$file))
      )
    )
    ((= (type _$str) 'SYM)
      (if (boundp _$str)
        T
        (ur:load (ur_mrffile _$file))
      )
    )
    ((not _$str)
      (ur:load (ur_mrffile _$file))
    )
  )
)
;;; (ur_mrffile) "return found file"
;;; ersetzt ai_ffile in (_autoqload), dem AUTOLOADER
;;; ermglicht Laden von compilierten oder kelvinateten Programmen
;;; vor normalen Programmen
(defun ur_mrffile (app / f)
  (ur_mffile app (ur_mlspext)))

;;; (UR_FFILE fname exts)
;;; sucht fname mit den Extensions in exts im ACAD-Pfad
;;; sucht zuerst fname, dann mit jeder Extension, gibt gefundenen Namen
;;; oder nil zurck
;;; zB: (ur_ffile "ACAD" '("LSP" "MNL")) -> "S:\\ACAD.LSP"
(defun ur_mffile (fname exts / f)
  (if (not ur_ffname) (defun ur_ffname (S1 S2) (STRCAT S1 "." S2)))
  (if (not (setq f (findfile fname)))
    (while exts
      (if (setq f (findfile (ur_ffname fname (car exts))))
	(setq exts nil)
	(setq exts (cdr exts))
      )
    )
  )
  f
)
(defun ur:load (f)
  (if (and f (= (type f) 'STR))
    (if (= (load f -3) -3)
      (progn (princ (strcat "\n>>Error while loading " f)) nil)
      (if *LOAD-VERBOSE*
        (progn (princ (strcat "\n>>Loaded " f )) T)
	T
      )
    )
    (ur_exit "Error: (ur:load) without filename! ")
  )
)
;;; erzeugt aus Auswahlsatz eine Elementliste
(defun ur_sslist (a / n lst)
  (if (and a (= (type a) 'PICKSET))
    (repeat (setq n (sslength a))
      (setq n (1- n)
            lst (cons (ssname a n) lst)))))

;;; Bitwert bit in Gruppe 70 von Element _$ele (=Flag) gesetzt?
(defun ur_filter (_$val _$ele)
  (eq (logand (ur_getval 70 _$ele) _$val) _$val))

;;; (UR_SSGET msg)   - ssget mit ssx und msg-prompt
(defun ur_ssget (msg / a)
  (if (and msg (= (type msg) 'STR))
    (prompt msg)
  )
  ;;neu: 07.09.94 V2.8b, ur_varini unterbricht PICKFIRST
  (cond
    (ur:picked
      (setq a ur:picked ur:picked nil)
      (princ " ")(princ (sslength a))(princ " found. ")
      a
    )
    ((and (ur_bitset 1 (getvar "PICKFIRST"))
                (setq a (ssget "_I")))
      (princ " ")(princ (sslength a))(princ " found. ")
      a
    )
    ((princ "\nSelect objects/SSX with ENTER: ")
      (if (setq a (ssget))
        a
        ;;(ssx)
        (c:filter)
))))
;;; Bitwert bit in _$flag gesetzt?
;;; zB: Bitwert 4 (=2.Bit) in 12 (=4+8) ist gesetzt
(defun ur_bitset (_$val _$flag)
  (eq (logand _$val _$flag) _$val))

;;;returns valid program extensions for each version
;;; (without unix), .lkv is my kelvinated format
;;;<=R12-Dos Bi4 lsp exp exe
;;;  R12-Win lsp exe
;;;  R13-Dos lsp exp exe
;;;  R13-Win lsp exe
(defun ur_mlspext (/ win r13)
  (setq win (wcmatch (getvar "PLATFORM") "*Windows*"))	;Win 3.x or NT
  (setq r13 (>= (atoi (getvar "ACADVER")) 13))
  (cond
    ((and r13 win) '("LSP" "ARX" "EXE"))
    (r13 '("LSP" "EXP" "ARX" "EXE"))
    (win '("LSP" "LKV" "EXE"))
    (T   '("BI4" "LKV" "LSP" "EXP" "EXE"))))

;;; gib ENAME von Element b zurck
;;; b kann sein: (entget) Liste, (entsel) Liste oder 'ENAME
(defun ur_entity (b)
  (ur_entname b))

(defun ur_entname (b / e tmp)
  (if (= (type b) 'SYM) (setq tmp b b (eval tmp)))
  (setq b
    (cond
      ((= (type b) 'ENAME) b)                     ; ENAME
      ((not (listp b)) nil)                       ; Fehler, keine Liste
      ((= (type (car b)) 'ENAME) (car b))         ; aus (entsel) Liste
      ((cdr (assoc -1 b)))                ; aus (entget) Liste oder nil
    )
  )
  (if tmp (set tmp b) b)
)

'(DOOM UTILITY functions loaded)
