// Class implementations
//
// DoomEd version 4.x
// from Windows program builder 1.0 (WinBuild)
// Copyright  1995 by Geoff Allan
// All Rights Reserved. No part of this source code may be distributed.

#include "DoomEd40.hpp"
#include <ctype.h>

//////////////////////////////////////////////////////////////////////////////
// Array:
//
// A class which dynamically allocates, deallocates, and generally keeps
// track of any data type, including structures.
//////////////////////////////////////////////////////////////////////////////

Array::Array(int RecSize, BOOL IsDynamic, int ToAlloc) :
               m_RecordSize(RecSize),
               m_Dynamic(IsDynamic),
               m_Allocate(ToAlloc)
{
  // set up the initial array data:
  m_hData      = GlobalAlloc(GHND, (DWORD)m_Allocate * (DWORD)sizeof(void FAR *));
  m_Data       = (void FAR **)GlobalLock(m_hData);
  // note: m_Data is a pointer to an array of pointers; hence the **
  // set tracking variables:
  m_MaxEntries = m_Allocate;
  m_TotalUsed  = 0;
}

Array::~Array(void)
{
  // clear out any data still in array:
  for(int i = 0; i < m_MaxEntries; i++)
    if(m_Data[i]) {
      delete (void FAR *)m_Data[i];
      m_Data[i] = NULL;
      }
  // unlock and free the global memory:
  GlobalUnlock(m_hData);
  GlobalFree(m_hData);
}

BOOL Array::ReSize(int Records)    // reallocate # of records
{
  if(Records == 0) {    // completely start over
    for(int i = 0; i < m_MaxEntries; i++)
      if(m_Data[i]) {
        delete (void FAR *)m_Data[i];
        m_Data[i] = NULL;
        }
    GlobalUnlock(m_hData);
    GlobalFree(m_hData);
    m_hData      = GlobalAlloc(GHND, (DWORD)m_Allocate * (DWORD)sizeof(void FAR *));
    m_Data       = (void FAR **)GlobalLock(m_hData);
    m_MaxEntries = m_Allocate;
    m_TotalUsed  = 0;
    m_MaxUsed    = 0;
    return TRUE;
    }
  if(Records < m_MaxEntries) {
    // destroy existing data and reallocate new space:
    // NOTE: reallocation to a smaller size causes a bug in MS-c products.
    // Thus, do not resize to a smaller size except when you want to
    // clear all of the old data.
    for(int i = 0; i < m_MaxEntries; i++)
      if(m_Data[i]) {
        delete (void FAR *)m_Data[i];
        m_Data[i] = NULL;
        }
    GlobalUnlock(m_hData);
    GlobalFree(m_hData);
    m_hData      = GlobalAlloc(GHND, (DWORD)Records * (DWORD)sizeof(void FAR *));
    if(!m_hData) return FALSE;
    m_Data       = (void FAR **)GlobalLock(m_hData);
    m_MaxEntries = Records;
    return TRUE;
    }
  // expand existing allocation:
  GlobalUnlock(m_hData);
  m_hData      = GlobalReAlloc(m_hData, (DWORD)Records * (DWORD)sizeof(void FAR *),
                               GMEM_ZEROINIT);
  if(!m_hData) return FALSE;
  m_Data       = (void FAR **)GlobalLock(m_hData);
  m_MaxEntries = Records;
  return TRUE;
}

int Array::New(void)
{
  int   i;
  for(i = 0; i < m_MaxEntries; i++)
    if(!m_Data[i]) {
      m_MaxUsed = max(m_MaxUsed, (i + 1));
      m_TotalUsed++;
      m_Data[i] = (void FAR *)new FAR BYTE[m_RecordSize];
      _fmemset(m_Data[i], 0, m_RecordSize);   // fill with nulls
      return i;
      }
  // all used up. Add some more:
  i = m_MaxEntries;   // this will be the new record
  ReSize(m_MaxEntries + m_Allocate);
  m_MaxUsed = max(m_MaxUsed, (i + 1));
  m_TotalUsed++;
  m_Data[i] = new FAR BYTE[m_RecordSize];
  _fmemset(m_Data[i], 0, m_RecordSize);
  return i;
}

void Array::Del(int Record, BOOL Shrink)
{
  delete (void FAR *)m_Data[Record];
  m_Data[Record] = NULL;
  m_TotalUsed--;
}

// note: these routines (Save, Load) do not guarantee the positional integrity.
//       A preprocessing routine may be required for applications which depend
//       on persistence of the position of records.

void Array::Save(HFILE hf)
{
  // assumptions: file has been validated, the current position is
  // the data chunk for Array data.
  int   i;
  _lwrite(hf, &m_TotalUsed, sizeof(int));   // write number of records
  for(i = 0; i < m_MaxUsed; i++)
    if(m_Data[i])                           // if valid data
      _lwrite(hf, m_Data[i], m_RecordSize); // write record
}

void Array::Load(HFILE hf)
{
  int   i;
  Flush();                                  // clear old data
  _lread(hf, &i, sizeof(int));              // get number of records
  ReSize(i);                                // allocate pointers
  m_TotalUsed = i;                          // set Total Used
  for(i = 0; i < m_MaxUsed; i++) {
    m_Data[i] = new FAR BYTE[m_RecordSize]; // allocate memory
    _lread(hf, m_Data[i], m_RecordSize);    // read record
    }
}

//////////////////////////////////////////////////////////////////////////////
//  User classes:
//////////////////////////////////////////////////////////////////////////////

