// Directory of Wad file for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"
#include <io.h>
#include <toolhelp.h>

void ClearProblems(void);

// This is the main edit dialog for wad files.
// You can view, add, edit, delete, and replace lumps
// that are in the loaded wad file.

// prototypes:
BOOL FAR PASCAL NotifyGraphics (WORD wID, DWORD dwData);
void AddMap(int which, char *mapname);
void InsertLump(int where, int which, char *filename);
void DeleteLump(int where, int which);
void ExportLump(int where, int which, char *filename);
void ReplaceLump(int where, int which, char *filename);
void ExportMapForBuild(int where, int which, char *filename);
void PurgeWad(void);
void PlaySound(char *name);
void WriteSound(char *name, char *filename);
void ReplaceSound(int which, char *filename);
void InsertSound(int which, char *filename);
void CoreName(char *filename, char *corename);
int EXPORT StubDlgProc(HWND hDlg,
                       WORD wMsg,
                       WORD wParam,
                       DWORD lParam);
static HWND     theDialog = NULL;   
static char     ChunkName[10];      // the actual (not file) name of this chunk
static BOOL     KeepOldChunkName = FALSE;   // use the current chunk name (don't calc)

#define PM_GRAPHICS     (WM_USER + 100)
#define PM_ANSI         (WM_USER + 101)
#define PM_SOUND        (WM_USER + 102)
#define PM_MUSIC        (WM_USER + 103)
#define PM_NODES        (WM_USER + 104)

void DoDirectory(void)
{
  FARPROC lpfnDlgProc;
  lpfnDlgProc = MakeProcInstance((FARPROC)DialogDirectory, hinst);
  if(lpfnDlgProc) {
    DialogBox(hinst,
              MAKEINTRESOURCE(IDD_DIRECTORY),
              hwnd,
              lpfnDlgProc);
    FreeProcInstance(lpfnDlgProc);
    }
}

HWND        hList1, hFileSize, hUsed, hDiff, hEdit;
int         WadEntry;

int EXPORT DialogDirectory(HWND hDlg,
                           WORD wMsg,
                           WORD wParam,
                           DWORD lParam)
{
  int   i, j;
  int   lpTabs[3] = {60, 105, 150}; // tab positions for listbox
  char  szTemp[144];

  switch(wMsg)
    {
    case WM_INITDIALOG:
      theDialog = hDlg;
      // make a nice title:
      wsprintf(szTemp, "Contents of %s", szPrevFile1);
      SendMessage(hDlg, WM_SETTEXT, 0,(LPARAM)(LPCSTR)szTemp);
      
      hList1    = GetDlgItem(hDlg, IDC_DIRECTORYLIST);
      hFileSize = GetDlgItem(hDlg, IDC_DIR_FILESIZE);
      hUsed     = GetDlgItem(hDlg, IDC_DIR_USED);
      hDiff     = GetDlgItem(hDlg, IDC_DIR_DIFF);
      hEdit     = GetDlgItem(hDlg, IDC_DIR_EDIT);
      wsprintf(szTemp, "%lu", WadSize);
      Static_SetText(hFileSize, szTemp);
      wsprintf(szTemp, "%lu", WadUsed);
      Static_SetText(hUsed, szTemp);
      wsprintf(szTemp, "%lu", (WadSize - WadUsed));
      Static_SetText(hDiff, szTemp);
      if(WadSize - WadUsed)
        Button_Enable(GetDlgItem(hDlg, IDC_DIR_PURGE), TRUE);
      WadEntry  = Nothing;
      Button_Enable(hEdit, FALSE);
      Button_Enable(GetDlgItem(hDlg, IDC_DIR_DELETE), FALSE);
      Button_Enable(GetDlgItem(hDlg, IDC_DIR_REPLACE), FALSE);
      Button_Enable(GetDlgItem(hDlg, IDC_DIR_EXPORT), FALSE);
      ListBox_ResetContent(hList1);
      ListBox_SetTabStops(hList1, 3, lpTabs);
      for(i=0; i < DirEntries; i++) {
        if((Dir[i].Type != WD_THINGS) &&
           (Dir[i].Type != WD_LINEDEFS) &&
           (Dir[i].Type != WD_SIDEDEFS) &&
           (Dir[i].Type != WD_VERTEXES) &&
           (Dir[i].Type != WD_SEGS) &&
           (Dir[i].Type != WD_SSECTORS) &&
           (Dir[i].Type != WD_NODES) &&
           (Dir[i].Type != WD_SECTORS) &&
           (Dir[i].Type != WD_REJECT) &&
           (Dir[i].Type != WD_BLOCKMAP) &&
           (Dir[i].Type != WD_TAG)) {
          strcpy(szTemp, Dir[i].Title);
          strcat(szTemp, "\t");
          switch(Dir[i].Type) {
            case WD_ID:
              strcat(szTemp, "<= Label");
              break;
            case WD_SPRITE:
              strcat(szTemp, "<= Sprite");
              break;
            case WD_PANEL:
              strcat(szTemp, "<= Panel");
              break;
            case WD_TILE:
              strcat(szTemp, "<= Tile");
              break;
            case WD_MUSIC:
              strcat(szTemp, "<= Music");
              break;
            case WD_SOUND:
              strcat(szTemp, "<= Sound");
              break;
            case WD_BEEP:
              strcat(szTemp, "<= Beep");
              break;
            case WD_TEXTURE:
              strcat(szTemp, "<= Texture");
              break;
            case WD_PLAYPAL:
              strcat(szTemp, "<= Playpal");
              break;
            case WD_COLORMAP:
              strcat(szTemp, "<= ColorMap");
              break;
            case WD_ENDOOM:
              strcat(szTemp, "<= Endoom");
              break;
            case WD_DEMO:
              strcat(szTemp, "<= Demo");
              break;
            case WD_PNAMES:
              strcat(szTemp, "<= PNames");
              break;
            case WD_DRIVER:
              strcat(szTemp, "<= Driver");
              break;
            case WD_STATUS:
              strcat(szTemp, "<= Status");
              break;
            case WD_LEVEL:
              strcat(szTemp, "<= Level");
              break;
            case WD_MENU:
              strcat(szTemp, "<= Menu");
              break;
            case WD_GRAPHIC:
              strcat(szTemp, "<= Graphic");
              break;
            case WD_MAP:
              strcat(szTemp, "<= Map");
              break;
            default:
              break;
            }
          j = ListBox_AddString(hList1, szTemp);
          // store Which item# is associated with the list entry
          ListBox_SetItemData(hList1, j, i);
          }     // endif (not map contents)
        }       // next i
      ListBox_SetCurSel(hList1, Nothing);
      return TRUE;
      break;

    case WM_COMMAND:
      switch (wParam) {
        case IDC_DIR_PURGE:
          if((DirEntries > 100) &&
             (MessageBox(hDlg, "This could take a while...\n"
                               "Are you sure you want to Purge?",
                               ProgName, MB_ICONQUESTION | MB_YESNO) == IDNO)) {
            return FALSE;
            break;
            }
          PurgeWad();
          wsprintf(szTemp, "%lu", WadSize);
          Static_SetText(hFileSize, szTemp);
          wsprintf(szTemp, "%lu", WadUsed);
          Static_SetText(hUsed, szTemp);
          wsprintf(szTemp, "%lu", (WadSize - WadUsed));
          Static_SetText(hDiff, szTemp);
          Button_Enable(GetDlgItem(hDlg, IDC_DIR_PURGE), FALSE);
          return FALSE;
          break;
        
        case IDC_DIR_EDIT: // or Play sound:
          switch(Dir[WadEntry].Type) {
            case WD_MAP:
              ReadMap(DD_EXTERNAL, WadEntry);
              strncpy(szMapName, Dir[WadEntry].Title, 8);
              MapEntry = WadEntry;
              BottomMapName(szMapName);
              EnableControlBarItems();
              EndDialog(hDlg, IDOK);
              RepaintMap();
              return TRUE;
              break;
            case WD_ID:
              DoLabel(hDlg, WadEntry);
              strcpy(szTemp, Dir[WadEntry].Title);
              strcat(szTemp, "\t<= Label");
              i = ListBox_GetCurSel(hList1);
              ListBox_DeleteString(hList1, i);
              j = ListBox_InsertString(hList1, i, szTemp);
              ListBox_SetItemData(hList1, j, WadEntry);
              ListBox_SetCurSel(hList1, j);
              return TRUE;
              break;
            case WD_SOUND:
              PlaySound(Dir[WadEntry].Title);
              return FALSE;
              break;
            default:
              break;
            }
          return FALSE;
          break;
        case IDC_DIR_ADD:
          {
          DoWhatToAdd();
          if(lpszMessage[0] != '\0') {
            AnsiUpper(lpszMessage);
            AddMap(WadEntry, lpszMessage);
            // reload the wad file
            LoadWad(szPrevFile1);
            // update data
            SendMessage(hDlg, WM_INITDIALOG, NULL, NULL);
            }   // endif not null
          }
          return TRUE;
          break;

        case IDC_DIR_DELETE:
          wsprintf(szTemp, "Are you sure you want to Remove\n"
                           "the item \"%s\"?", Dir[WadEntry].Title);
          if(MessageBox(hDlg, szTemp, ProgName,
                        MB_ICONQUESTION | MB_YESNO) == IDYES) {
            DeleteLump(DD_EXTERNAL, WadEntry);
            // reload the wad file
            LoadWad(szPrevFile1);
            // update data
            SendMessage(hDlg, WM_INITDIALOG, NULL, NULL);
            }
          return FALSE;
          break;

        case IDC_DIR_RENAME:
          DoLabel(hDlg, WadEntry);
          strcpy(szTemp, Dir[WadEntry].Title);
          strcat(szTemp, "\t");
          switch(Dir[WadEntry].Type) {
            case WD_ID:
              strcat(szTemp, "<= Label");
              break;
            case WD_SPRITE:
              strcat(szTemp, "<= Sprite");
              break;
            case WD_PANEL:
              strcat(szTemp, "<= Panel");
              break;
            case WD_TILE:
              strcat(szTemp, "<= Tile");
              break;
            case WD_MUSIC:
              strcat(szTemp, "<= Music");
              break;
            case WD_SOUND:
              strcat(szTemp, "<= Sound");
              break;
            case WD_BEEP:
              strcat(szTemp, "<= Beep");
              break;
            case WD_TEXTURE:
              strcat(szTemp, "<= Texture");
              break;
            case WD_PLAYPAL:
              strcat(szTemp, "<= Playpal");
              break;
            case WD_COLORMAP:
              strcat(szTemp, "<= ColorMap");
              break;
            case WD_ENDOOM:
              strcat(szTemp, "<= Endoom");
              break;
            case WD_DEMO:
              strcat(szTemp, "<= Demo");
              break;
            case WD_PNAMES:
              strcat(szTemp, "<= PNames");
              break;
            case WD_DRIVER:
              strcat(szTemp, "<= Driver");
              break;
            case WD_STATUS:
              strcat(szTemp, "<= Status");
              break;
            case WD_LEVEL:
              strcat(szTemp, "<= Level");
              break;
            case WD_MENU:
              strcat(szTemp, "<= Menu");
              break;
            case WD_GRAPHIC:
              strcat(szTemp, "<= Graphic");
              break;
            case WD_MAP:
              strcat(szTemp, "<= Map");
              break;
            default:
              break;
            }
          i = ListBox_GetCurSel(hList1);
          ListBox_DeleteString(hList1, i);
          j = ListBox_InsertString(hList1, i, szTemp);
          ListBox_SetItemData(hList1, j, WadEntry);
          ListBox_SetCurSel(hList1, j);
          return FALSE;
          break;

        case IDC_DIR_INSERT:
          {
            OPENFILENAME    ofn;
            UINT            cbString;
            int             chReplace;
            char            szDirName[128], szFilter[128];
    
            if(szExportDir[0]=='\0')            
              strcpy(szDirName, "C:\\");
            else
              strcpy(szDirName, szExportDir);
            
            cbString = LoadString(hinst, IDS_FILTER_IMPORTS,
                                  szFilter, sizeof(szFilter));
            chReplace=szFilter[cbString-1];
            for(j = 0; szFilter[j] != '\0'; j++)
              if(szFilter[j] == chReplace)
                szFilter[j] = '\0';
            memset(&ofn, 0, sizeof(OPENFILENAME));
            strcpy(szExportFile, "");
            ofn.lStructSize     = sizeof(OPENFILENAME);
            ofn.hwndOwner       = hDlg;
            ofn.lpstrFilter     = szFilter;
            ofn.lpstrFile       = szExportFile;
            ofn.nMaxFile        = sizeof(szExportFile);
            ofn.lpstrInitialDir = szDirName;
            ofn.lpstrTitle      = "Select File to Insert";
            ofn.Flags = OFN_FILEMUSTEXIST;
            if(GetOpenFileName(&ofn)) {
              BOOL  SomethingSpecial = FALSE;
              AnsiUpper(ofn.lpstrFile);
              // insert in FRONT of this entry (or at end if Nothing)
              if(strncmp(&ofn.lpstrFile[strlen(ofn.lpstrFile) - 3],
                 "WAV", 3) == 0) {
                InsertSound(WadEntry, ofn.lpstrFile);
                SomethingSpecial = TRUE;
                }
              if(strncmp(&ofn.lpstrFile[strlen(ofn.lpstrFile) - 3],
                 "BIN", 3) == 0) {
                InsertLump(DD_EXTERNAL, WadEntry, ofn.lpstrFile);
                SomethingSpecial = TRUE;
                }
              if(!SomethingSpecial)
                InsertLump(DD_EXTERNAL, WadEntry, ofn.lpstrFile);
              // reload the wad file
              LoadWad(szPrevFile1);
              // update data
              SendMessage(hDlg, WM_INITDIALOG, NULL, NULL);
              }
          }
          return FALSE;
          break;

        case IDC_DIR_REPLACE:
          {
            OPENFILENAME    ofn;
            UINT            cbString;
            int             chReplace;
            char            szDirName[128], szFilter[128];
              
            if(szExportDir[0]=='\0')            
              strcpy(szDirName, "C:\\");
            else
              strcpy(szDirName, szExportDir);
            
            cbString = LoadString(hinst, IDS_FILTER_IMPORTS,
                                  szFilter, sizeof(szFilter));
            chReplace=szFilter[cbString-1];
            for(j = 0; szFilter[j] != '\0'; j++)
              if(szFilter[j] == chReplace)
                szFilter[j] = '\0';
            memset(&ofn, 0, sizeof(OPENFILENAME));
            strcpy(szExportFile, Dir[WadEntry].Title);
            ofn.lStructSize = sizeof(OPENFILENAME);
            ofn.hwndOwner = hDlg;
            ofn.lpstrFilter = szFilter;
            ofn.lpstrFile = szExportFile;
            ofn.nMaxFile = sizeof(szExportFile);
            ofn.lpstrInitialDir = szDirName;
            ofn.lpstrTitle = "Select File for Replace";
            ofn.Flags = OFN_FILEMUSTEXIST;
            if(GetOpenFileName(&ofn)) {
              BOOL  SomethingSpecial = FALSE;
              AnsiUpper(ofn.lpstrFile);
              if(strncmp(&ofn.lpstrFile[strlen(ofn.lpstrFile) - 3],
                 "WAV", 3) == 0) {
                ReplaceSound(WadEntry, ofn.lpstrFile);
                SomethingSpecial = TRUE;
                }
              if(!SomethingSpecial)
                ReplaceLump(DD_EXTERNAL, WadEntry, ofn.lpstrFile);
              // reload the wad file
              LoadWad(szPrevFile1);
              // update data
              SendMessage(hDlg, WM_INITDIALOG, NULL, NULL);
              }
          }
          return FALSE;
          break;

        case IDC_DIR_EXPORT:
          {
            OPENFILENAME    ofn;
            UINT            cbString;
            int             chReplace;
            char            szDirName[128], szFilter[128];
            
            if(szExportDir[0]=='\0')            
              strcpy(szDirName, "C:\\");
            else
              strcpy(szDirName, szExportDir);
            cbString = LoadString(hinst, IDS_FILTER_CHUNK,
                                  szFilter, sizeof(szFilter));
            if((Dir[WadEntry].Type == WD_SPRITE)  ||
               (Dir[WadEntry].Type == WD_PANEL)   ||
               (Dir[WadEntry].Type == WD_LEVEL)   ||
               (Dir[WadEntry].Type == WD_STATUS)  ||
               (Dir[WadEntry].Type == WD_MENU)    ||
               (Dir[WadEntry].Type == WD_GRAPHIC) ||
               (Dir[WadEntry].Type == WD_TILE))
              cbString = LoadString(hinst, IDS_FILTER_EXPORTGRAPHICS,
                                    szFilter, sizeof(szFilter));
            if(Dir[WadEntry].Type == WD_ENDOOM)
              cbString = LoadString(hinst, IDS_FILTER_EXPORTENDOOM,
                                    szFilter, sizeof(szFilter));
            if(Dir[WadEntry].Type == WD_SOUND)
              cbString = LoadString(hinst, IDS_FILTER_EXPORTSOUNDS,
                                    szFilter, sizeof(szFilter));
            chReplace=szFilter[cbString-1];
            for(j = 0; szFilter[j] != '\0'; j++)
              if(szFilter[j] == chReplace)
                szFilter[j] = '\0';
            memset(&ofn, 0, sizeof(OPENFILENAME));
            strcpy(szExportFile, Dir[WadEntry].Title);
            if((Dir[WadEntry].Type == WD_SPRITE)  ||
               (Dir[WadEntry].Type == WD_PANEL)   ||
               (Dir[WadEntry].Type == WD_LEVEL)   ||
               (Dir[WadEntry].Type == WD_STATUS)  ||
               (Dir[WadEntry].Type == WD_MENU)    ||
               (Dir[WadEntry].Type == WD_GRAPHIC) ||
               (Dir[WadEntry].Type == WD_TILE))
              strcat(szExportFile, ".bmp");
            if(Dir[WadEntry].Type == WD_ENDOOM)
              strcat(szExportFile, ".bin");
            if(Dir[WadEntry].Type == WD_SOUND)
              strcat(szExportFile, ".wav");
            ofn.lStructSize = sizeof(OPENFILENAME);
            ofn.hwndOwner = hwnd;
            ofn.lpstrFilter = szFilter;
            ofn.lpstrFile = szExportFile;
            ofn.nMaxFile = sizeof(szExportFile);
            ofn.lpstrInitialDir = szDirName;
            ofn.lpstrTitle = "Select Filename for Export";
            ofn.Flags = OFN_OVERWRITEPROMPT;
            if(GetSaveFileName(&ofn)) {
              BOOL  SomethingSpecial = FALSE;
              AnsiUpper(ofn.lpstrFile);
              if((Dir[WadEntry].Type == WD_SPRITE)  ||
                 (Dir[WadEntry].Type == WD_PANEL)   ||
                 (Dir[WadEntry].Type == WD_LEVEL)   ||
                 (Dir[WadEntry].Type == WD_STATUS)  ||
                 (Dir[WadEntry].Type == WD_MENU)    ||
                 (Dir[WadEntry].Type == WD_GRAPHIC) ||
                 (Dir[WadEntry].Type == WD_TILE))
                if(strncmp(&ofn.lpstrFile[strlen(ofn.lpstrFile) - 3],
                   "BMP", 3) == 0) {
                  ReadGraphic(DD_EXTERNAL, WadEntry);
                  SaveBmp(hBitmap, ofn.lpstrFile);
                  SomethingSpecial = TRUE;
                  }
              if(Dir[WadEntry].Type == WD_ENDOOM)
                if(strncmp(&ofn.lpstrFile[strlen(ofn.lpstrFile) - 3],
                   "BIN", 3) == 0) {
                  SaveLump(DD_EXTERNAL, WadEntry, ofn.lpstrFile);
                  SomethingSpecial = TRUE;
                  }
              if(Dir[WadEntry].Type == WD_SOUND)
                if(strncmp(&ofn.lpstrFile[strlen(ofn.lpstrFile) - 3],
                   "WAV", 3) == 0) {
                  WriteSound(Dir[WadEntry].Title, ofn.lpstrFile);
                  SomethingSpecial = TRUE;
                  }
              if(!SomethingSpecial)
                ExportLump(DD_INTERNAL, WadEntry, ofn.lpstrFile);
              }
          }
          return FALSE;
          break;
        case IDOK:              // OK button
          EndDialog(hDlg, IDOK);
          return TRUE;
          break;
        case IDC_DIRECTORYLIST:
          switch(HIWORD(lParam)) {
            case LBN_DBLCLK:
              // "edit" is the default double click action
              SendMessage(hDlg, WM_COMMAND, IDC_DIR_EDIT, 0L);
              return TRUE;
              break;
            case LBN_SELCHANGE:
              // single click OR first click of double click:
              WadEntry = (int)ListBox_GetItemData(hList1,
                              ListBox_GetCurSel(hList1));
              Button_Enable(GetDlgItem(hDlg, IDC_DIR_DELETE), TRUE);
              Button_Enable(GetDlgItem(hDlg, IDC_DIR_REPLACE), TRUE);
              Button_Enable(GetDlgItem(hDlg, IDC_DIR_EXPORT), TRUE);
              Button_Enable(GetDlgItem(hDlg, IDC_DIR_RENAME), TRUE);
              if(Dir[WadEntry].Type == WD_SOUND) {
                Button_SetText(hEdit, "Play");
                Button_Enable(GetDlgItem(hDlg, IDC_DIR_EDIT), TRUE);
                }
              else if(Dir[WadEntry].Type == WD_MAP) {
                Button_SetText(hEdit, "Edit...");
                Button_Enable(GetDlgItem(hDlg, IDC_DIR_EDIT), TRUE);
                }
              else {
                Button_SetText(hEdit, "Edit...");
                Button_Enable(GetDlgItem(hDlg, IDC_DIR_EDIT), FALSE);
                }
              return TRUE;
              break;

            default:
              return TRUE;
              break;
            }
          return TRUE;
          break;
        default:
          return FALSE;
          break;
        }
      
    default:
      return FALSE;
    }
}

void PlaySound(char *name)
{
  int       where = DD_EXTERNAL, which;
  char      szFileSpec[144];
  char      szSource[128];
  WadSound  wsh;
  WavSound  wav;
  HFILE     WadFile, hOutFile;
  HGLOBAL   hglb;
  BYTE    __huge *sBuf;         // sound buffer
  OFSTRUCT  ofOutFile;          // output file info
          
  strcpy(szSource, szPrevFile1);
  if((which = DirEntry(name)) == NotFound) {
    where = DD_INTERNAL;
    strcpy(szSource, szDoomWad);
    if((which = DoomEntry(name)) == NotFound)
      return;
    }
  
  WadFile = _lopen(szSource, OF_READ);   // open wad file
  if(where == DD_INTERNAL)
    _llseek(WadFile, Doom[which].Offset, 0);    // position to data
  else
    _llseek(WadFile, Dir[which].Offset, 0);    // position to data
  _lread(WadFile, &wsh, sizeof(WadSound));
  if(wsh.id != 3) {
    _lclose(WadFile);
    ErrorMessage(IDS_SOUNDINVALID);
    return;
    }

  hglb = GlobalAlloc(GHND, wsh.size);
  sBuf = (BYTE __huge *)GlobalLock(hglb);

  if(where == DD_INTERNAL)
    _llseek(WadFile, Doom[which].Offset + 8, 0);   // position to data
  else
    _llseek(WadFile, Dir[which].Offset + 8, 0);   // position to data
  _hread(WadFile, sBuf, wsh.size);          // suck it into memory
  _lclose(WadFile);                         // close file

  wav.riff = mmioStringToFOURCC("RIFF", 0);
  wav.size = wsh.size + 36;
  wav.wave = mmioStringToFOURCC("WAVE", 0);
  wav.fmt  = mmioStringToFOURCC("fmt ", 0);
  wav.offset = 16L;
  wav.wf.wFormatTag = 1;
  wav.wf.nChannels = 1;
  wav.wf.nSamplesPerSec = (long)wsh.rate;
  wav.wf.nAvgBytesPerSec = (long)wsh.rate;
  wav.wf.nBlockAlign = 1;
  wav.u1 = 8;
  wav.data = mmioStringToFOURCC("data", 0);
  wav.datasize = wsh.size;
  GetTempFileName(0, "wav", 0, szFileSpec);
          
  if(hOutFile = OpenFile(szFileSpec, &ofOutFile, OF_CREATE)){
      _lwrite(hOutFile, &wav, sizeof(WavSound));
      _hwrite(hOutFile, sBuf, wsh.size);
      _lclose(hOutFile);
      GlobalUnlock(hglb);
      GlobalFree(hglb);
      sndPlaySound(szFileSpec, SND_SYNC);
      OpenFile(szFileSpec, &ofOutFile, OF_DELETE);
    }
}

void WriteSound(char *name, char *filename)
{
  int       where = DD_EXTERNAL, which;
  char      szSource[128];
  WadSound  wsh;
  WavSound  wav;
  HFILE     WadFile, hOutFile;
  HGLOBAL   hglb;
  BYTE    __huge *sBuf;         // sound buffer
  OFSTRUCT  ofOutFile;          // output file info
          
  strcpy(szSource, szDoomWad);
  if((which = DirEntry(name)) == NotFound) {
    where = DD_INTERNAL;
    strcpy(szSource, szPrevFile1);
    if((which = DoomEntry(name)) == NotFound)
      return;
    }
  
  WadFile = _lopen(szSource, OF_READ);   // open wad file
  if(where == DD_INTERNAL)
    _llseek(WadFile, Doom[which].Offset, 0);    // position to data
  else
    _llseek(WadFile, Dir[which].Offset, 0);    // position to data
  _lread(WadFile, &wsh, sizeof(WadSound));
  if(wsh.id != 3) {
    _lclose(WadFile);
    ErrorMessage(IDS_SOUNDINVALID);
    return;
    }

  hglb = GlobalAlloc(GHND, wsh.size);
  sBuf = (BYTE __huge *)GlobalLock(hglb);

  if(where == DD_INTERNAL)
    _llseek(WadFile, Doom[which].Offset + 8, 0);   // position to data
  else
    _llseek(WadFile, Dir[which].Offset + 8, 0);   // position to data
  _hread(WadFile, sBuf, wsh.size);          // suck it into memory
  _lclose(WadFile);                         // close file

  wav.riff = mmioStringToFOURCC("RIFF", 0);
  wav.size = wsh.size + 36;
  wav.wave = mmioStringToFOURCC("WAVE", 0);
  wav.fmt  = mmioStringToFOURCC("fmt ", 0);
  wav.offset = 16L;
  wav.wf.wFormatTag = 1;
  wav.wf.nChannels = 1;
  wav.wf.nSamplesPerSec = (long)wsh.rate;
  wav.wf.nAvgBytesPerSec = (long)wsh.rate;
  wav.wf.nBlockAlign = 1;
  wav.u1 = 8;
  wav.data = mmioStringToFOURCC("data", 0);
  wav.datasize = wsh.size;
          
  if(hOutFile = OpenFile(filename, &ofOutFile, OF_CREATE)){
      _lwrite(hOutFile, &wav, sizeof(wav));
      _hwrite(hOutFile, sBuf, wsh.size);
      _lclose(hOutFile);
      GlobalUnlock(hglb);
      GlobalFree(hglb);
    }
}

void SavePending(void)
{
// Something that we called an external editor for has finished.
// The user has verified that it is ok to save changes.
#if defined ( _DEBUG )
  char  szTemp[256];
  
  wsprintf(szTemp, "Pending  type: %i\nPending where: %i\n"
                   "Pending which: %i\nPending  file: %s",
                   Pending.type,
                   Pending.where,
                   Pending.which,
                   Pending.filename);
  MessageBox(hwnd, szTemp, ProgName, MB_ICONINFORMATION | MB_OK);
#endif

  switch(Pending.type) {
    case WD_ENDOOM:
      ReplaceLump(Pending.where, Pending.which, Pending.filename);
      // reload the wad file
      LoadWad(szPrevFile1);
      // update data (if required)
      if(IsWindowVisible(theDialog))
        SendMessage(theDialog, WM_INITDIALOG, NULL, NULL);
      break;
    default:
      ;
      break;
    }
}

void DoMapName(void)
{
  FARPROC lpfnDlgProc;
  lpfnDlgProc = MakeProcInstance((FARPROC)DialogMapName, hinst);
  if(lpfnDlgProc) {
    DialogBox(hinst,
              MAKEINTRESOURCE(IDD_MAPNAME),
              hwnd,
              lpfnDlgProc);
    FreeProcInstance(lpfnDlgProc);
    }
}

static HWND hMapName;

int EXPORT DialogMapName(HWND hDlg,
                         WORD wMsg,
                         WORD wParam,
                         DWORD lParam)
{
  switch(wMsg)
    {
    case WM_INITDIALOG:
      hMapName = GetDlgItem(hDlg, IDC_MAPNAME);
      Edit_SetText(hMapName, szMapName);
      return TRUE;
      break;

    case WM_COMMAND:
      switch (wParam) {
        case IDOK:
          GetDlgItemText(hDlg, IDC_MAPNAME, (LPSTR)szMapName, 8);
          BottomMapName(szMapName);
          EndDialog(hDlg, IDOK);
          return FALSE;
          break;
        case IDCANCEL:
          EndDialog(hDlg, IDOK);
          return FALSE;
          break;
        default:
          return FALSE;
          break;
        }
      
    default:
      return FALSE;
    }
}

void InsertLump(int where, int which, char *filename)
{
  // insert the lump that is now in (filename)
  // into the (where:DD_INTERNAL) wad file,
  // at position (which)
  char      szTemp[16];
  int       i, j;
  long      MaxLen = 0,     // max size for setting buffer
            CurPos = 12,    // offset for writing
            CurLen,         // length of current hunk
            TotalSize;      // total size of what is being added
  long      DirOffset,      // where directory is in our WAD file
            nDirOffset,     // where directory is in miniwad file
            Entries,        // how many entries in miniwad file (if)
            OldEntries;     // how many entries were in the WAD file
  OFSTRUCT  ff;             // openfile structure
  HFILE     WadFile,        // file handles
            ChunkFile;
  HGLOBAL   hglbBuf;            // global handle to data buffer
  unsigned  char __huge *fbuf;  // data buffer
  HGLOBAL   hglbDir;            // global handle to data buffer
  WadDir   *nDir;               // miniwad directory

  if(SharewareVersion) {
    ErrorMessage(IDS_SHAREWARE);
    return;
    }

  // get the lump name
  if(!KeepOldChunkName)
    CoreName(filename, ChunkName);

  // open the files
  WadFile = OpenFile(szPrevFile1, &ff, OF_READWRITE);
  ChunkFile = _lopen(filename, READ);
  // get critical information from our Wad file:
  _llseek(WadFile, 4L, 0);          // seek to location
  _lread(WadFile, &OldEntries, 4);  // find out how many there are
  _llseek(WadFile, 8L, 0);          // offset to directory (paranoia)
  _lread(WadFile, &DirOffset, 4);   // where directory is now
  CurPos = DirOffset;               // location to add new hunk(s)

  // first, determine if this is a PWAD (or IWAD) file:
  szTemp[4] = '\0';
  _llseek(ChunkFile, 0L, 0);
  _lread(ChunkFile, &szTemp, 4);
  if((strcmp(szTemp, "IWAD") == 0) ||
     (strcmp(szTemp, "PWAD") == 0)) {
    // it IS a PWAD or IWAD file - insert all of the parts:
    _llseek(ChunkFile, 4L, 0);          // seek to correct area
    _lread(ChunkFile, &Entries, 4);     // read the number of entries
    _llseek(ChunkFile, 8L, 0);          // offset to directory
    _lread(ChunkFile, &nDirOffset, 4);  // where directory is
    // allocate the memory for a temporary directory (nDir):
    hglbDir = GlobalAlloc(GMEM_FIXED, (DWORD)Entries * sizeof(WadDir));
    nDir = (WadDir *)GlobalLock(hglbDir);
    // read the directory entries into nDir:
    TotalSize = 0;                      // for keeping track of size
    _llseek(ChunkFile, nDirOffset, 0);  // seek to directory area
    for(i=0; i<Entries; i++) {          // read all directory entries
      _lread(ChunkFile, &nDir[i], 16);  // 16 bytes / record
      nDir[i].Title[8] = '\0';          // null term the title string
      TotalSize += nDir[i].Length;      // count up the bytes
      MaxLen = max(MaxLen, nDir[i].Length);
      }
    // allocate the buffer memory
    hglbBuf = GlobalAlloc(GMEM_FIXED, MaxLen);
    fbuf = (unsigned char __huge *)GlobalLock(hglbBuf);
    // perform correct action:
    if(which == Nothing) {
      // add to end
      for(i=0; i<Entries; i++) {
        strncpy(Dir[DirEntries].Title, nDir[i].Title, 9);   // include null term
        Dir[DirEntries].Offset = CurPos;
        Dir[DirEntries++].Length = nDir[i].Length;
        if(nDir[i].Length) {
          _llseek(ChunkFile, nDir[i].Offset, 0);
          _hread(ChunkFile, fbuf, nDir[i].Length);
          _llseek(WadFile, CurPos, 0);
          _hwrite(WadFile, fbuf, nDir[i].Length);
          CurPos += nDir[i].Length;
          }     // endif Length > 0
        }       // next i
      }         // endif which == nothing
    else {
      // insert at start or middle
      DirEntries += (int)Entries;
      for(j = DirEntries; j > which; j--)
        if(j > 11)
          Dir[j] = Dir[j - Entries];
      for(i=0; i<Entries; i++) {
        strncpy(Dir[which + i].Title, nDir[i].Title, 9);   // include null term
        Dir[which + i].Offset = CurPos;
        Dir[which + i].Length = nDir[i].Length;
        if(nDir[i].Length) {
          _llseek(ChunkFile, nDir[i].Offset, 0);
          _hread(ChunkFile, fbuf, nDir[i].Length);
          _llseek(WadFile, CurPos, 0);
          _hwrite(WadFile, fbuf, nDir[i].Length);
          CurPos += nDir[i].Length;
          }     // endif Length > 0
        }       // next i
      }         // endif add in middle
    // free up the nDir memory
    GlobalUnlock(hglbDir);
    GlobalFree(hglbDir);
    DirOffset += TotalSize;
    }           // endif inserting Wad file
  else {
    // single content file with no wad directory:
    MaxLen = _filelength(ChunkFile);
    CurLen = _filelength(ChunkFile);
    DirOffset = CurPos + CurLen;
    _llseek(WadFile, 8L, 0);
    _lwrite(WadFile, &DirOffset, 4); // new location of directory
    // allocate the buffer memory
    hglbBuf = GlobalAlloc(GMEM_FIXED, CurLen);
    fbuf = (unsigned char __huge *)GlobalLock(hglbBuf);
    _llseek(ChunkFile, 0L, 0);         // seek to start
    _hread(ChunkFile, fbuf, CurLen);   // read it
    _llseek(WadFile, CurPos, 0);     // seek to what was the directory
    _hwrite(WadFile, fbuf, CurLen);  // write it
    // doctor up the Dir listing:
    if(which == Nothing) {
      // add to end
      strncpy(Dir[DirEntries].Title, ChunkName, 9);
      Dir[DirEntries].Offset = CurPos;
      Dir[DirEntries++].Length = CurLen;
      }         // endif add to end
    else {
      // add at the start or middle
      DirEntries++;
      for(j = DirEntries; j > which; j--)
        Dir[j] = Dir[j - 1];
      strncpy(Dir[which].Title, ChunkName, 9);
      Dir[which].Offset = CurPos;
      Dir[which].Length = CurLen;
      }         // endif at in middle
    // free up the buffer memory
    GlobalUnlock(hglbBuf);
    GlobalFree(hglbBuf);
    }           // endif single content chunk
    
  OldEntries = DirEntries;
  _llseek(WadFile, 4L, 0);          // seek to entries
  _lwrite(WadFile, &OldEntries, 4); // write how many there are
  _llseek(WadFile, 8L, 0);          // seek to dir offset
  _lwrite(WadFile, &DirOffset, 4);  // write directory location
  _llseek(WadFile, DirOffset, 0);   // seek to what is now the directory
  for(i=0; i<DirEntries; i++)       // now write directory
    _lwrite(WadFile, &Dir[i], 16);  // first 16 bytes of each record
  // close both files
  _lclose(ChunkFile);
  _lclose(WadFile);
  return;
}

void DeleteLump(int where, int which)
{
  int       i, j, Entries = 1;
  long      DirOffset,      // where directory is in our WAD file
            OldEntries;
  OFSTRUCT  ff;             // openfile structure
  HFILE     WadFile;        // file handles

  if(SharewareVersion) {
    ErrorMessage(IDS_SHAREWARE);
    return;
    }

  WadFile = OpenFile(szPrevFile1, &ff, OF_READWRITE);

  _llseek(WadFile, 8L, 0);          // offset to directory (paranoia)
  _lread(WadFile, &DirOffset, 4);   // where directory is now

  if(Dir[which].Type == WD_MAP)
    for(i = which + 1; i < which + 12; i++) 
      if((Dir[i].Type != WD_THINGS) &&
         (Dir[i].Type != WD_LINEDEFS) &&
         (Dir[i].Type != WD_SIDEDEFS) &&
         (Dir[i].Type != WD_VERTEXES) &&
         (Dir[i].Type != WD_SEGS) &&
         (Dir[i].Type != WD_SSECTORS) &&
         (Dir[i].Type != WD_NODES) &&
         (Dir[i].Type != WD_SECTORS) &&
         (Dir[i].Type != WD_REJECT) &&
         (Dir[i].Type != WD_BLOCKMAP) &&
         (Dir[i].Type != WD_TAG))
        break;
      else
        Entries++;

  DirEntries -= Entries;

  for(j = which; j < DirEntries; j++)
    Dir[j] = Dir[j + Entries];
    
  OldEntries = DirEntries;
  _llseek(WadFile, 4L, 0);
  _lwrite(WadFile, &OldEntries, 4); // write how many there are
  _llseek(WadFile, 8L, 0);
  _lwrite(WadFile, &DirOffset, 4);  // write directory location

  _llseek(WadFile, DirOffset, 0);
  for(i=0; i<DirEntries; i++)
    _lwrite(WadFile, &Dir[i], 16);

  _lclose(WadFile);
}

void ExportLump(int where, int which, char *filename)
{

  int       i, j, Entries = 1;
  long      MaxLen = 0, CurPos = 12, DirOffset, OldEntries;
  HFILE     WadFile, ChunkFile;
  WadDir    nDir[16];           // miniwad directory
  char      pwad[5] = "PWAD";
  HGLOBAL   hglbBuf;            // global handle to data buffer
  unsigned  char __huge *fbuf;  // data buffer
  OFSTRUCT  ff;                 // openfile structure
  
  WadFile = _lopen(szPrevFile1, READ);

  if(Dir[which].Type == WD_MAP) {
    nDir[0] = Dir[which];
    for(i = which + 1; i < which + 12; i++)
      if((Dir[i].Type != WD_THINGS) &&
         (Dir[i].Type != WD_LINEDEFS) &&
         (Dir[i].Type != WD_SIDEDEFS) &&
         (Dir[i].Type != WD_VERTEXES) &&
         (Dir[i].Type != WD_SEGS) &&
         (Dir[i].Type != WD_SSECTORS) &&
         (Dir[i].Type != WD_NODES) &&
         (Dir[i].Type != WD_SECTORS) &&
         (Dir[i].Type != WD_REJECT) &&
         (Dir[i].Type != WD_BLOCKMAP) &&
         (Dir[i].Type != WD_TAG))
        break;
      else {
        nDir[Entries++] = Dir[i];
        MaxLen = max(MaxLen, Dir[i].Length);
        }

    if(ChunkFile = OpenFile(filename, &ff, OF_CREATE)) {
      hglbBuf = GlobalAlloc(GMEM_FIXED, MaxLen);
      fbuf = (unsigned char __huge *)GlobalLock(hglbBuf);
      OldEntries = Entries;
      _lwrite(ChunkFile, &pwad, 4);
      _lwrite(ChunkFile, &OldEntries, 4);
      _lwrite(ChunkFile, &OldEntries, 4);
      for(i = 0, j = which; i < Entries; i++) {
        nDir[i].Offset = CurPos;
        if(Dir[j].Length) {
          _llseek(WadFile, Dir[j].Offset, 0);
          _hread(WadFile, fbuf, Dir[j].Length);
          _hwrite(ChunkFile, fbuf, Dir[j].Length);
          CurPos += Dir[j].Length;
          }     // endif Length > 0
          j++;
        }       // next i
      DirOffset = CurPos;

      for(i = 0; i < Entries; i++)
        _lwrite(ChunkFile, &nDir[i], 16);

      _llseek(ChunkFile, 8L, 0);
      _lwrite(ChunkFile, &DirOffset, 4);  // write directory location
      _lclose(ChunkFile);
      GlobalUnlock(hglbBuf);
      GlobalFree(hglbBuf);
      }         // endif file opened Ok
    }           // endif is map
  else {
    hglbBuf = GlobalAlloc(GMEM_FIXED, Dir[which].Length);
    fbuf = (unsigned char __huge *)GlobalLock(hglbBuf);
    _llseek(WadFile, Dir[which].Offset, 0);
    _hread(WadFile, fbuf, Dir[which].Length);
    _lclose(WadFile);
    if(ChunkFile = OpenFile(filename, &ff, OF_CREATE)) {
      _hwrite(ChunkFile, fbuf, Dir[which].Length);
      _lclose(ChunkFile);
      }
    GlobalUnlock(hglbBuf);
    GlobalFree(hglbBuf);
    }   // endif single object
  _lclose(WadFile);
}

void ReplaceLump(int where, int which, char *filename)
{
  // replace the lump that is now in position "which"
  // with the file "filename"
  int       i, j, Entries = 1;

  if(SharewareVersion) {
    ErrorMessage(IDS_SHAREWARE);
    return;
    }

  // strategy:
  // Delete what WAS there, then call Insert to replace it.
  if(((Dir[which].Title[0] == 'E') &&
      (Dir[which].Title[2] == 'M')) ||
     ((Dir[which].Title[0] == 'M') &&
      (Dir[which].Title[1] == 'A') &&
      (Dir[which].Title[2] == 'P')))
    for(i = which + 1; i < which + 12; i++) 
      if((Dir[i].Type != WD_THINGS) &&
         (Dir[i].Type != WD_LINEDEFS) &&
         (Dir[i].Type != WD_SIDEDEFS) &&
         (Dir[i].Type != WD_VERTEXES) &&
         (Dir[i].Type != WD_SEGS) &&
         (Dir[i].Type != WD_SSECTORS) &&
         (Dir[i].Type != WD_NODES) &&
         (Dir[i].Type != WD_SECTORS) &&
         (Dir[i].Type != WD_REJECT) &&
         (Dir[i].Type != WD_BLOCKMAP) &&
         (Dir[i].Type != WD_ID) &&
         (Dir[i].Type != WD_TAG))
        break;
      else
        Entries++;

  DirEntries -= Entries;    // delete from end.

  for(j = which; j < DirEntries; j++)
    Dir[j] = Dir[j + Entries];
  
  InsertLump(where, which, filename);
  
}

void ExportMapForBuild(int where, int which, char *filename)
{
  // Same as ExportLump, but strips the tagdescs
  int       i, j, Entries = 1;
  long      MaxLen = 0, CurPos = 12, DirOffset, OldEntries;
  HFILE     WadFile, ChunkFile;
  WadDir    nDir[16];           // miniwad directory
  char      pwad[5] = "PWAD";
  HGLOBAL   hglbBuf;            // global handle to data buffer
  unsigned  char __huge *fbuf;  // data buffer
  OFSTRUCT  ff;                 // openfile structure
  
  if(SharewareVersion) {
    ErrorMessage(IDS_SHAREWARE);
    return;
    }

  WadFile = _lopen(szPrevFile1, READ);

  nDir[0] = Dir[which];
  for(i = which + 1; i < which + 12; i++)
    if((Dir[i].Type != WD_THINGS) &&
       (Dir[i].Type != WD_LINEDEFS) &&
       (Dir[i].Type != WD_SIDEDEFS) &&
       (Dir[i].Type != WD_VERTEXES) &&
       (Dir[i].Type != WD_SEGS) &&
       (Dir[i].Type != WD_SSECTORS) &&
       (Dir[i].Type != WD_NODES) &&
       (Dir[i].Type != WD_SECTORS) &&
       (Dir[i].Type != WD_REJECT) &&
       (Dir[i].Type != WD_BLOCKMAP))
      break;
    else {
      nDir[Entries++] = Dir[i];
      MaxLen = max(MaxLen, Dir[i].Length);
      }

  if(ChunkFile = OpenFile(filename, &ff, OF_CREATE)) {
    hglbBuf = GlobalAlloc(GMEM_FIXED, MaxLen);
    fbuf = (unsigned char __huge *)GlobalLock(hglbBuf);
    OldEntries = Entries;
    _lwrite(ChunkFile, &pwad, 4);
    _lwrite(ChunkFile, &OldEntries, 4);
    _lwrite(ChunkFile, &OldEntries, 4);
    for(i = 0, j = which; i < Entries; i++) {
      nDir[i].Offset = CurPos;
      if(Dir[j].Length) {
        _llseek(WadFile, Dir[j].Offset, 0);
        _hread(WadFile, fbuf, Dir[j].Length);
        _hwrite(ChunkFile, fbuf, Dir[j].Length);
        CurPos += Dir[j].Length;
        }     // endif Length > 0
        j++;
      }       // next i
    DirOffset = CurPos;

    for(i = 0; i < Entries; i++)
      _lwrite(ChunkFile, &nDir[i], 16);

    _llseek(ChunkFile, 8L, 0);
    _lwrite(ChunkFile, &DirOffset, 4);  // write directory location
    _lclose(ChunkFile);
    GlobalUnlock(hglbBuf);
    GlobalFree(hglbBuf);
    }         // endif file opened Ok
  _lclose(WadFile);
}

void PurgeWad(void)
{
  // rebuild the wad file according to its directory
  
  char      szBakFileName[128], szTemp[16];
  int       i, j = 0, Percent, OldPercent = 0, ProgWidth;
  long      MaxLen = 0,
            CurPos = 12,
            CurLen;
  OFSTRUCT  ff;
  HFILE     fi,     // file in (.bak file)
            fo;     // file out (.wad file)
  unsigned  char __huge *fbuf;
  HGLOBAL   hglb;
  HWND      hWndDlg, hPercent, hEntry, hEntries;
  FARPROC   lpfnStubDlgProc;
  HDC       rDC;
  RECT      ProgRect;
  HBRUSH    hProgressBrush, hOldBrush;
  HPEN      hProgressPen,   hOldPen;
  
  if(SharewareVersion) {
    ErrorMessage(IDS_SHAREWARE);
    return;
    }

  strcpy(szBakFileName, szPrevFile1);
  for(i = 0; i < 128; i++)
    if(szBakFileName[i] == '.') {
      j = i;
      break;
      }
  if(j) {
    szBakFileName[j+1]='b';
    szBakFileName[j+2]='a';
    szBakFileName[j+3]='k';
    }
  else
    strcat(szBakFileName,".bak");

  // if the backup file exists, delete it.
  if(OpenFile(szBakFileName, &ff, OF_EXIST))
    OpenFile(szBakFileName, &ff, OF_DELETE);

  rename(szPrevFile1, szBakFileName);

  for(i=0; i<DirEntries; i++) // find maximum length
    MaxLen = max(Dir[i].Length, MaxLen);

  hglb = GlobalAlloc(GMEM_FIXED, MaxLen);
  fbuf = (unsigned char __huge *)GlobalLock(hglb);
  
  fi = _lopen(szBakFileName, READ);
  _llseek(fi, 0L, 0);
  _lread(fi, &szTemp, 4);          // signature
  fo = OpenFile(szPrevFile1, &ff, OF_CREATE);
  _lwrite(fo, &szTemp, 4);         // signature
  CurLen = (long)DirEntries;
  _lwrite(fo, &CurLen, 4);          // number of entries
  _lwrite(fo, &CurLen, 4);          // placeholder for dir offset

  hWndDlg = NULL;                   // handle for destroying
  lpfnStubDlgProc = MakeProcInstance((FARPROC) StubDlgProc, hinst);
  if(lpfnStubDlgProc)
    hWndDlg=CreateDialog(hinst,
                         MAKEINTRESOURCE(IDD_UPDATE_STATUS),
                         hwnd,
                         lpfnStubDlgProc);
  // Graphic location:
  ProgRect.top    = 42;
  ProgRect.bottom = 56;
  ProgRect.left   = 11;
  ProgRect.right  = 143;
  MapDialogRect(hWndDlg, &ProgRect);
  ProgRect.top++;
  ProgWidth = ProgRect.right - ProgRect.left;
  hProgressBrush = CreateSolidBrush(ColorMarked);
  hProgressPen   = CreatePen(PS_NULL, NULL, NULL);

  hPercent = GetDlgItem(hWndDlg, IDC_PERCENT);
  hEntry   = GetDlgItem(hWndDlg, IDC_ITEMNUMBER);
  hEntries = GetDlgItem(hWndDlg, IDC_TOTALITEMS);
  
  // display total entries in dialog
  wsprintf(szTemp, "%i", DirEntries);
  Static_SetText(hEntries, szTemp);
  
  for(i=0; i<DirEntries; i++) {
    // display current entry in dialog
    wsprintf(szTemp, "%i", (i + 1));
    Static_SetText(hEntry, szTemp);

    // display percent remaining in dialog
    Percent = (int)(((long)(DirEntries - i) * 100) /
                     (long)DirEntries);
    if(Percent != OldPercent) {
      wsprintf(szTemp, "%u", Percent);
      Static_SetText(hPercent, szTemp);
      OldPercent = Percent;
      // update graphic to reflect progress:
      rDC = GetDC(hWndDlg);
      hOldBrush = SelectBrush(rDC, hProgressBrush);
      hOldPen   = SelectPen(rDC, hProgressPen);
      Rectangle(rDC, ProgRect.left, ProgRect.top,
                     ProgRect.left + ((ProgWidth * (100 - Percent)) / 100),
                     ProgRect.bottom);
      SelectBrush(rDC, hOldBrush);
      SelectPen(rDC, hOldPen);
      ReleaseDC(hWndDlg, rDC);
      }

    if(Dir[i].Length) {           // allow for zero-length
      // seek to old file location:
      _llseek(fi, Dir[i].Offset, 0);
      // read data chunk
      _hread(fi, fbuf, Dir[i].Length);
      // write to new file location:
      _hwrite(fo, fbuf, Dir[i].Length);
      }
    // do this even if nothing was written:
    // set the Offset:
    Dir[i].Offset = CurPos;
    // keep current location current
    CurPos += Dir[i].Length;
    }

  WadUsed = WadSize = CurPos;
  for(i=0; i<DirEntries; i++)   // now write directory
    _lwrite(fo, &Dir[i], 16);   // first 16 bytes of each record (clever!)
  _llseek(fo, 8, 0);            // offset to directory
  _lwrite(fo, &CurPos, 4);      // CurPos is where directory was written

  
  _lclose(fo);
  _lclose(fi);

  GlobalUnlock(hglb);
  GlobalFree(hglb);
  
  DeleteBrush(hProgressBrush);
  DeletePen(hProgressPen);
  DestroyWindow(hWndDlg);
  FreeProcInstance(lpfnStubDlgProc);
  
}

void AddMap(int which, char *mapname)
{
  OFSTRUCT      ff;
  HFILE         WadFile;
  DWORD         DirOffset, OldEntries, CurPos;
  WadThings     tThing;
  WadLineDefs   tLineDef;
  WadSideDefs   tSideDef;
  POINT         tVertex;
  WadSectors    tSector;
  
  if(SharewareVersion) {
    ErrorMessage(IDS_SHAREWARE);
    return;
    }

  ClearProblems();
  WadFile = OpenFile(szPrevFile1, &ff, OF_READWRITE);
  _llseek(WadFile, 4L, 0);          // seek to location
  _lread(WadFile, &OldEntries, 4);  // find out how many there are
  _llseek(WadFile, 8L, 0);          // offset to directory
  _lread(WadFile, &DirOffset, 4);   // where directory is now
  CurPos = DirOffset;               // location to add new hunk(s)
  if(which == Nothing) {
    // add to end
    strncpy(Dir[DirEntries].Title, mapname, 9); // null terminated by itemadd
    Dir[DirEntries].Offset = CurPos;
    Dir[DirEntries++].Length = 0;
    strcpy(Dir[DirEntries].Title, "THINGS");
    Dir[DirEntries].Offset = CurPos;
    Dir[DirEntries++].Length = sizeof(WadThings);
    tThing = DefThing;
    tThing.x = 0;       // dead center
    tThing.y = 0;       // ditto
    tThing.item = 1;    // player 1 start position
    tThing.face = 0;    // east
    _llseek(WadFile, CurPos, 0);
    _lwrite(WadFile, &tThing, sizeof(WadThings));
    CurPos += sizeof(WadThings);
    strcpy(Dir[DirEntries].Title, "LINEDEFS");
    Dir[DirEntries].Offset = CurPos;
    Dir[DirEntries++].Length = 7 * sizeof(WadLineDefs);
    CurPos += 7 * sizeof(WadLineDefs);
    tLineDef = DefLineDef;
    tLineDef.from = 0;
    tLineDef.to = 1;
    tLineDef.sidedef1 = 0;
    _lwrite(WadFile, &tLineDef, sizeof(WadLineDefs));
    tLineDef.from = 1;
    tLineDef.to = 2;
    tLineDef.sidedef1 = 1;
    _lwrite(WadFile, &tLineDef, sizeof(WadLineDefs));
    tLineDef.from = 2;
    tLineDef.to = 3;
    tLineDef.sidedef1 = 2;
    tLineDef.sidedef2 = 7;
    tLineDef.solidity = ML_TWOSIDED;
    _lwrite(WadFile, &tLineDef, sizeof(WadLineDefs));
    tLineDef.from = 3;
    tLineDef.to = 0;
    tLineDef.sidedef1 = 3;
    tLineDef.sidedef2 = Nothing;
    tLineDef.solidity = ML_BLOCKING;
    _lwrite(WadFile, &tLineDef, sizeof(WadLineDefs));
    tLineDef.from = 2;
    tLineDef.to = 4;
    tLineDef.sidedef1 = 4;
    _lwrite(WadFile, &tLineDef, sizeof(WadLineDefs));
    tLineDef.from = 4;
    tLineDef.to = 5;
    tLineDef.sidedef1 = 5;
    _lwrite(WadFile, &tLineDef, sizeof(WadLineDefs));
    tLineDef.from = 5;
    tLineDef.to = 3;
    tLineDef.sidedef1 = 6;
    _lwrite(WadFile, &tLineDef, sizeof(WadLineDefs));
    strcpy(Dir[DirEntries].Title, "SIDEDEFS");
    Dir[DirEntries].Offset = CurPos;
    Dir[DirEntries++].Length = 8 * sizeof(WadSideDefs);
    CurPos += 8 * sizeof(WadSideDefs);
    tSideDef = DefSideDef;
    tSideDef.sector = 0;
    _lwrite(WadFile, &tSideDef, sizeof(WadSideDefs));   // 0
    _lwrite(WadFile, &tSideDef, sizeof(WadSideDefs));   // 1
    NullWall(tSideDef.t3);
    _lwrite(WadFile, &tSideDef, sizeof(WadSideDefs));   // 2
    CopyWall(tSideDef.t3, DefaultSectorWall);
    _lwrite(WadFile, &tSideDef, sizeof(WadSideDefs));   // 3
    tSideDef.sector = 1;
    _lwrite(WadFile, &tSideDef, sizeof(WadSideDefs));   // 4
    _lwrite(WadFile, &tSideDef, sizeof(WadSideDefs));   // 5
    _lwrite(WadFile, &tSideDef, sizeof(WadSideDefs));   // 6
    NullWall(tSideDef.t3);
    _lwrite(WadFile, &tSideDef, sizeof(WadSideDefs));   // 7
    strcpy(Dir[DirEntries].Title, "VERTEXES");
    Dir[DirEntries].Offset = CurPos;
    Dir[DirEntries++].Length = 6 * sizeof(POINT);
    CurPos += 6 * sizeof(POINT);
    tVertex.x = -128;   // Vertex 0
    tVertex.y = -128;
    _lwrite(WadFile, &tVertex, sizeof(POINT));
    tVertex.x = -128;   // Vertex 1
    tVertex.y =  128;
    _lwrite(WadFile, &tVertex, sizeof(POINT));
    tVertex.x =  0;     // Vertex 2
    tVertex.y =  128;
    _lwrite(WadFile, &tVertex, sizeof(POINT));
    tVertex.x =  0;     // Vertex 3
    tVertex.y = -128;
    _lwrite(WadFile, &tVertex, sizeof(POINT));
    tVertex.x =  128;   // Vertex 4
    tVertex.y =  128;
    _lwrite(WadFile, &tVertex, sizeof(POINT));
    tVertex.x =  128;   // Vertex 5
    tVertex.y = -128;
    _lwrite(WadFile, &tVertex, sizeof(POINT));
    strcpy(Dir[DirEntries].Title, "SEGS");
    Dir[DirEntries].Offset = CurPos;
    Dir[DirEntries++].Length = 0;
    strcpy(Dir[DirEntries].Title, "SSECTORS");
    Dir[DirEntries].Offset = CurPos;
    Dir[DirEntries++].Length = 0;
    strcpy(Dir[DirEntries].Title, "NODES");
    Dir[DirEntries].Offset = CurPos;
    Dir[DirEntries++].Length = 0;
    strcpy(Dir[DirEntries].Title, "SECTORS");
    Dir[DirEntries].Offset = CurPos;
    Dir[DirEntries++].Length = 2 * sizeof(WadSectors);
    CurPos += 2 * sizeof(WadSectors);
    tSector = DefSector;
    _lwrite(WadFile, &tSector, sizeof(WadSectors));
    _lwrite(WadFile, &tSector, sizeof(WadSectors));
    strcpy(Dir[DirEntries].Title, "REJECT");
    Dir[DirEntries].Offset = CurPos;
    Dir[DirEntries++].Length = 0;
    strcpy(Dir[DirEntries].Title, "BLOCKMAP");
    Dir[DirEntries].Offset = CurPos;
    Dir[DirEntries++].Length = 0;
    strcpy(Dir[DirEntries].Title, "TAGDESC");
    Dir[DirEntries].Offset = CurPos;
    Dir[DirEntries++].Length = 0;
    }
  else {
    // add to middle somewhere
    DirEntries += 12;
    for(int j = DirEntries; j > which; j--)
      if(j > 11)
        Dir[j] = Dir[j - 12];
    strncpy(Dir[which].Title, mapname, 9); // null terminated by itemadd
    Dir[which].Offset = CurPos;
    Dir[which].Length = 0;
    strcpy(Dir[which + 1].Title, "THINGS");
    Dir[which + 1].Offset = CurPos;
    Dir[which + 1].Length = sizeof(WadThings);
    tThing = DefThing;
    tThing.x = 0;       // dead center
    tThing.y = 0;       // ditto
    tThing.item = 1;    // player 1 start position
    tThing.face = 0;    // east
    _llseek(WadFile, CurPos, 0);
    _lwrite(WadFile, &tThing, sizeof(WadThings));
    CurPos += sizeof(WadThings);
    strcpy(Dir[which + 2].Title, "LINEDEFS");
    Dir[which + 2].Offset = CurPos;
    Dir[which + 2].Length = 7 * sizeof(WadLineDefs);
    CurPos += 7 * sizeof(WadLineDefs);
    tLineDef = DefLineDef;
    tLineDef.from = 0;
    tLineDef.to = 1;
    tLineDef.sidedef1 = 0;
    _lwrite(WadFile, &tLineDef, sizeof(WadLineDefs));
    tLineDef.from = 1;
    tLineDef.to = 2;
    tLineDef.sidedef1 = 1;
    _lwrite(WadFile, &tLineDef, sizeof(WadLineDefs));
    tLineDef.from = 2;
    tLineDef.to = 3;
    tLineDef.sidedef1 = 2;
    tLineDef.sidedef2 = 7;
    tLineDef.solidity = ML_TWOSIDED;
    _lwrite(WadFile, &tLineDef, sizeof(WadLineDefs));
    tLineDef.from = 3;
    tLineDef.to = 0;
    tLineDef.sidedef1 = 3;
    tLineDef.sidedef2 = Nothing;
    tLineDef.solidity = ML_BLOCKING;
    _lwrite(WadFile, &tLineDef, sizeof(WadLineDefs));
    tLineDef.from = 2;
    tLineDef.to = 4;
    tLineDef.sidedef1 = 4;
    _lwrite(WadFile, &tLineDef, sizeof(WadLineDefs));
    tLineDef.from = 4;
    tLineDef.to = 5;
    tLineDef.sidedef1 = 5;
    _lwrite(WadFile, &tLineDef, sizeof(WadLineDefs));
    tLineDef.from = 5;
    tLineDef.to = 3;
    tLineDef.sidedef1 = 6;
    _lwrite(WadFile, &tLineDef, sizeof(WadLineDefs));
    strcpy(Dir[which + 3].Title, "SIDEDEFS");
    Dir[which + 3].Offset = CurPos;
    Dir[which + 3].Length = 8 * sizeof(WadSideDefs);
    CurPos += 8 * sizeof(WadSideDefs);
    tSideDef = DefSideDef;
    tSideDef.sector = 0;
    _lwrite(WadFile, &tSideDef, sizeof(WadSideDefs));   // 0
    _lwrite(WadFile, &tSideDef, sizeof(WadSideDefs));   // 1
    NullWall(tSideDef.t3);
    _lwrite(WadFile, &tSideDef, sizeof(WadSideDefs));   // 2
    CopyWall(tSideDef.t3, DefaultSectorWall);
    _lwrite(WadFile, &tSideDef, sizeof(WadSideDefs));   // 3
    tSideDef.sector = 1;
    _lwrite(WadFile, &tSideDef, sizeof(WadSideDefs));   // 4
    _lwrite(WadFile, &tSideDef, sizeof(WadSideDefs));   // 5
    _lwrite(WadFile, &tSideDef, sizeof(WadSideDefs));   // 6
    NullWall(tSideDef.t3);
    _lwrite(WadFile, &tSideDef, sizeof(WadSideDefs));   // 7
    strcpy(Dir[which + 4].Title, "VERTEXES");
    Dir[which + 4].Offset = CurPos;
    Dir[which + 4].Length = 6 * sizeof(POINT);
    CurPos += 6 * sizeof(POINT);
    tVertex.x = -128;   // Vertex 0
    tVertex.y = -128;
    _lwrite(WadFile, &tVertex, sizeof(POINT));
    tVertex.x = -128;   // Vertex 1
    tVertex.y =  128;
    _lwrite(WadFile, &tVertex, sizeof(POINT));
    tVertex.x =  0;     // Vertex 2
    tVertex.y =  128;
    _lwrite(WadFile, &tVertex, sizeof(POINT));
    tVertex.x =  0;     // Vertex 3
    tVertex.y = -128;
    _lwrite(WadFile, &tVertex, sizeof(POINT));
    tVertex.x =  128;   // Vertex 4
    tVertex.y =  128;
    _lwrite(WadFile, &tVertex, sizeof(POINT));
    tVertex.x =  128;   // Vertex 5
    tVertex.y = -128;
    _lwrite(WadFile, &tVertex, sizeof(POINT));
    strcpy(Dir[which + 5].Title, "SEGS");
    Dir[which + 5].Offset = CurPos;
    Dir[which + 5].Length = 0;
    strcpy(Dir[which + 6].Title, "SSECTORS");
    Dir[which + 6].Offset = CurPos;
    Dir[which + 6].Length = 0;
    strcpy(Dir[which + 7].Title, "NODES");
    Dir[which + 7].Offset = CurPos;
    Dir[which + 7].Length = 0;
    strcpy(Dir[which + 8].Title, "SECTORS");
    Dir[which + 8].Offset = CurPos;
    Dir[which + 8].Length = 2 * sizeof(WadSectors);
    CurPos += 2 * sizeof(WadSectors);
    tSector = DefSector;
    _lwrite(WadFile, &tSector, sizeof(WadSectors));
    _lwrite(WadFile, &tSector, sizeof(WadSectors));
    strcpy(Dir[which + 9].Title, "REJECT");
    Dir[which + 9].Offset = CurPos;
    Dir[which + 9].Length = 0;
    strcpy(Dir[which + 10].Title, "BLOCKMAP");
    Dir[which + 10].Offset = CurPos;
    Dir[which + 10].Length = 0;
    strcpy(Dir[which + 11].Title, "TAGDESC");
    Dir[which + 11].Offset = CurPos;
    Dir[which + 11].Length = 0;
    }
  DirOffset += (CurPos - DirOffset);
  OldEntries = DirEntries;
  _llseek(WadFile, 4L, 0);          // seek to entries
  _lwrite(WadFile, &OldEntries, 4); // write how many there are
  _llseek(WadFile, 8L, 0);          // seek to dir offset
  _lwrite(WadFile, &DirOffset, 4);  // write directory location
  _llseek(WadFile, DirOffset, 0);   // seek to what is now the directory
  for(int i = 0; i < DirEntries; i++)       // now write directory
    _lwrite(WadFile, &Dir[i], 16);  // first 16 bytes of each record
  _lclose(WadFile);
  MapChangeNode();
}

void ReplaceSound(int which, char *filename)
{
  HFILE         fi;         // input WAV file
  BYTE        __huge *wavbuf;
  long          wavlen;
  HGLOBAL       hglb;
  WAVEFORMAT    wf;
  char          tempfilename[144];
  OFSTRUCT      ofOutFile;
  HFILE         hOutFile;
  
  if(SharewareVersion) {
    ErrorMessage(IDS_SHAREWARE);
    return;
    }

  fi = _lopen(filename, READ);
  wavlen = _llseek(fi, 0L, 2);
  hglb = GlobalAlloc(GMEM_FIXED, wavlen);
  wavbuf = (BYTE __huge *)GlobalLock(hglb);
  _llseek(fi, 0L, 0);
  _hread(fi, wavbuf, wavlen);
  _lclose(fi);
  for(int k = 0; k < wavlen; k++)
    if((wavbuf[k]     == 'f') &&
       (wavbuf[k + 1] == 'm') &&
       (wavbuf[k + 2] == 't') &&
       (wavbuf[k + 3] == ' ')) {
      k += 8;
      hmemcpy(&wf, wavbuf + k, sizeof(WAVEFORMAT));
      break;
      }
  wsh.id = 3;
  wsh.rate = (int)wf.nSamplesPerSec;
  if(wsh.rate != 11025) {
    ErrorMessage(IDS_SOUNDSAMPLE);
    return;
    }
  for(k=0; k<wavlen; k++)
    if((wavbuf[k]     == 'd') &&
       (wavbuf[k + 1] == 'a') &&
       (wavbuf[k + 2] == 't') &&
       (wavbuf[k + 3] == 'a')) {
      k += 4;
      hmemcpy(&wsh.size, wavbuf + k, 4);
      k += 4;
      break;
      }
  hmemcpy(wavbuf, &wsh, 8);                   // header
  hmemcpy(wavbuf + 8, wavbuf + k, wsh.size);  // data
  wavlen = wsh.size + 8;

  GetTempFileName(0, "WAV", 0, tempfilename);
  if(hOutFile = OpenFile(tempfilename, &ofOutFile, OF_CREATE)){
    _hwrite(hOutFile, wavbuf, wavlen);
    _lclose(hOutFile);
    }
  GlobalUnlock(hglb);
  GlobalFree(hglb);
  KeepOldChunkName = TRUE;
  ReplaceLump(DD_EXTERNAL, which, tempfilename);
  KeepOldChunkName = FALSE;
  if(hOutFile)
    OpenFile(tempfilename, &ofOutFile, OF_DELETE);
}

void CoreName(char *filename, char *corename)
{
  // return just the core name, without path or extension
  int StartChar = 0;
  int EndChar = strlen(filename);
  for(int i = strlen(filename); i > 0; i--)
    if(filename[i] == '\\') {
      StartChar = i + 1;
      break;
      }
  for(i = strlen(filename); i > 0; i--)
    if(filename[i] == '.') {
      EndChar = i - 1;
      break;
      }
  for(i=0; i<10; i++)
    corename[i] = '\0';
  int j = 0;
  for(i = StartChar; i <= EndChar; i++)    
    corename[j++] = filename[i];
}

void InsertSound(int which, char *filename)
{
  HFILE         fi;         // input WAV file
  BYTE        __huge *wavbuf;
  long          wavlen;
  HGLOBAL       hglb;
  WAVEFORMAT    wf;
  char          tempfilename[144];
  OFSTRUCT      ofOutFile;
  HFILE         hOutFile;
  
  if(SharewareVersion) {
    ErrorMessage(IDS_SHAREWARE);
    return;
    }

  CoreName(filename, ChunkName);

  fi = _lopen(filename, READ);
  wavlen = _llseek(fi, 0L, 2);
  hglb = GlobalAlloc(GMEM_FIXED, wavlen);
  wavbuf = (BYTE __huge *)GlobalLock(hglb);
  _llseek(fi, 0L, 0);
  _hread(fi, wavbuf, wavlen);
  _lclose(fi);
  for(int k = 0; k < wavlen; k++)
    if((wavbuf[k]     == 'f') &&
       (wavbuf[k + 1] == 'm') &&
       (wavbuf[k + 2] == 't') &&
       (wavbuf[k + 3] == ' ')) {
      k += 8;
      hmemcpy(&wf, wavbuf + k, sizeof(WAVEFORMAT));
      break;
      }
  wsh.id = 3;
  wsh.rate = (int)wf.nSamplesPerSec;
  if(wsh.rate != 11025) {
    ErrorMessage(IDS_SOUNDSAMPLE);
    return;
    }
  for(k=0; k<wavlen; k++)
    if((wavbuf[k]     == 'd') &&
       (wavbuf[k + 1] == 'a') &&
       (wavbuf[k + 2] == 't') &&
       (wavbuf[k + 3] == 'a')) {
      k += 4;
      hmemcpy(&wsh.size, wavbuf + k, 4);
      k += 4;
      break;
      }
  hmemcpy(wavbuf, &wsh, 8);                   // header
  hmemcpy(wavbuf + 8, wavbuf + k, wsh.size);  // data
  wavlen = wsh.size + 8;

  GetTempFileName(0, "WAV", 0, tempfilename);
  if(hOutFile = OpenFile(tempfilename, &ofOutFile, OF_CREATE)){
    _hwrite(hOutFile, wavbuf, wavlen);
    _lclose(hOutFile);
    }
  GlobalUnlock(hglb);
  GlobalFree(hglb);
  // place the doctored file into the wad
  KeepOldChunkName = TRUE;
  InsertLump(DD_EXTERNAL, which, tempfilename);
  KeepOldChunkName = FALSE;
  // delete the temporary file
  if(hOutFile)
    OpenFile(tempfilename, &ofOutFile, OF_DELETE);
}


