// DWD format support for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"

#define OutString   strcat(szBuf, "\n"); \
                    _lwrite(ExportFile, szBuf, strlen(szBuf));

void ExportDWD(void)
{
  // get filename
  // save current map to DWD format
  int           i;
  int           LinesInUse = 0;
  int           ThingsInUse = 0;
  char          szBuf[256];
  char          szTopt[9], szBott[9], szMidt[9], szFpic[9], szCpic[9];
  HFILE         ExportFile;
  OFSTRUCT      ofOutFile;      // output file info

  if(!FileNameExportDWD())
    return;
  // pack the map structure "all neat and tidy",
  // removing deleted objects:
  PackMap();
  // assume that szExportFile is good:
  if(ExportFile = OpenFile(szExportFile, &ofOutFile, OF_CREATE)) {
    strcpy(szBuf, "WorldServer version 4\n");
    OutString
    strcpy(szBuf, "level:");
    strcat(szBuf, szMapName);
    OutString
    for(i = 0; i < LineDefsNum; i++)
      if(eLineDef[i].Used)
        LinesInUse++;

    sprintf(szBuf,"lines:%d", LinesInUse);
    OutString
    for(i=0; i<LineDefsNum; i++) {
      if(!eLineDef[i].Used)
        continue;
      if((LineDef[i].solidity & 4) && 
         ((LineDef[i].sidedef1 == Nothing) ||
          (LineDef[i].sidedef2 == Nothing)))
        LineDef[i].solidity ^= 4;   // clear double sided if not double sided

      sprintf(szBuf, "(%d,%d) to (%d,%d) : %d : %d : %d",
                     Vertex[LineDef[i].from].x, Vertex[LineDef[i].from].y,
                     Vertex[LineDef[i].to].x, Vertex[LineDef[i].to].y,
                     LineDef[i].solidity,
                     LineDef[i].special,
                     LineDef[i].tag);
      OutString
      if(LineDef[i].sidedef1 != Nothing) {
        strncpy(szTopt, SideDef[LineDef[i].sidedef1].t1, 8);
        szTopt[8] = '\0';
        strncpy(szBott, SideDef[LineDef[i].sidedef1].t2, 8);
        szBott[8] = '\0';
        strncpy(szMidt, SideDef[LineDef[i].sidedef1].t3, 8);
        szMidt[8] = '\0';
        strncpy(szFpic, Sector[SideDef[LineDef[i].sidedef1].sector].Floor, 8);
        szFpic[8] = '\0';
        strncpy(szCpic, Sector[SideDef[LineDef[i].sidedef1].sector].Ceil, 8);
        szCpic[8] = '\0';
        sprintf(szBuf, "    %d (%d : %s / %s / %s )",
                SideDef[LineDef[i].sidedef1].y,
                SideDef[LineDef[i].sidedef1].x,
                szTopt, szBott, szMidt);
        OutString
        sprintf(szBuf, "    %d : %s %d : %s %d %d %d",
                Sector[SideDef[LineDef[i].sidedef1].sector].floorZ, szFpic,
                Sector[SideDef[LineDef[i].sidedef1].sector].ceilZ, szCpic,
                Sector[SideDef[LineDef[i].sidedef1].sector].light,
                Sector[SideDef[LineDef[i].sidedef1].sector].flash,
                Sector[SideDef[LineDef[i].sidedef1].sector].tag);
        OutString
        }
        
      if((LineDef[i].solidity & 4) && (LineDef[i].sidedef2 != Nothing)) {
        strncpy(szTopt, SideDef[LineDef[i].sidedef2].t1, 8);
        szTopt[8] = '\0';
        strncpy(szBott, SideDef[LineDef[i].sidedef2].t2, 8);
        szBott[8] = '\0';
        strncpy(szMidt, SideDef[LineDef[i].sidedef2].t3, 8);
        szMidt[8] = '\0';
        strncpy(szFpic, Sector[SideDef[LineDef[i].sidedef2].sector].Floor, 8);
        szFpic[8] = '\0';
        strncpy(szCpic, Sector[SideDef[LineDef[i].sidedef2].sector].Ceil, 8);
        szCpic[8] = '\0';
        sprintf(szBuf, "    %d (%d : %s / %s / %s )",
                SideDef[LineDef[i].sidedef2].y,
                SideDef[LineDef[i].sidedef2].x,
                szTopt, szBott, szMidt);
        OutString
        sprintf(szBuf, "    %d : %s %d : %s %d %d %d",
                Sector[SideDef[LineDef[i].sidedef2].sector].floorZ, szFpic,
                Sector[SideDef[LineDef[i].sidedef2].sector].ceilZ, szCpic,
                Sector[SideDef[LineDef[i].sidedef2].sector].light,
                Sector[SideDef[LineDef[i].sidedef2].sector].flash,
                Sector[SideDef[LineDef[i].sidedef2].sector].tag);
        OutString
        }   // endif (second sidedef)
      }     // next i (linedef)

    for(i=0; i<ThingsNum; i++)
      if(eThing[i].Used)
        ThingsInUse++;

    sprintf(szBuf,"\nthings:%d", ThingsInUse);
    OutString
    for(i=0; i<ThingsNum; i++) {
      if(!eThing[i].Used)
        continue;
      sprintf(szBuf, "(%i,%i, %d) :%d, %d",
              Thing[i].x, Thing[i].y,
              Thing[i].face, Thing[i].item, Thing[i].lev);
      OutString
      }
        
    _lclose(ExportFile);
    }
}

void ImportDWD(void)
{
  // prompt for filename
  // read current map from DWD format
}

