// Finding of nearest item for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"
#include <math.h>

int LineDefNearAmount;

int hypotenuse(POINT p1, POINT p2)
{
  // quick sqrt from Graphics Gems I
  POINT t1 = p1, t2 = p2;
  if((t2.x -= t1.x) < 0) t2.x = -t2.x;
  if((t2.y -= t1.y) < 0) t2.y = -t2.y;
  return (t2.x + t2.y - (((t2.x > t2.y) ? t2.y : t2.x) >> 1));
}

BOOL LineDefNear(int ldn, POINT mouse)
{
  // entry: ldn=LineDef Num, mouse = current mouse location
  int x0 = mouse.x - LineDefNearAmount;     // mouse window
  int y0 = mouse.y - LineDefNearAmount;
  int x1 = mouse.x + LineDefNearAmount;
  int y1 = mouse.y + LineDefNearAmount;
  int lx0= Vertex[LineDef[ldn].from].x;     // linedef    
  int ly0= Vertex[LineDef[ldn].from].y;
  int lx1= Vertex[LineDef[ldn].to].x;
  int ly1= Vertex[LineDef[ldn].to].y;
  int i;

  if(!eLineDef[ldn].Used)
    return FALSE;

  if((ly0 > y0) != (ly1 > y0)) {
    i = lx0 + (int)((long)(y0 - ly0) * (long)(lx1 - lx0) / (long)(ly1 - ly0));
    if(i >= x0 && i <= x1)
     return TRUE;   // the LineDef crosses the y0 side (left)
    }
  if((ly0 > y1) != (ly1 > y1)) {
    i = lx0 + (int)((long)(y1 - ly0) * (long)(lx1 - lx0) / (long)(ly1 - ly0));
    if(i >= x0 && i <= x1)
      return TRUE;  // the LineDef crosses the y1 side (right)
    }
  if((lx0 > x0) != (lx1 > x0)) {
    i = ly0 + (int)((long)(x0 - lx0) * (long)(ly1 - ly0) / (long)(lx1 - lx0));
    if (i >= y0 && i <= y1)
      return TRUE;  // the LineDef crosses the x0 side (down)
    }
  if((lx0 > x1) != (lx1 > x1)) {
    i = ly0 + (int)((long)(x1 - lx0) * (long)(ly1 - ly0) / (long)(lx1 - lx0));
    if (i >= y0 && i <= y1)
      return TRUE;  // the LineDef crosses the x1 side (up)
    }
  if(lx0 >= x0 && lx0 <= x1 && ly0 >= y0 && ly0 <= y1)
    return TRUE;    // the LineDef is entirely inside the square
  if(lx1 >= x0 && lx1 <= x1 && ly1 >= y0 && ly1 <= y1)
    return TRUE;
  return FALSE;
}

int NearestVertex(POINT mouse)
{
  int  i, cdist, ret = Nothing;
  int  _far *dist;
  dist = (int *)alloca(VertexNum * sizeof(int));

  for(i=0; i<VertexNum; i++)
    if(eVertex[i].Used)
      dist[i] = hypotenuse(mouse, Vertex[i]);
    else
      dist[i] = MAXINT;

  cdist = MAXINT;
  for(i=0; i<VertexNum; i++) {
    if(eVertex[i].Used && (dist[i] < cdist)) {
      cdist = dist[i];
      ret = i;
      }
    }
  if(dist[ret] > 64)
    ret = Nothing;
  return ret;
}

int NearestLineDef(POINT mouse)
{
  int i, ret = Nothing, NumFound = 0;
  
  LineDefNearAmount = 64;
DoItAgain:
  for(i=0; i<LineDefsNum; i++)
    if(eLineDef[i].Used && LineDefNear(i, mouse)) {
      NumFound++;
      ret = i;
      }
  if(NumFound > 1) {
    NumFound = 0;
    ret = Nothing;
    LineDefNearAmount /= 2;
    if(LineDefNearAmount == 1)
      return Nothing;
    else
      goto DoItAgain;
    }
  return ret;
}

int NearestSectorNotMove(POINT mouse)
{
  // returns the sector number that the mouse is within
  // EXCLUDING the lines that are marked as MOVING!!!!

  int m, n, cur, curx;
  int lx0, ly0, lx1, ly1;
   
  curx = MAXINT;
  cur = Nothing;
  for(n = 0; n < LineDefsNum; n++)
    if(eLineDef[n].Used && !eLineDef[n].Moving)
      if((Vertex[LineDef[n].from].y > mouse.y) != 
         (Vertex[LineDef[n].to].y   > mouse.y)) {
        lx0 = Vertex[LineDef[n].from].x;
        ly0 = Vertex[LineDef[n].from].y;
        lx1 = Vertex[LineDef[n].to].x;
        ly1 = Vertex[LineDef[n].to].y;
        m = lx0 + (int)((long)(mouse.y - ly0) * 
            (long)(lx1 - lx0) / (long) (ly1 - ly0));
        if(m >= mouse.x && m < curx) {
          curx = m;
          cur = n;
          }     // end if
      }         // end if
      // now see if this LineDef has a SideDef bound to one sector
      if(cur != Nothing) {
        if(Vertex[LineDef[cur].from].y > Vertex[LineDef[cur].to].y) {
          if(LineDef[cur].sidedef1 >= 0)
            cur = SideDef[LineDef[cur].sidedef1].sector;
           else
            cur = Nothing;
          }
        else {
          if(LineDef[cur].sidedef2 >= 0)
            cur = SideDef[LineDef[cur].sidedef2].sector;
         else
            cur = Nothing;
          }
        }
      else
        cur = Nothing;
  return cur;
}

int NearestSector(POINT mouse)
{
  // returns the sector number that the mouse is within

  int m, n, cur, curx;
  int lx0, ly0, lx1, ly1;
   
  curx = MAXINT;
  cur = Nothing;
  for(n = 0; n < LineDefsNum; n++)
    if(eLineDef[n].Used)
      if((Vertex[LineDef[n].from].y > mouse.y) != 
         (Vertex[LineDef[n].to].y   > mouse.y)) {
        lx0 = Vertex[LineDef[n].from].x;
        ly0 = Vertex[LineDef[n].from].y;
        lx1 = Vertex[LineDef[n].to].x;
        ly1 = Vertex[LineDef[n].to].y;
        m = lx0 + (int)((long)(mouse.y - ly0) * 
            (long)(lx1 - lx0) / (long) (ly1 - ly0));
        if(m >= mouse.x && m < curx) {
          curx = m;
          cur = n;
          }     // end if
      }         // end if
      // now see if this LineDef has a SideDef bound to one sector
      if(cur != Nothing) {
        if(Vertex[LineDef[cur].from].y > Vertex[LineDef[cur].to].y) {
          if(LineDef[cur].sidedef1 >= 0)
            cur = SideDef[LineDef[cur].sidedef1].sector;
           else
            cur = Nothing;
          }
        else {
          if(LineDef[cur].sidedef2 >= 0)
            cur = SideDef[LineDef[cur].sidedef2].sector;
         else
            cur = Nothing;
          }
        }
      else
        cur = Nothing;
  return cur;
}

int NearestThing(POINT mouse)
{
  int       i, cdist, ret = Nothing;
  int _far *dist;
  POINT     tp;
  dist = (int *)alloca(ThingsNum * sizeof(int));

  for(i=0; i<ThingsNum; i++) {
    if(eThing[i].Used) {
      tp.x = Thing[i].x;
      tp.y = Thing[i].y;
      dist[i] = hypotenuse(mouse, tp);
      }
    else
      dist[i] = MAXINT;
    }

  cdist = MAXINT;
  for(i=0; i<ThingsNum; i++) {
    if(dist[i] < cdist) {
      cdist = dist[i];
      ret = i;
      }
    }
  if(dist[ret] > 64)
    ret = Nothing;
  return ret;
}

int DoomEntry(char *Search)
{
  // returns the Doom number for the string
  int   i, j, retval = NotFound;
  char  szTemp1[10];
  
  strcpy(szTemp1, Search);
  AnsiUpper(szTemp1);
  j = strlen(szTemp1);
  if(j > 0)
    for(i = 0; i < DoomEntries; i++)
      if(strcmp(szTemp1, Doom[i].Title) == 0) {
        retval = i;
        break;
        }
  return retval;
}

int DirEntry(char *Search)
{
  // returns the Dir number for the string
  int   i, j, retval = NotFound;
  char  szTemp1[10];
  
  strcpy(szTemp1, Search);
  AnsiUpper(szTemp1);
  j = strlen(szTemp1);
  if(j > 0)
    for(i = 0; i < DirEntries; i++)
      if(strcmp(szTemp1, Dir[i].Title) == 0) {
        retval = i;
        break;
        }
  return retval;
}

int TextureEntry(char *Search)
{
  int   i, j, retval = NotFound;
  char  szTemp1[10];
  
  strcpy(szTemp1, Search);
  AnsiUpper(szTemp1);
  j = strlen(szTemp1);
  if(j > 0)
    for(i = 0; i < TexturesNum; i++)
      if(strncmp(szTemp1, Texture[i].name, j) == 0) {
        retval = i;
        break;
        }
  return retval;
}