// Global Declarations for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#ifndef DOOMED_GLOBALS

// In the tradition of BASIC programming, I'm keeping lots of
// variables in the global segment. This is to keep from having
// to initialize variables as we go, as well as to keep track
// of instance specific data

// Windows stuff:
extern HWND         hwnd;               // handle to our window
extern HINSTANCE    hinst;              // handle to our instance
extern HDC          hdc;                // device context - our client area
extern WNDCLASS     rClass;             // our class
extern WNDCLASS     dClass;             // our Dialog box class
extern HWND         hDialogWindow;      // our Dialog box handle
extern HANDLE       hAccel;             // accelerator table
extern HPALETTE     hPalette;           // palette of 256 colors
extern HCURSOR      oldCursor;
extern HCURSOR      hCursorMag;         // Magnifying glass
extern POINT        MouseOnScreen;      // mostly for zooms...
extern BOOL         ReallyBusy;         // for multi-tasking
extern HWND         hCBSave;            // the save button on the control bar

// Modeless Dialog stuff:
extern HWND         Frontmost;          // which modeless dialog gets messages
extern HWND         hwndDialogThing;    // modeless dialog boxes
extern HWND         hwndDialogSector;
extern HWND         hwndDialogLineDef;
extern HWND         hwndDialogSplash;
extern HWND         hwndControlBar;
extern HWND         hwndControlBot;
extern HWND         hwndTileViewer;
extern HWND         hwndTextureViewer;
extern HWND         hwndProblems;
extern HWND         hwndViewer;
extern FARPROC      lpfnDialogThing;    // function pointers
extern FARPROC      lpfnDialogSector;
extern FARPROC      lpfnDialogLineDef;
extern FARPROC      lpfnDialogSplash;
extern FARPROC      lpfnControlBar;
extern FARPROC      lpfnControlBot;
extern FARPROC      lpfnTileViewer;
extern FARPROC      lpfnTextureViewer;
extern FARPROC      lpfnProblems;
extern FARPROC      lpfnViewer;

// 3d stuff:
extern RectArray    Rect;

// Pens and brushes:
extern HPEN         hPenBackground, hPenMapLines, hPenMapInnerLines,
                    hPenSelected, hPenMarked, hPenGrid, hPenUserGrid,
                    hPenDrag;
extern HBRUSH       hBrushBackground, hBrushMapLines, hBrushMapInnerLines,
                    hBrushSelected, hBrushMarked, hBrushGrid, hBrushUserGrid;
extern HBRUSH       hBrushNull;         // for null filled rectangles
extern HPEN         hOriginalPen;
extern HBRUSH       hOriginalBrush;

// Colors:
extern COLORREF     ColorBackground;
extern COLORREF     ColorMapLines;
extern COLORREF     ColorMapInnerLines;
extern COLORREF     ColorSelected;
extern COLORREF     ColorMarked;
extern COLORREF     ColorGrid;
extern COLORREF     ColorUserGrid;
extern HGLOBAL      hgPalette;

// memory allocation:
extern HGLOBAL      hgDoom, hgDir,
                    hgVertex, hgLineDef, hgSideDef, hgSector,
                    hgThing, hgNode, hgSSector, hgSeg,
                    hgTag, hgReject, hgBlockMap,
                    hgeVertex, hgeLineDef, hgeSideDef, hgeSector,
                    hgeThing, hgProblem,
                    hgStyle, hgBuilder;

extern int          MAX_VERTEX,
                    MAX_LINEDEF,
                    MAX_SIDEDEF,
                    MAX_SECTOR,
                    MAX_THING,
                    MAX_NODE,
                    MAX_SSECTOR,
                    MAX_SEG,
                    MAX_TAG,
                    MAX_STYLE,
                    MAX_BUILDER;

// data structures:
// Wad directories:
extern WadDir           FAR  *Doom;     // Doom.Wad directory
extern int              DoomEntries;
extern WadDir           FAR  *Dir;      // external Wad directory
extern int              DirEntries;
extern DWORD            WadSize,        // for status and determining
                        WadUsed;        // if a purge is required.
// current map:
extern WadThings      __huge *Thing;
extern POINT          __huge *Vertex;
extern WadLineDefs    __huge *LineDef;
extern WadSideDefs    __huge *SideDef;
extern WadSectors     __huge *Sector;
extern WadNodes       __huge *Node;
extern WadSSectors    __huge *SSector;
extern WadSegs        __huge *Seg;
extern WadTags          FAR  *Tag;
extern BYTE             FAR  *Reject;           // reject data block
extern DWORD                  RejectSize;       // how big it is (bytes)
extern int              FAR  *BlockMap;         // blockmap data block
extern DWORD                  BlockMapSize;     // how big it is (bytes)
extern char                   szMapName[10];    // title (ie. E1M1)
extern ExtraVertex    __huge *eVertex;
extern ExtraThings    __huge *eThing;
extern ExtraLineDefs  __huge *eLineDef;
extern ExtraSideDefs  __huge *eSideDef;
extern ExtraSectors   __huge *eSector;
extern int                    NextTag,
                              CurrentTag,
                              TagShowing;
extern prob             FAR  *Problem;
extern int                    ProblemsNum;

// selection stuff:
extern RECT         SelRect;            // for multiple selection window
extern int          SelectedThings,
                    SelectedVertexes,
                    SelectedLineDefs,
                    SelectedSectors;
extern int          CurrentThing,
                    CurrentVertex,
                    CurrentSector,
                    CurrentLineDef;
extern BOOL         CreatingSectorWithinSector;

// Map information:
extern int          VertexNum, LineDefsNum, ThingsNum, NodesNum, SectorsNum,
                    SideDefsNum, SSectorsNum, SegsNum, TagsNum;
extern RECT         MapExtent;          // how big the map is
extern RECT         MapOnScreen;        // how much is displayed
extern RECT         PreviousZoom;       // for ZoomPrev button
extern int          GridSize;           // the snap-to grid size
extern WadThings    DefThing;           // default for new additions
extern WadLineDefs  DefLineDef;
extern WadSideDefs  DefSideDef;
extern WadSectors   DefSector;
extern int          MapEntry;           // where the map came from (and goes)
extern int          SectorInside;

// Bitmap stuff
extern int          ViewerOffsetX, ViewerOffsetY;  // lock point
extern PALETTEENTRY Pal[256];
extern HBITMAP      hBitmap;
extern WORD         BitmapWidth, BitmapHeight;

// Textures and related support:
extern int          TexturesNum;
extern TextureInfo *Texture;
extern int          PNamesNum;
extern PNames      *PName;

// Multimedia stuff (sounds & music)
extern struct       WadSoundHeader wsh;
extern struct       WavSoundHeader wav;

// Sector creation stuff:
extern int          DefaultSectorBottom;
extern int          DefaultSectorTop;
extern int          DefaultSectorLight;
extern int          vv;                 // needed for Wall macros
extern int          floorUD, ceilUD;    // whether floor & ceil are
                                        // indented or outdented
// Task tracking
extern TASKENTRY    te;
extern BOOL         WaitingForTask;
extern HTASK        TaskToWatch;
extern UINT         hTimer;
extern PENDING      Pending;            // only one pending for now

// Flags and Options:
extern BOOL         ShowGrid;
extern BOOL         RegisteredVersion;
                //  note: macro SharewareVersion = (!RegisteredVersion)
extern BOOL         ShowingSplash;
extern BOOL         PaletteLoaded;
extern BOOL         MapLoaded;              
extern BOOL         MapEdited;
extern BOOL         MapNodes;
extern BOOL         WaitGraphics;
extern BOOL         WaitSound;
extern BOOL         WaitMusic;
extern BOOL         WaitAnsi;
extern BOOL         ShowingSectorRectangle;
extern int          Paradigm;
extern int          Tool;
extern int          MouseAction;
extern int          NodeBuilderAction;
extern int          RejectAction;
extern int          DoomVersion;
// options selectable using Options dialog
extern BOOL         oVerifyExit;
extern BOOL         oShowSnapToGrid;
extern BOOL         oShow64x64Grid;
extern BOOL         oBuildNodesAtEverySave;
extern BOOL         oAutoStitchDuringConstruction;
extern BOOL         oAutoLoadMostRecentFile;
extern BOOL         oVerifyAfterEdit;

// strings:
// constants:
extern char         Direction[8][10];   // strings
// variables:
extern char         lpszMessage[255];   // for loading strings
extern char         DefaultSectorWall[10];
extern char         DefaultSectorFloor[10];
extern char         DefaultSectorCeil[10];
// filenames:
extern char         szDoomWad[128];
extern char         szThingsDef[128];
extern char         szSound[128];
extern char         szMusic[128];
extern char         szBitmap[128];
extern char         szEndScreen[128];
extern char         szPrevFile1[128];
extern char         szPrevFile2[128];
extern char         szPrevFile3[128];
extern char         szPrevFile4[128];
extern char         szExportFile[128];
extern char         szEditorGraphics[128];
extern char         szEditorText[128];
extern char         szEditorAnsi[128];
extern char         szEditorSound[128];
extern char         szEditorMusic[128];
// directory names:
extern char         szDoomDir[128];
extern char         szExportDir[128];
// styles:
extern int          StylesNum;
extern Styles       FAR *Style;
// BSP Builders
extern int          BuildersNum;
extern Builders     FAR *Builder;

// thing descriptions and bitmaps:
extern dThing       ThingDesc[128];
extern int          ThingUnknown;   // the listbox entry for Unknown

#define             DOOMED_GLOBALS

#endif


