// Help Routines for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"

int EXPORT DialogAbout(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam);

void DoomEdHelpContents(void)
{
}

void DoomEdHelpSearch(void)
{
}

void DoomEdHelpAbout(void)
{
  FARPROC lpfnDlgProc;
  lpfnDlgProc = MakeProcInstance((FARPROC)DialogAbout, hinst);
  if(lpfnDlgProc) {
    DialogBox(hinst,
              MAKEINTRESOURCE(IDD_ABOUT),
              hwnd,
              lpfnDlgProc);
    FreeProcInstance(lpfnDlgProc);
    }
}

void DoomEdHelpSupport(void)
{
  FARPROC lpfnDlgProc;
  lpfnDlgProc = MakeProcInstance((FARPROC)SimpleDialog, hinst);
  if(lpfnDlgProc) {
    DialogBox(hinst,
              MAKEINTRESOURCE(IDD_SHAREWARE),
              hwnd,
              lpfnDlgProc);
    FreeProcInstance(lpfnDlgProc);
    }
}

int EXPORT SimpleDialog(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam)
{
  switch(wMsg)
    {
    case WM_COMMAND:
      EndDialog(hDlg, IDOK);
      return TRUE;
    default:
      return FALSE;
    }
}

void SeriousError(char *Message)
{
  wsprintf(lpszMessage, "Serious Program Fault\n"
                        "%s\n", Message);
  MessageBox(hwnd, lpszMessage, ProgErr, MB_ICONEXCLAMATION | MB_OK);
}

static HBITMAP hTitleBitmap = NULL;
static HWND  hStuff;

int EXPORT DialogAbout(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam)
{
  DWORD f0, v0;
  UINT  f1, f2, f3;
  unsigned long f4;
  struct _diskfree_t drive;
  char  szTemp1[128];
  int   len;
  
  switch(wMsg) 
    {
    case WM_INITDIALOG:
      hStuff = GetDlgItem(hDlg, IDC_SYSTEMINFO);
      f0 = GetFreeSpace(0);
      f1 = GetFreeSystemResources(GFSR_SYSTEMRESOURCES);
      f2 = GetFreeSystemResources(GFSR_GDIRESOURCES);
      f3 = GetFreeSystemResources(GFSR_USERRESOURCES);
      _dos_getdiskfree(0, &drive);
      f4 = (unsigned long)drive.avail_clusters * 
           ((unsigned long)drive.sectors_per_cluster * 
            (unsigned long)drive.bytes_per_sector);
      v0 = GetVersion();
      len = sprintf(szTemp1, "%lu\n%lu\n%u\n%u\n%u\n", f0,f4, f1, f2, f3);
      sprintf(szTemp1 + len, "%d.%d\n%d.%d",
              LOBYTE(LOWORD(v0)),
              HIBYTE(LOWORD(v0)),
              HIBYTE(HIWORD(v0)),
              LOBYTE(HIWORD(v0)));
      Static_SetText(hStuff, szTemp1);
      hTitleBitmap = BitmapFromDoom(DoomEntry("M_DOOM"));
      return FALSE;
      break;

    case WM_PAINT:
      {
      PAINTSTRUCT   ps;
      HDC           hMemDC;
      HBITMAP       old;
      
      BeginPaint(hDlg, &ps);
      hMemDC = CreateCompatibleDC(ps.hdc);
      old = SelectObject(hMemDC, hTitleBitmap);
      BitBlt(ps.hdc, 98, 5, BitmapWidth, BitmapHeight,
             hMemDC, 0, 0, SRCCOPY);
      SelectObject(hMemDC, old);
      DeleteDC(hMemDC);
      EndPaint(hDlg, &ps);
      }
      return FALSE;
      break;

    case WM_DESTROY:
      DeleteObject(hTitleBitmap);
      return FALSE;
      break;

    case WM_COMMAND:
      EndDialog(hDlg, IDOK);
      return TRUE;
    default:
      return FALSE;
    }
}
