// Listbox Fillers for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"

void FillListWithStyles(HWND hList)
{
  int   i;
  ListBox_ResetContent(hList);
  for(i=0; i<StylesNum; i++)
    ListBox_AddString(hList, Style[i].Name);
}

void FillListWithBuilders(HWND hList)
{
  int   i;
  ListBox_ResetContent(hList);
  for(i=0; i<BuildersNum; i++)
    ListBox_AddString(hList, Builder[i].Name);
}

void FillListWithTextures(HWND hList)
{
  int   i, j;
  ListBox_ResetContent(hList);
  j = ListBox_AddString(hList, "-");
  ListBox_SetItemData(hList, j, Nothing);
  for(i=0; i<TexturesNum; i++) {
    j = ListBox_AddString(hList, Texture[i].name);
    ListBox_SetItemData(hList, j, i);
    }
}

void FillListWithTiles(HWND hList)
{
  int   i, j;
  ListBox_ResetContent(hList);
  for(i=0; i<DoomEntries; i++)
    if(Doom[i].Type == WD_TILE) {
      j = ListBox_AddString(hList, Doom[i].Title);
      ListBox_SetItemData(hList, j, i);
      }
}

void FillListWithPanels(HWND hList)
{
  int   i, j;
  ListBox_ResetContent(hList);
  for(i=0; i<DoomEntries; i++)
    if(Doom[i].Type == WD_PANEL) {
      j = ListBox_AddString(hList, Doom[i].Title);
      ListBox_SetItemData(hList, j, i);
      }
}

void FillListWithSprites(HWND hList)
{
  int   i, j;
  ListBox_ResetContent(hList);
  for(i=0; i<DoomEntries; i++)
    if(Doom[i].Type == WD_SPRITE) {
      j = ListBox_AddString(hList, Doom[i].Title);
      ListBox_SetItemData(hList, j, i);
      }
}

void FillListWithGraphics(HWND hList)
{
  int   i, j;
  ListBox_ResetContent(hList);
  for(i=0; i<DoomEntries; i++)
    if((Doom[i].Type == WD_GRAPHIC) ||
       (Doom[i].Type == WD_PANEL)   ||
       (Doom[i].Type == WD_MENU)    ||
       (Doom[i].Type == WD_LEVEL)   ||
       (Doom[i].Type == WD_SPRITE)) {
      j = ListBox_AddString(hList, Doom[i].Title);
      ListBox_SetItemData(hList, j, i);
      }
}

void FillListWithPlatforms(HWND hList)
{
  int   i, j;
  char  szTemp[290];
  
  ListBox_ResetContent(hList);
  for(i=0; i<TagsNum; i++) {
    wsprintf(szTemp, "%s - %s", Tag[i].Name, Tag[i].Desc);
    j = ListBox_AddString(hList, szTemp);
    ListBox_SetItemData(hList, j, Tag[i].Num);
    }
}

void FillComboWithStyles(HWND hList)
{
  int   i;
  ComboBox_ResetContent(hList);
  for(i=0; i<StylesNum; i++)
    ComboBox_AddString(hList, Style[i].Name);
}

void FillComboWithTextures(HWND hList)
{
  int   i, j;
  ComboBox_ResetContent(hList);
  j = ComboBox_AddString(hList, "-");
  ComboBox_SetItemData(hList, j, Nothing);
  for(i=0; i<TexturesNum; i++) {
    j = ComboBox_AddString(hList, Texture[i].name);
    ComboBox_SetItemData(hList, j, i);
    }
}

void FillComboWithTiles(HWND hList)
{
  int   i, j;
  ComboBox_ResetContent(hList);
  for(i=0; i<DoomEntries; i++)
    if(Doom[i].Type == WD_TILE) {
      j = ComboBox_AddString(hList, Doom[i].Title);
      ComboBox_SetItemData(hList, j, i);
      }
}

void FillComboWithPanels(HWND hList)
{
  int   i, j;
  ComboBox_ResetContent(hList);
  for(i=0; i<DoomEntries; i++)
    if(Doom[i].Type == WD_PANEL) {
      j = ComboBox_AddString(hList, Doom[i].Title);
      ComboBox_SetItemData(hList, j, i);
      }
}

void FillComboWithSprites(HWND hList)
{
  int   i, j;
  ComboBox_ResetContent(hList);
  for(i=0; i<DoomEntries; i++)
    if(Doom[i].Type == WD_SPRITE) {
      j = ComboBox_AddString(hList, Doom[i].Title);
      ComboBox_SetItemData(hList, j, i);
      }
}

void FillComboWithGraphics(HWND hList)
{
  int   i, j;
  ComboBox_ResetContent(hList);
  for(i=0; i<DoomEntries; i++)
    if((Doom[i].Type == WD_GRAPHIC) ||
       (Doom[i].Type == WD_PANEL)   ||
       (Doom[i].Type == WD_MENU)    ||
       (Doom[i].Type == WD_LEVEL)   ||
       (Doom[i].Type == WD_SPRITE)) {
      j = ComboBox_AddString(hList, Doom[i].Title);
      ComboBox_SetItemData(hList, j, i);
      }
}

void FillComboWithPlatforms(HWND hList)
{
  int   i, j;
  char  szTemp[290];
  
  ComboBox_ResetContent(hList);
  for(i=0; i<TagsNum; i++) {
    wsprintf(szTemp, "%s - %s", Tag[i].Name, Tag[i].Desc);
    j = ComboBox_AddString(hList, szTemp);
    ComboBox_SetItemData(hList, j, Tag[i].Num);
    }
}

void FillComboWithSectorAttributes(HWND hList)
{
  ComboBox_ResetContent(hList);
  ComboBox_AddString(hList, "Normal");                          // 0
  ComboBox_AddString(hList, "Light: Flickering");               // 1
  ComboBox_AddString(hList, "Light: Fast Strobe");              // 2
  ComboBox_AddString(hList, "Light: Slow Strobe");              // 3
  ComboBox_AddString(hList, "Damage: SuperStrobe");             // 4
  ComboBox_AddString(hList, "Damage: HellSlime");               // 5
  ComboBox_AddString(hList, "Ceiling: Crush & Raise *");        // 6
  ComboBox_AddString(hList, "Damage: Nukage");                  // 7
  ComboBox_AddString(hList, "Light: Glowing");                  // 8
  ComboBox_AddString(hList, "Secret Area");                     // 9
  ComboBox_AddString(hList, "Door: Close in 30");               // 10
  ComboBox_AddString(hList, "Exit: Super Damage");              // 11
  ComboBox_AddString(hList, "Light: Synch Strobe Slow");        // 12
  ComboBox_AddString(hList, "Light: Synch Strobe Fast");        // 13
  ComboBox_AddString(hList, "Door: Raise in 5 Mins");           // 14
  ComboBox_AddString(hList, "15 - undefined (don\'t use!)");    // 15
  ComboBox_AddString(hList, "Damage: Super Hell Slime *");      // 16
  ComboBox_AddString(hList, "Light: Fire Flickering *");        // 17
  return;
}

void FillListWithLineAttributes(HWND hList)
{
  ListBox_ResetContent(hList);                                 //  bit  val
  ListBox_AddString(hList, "Nobody can cross");                //   0    1
  ListBox_AddString(hList, "Enemies cannot cross");            //   1    2
  ListBox_AddString(hList, "Two sided");                       //   2    4
  ListBox_AddString(hList, "Upper texture not \"pegged\"");    //   3    8
  ListBox_AddString(hList, "Lower texture not \"pegged\"");    //   4    10
  ListBox_AddString(hList, "Secret (don\'t map behind)");      //   5    20
  ListBox_AddString(hList, "Sound cannot cross");              //   6    40
  ListBox_AddString(hList, "Never shows on map");              //   7    80
  ListBox_AddString(hList, "Always shows on map");             //   8    100
}

#define AddOne(num, txt)  i=ComboBox_AddString(hList, txt);  \
                          ComboBox_SetItemData(hList, i, num);

void FillListWithLineDefActions(HWND hList)
{
  int   i;

  ComboBox_ResetContent(hList);
  AddOne(0, "- Normal -");  // the "-" makes it sort to the front
  // the following are direct from John Romero @ Id:
  AddOne(123, "Switch (Many): Blaze Down, Wait, Up, Stay. *");
  AddOne(116, "Switch (Many): Blazing Door Close *");
  AddOne(115, "Switch (Many): Blazing Door Open (stay) *");
  AddOne(114, "Switch (Many): Blazing Door Raise *");
  AddOne(99,  "Switch (Many): Blazing Door Open (stay) - Blue key");
  AddOne(134, "Switch (Many): Blazing Door Open (stay) - Red key");
  AddOne(136, "Switch (Many): Blazing Door Open (stay) - Yellow key");
  AddOne(42,  "Switch (Many): Close Door");
  AddOne(139, "Switch (Many): Light Off");
  AddOne(138, "Switch (Many): Light On");
  AddOne(43,  "Switch (Many): Lower Ceiling To Floor");
  AddOne(45,  "Switch (Many): Lower Floor");
  AddOne(60,  "Switch (Many): Lower Floor To Lowest Neighbor");
  AddOne(61,  "Switch (Many): Open Door (stay)");
  AddOne(62,  "Switch (Many): Platform Down, Wait, Up, Stay.");
  AddOne(63,  "Switch (Many): Raise Door");
  AddOne(64,  "Switch (Many): Raise Floor");
  AddOne(66,  "Switch (Many): Raise Floor 24");
  AddOne(67,  "Switch (Many): Raise Floor 32");
  AddOne(65,  "Switch (Many): Raise Floor Crush");
  AddOne(68,  "Switch (Many): Raise Floor Near & Change");
  AddOne(132, "Switch (Many): Raise Floor Turbo *");
  AddOne(69,  "Switch (Many): Raise To Nearest Floor");
  AddOne(70,  "Switch (Many): Turbo Lower Floor");
  AddOne(48,  "Effect: Horizontal Scroll");
  AddOne(46,  "Impact: Door Open (stay)");
  AddOne(24,  "Impact: Raise Floor");
  AddOne(47,  "Impact: Raise Floor Near & Change");
  AddOne(118, "Manual: Blazing Door Open (stay) *");
  AddOne(117, "Manual: Blazing Door Raise *");
  AddOne(31,  "Manual: Door Open (stay)");
  AddOne(32,  "Manual: Door Open (stay) - Blue key");
  AddOne(33,  "Manual: Door Open (stay) - Red key");
  AddOne(34,  "Manual: Door Open (stay) - Yellow key");
  AddOne(1,   "Manual: Door Raise");
  AddOne(26,  "Manual: Door Raise - Blue key");
  AddOne(28,  "Manual: Door Raise - Red key");
  AddOne(27,  "Manual: Door Raise - Yellow key");
  AddOne(120, "Cross (Many): Blaze Down, Wait, Up, Stay. *");
  AddOne(107, "Cross (Many): Blazing Door Close *");
  AddOne(106, "Cross (Many): Blazing Door Open (stay) *");
  AddOne(105, "Cross (Many): Blazing Door Raise *");
  AddOne(72,  "Cross (Many): Ceiling Crush");
  AddOne(73,  "Cross (Many): Ceiling Crush & Raise");
  AddOne(74,  "Cross (Many): Ceiling Crush Stop");
  AddOne(75,  "Cross (Many): Close Door");
  AddOne(76,  "Cross (Many): Close Door for 30 seconds");
  AddOne(77,  "Cross (Many): Fast Crush & Raise");
  AddOne(80,  "Cross (Many): Light Turn On");
  AddOne(81,  "Cross (Many): Light Turn On 255");
  AddOne(79,  "Cross (Many): Lights Very Dark");
  AddOne(78,  "Cross (Many): Lights To Dimmest Near *");
  AddOne(83,  "Cross (Many): Lower Floor");
  AddOne(84,  "Cross (Many): Lower Floor & Change");
  AddOne(82,  "Cross (Many): Lower Floor To Lowest");
  AddOne(85,  "Cross (Many): Lwr Floor Raise Ceiling *");
  AddOne(86,  "Cross (Many): Open Door");
  AddOne(87,  "Cross (Many): Perpetual Platform Raise");
  AddOne(88,  "Cross (Many): Platform Down, Wait, Up, Stay");
  AddOne(89,  "Cross (Many): Platform Stop");
  AddOne(90,  "Cross (Many): Raise Door");
  AddOne(91,  "Cross (Many): Raise Floor");
  AddOne(92,  "Cross (Many): Raise Floor 24");
  AddOne(94,  "Cross (Many): Raise Floor Crush");
  AddOne(129, "Cross (Many): Raise Floor Turbo *");
  AddOne(96,  "Cross (Many): Raise To Short Texture");
  AddOne(93,  "Cross (Many): Raise Floor 24 & Change");
  AddOne(95,  "Cross (Many): Raise Floor Near & Change");
  AddOne(128, "Cross (Many): Raise To Nearest Floor");
  AddOne(97,  "Cross (Many): TELEPORT");
  AddOne(126, "Cross (Many): TELEPORT Monster ONLY");
  AddOne(98,  "Cross (Many): Turbo Lower Floor");
  AddOne(122, "Switch (Once): Blaze Down, Wait, Up, Stay *");
  AddOne(113, "Switch (Once): Blazing Door Close *");
  AddOne(112, "Switch (Once): Blazing Door Open (stay) *");
  AddOne(111, "Switch (Once): Blazing Door Raise *");
  AddOne(133, "Switch (Once): Blazing Door Open (stay) - Blue key");
  AddOne(135, "Switch (Once): Blazing Door Open (stay) - Red key");
  AddOne(137, "Switch (Once): Blazing Door Open (stay) - Yellow key");
  AddOne(7,   "Switch (Once): Build Stairs");
  AddOne(127, "Switch (Once): Build Stairs Turbo 16 *");
  AddOne(49,  "Switch (Once): Ceiling Crush & Raise");
  AddOne(9,   "Switch (Once): Change Donut");
  AddOne(50,  "Switch (Once): Close Door");
  AddOne(11,  "Switch (Once): EXIT");
  AddOne(41,  "Switch (Once): Lower Ceiling To Floor");
  AddOne(102, "Switch (Once): Lower Floor");
  AddOne(23,  "Switch (Once): Lower Floor To Lowest");
  AddOne(103, "Switch (Once): Open Door");
  AddOne(21,  "Switch (Once): Platform Down, Wait, Up, Stay");
  AddOne(29,  "Switch (Once): Raise Door");
  AddOne(101, "Switch (Once): Raise Floor");
  AddOne(131, "Switch (Once): Raise Floor Turbo *");
  AddOne(55,  "Switch (Once): Raise Floor Crush");
  AddOne(15,  "Switch (Once): Raise Floor 24");
  AddOne(14,  "Switch (Once): Raise Floor 32");
  AddOne(140, "Switch (Once): Raise Floor 512");
  AddOne(20,  "Switch (Once): Raise Floor Near & Change");
  AddOne(18,  "Switch (Once): Raise To Nearest Floor");
  AddOne(51,  "Switch (Once): Secret Exit");
  AddOne(71,  "Switch (Once): Turbo Lower Floor");
  AddOne(121, "Cross (Once): Blaze Down, Wait, Up, Stay *");
  AddOne(110, "Cross (Once): Blazing Door Close *");
  AddOne(109, "Cross (Once): Blazing Door Open (stay) *");
  AddOne(108, "Cross (Once): Blazing Door Raise *");
  AddOne(8,   "Cross (Once): Build Stairs");
  AddOne(100, "Cross (Once): Build Stairs Turbo 16 *");
  AddOne(44,  "Cross (Once): Ceiling Crush");
  AddOne(25,  "Cross (Once): Ceiling Crush & Raise");
  AddOne(57,  "Cross (Once): Ceiling Crush Stop");
  AddOne(3,   "Cross (Once): Close Door");
  AddOne(16,  "Cross (Once): Close Door for 30 seconds");
  AddOne(52,  "Cross (Once): EXIT");
  AddOne(6,   "Cross (Once): Fast Crush & Raise");
  AddOne(104, "Cross (Once): Lights To Dimmest Near *");
  AddOne(35,  "Cross (Once): Lights Very Dark");
  AddOne(12,  "Cross (Once): Light Turn On");
  AddOne(13,  "Cross (Once): Light Turn On 255");
  AddOne(38,  "Cross (Once): Lower Floor To Lowest");
  AddOne(19,  "Cross (Once): Lower Floor");
  AddOne(37,  "Cross (Once): Lower Floor & Change");
  AddOne(40,  "Cross (Once): Lower Floor Raise Ceiling");
  AddOne(2,   "Cross (Once): Open Door");
  AddOne(53,  "Cross (Once): Perpetual Platform Raise");
  AddOne(10,  "Cross (Once): Platform Down, Wait, Up, Stay");
  AddOne(54,  "Cross (Once): Platform Stop");
  AddOne(4,   "Cross (Once): Raise Door");
  AddOne(5,   "Cross (Once): Raise Floor");
  AddOne(58,  "Cross (Once): Raise Floor 24");
  AddOne(59,  "Cross (Once): Raise Floor 24 & Change");
  AddOne(130, "Cross (Once): Raise Floor Turbo");
  AddOne(56,  "Cross (Once): Raise Floor Crush *");
  AddOne(22,  "Cross (Once): Raise Floor Near & Change");
  AddOne(119, "Cross (Once): Raise To Nearest Floor");
  AddOne(30,  "Cross (Once): Raise To Short Texture");
  AddOne(124, "Cross (Once): Secret Exit");
  AddOne(141, "Cross (Once): Silent Ceiling Crush and Raise");
  AddOne(17,  "Cross (Once): Start Slow Strobing");
  AddOne(39,  "Cross (Once): TELEPORT");
  AddOne(125, "Cross (Once): TELEPORT Monster ONLY");
  AddOne(36,  "Cross (Once): Turbo Lower Floor");
}
 
void FillComboWithDirections(HWND hList)
{
  ComboBox_ResetContent(hList);
  ComboBox_AddString(hList, "East");
  ComboBox_SetItemData(hList, 0, 0);
  ComboBox_AddString(hList, "NorthEast");
  ComboBox_SetItemData(hList, 1, 45);
  ComboBox_AddString(hList, "North");
  ComboBox_SetItemData(hList, 2, 90);
  ComboBox_AddString(hList, "NorthWest");
  ComboBox_SetItemData(hList, 3, 135);
  ComboBox_AddString(hList, "West");
  ComboBox_SetItemData(hList, 4, 180);
  ComboBox_AddString(hList, "SouthWest");
  ComboBox_SetItemData(hList, 5, 225);
  ComboBox_AddString(hList, "South");
  ComboBox_SetItemData(hList, 6, 270);
  ComboBox_AddString(hList, "SouthEast");
  ComboBox_SetItemData(hList, 7, 315);
}

int FillComboWithThings(HWND hList)
{
  int   i, j;
  
  ComboBox_ResetContent(hList);
  for(i = 0; ThingDesc[i].num > 0; i++) {
    j = ComboBox_AddString(hList, ThingDesc[i].desc);
    ComboBox_SetItemData(hList, j, ThingDesc[i].num);
    }
  j = ComboBox_AddString(hList, "Unknown");
  ComboBox_SetItemData(hList, j, 0);
  ComboBox_SetCurSel(hList, Nothing);
  return j;     // return the "unknown" value
} 