// Macros for DoomEd 4.0
//
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

// completely erase a texture name in the destination:
#define NullWall(to)    {                                           \
                        int tqtq;                                   \
                        to[0] = '-';                                \
                        for(tqtq = 1; tqtq < 8; tqtq++)             \
                          to[tqtq] = '\0';                          \
                        }
// copy one texture to another, erasing trailing garbage:
#define CopyWall(to, fr) {                                          \
                         NullWall(to);                              \
                         strncpy(to, fr, 8);                        \
                         }

// set cursor to hourglass:
#define CURSOR_BUSY     oldCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
// set cursor back to normal:
#define CURSOR_NOTBUSY  SetCursor(oldCursor);

// load message into lpszMessage:
#define MESSAGE(var)    LoadString(hinst, var,                      \
                                   lpszMessage,                     \
                                   sizeof(lpszMessage));
// check if linedef is two sided:
#define TwoSided(a)     (((LineDef[a].sidedef1 != Nothing) &&       \
                          (LineDef[a].sidedef2 != Nothing)) ?       \
                          TRUE : FALSE)
// check if linedef is one sided:
#define OneSided(a)     (((LineDef[a].sidedef1 == Nothing) ||       \
                          (LineDef[a].sidedef2 == Nothing)) ?       \
                          TRUE : FALSE)
// load and display a message:
#define Message(var)    {                                           \
                        char lpszMess[200];                         \
                        LoadString(hinst, var,                      \
                                   lpszMess,                        \
                                   sizeof(lpszMess));               \
                        MessageBox(hwnd, lpszMess,                  \
                                   ProgName,                        \
                                   MB_ICONINFORMATION | MB_OK);     \
                        }
// load and display an error message:
#define ErrorMessage(var) {                                         \
                        char lpszMess[200];                         \
                        LoadString(hinst, var,                      \
                                   lpszMess,                        \
                                   sizeof(lpszMess));               \
                        MessageBox(hwnd, lpszMess,                  \
                                   ProgErr,                         \
                                   MB_ICONSTOP | MB_OK);            \
                        }
                                   
// hide and show windows:
#define HIDE_HWND(var)  ShowWindow(var, SW_HIDE);
#define SHOW_HWND(var)  ShowWindow(var, SW_NORMAL);

#define SharewareVersion (!RegisteredVersion)

#define SetLineBit(var, w)  LineDef[var].solidity |= w;     // logical or
#define ClearLineBit(var,w) LineDef[var].solidity |= w;     \
                            LineDef[var].solidity ^= w;     // logical not
#define TestLineBit(var, w) (LineDef[var].solidity & w)     // logical and

#if defined ( _DEBUG)
#define Assert(t)           if(!(t)) {                                  \
                            sprintf(lpszMessage, "Assertion Failed:\n"  \
                            "File: "                                    \
                            __FILE__                                    \
                            ", Line: %u", __LINE__);                    \
                            MessageBox(NULL, lpszMessage, "Assertion",  \
                                       MB_ICONEXCLAMATION | MB_OK);     \
                            }
#else
#define Assert(t)           ; // Assert: t
#endif
