// Memory Management for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"

void AllocateSectors(int num)
{
  // no change, go back
  if(num == MAX_SECTOR)
    return;
  
  // Destroy existing data and reallocate new space:
  if(num < MAX_SECTOR) {
    GlobalUnlock(hgSector);  GlobalFree(hgSector);
    GlobalUnlock(hgeSector); GlobalFree(hgeSector);
    hgSector   = GlobalAlloc(GHND, (DWORD)num * sizeof(WadSectors));
    hgeSector  = GlobalAlloc(GHND, (DWORD)num * sizeof(ExtraSectors));
    Sector     = (WadSectors __huge *)  GlobalLock(hgSector);
    eSector    = (ExtraSectors __huge *)GlobalLock(hgeSector);
    MAX_SECTOR = num;
    return;
    }
    
  // Use GlobalReAlloc to expand storage:
  GlobalUnlock(hgSector);
  GlobalUnlock(hgeSector);
  hgSector   = GlobalReAlloc(hgSector,  (DWORD)num * sizeof(WadSectors), GHND);
  hgeSector  = GlobalReAlloc(hgeSector, (DWORD)num * sizeof(ExtraSectors), GHND);
  Sector     = (WadSectors __huge *)  GlobalLock(hgSector);
  eSector    = (ExtraSectors __huge *)GlobalLock(hgeSector);
  MAX_SECTOR = num;
}

void AllocateLineDefs(int num)
{
  // no change, go back
  if(num == MAX_LINEDEF)
    return;
  
  // Destroy existing data and reallocate new space:
  if(num < MAX_LINEDEF) {
    GlobalUnlock(hgLineDef);  GlobalFree(hgLineDef);
    GlobalUnlock(hgeLineDef); GlobalFree(hgeLineDef);
    hgLineDef   = GlobalAlloc(GHND, (DWORD)num * sizeof(WadLineDefs));
    hgeLineDef  = GlobalAlloc(GHND, (DWORD)num * sizeof(ExtraLineDefs));
    LineDef     = (WadLineDefs __huge *)  GlobalLock(hgLineDef);
    eLineDef    = (ExtraLineDefs __huge *)GlobalLock(hgeLineDef);
    MAX_LINEDEF = num;
    return;
    }
    
  // Use GlobalReAlloc to expand storage:
  GlobalUnlock(hgLineDef);
  GlobalUnlock(hgeLineDef);
  hgLineDef   = GlobalReAlloc(hgLineDef,  (DWORD)num * sizeof(WadLineDefs), GHND);
  hgeLineDef  = GlobalReAlloc(hgeLineDef, (DWORD)num * sizeof(ExtraLineDefs), GHND);
  LineDef     = (WadLineDefs __huge *)  GlobalLock(hgLineDef);
  eLineDef    = (ExtraLineDefs __huge *)GlobalLock(hgeLineDef);
  MAX_LINEDEF = num;
}

void AllocateSideDefs(int num)
{
  // no change, go back
  if(num == MAX_SIDEDEF)
    return;
  
  // Destroy existing data and reallocate new space:
  if(num < MAX_SIDEDEF) {
    GlobalUnlock(hgSideDef);  GlobalFree(hgSideDef);
    GlobalUnlock(hgeSideDef); GlobalFree(hgeSideDef);
    hgSideDef   = GlobalAlloc(GHND, (DWORD)num * sizeof(WadSideDefs));
    hgeSideDef  = GlobalAlloc(GHND, (DWORD)num * sizeof(ExtraSideDefs));
    SideDef     = (WadSideDefs __huge *)GlobalLock(hgSideDef);
    eSideDef    = (ExtraSideDefs __huge *)     GlobalLock(hgeSideDef);
    MAX_SIDEDEF = num;
    return;
    }
    
  // Use GlobalReAlloc to expand storage:
  GlobalUnlock(hgSideDef);
  GlobalUnlock(hgeSideDef);
  hgSideDef   = GlobalReAlloc(hgSideDef,  (DWORD)num * sizeof(WadSideDefs), GHND);
  hgeSideDef  = GlobalReAlloc(hgeSideDef, (DWORD)num * sizeof(ExtraSideDefs), GHND);
  SideDef     = (WadSideDefs __huge *)  GlobalLock(hgSideDef);
  eSideDef    = (ExtraSideDefs __huge *)GlobalLock(hgeSideDef);
  MAX_SIDEDEF = num;
}

void AllocateThings(int num)
{
  // no change, go back
  if(num == MAX_THING)
    return;
  
  // Destroy existing data and reallocate new space:
  if(num < MAX_THING) {
    GlobalUnlock(hgThing);  GlobalFree(hgThing);
    GlobalUnlock(hgeThing); GlobalFree(hgeThing);
    hgThing   = GlobalAlloc(GHND, (DWORD)num * sizeof(WadThings));
    hgeThing  = GlobalAlloc(GHND, (DWORD)num * sizeof(ExtraThings));
    Thing     = (WadThings __huge *)  GlobalLock(hgThing);
    eThing    = (ExtraThings __huge *)GlobalLock(hgeThing);
    MAX_THING = num;
    return;
    }
    
  // Use GlobalReAlloc to expand storage:
  GlobalUnlock(hgThing);
  GlobalUnlock(hgeThing);
  hgThing   = GlobalReAlloc(hgThing,  (DWORD)num * sizeof(WadThings), GHND);
  hgeThing  = GlobalReAlloc(hgeThing, (DWORD)num * sizeof(ExtraThings), GHND);
  Thing     = (WadThings __huge *)  GlobalLock(hgThing);
  eThing    = (ExtraThings __huge *)GlobalLock(hgeThing);
  MAX_THING = num;
}

void AllocateVertex(int num)
{
  // no change, go back
  if(num == MAX_VERTEX)
    return;
  
  // any size reduction bypasses GlobalReAlloc to avoid MS bug
  if(num < MAX_VERTEX) {
    GlobalUnlock(hgVertex);  GlobalFree(hgVertex);
    GlobalUnlock(hgeVertex); GlobalFree(hgeVertex);
    hgVertex   = GlobalAlloc(GHND, (DWORD)num * sizeof(POINT));
    hgeVertex  = GlobalAlloc(GHND, (DWORD)num * sizeof(ExtraVertex));
    Vertex     = (POINT __huge *)      GlobalLock(hgVertex);
    eVertex    = (ExtraVertex __huge *)GlobalLock(hgeVertex);
    MAX_VERTEX = num;
    return;
    }
    
  // use GlobalReAlloc to get a larger amount of memory:
  GlobalUnlock(hgVertex);
  GlobalUnlock(hgeVertex);
  hgVertex   = GlobalReAlloc(hgVertex,  (DWORD)num * sizeof(POINT), GHND);
  hgeVertex  = GlobalReAlloc(hgeVertex, (DWORD)num * sizeof(ExtraVertex), GHND);
  Vertex     = (POINT __huge *)      GlobalLock(hgVertex);
  eVertex    = (ExtraVertex __huge *)GlobalLock(hgeVertex);

  MAX_VERTEX = num;
}

void AllocateNodes(int num)
{
  // no change, go back
  if(num == MAX_NODE)
    return;
  
  // Destroy existing data and reallocate new space:
  if(num < MAX_NODE) {
    GlobalUnlock(hgNode); GlobalFree(hgNode);
    hgNode   = GlobalAlloc(GHND, (DWORD)num * sizeof(WadNodes));
    Node     = (WadNodes __huge *)GlobalLock(hgNode);
    MAX_NODE = num;
    return;
    }
    
  // Use GlobalReAlloc to expand storage:
  GlobalUnlock(hgNode);
  hgNode   = GlobalReAlloc(hgNode, (DWORD)num * sizeof(WadNodes), GHND);
  Node     = (WadNodes __huge *)GlobalLock(hgNode);
  MAX_NODE = num;
}

void AllocateSSectors(int num)
{
  // no change, go back
  if(num == MAX_SSECTOR)
    return;
  
  // Destroy existing data and reallocate new space:
  if(num < MAX_SSECTOR) {
    GlobalUnlock(hgSSector); GlobalFree(hgSSector);
    hgSSector   = GlobalAlloc(GHND, (DWORD)num * sizeof(WadSSectors));
    SSector     = (WadSSectors __huge *)GlobalLock(hgSSector);
    MAX_SSECTOR = num;
    return;
    }
    
  // Use GlobalReAlloc to expand storage:
  GlobalUnlock(hgSSector);
  hgSSector   = GlobalReAlloc(hgSSector, (DWORD)num * sizeof(WadSSectors), GHND);
  SSector     = (WadSSectors __huge *)GlobalLock(hgSSector);
  MAX_SSECTOR = num;
}

void AllocateSegs(int num)
{
  // no change, go back
  if(num == MAX_SEG)
    return;
  
  // Destroy existing data and reallocate new space:
  if(num < MAX_SEG) {
    GlobalUnlock(hgSeg); GlobalFree(hgSeg);
    hgSeg   = GlobalAlloc(GHND, (DWORD)num * sizeof(WadSegs));
    Seg     = (WadSegs __huge *)GlobalLock(hgSeg);
    MAX_SEG = num;
    return;
    }
    
  // Use GlobalReAlloc to expand storage:
  GlobalUnlock(hgSeg);
  hgSeg   = GlobalReAlloc(hgSeg, (DWORD)num * sizeof(WadSegs), GHND);
  Seg     = (WadSegs __huge *)GlobalLock(hgSeg);
  MAX_SEG = num;
}



