// Printing for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"

static POINT    WhereToTitle;

void SetPrintMapping(HDC hDc) {
  int   extra;
  float ratioX, ratioY;
  SIZE  MapSize, PageSize;
  RECT  rc, pc; // PseudoCoordinates
  
  // adjust so map is centered in window
  SetMapMode(hDc, MM_TEXT);
  rc.left = 0;
  rc.right = GetDeviceCaps(hDc, HORZRES);
  rc.bottom = 0;
  rc.top = GetDeviceCaps(hDc, VERTRES);

  PageSize.cx = rc.right;               // total width
  PageSize.cy = rc.top;                 // total height
  pc = MapExtent;                       // get map extents
  MapSize.cx = pc.right - pc.left;      // total world width
  MapSize.cy = pc.top - pc.bottom;      // total world height
  ratioX = (float)MapSize.cx / (float)PageSize.cx;
  ratioY = (float)MapSize.cy / (float)PageSize.cy;
  if(ratioX > ratioY) {
    extra = (int)((float)PageSize.cy * (float)ratioX) - MapSize.cy;
    pc.top += (extra / 2); pc.bottom -= (extra / 2); }
  else {
    extra = (int)((float)PageSize.cx * (float)ratioY) - MapSize.cx;
    pc.left -= (extra / 2); pc.right += (extra / 2); }
  MapSize.cx = pc.right - pc.left;      // new world width
  MapSize.cy = pc.top - pc.bottom;      // new world height
  WhereToTitle.x = pc.left;
  WhereToTitle.y = MapExtent.top;
  // setup Windows mapping so logical and physical units are correct.
  SetMapMode(hDc, MM_ISOTROPIC);
  SetWindowExt(hDc, MapSize.cx, -MapSize.cy);
  SetViewportExt(hDc, PageSize.cx, PageSize.cy);
  SetWindowOrg(hDc, pc.left, pc.top);
  return;
}

void PrintMap(void)
{
  PRINTDLG  pd;
  DOCINFO   di;
  char      szTemp[128];
  int       i;
  HPEN      hThickLine, hThinLine, hOriginal;
  
  if(!MapLoaded)
    return;

  memset(&pd, 0, sizeof(PRINTDLG));
  memset(&di, 0, sizeof(DOCINFO));

  pd.lStructSize = sizeof(PRINTDLG);
  pd.hwndOwner = hwnd;
  pd.Flags = PD_RETURNDC;

  if(PrintDlg(&pd)) {
    RepaintMap();
    hThickLine = CreatePen(PS_SOLID, 8, RGB(0, 0, 0));
    hThinLine = CreatePen(PS_SOLID, 1, RGB(0, 0, 0));
    wsprintf(szTemp, "DoomEd 4: Map %s from %s", szMapName, szPrevFile1);
    di.cbSize = sizeof(DOCINFO);
    di.lpszDocName = szTemp;
    di.lpszOutput = NULL;

    StartDoc(pd.hDC, &di);
    StartPage(pd.hDC);

    TextOut(pd.hDC, 0, 10, szTemp, strlen(szTemp));

    SetPrintMapping(pd.hDC);

    hOriginal = SelectPen(pd.hDC, hThickLine);
    
    // walls:
    for(i=0; i<LineDefsNum; i++) {
      if(eLineDef[i].Used) {
        if((LineDef[i].sidedef1 != Nothing) &&
           (LineDef[i].sidedef1 != Nothing))
          SelectPen(pd.hDC, hThinLine);
        else 
          SelectPen(pd.hDC, hThickLine);
        MoveTo(pd.hDC, Vertex[LineDef[i].from].x,
                       Vertex[LineDef[i].from].y);
        LineTo(pd.hDC, Vertex[LineDef[i].to].x,
                       Vertex[LineDef[i].to].y);
        }   // endif
      }     // next i

    // things:
    SelectPen(pd.hDC, hThinLine);
    for(i=0; i<ThingsNum; i++) {
      if(eThing[i].Used) {
        Rectangle(pd.hDC, Thing[i].x-8, Thing[i].y-8,
                          Thing[i].x+8, Thing[i].y+8);
        }   // endif
      }     // next i

    SelectPen(pd.hDC, hOriginal);
    DeletePen(hThickLine);
    DeletePen(hThinLine);
    EndPage(pd.hDC);
    EndDoc(pd.hDC);
    DeleteDC(pd.hDC);
    if(pd.hDevMode != NULL)
      GlobalFree(pd.hDevMode);
    if(pd.hDevNames != NULL)
      GlobalFree(pd.hDevNames);
    }
  else
    MessageBox(hwnd, "Unable to print.", ProgErr, MB_ICONINFORMATION | MB_OK);

}