// Exit Routines for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"


long DoomEdClose(HWND hWnd)
{
//  if(MapEdited)
//  DoSave();           // see if we need to save map changes
  if(oVerifyExit)
    if(MessageBox(hwnd,"This will end your DoomEd session.\n"
                       "Are you sure?",
                  ProgName, MB_ICONQUESTION | MB_YESNO)==IDNO)
      return FALSE;
  if(PaletteLoaded)
    DeletePalette(hPalette);
  PopupQuit();  // deallocate the popup menus
  DestroyWindow(hWnd);
  return TRUE;
}

void DoomEdDestroy(void)
{
  int   i;
  char  szTemp[32], szNum[32];
  
  // unlock the memory and free pointers:
  GlobalUnlock(hgDoom);      GlobalFree(hgDoom);
  GlobalUnlock(hgDir);       GlobalFree(hgDir);
  GlobalUnlock(hgThing);     GlobalFree(hgThing);
  GlobalUnlock(hgLineDef);   GlobalFree(hgLineDef);
  GlobalUnlock(hgSideDef);   GlobalFree(hgSideDef);
  GlobalUnlock(hgSeg);       GlobalFree(hgSeg);
  GlobalUnlock(hgSSector);   GlobalFree(hgSSector);
  GlobalUnlock(hgVertex);    GlobalFree(hgVertex);
  GlobalUnlock(hgNode);      GlobalFree(hgNode);
  GlobalUnlock(hgSector);    GlobalFree(hgSector);
  GlobalUnlock(hgTag);       GlobalFree(hgTag);
  GlobalUnlock(hgReject);    GlobalFree(hgReject);
  GlobalUnlock(hgBlockMap);  GlobalFree(hgBlockMap);
  GlobalUnlock(hgProblem);   GlobalFree(hgProblem);

  GlobalUnlock(hgPalette);   GlobalFree(hgPalette);
  
// save the options into the .ini file
  sprintf(szTemp, "%lX", ColorBackground);
  WritePrivateProfileString("Colors", "Background",
                            szTemp, IniFile);
  sprintf(szTemp, "%lX", ColorMapLines);
  WritePrivateProfileString("Colors", "MapLines",
                            szTemp, IniFile);
  sprintf(szTemp, "%lX", ColorMapInnerLines);
  WritePrivateProfileString("Colors", "MapInnerLines",
                            szTemp, IniFile);
  sprintf(szTemp, "%lX", ColorSelected);
  WritePrivateProfileString("Colors", "Selected",
                            szTemp, IniFile);
  sprintf(szTemp, "%lX", ColorMarked);
  WritePrivateProfileString("Colors", "Marked",
                            szTemp, IniFile);
  sprintf(szTemp, "%lX", ColorGrid);
  WritePrivateProfileString("Colors", "Grid",
                            szTemp, IniFile);
  sprintf(szTemp, "%lX", ColorUserGrid);
  WritePrivateProfileString("Colors", "UserGrid",
                            szTemp, IniFile);
  // selectable options:
  sprintf(szTemp, "%u", oVerifyExit);
  WritePrivateProfileString("Options", "VerifyExit",
                            szTemp,IniFile);
  sprintf(szTemp, "%u", oShowSnapToGrid);
  WritePrivateProfileString("Options", "ShowSnapToGrid",
                            szTemp, IniFile);
  sprintf(szTemp, "%u", oShow64x64Grid);
  WritePrivateProfileString("Options", "Show64x64Grid",
                            szTemp, IniFile);
  sprintf(szTemp, "%u", oBuildNodesAtEverySave);
  WritePrivateProfileString("Options", "BuildNodesAtEverySave",
                            szTemp, IniFile);
  sprintf(szTemp, "%u", oAutoStitchDuringConstruction);
  WritePrivateProfileString("Options", "AutoStitchDuringConstruction",
                            szTemp, IniFile);
  sprintf(szTemp, "%u", oAutoLoadMostRecentFile);
  WritePrivateProfileString("Options", "AutoLoadMostRecentFile",
                            szTemp, IniFile);
  sprintf(szTemp, "%u", oVerifyAfterEdit);
  WritePrivateProfileString("Options", "VerifyAfterEdit",
                            szTemp, IniFile);
  sprintf(szTemp, "%u", NodeBuilderAction);
  WritePrivateProfileString("Options", "NodeBuilder",
                            szTemp, IniFile);
  sprintf(szTemp, "%u", RejectAction);
  WritePrivateProfileString("Options", "RejectBuilder",
                            szTemp, IniFile);
  sprintf(szTemp, "%u", GridSize);
  WritePrivateProfileString("Options", "GridSize",
                            szTemp, IniFile);
  // write the four most recently accessed files:
  WritePrivateProfileString("Files", "RecentFile1",
                            szPrevFile1, IniFile);
  WritePrivateProfileString("Files", "RecentFile2",
                            szPrevFile2, IniFile);
  WritePrivateProfileString("Files", "RecentFile3",
                            szPrevFile3, IniFile);
  WritePrivateProfileString("Files", "RecentFile4",
                            szPrevFile4, IniFile);

  // write editors:
  WritePrivateProfileString("Editors", "Graphics",
                            szEditorGraphics, IniFile);
  WritePrivateProfileString("Editors", "Text",
                            szEditorText, IniFile);
  WritePrivateProfileString("Editors", "Ansi",
                            szEditorAnsi, IniFile);
  WritePrivateProfileString("Editors", "Sound",
                            szEditorSound, IniFile);
  WritePrivateProfileString("Editors", "Music",
                            szEditorMusic, IniFile);

  // write styles:
  sprintf(szTemp, "%u", StylesNum);
  WritePrivateProfileString("Styles", "NumberOfStyles",
                            szTemp, IniFile);
  for(i=0; i<StylesNum; i++) {
    sprintf(szNum, "Style%u", i);
    WritePrivateProfileString(szNum, "Name",
                              Style[i].Name, IniFile);
    szTemp[8] = '\0';   // force null termination
    CopyWall(szTemp, Style[i].Floor);
    WritePrivateProfileString(szNum, "Floor",
                              szTemp, IniFile);
    CopyWall(szTemp, Style[i].Ceiling);
    WritePrivateProfileString(szNum, "Ceiling",
                              szTemp, IniFile);
    CopyWall(szTemp, Style[i].Walls);
    WritePrivateProfileString(szNum, "Walls",
                              szTemp, IniFile);
    }

  GlobalUnlock(hgStyle);  GlobalFree(hgStyle);

  // write Builders:
  sprintf(szTemp, "%u", BuildersNum);
  WritePrivateProfileString("Builders", "NumberOfBuilders",
                            szTemp, IniFile);
  for(i=0; i<BuildersNum; i++) {
    sprintf(szNum, "Builder%u", i);
    WritePrivateProfileString(szNum, "Name",
                              Builder[i].Name, IniFile);
    WritePrivateProfileString(szNum, "Command",
                              Builder[i].Command, IniFile);
    sprintf(szTemp, "%u", Builder[i].Format);
    WritePrivateProfileString(szNum, "Format",
                              szTemp, IniFile);
    }

  GlobalUnlock(hgBuilder);  GlobalFree(hgBuilder);

  // write the current default sector and wall info:
  WritePrivateProfileString("DefaultSettings", "Walls",
                            DefaultSectorWall, IniFile);
  WritePrivateProfileString("DefaultSettings", "Floor",
                            DefaultSectorFloor, IniFile);
  WritePrivateProfileString("DefaultSettings", "Ceiling",
                            DefaultSectorCeil, IniFile);
  sprintf(szTemp, "%u", DefaultSectorBottom);
  WritePrivateProfileString("DefaultSettings", "FloorHeight",
                            szTemp, IniFile);
  sprintf(szTemp, "%u", DefaultSectorTop);
  WritePrivateProfileString("DefaultSettings", "CeilingHeight",
                            szTemp, IniFile);
  sprintf(szTemp, "%u", DefaultSectorLight);
  WritePrivateProfileString("DefaultSettings", "Light",
                            szTemp, IniFile);

  // return resources:
  SelectPen(hdc, hOriginalPen);
  SelectBrush(hdc, hOriginalBrush);

  DeletePen(hPenBackground);
  DeletePen(hPenMapLines);
  DeletePen(hPenMapInnerLines);
  DeletePen(hPenSelected);
  DeletePen(hPenMarked);
  DeletePen(hPenGrid);
  DeletePen(hPenUserGrid);
  DeleteBrush(hBrushBackground);
  DeleteBrush(hBrushMapLines);
  DeleteBrush(hBrushMapInnerLines);
  DeleteBrush(hBrushSelected);
  DeleteBrush(hBrushMarked);
  DeleteBrush(hBrushGrid);
  DeleteBrush(hBrushUserGrid);

  free(Texture);
  free(PName);

  UnregisterClass("DoomEdDialog", hinst);
  PostQuitMessage(0);       // get us OUT of here
}

