// Internal Reject builder for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"

#define THRESHOLD 600

POINT SectorCenter(int num)
{
  POINT center;
  center.x = eSector[num].Extent.left +
             ((eSector[num].Extent.right - eSector[num].Extent.left) / 2);
  center.y = eSector[num].Extent.bottom +
             ((eSector[num].Extent.top - eSector[num].Extent.bottom) / 2);
  return center;
}

int idist(POINT p1, POINT p2)
{
  POINT t1 = p1, t2 = p2;
  if((t2.x -= t1.x) < 0) t2.x = -t2.x;
  if((t2.y -= t1.y) < 0) t2.y = -t2.y;
  return (t2.x + t2.y - (((t2.x > t2.y) ? t2.y : t2.x) >> 1));
}

void ResetRejectBit(DWORD bit)
{
     Reject[bit/8] &= ~(0x1 << (bit % 8)); 
}

void BuildReject(void)
{
  int   i, j;

  BottomMessage("Building Reject...");
  RejectSize = (((DWORD)SectorsNum * (DWORD)SectorsNum) / 8);
  _fmemset(Reject, 0xff, (size_t)RejectSize);

  if(RejectAction == REJECT_QUICK) {
//  Quick Method: test centers:
    POINT c1, c2;
    GetSectorExtents();
    for(i = 0; i < SectorsNum; i++)
      if(eSector[i].Used) {
        c1 = SectorCenter(i);
        for(j = 0; j < SectorsNum; j++)
          if(eSector[j].Used) {
            c2 = SectorCenter(j);
            if(idist(c1, c2) <= THRESHOLD)
              ResetRejectBit((DWORD)j * (DWORD)SectorsNum + (DWORD)i);
            }
        }
    return;
    }

// Thorough Method: test vertices:
  CURSOR_BUSY

  int   s1, s2;
  for(i = 0; i < LineDefsNum; i++)
    if(eLineDef[i].Used) {
      if(LineDef[i].sidedef1 != Nothing) {
        s1 = SideDef[LineDef[i].sidedef1].sector;
        for(j = 0; j < LineDefsNum; j++)
          if(eLineDef[j].Used) {
            if(LineDef[j].sidedef1 != Nothing) {
              s2 = SideDef[LineDef[j].sidedef1].sector;
              if(idist(Vertex[LineDef[i].from],
                       Vertex[LineDef[j].from]) <= THRESHOLD)
                ResetRejectBit((DWORD)s1 * (DWORD)SectorsNum + (DWORD)s2);
              if(idist(Vertex[LineDef[i].from],
                       Vertex[LineDef[j].to]) <= THRESHOLD)
                ResetRejectBit((DWORD)s1 * (DWORD)SectorsNum + (DWORD)s2);
              if(idist(Vertex[LineDef[i].to],
                       Vertex[LineDef[j].from]) <= THRESHOLD)
                ResetRejectBit((DWORD)s1 * (DWORD)SectorsNum + (DWORD)s2);
              if(idist(Vertex[LineDef[i].to],
                       Vertex[LineDef[j].to]) <= THRESHOLD)
                ResetRejectBit((DWORD)s1 * (DWORD)SectorsNum + (DWORD)s2);
              }     // endif Linedef[j].sidedef1 != Nothing
            if(LineDef[j].sidedef2 != Nothing) {
              s2 = SideDef[LineDef[j].sidedef2].sector;
              if(idist(Vertex[LineDef[i].from],
                       Vertex[LineDef[j].from]) <= THRESHOLD)
                ResetRejectBit((DWORD)s1 * (DWORD)SectorsNum + (DWORD)s2);
              if(idist(Vertex[LineDef[i].from],
                       Vertex[LineDef[j].to]) <= THRESHOLD)
                ResetRejectBit((DWORD)s1 * (DWORD)SectorsNum + (DWORD)s2);
              if(idist(Vertex[LineDef[i].to],
                       Vertex[LineDef[j].from]) <= THRESHOLD)
                ResetRejectBit((DWORD)s1 * (DWORD)SectorsNum + (DWORD)s2);
              if(idist(Vertex[LineDef[i].to],
                       Vertex[LineDef[j].to]) <= THRESHOLD)
                ResetRejectBit((DWORD)s1 * (DWORD)SectorsNum + (DWORD)s2);
              }     // endif Linedef[j].sidedef2 != Nothing
            }       // endif Linedef[j].Used
        }           // endif Linedef[i].sidedef1 != Nothing
      if(LineDef[i].sidedef2 != Nothing) {
        s1 = SideDef[LineDef[i].sidedef2].sector;
        for(j = 0; j < LineDefsNum; j++)
          if(eLineDef[j].Used) {
            if(LineDef[j].sidedef1 != Nothing) {
              s2 = SideDef[LineDef[j].sidedef1].sector;
              if(idist(Vertex[LineDef[i].from],
                       Vertex[LineDef[j].from]) <= THRESHOLD)
                ResetRejectBit((DWORD)s1 * (DWORD)SectorsNum + (DWORD)s2);
              if(idist(Vertex[LineDef[i].from],
                       Vertex[LineDef[j].to]) <= THRESHOLD)
                ResetRejectBit((DWORD)s1 * (DWORD)SectorsNum + (DWORD)s2);
              if(idist(Vertex[LineDef[i].to],
                       Vertex[LineDef[j].from]) <= THRESHOLD)
                ResetRejectBit((DWORD)s1 * (DWORD)SectorsNum + (DWORD)s2);
              if(idist(Vertex[LineDef[i].to],
                       Vertex[LineDef[j].to]) <= THRESHOLD)
                ResetRejectBit((DWORD)s1 * (DWORD)SectorsNum + (DWORD)s2);
              }     // endif Linedef[j].sidedef1 != Nothing
            if(LineDef[j].sidedef2 != Nothing) {
              s2 = SideDef[LineDef[j].sidedef2].sector;
              if(idist(Vertex[LineDef[i].from],
                       Vertex[LineDef[j].from]) <= THRESHOLD)
                ResetRejectBit((DWORD)s1 * (DWORD)SectorsNum + (DWORD)s2);
              if(idist(Vertex[LineDef[i].from],
                       Vertex[LineDef[j].to]) <= THRESHOLD)
                ResetRejectBit((DWORD)s1 * (DWORD)SectorsNum + (DWORD)s2);
              if(idist(Vertex[LineDef[i].to],
                       Vertex[LineDef[j].from]) <= THRESHOLD)
                ResetRejectBit((DWORD)s1 * (DWORD)SectorsNum + (DWORD)s2);
              if(idist(Vertex[LineDef[i].to],
                       Vertex[LineDef[j].to]) <= THRESHOLD)
                ResetRejectBit((DWORD)s1 * (DWORD)SectorsNum + (DWORD)s2);
              }     // endif Linedef[j].sidedef2 != Nothing
            }       // endif Linedef[j].Used
        }           // endif Linedef[i].sidedef1 != Nothing
      }             // endif Linedef[i].Used

  CURSOR_NOTBUSY
}

