// DoomEd Setup for version 4.03.01

#include "SETUP.h"

#define EXPORT  FAR PASCAL __export

static BOOL     Installed = FALSE;
static char     szModule[128];
static char     szSourceDir[128] = "A:\\";
static char     szDestDir[128] =   "C:\\DoomEd\\";
static char     szFrom[128], szTo[128];
static HCURSOR  oldCursor;
static HDC      hDC;
static HWND     hwnd, hwndInstall;
static HBITMAP  hTitle;
// DDE stuff
static UINT     retval;
static DWORD    idInst = 0L;    // instance identifier
static FARPROC  lpDdeProc;      // procedure instance address


int PASCAL WinMain(HANDLE hInstance,
                   HANDLE hPrevInstance,
                   LPSTR lpszCmdLine,
                   int nCmdShow)
{
  MSG   msg;
  int   nRc;
  int   i, j;

  strcpy(szAppName, "SETUP");
  Ctl3dRegister(hInstance);
  Ctl3dAutoSubclass(hInstance);

  GetModuleFileName(hInstance, szModule, 128);
  for(i = strlen(szModule); i>2; i--)
    if(szModule[i] == '\\') {
      for(j=0; j<(i+1); j++)
        szSourceDir[j] = szModule[j];
      szSourceDir[i+2] = '\0';
      break;
      }
  hInst = hInstance;
  if(!hPrevInstance) {
    if((nRc = nCwRegisterClasses()) == -1) {
       // registering one of the windows failed
       LoadString(hInst, IDS_ERR_REGISTER_CLASS, szString, sizeof(szString));
       MessageBox(NULL, szString, NULL, MB_ICONEXCLAMATION);
       return nRc;    
      }
    }

  // create application's Main window
  hWndMain = CreateWindow(szAppName,            // Window class name
                          NULL,                 // Window's title
                          WS_DLGFRAME     |     // no title bar
                          WS_MAXIMIZE     |     // maximized window
                          WS_CLIPCHILDREN,      // exclude children in redraw
                          CW_USEDEFAULT, 0,
                          CW_USEDEFAULT, 0,
                          NULL,                 // Parent window's handle
                          NULL,                 // Default to Class Menu
                          hInst,                // Instance of window
                          NULL);                // Create struct for WM_CREATE


  if(hWndMain == NULL) {
    LoadString(hInst, IDS_ERR_CREATE_WINDOW, szString, sizeof(szString));
    MessageBox(NULL, szString, NULL, MB_ICONEXCLAMATION);
    return IDS_ERR_CREATE_WINDOW;
    }

  ShowWindow(hWndMain, SW_SHOWMAXIMIZED);   // display main window

  // DDE stuff:
  lpDdeProc = MakeProcInstance((FARPROC) DdeCallback, hInst);
  retval = DdeInitialize(&idInst,                 // receives instance identifier
                         (PFNCALLBACK)lpDdeProc,   // address of callback function
                         APPCLASS_STANDARD |
                         APPCMD_CLIENTONLY, 0L);
  if(retval != DMLERR_NO_ERROR)
    return FALSE;

  hwnd = hWndMain;
  PostMessage(hwnd, WM_COMMAND, IDM_F_INSTALL, 0L);
  hTitle = LoadBitmap(hInstance, MAKEINTRESOURCE(IDB_TITLE));
  
  while(GetMessage(&msg, NULL, 0, 0)) {     // Until WM_QUIT message
    TranslateMessage(&msg);
    DispatchMessage(&msg);
    }

  // Do clean up before exiting
  DeleteObject(hTitle);
  DdeUninitialize(idInst);
  CwUnRegisterClasses();
  Ctl3dUnregister(hInstance);
  return msg.wParam;
}


LONG EXPORT WndProc(HWND   hWnd,   UINT   Message,
                    WPARAM wParam, LPARAM lParam)
{
  HMENU      hMenu=0;           // handle for the menu
  HBITMAP    hBitmap=0;         // handle for bitmaps
  PAINTSTRUCT ps;               // holds PAINT information
  int        nRc=0;             // return code

  switch (Message) {
    case WM_COMMAND:
      switch (wParam) {
        case IDM_F_CONFIGURE:
          {
          FARPROC lpfnCFGMsgProc;
          lpfnCFGMsgProc = MakeProcInstance((FARPROC)CFGMsgProc, hInst); 
          nRc = DialogBox(hInst, MAKEINTRESOURCE(IDD_CONFIGURE),
                          hWnd, lpfnCFGMsgProc);
          FreeProcInstance(lpfnCFGMsgProc);
          }
          break; 

        case IDM_F_INSTALL:
          {
          FARPROC lpfnINSTALLMsgProc;

          lpfnINSTALLMsgProc = MakeProcInstance((FARPROC)INSTALLMsgProc, hInst); 
          nRc = DialogBox(hInst, MAKEINTRESOURCE(IDD_INSTALL),
                          hWnd, lpfnINSTALLMsgProc);
          FreeProcInstance(lpfnINSTALLMsgProc);
          }
          break; 

        case ID_FILE_EXIT:
          if(!Installed) {
            if(MessageBox(hWnd, "DoomEd 4 was not installed.\n"
                                "Are you sure you want to quit?",
                                "Doomed 4 Setup",
                                MB_ICONQUESTION | MB_YESNO) == IDYES)
              PostMessage(hWnd, WM_CLOSE, 0, 0L);
            else
              PostMessage(hwnd, WM_COMMAND, IDM_F_INSTALL, 0L);
            }
          if(Installed)
            PostMessage(hWnd, WM_CLOSE, 0, 0L);
            break; 

        default:
          return DefWindowProc(hWnd, Message, wParam, lParam);
        }
      break;

    case WM_PAINT:
      {
      HBRUSH    hb, ob;
      HPEN      hp, op;
      HDC       hMemDC;
      HBITMAP   old;
      BITMAP    bm;
      memset(&ps, 0x00, sizeof(PAINTSTRUCT));
      hDC = BeginPaint(hWnd, &ps);
      RECT   clientrect;
      GetClientRect(hWndMain, &clientrect);
      float t = (float)clientrect.bottom / (float)256;
      hb = CreateSolidBrush(RGB(0, 0, 0));
      hp = CreatePen(PS_NULL, 0, RGB(0, 0, 0));
      ob = SelectObject(ps.hdc, hb);
      op = SelectObject(ps.hdc, hp);
      Rectangle(ps.hdc, clientrect.left, clientrect.top,
                        clientrect.right, clientrect.bottom);
      SelectObject(ps.hdc, ob);
      SelectObject(ps.hdc, op);
      DeleteObject(hb);
      DeleteObject(hp);
      for(int i = 0; i < 256; i++) {
        hb = CreateSolidBrush(RGB(0, 0, i));
        hp = CreatePen(PS_NULL, 0, RGB(0, 0, 0));
        ob = SelectObject(ps.hdc, hb);
        op = SelectObject(ps.hdc, hp);
        Rectangle(ps.hdc, clientrect.left, int(t * float(i)),
                          clientrect.right, int(t * float(i + 1)) + 4);
        SelectObject(ps.hdc, ob);
        SelectObject(ps.hdc, op);
        DeleteObject(hb);
        DeleteObject(hp);
        }

      GetObject(hTitle, sizeof(BITMAP), &bm);
      hMemDC = CreateCompatibleDC(ps.hdc);
      old = SelectObject(hMemDC, hTitle);
      BitBlt(ps.hdc, 10, 10, bm.bmWidth, bm.bmHeight,
             hMemDC, 0, 0, SRCCOPY);
      SelectObject(hMemDC, old);
      DeleteDC(hMemDC);
      EndPaint(hWnd, &ps);
      }
      break;

    case WM_CLOSE:
      DestroyWindow(hWnd);
      if(hWnd == hWndMain)
        PostQuitMessage(0);
      break;

    default:
      return DefWindowProc(hWnd, Message, wParam, lParam);
    } 
  return 0L;
}

HWND hSource, hDest;

int EXPORT CFGMsgProc(HWND hDlg, UINT Message,
                      WPARAM wParam, LPARAM lParam)
{ 
  switch(Message) {
    case WM_INITDIALOG:
      cwCenter(hDlg, 0);
      hSource = GetDlgItem(hDlg, IDC_SOURCE);
      hDest   = GetDlgItem(hDlg, IDC_DESTINATION);
      Edit_SetText(hSource, szSourceDir);
      Edit_SetText(hDest, szDestDir);
      break;
                           
    case WM_CLOSE:
      PostMessage(hDlg, WM_COMMAND, IDCANCEL, 0L);
      break;
           
    case WM_COMMAND:
      switch(wParam) {
        case IDOK:
          Edit_GetText(hSource, szSourceDir, 128);
          Edit_GetText(hDest, szDestDir, 128);
          if(szSourceDir[strlen(szSourceDir)-1]!='\\')
            strcat(szSourceDir, "\\");
          if(szDestDir[strlen(szDestDir)-1]!='\\')
            strcat(szDestDir, "\\");
          PostMessage(hwnd, WM_COMMAND, IDM_F_INSTALL, 0L);
          EndDialog(hDlg, TRUE);
          break;
        case IDCANCEL:
          PostMessage(hwnd, WM_COMMAND, IDM_F_INSTALL, 0L);
          EndDialog(hDlg, FALSE);
          break;
        }
      break;
                                  
    default:
      return FALSE;
    }
 return TRUE;
}

// Macro for copying files:
#define COPY(a) strcpy(szFrom, szSourceDir);    \
                strcat(szFrom, a);              \
                strcpy(szTo, szDestDir);        \
                strcat(szTo, a);                \
                CopyFile();

// Macro for sending string to ProgMan:
#define Send(a) hglb = GlobalAlloc(GMEM_SHARE, 80);         \
                tttt = (char FAR *)GlobalLock(hglb);        \
                strcpy(tttt, a);                            \
                GlobalUnlock(hglb);                         \
                DdeClientTransaction(tttt,                  \
                                     80,                    \
                                     hconv,                 \
                                     NULL,                  \
                                     CF_TEXT,               \
                                     XTYP_EXECUTE,          \
                                     1000,                  \
                                     NULL);                 \
                GlobalFree(hglb);

static HWND hWinDir, hSysDir, hDestDir, hSrcDir;

int EXPORT INSTALLMsgProc(UINT hDlg, UINT Message,
                          UINT wParam, LONG lParam)
{ 
  char   szTemp[144];
  int    i, j, count;
 
  switch(Message) {
    case WM_INITDIALOG:
      hwndInstall = hDlg;
      cwCenter(hDlg, 0);
      hWinDir  = GetDlgItem(hDlg, IDC_WINDIR);
      hSysDir  = GetDlgItem(hDlg, IDC_SYSDIR);
      hSrcDir  = GetDlgItem(hDlg, IDC_SOURCE);
      hDestDir = GetDlgItem(hDlg, IDC_DESTINATION);
      Static_SetText(hSrcDir, szSourceDir);
      Static_SetText(hDestDir, szDestDir);
      GetWindowsDirectory(szTemp, sizeof(szTemp));
      strcat(szTemp, "\\");
      Static_SetText(hWinDir, szTemp);
      GetSystemDirectory(szTemp, sizeof(szTemp));
      strcat(szTemp, "\\");
      Static_SetText(hSysDir, szTemp);
      break;
                           
    case WM_CLOSE:
      PostMessage(hDlg, WM_COMMAND, IDCANCEL, 0L);
      break;
           
    case WM_COMMAND:
      switch(wParam) {
        case IDC_CONFIG:
          PostMessage(hwnd, WM_COMMAND, IDM_F_CONFIGURE, 0L);
          EndDialog(hDlg, FALSE);
          break;

        case IDOK:
          oldCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
          // Here's where the actual installation takes place:
          // First, create the destination directory as required.
          // since only one directory at a time can be created, we
          // slide along the directory name and create several times
          count = strlen(szDestDir);
          for(i = 3; i < count; i++)
            if(szDestDir[i] == '\\') {
              for(j = 0; j < i; j++)
                szTemp[j] = szDestDir[j];
                szTemp[j] = '\0';
                _mkdir(szTemp);   
                }
          // OK, destination directory exists.
          // Now, copy CTL3DV2.DLL into System Directory:
          strcpy(szFrom, szSourceDir);
          strcat(szFrom, "CTL3DV2.DLL");
          GetSystemDirectory(szTo, sizeof(szTo));
          strcat(szTo, "\\");
          strcat(szTo, "CTL3DV2.DLL");
          CopyFile();

          Installed = TRUE;     // set installed flag.
          COPY("DoomEd.Exe");   // errors during copy will
          COPY("ReadMe.Txt");   // set Installed to FALSE
          COPY("DMatch.Wad");

          if(!Installed)
            return FALSE;
          
          // DDE stuff to ProgMan:
          HSZ   hszService, hszTopic;
          HCONV hconv;
          UINT  uError;

          hszService = DdeCreateStringHandle(idInst, "PROGMAN", CP_WINANSI);
          hszTopic   = DdeCreateStringHandle(idInst, "PROGMAN", CP_WINANSI);

          if((hconv = DdeConnect(idInst, hszService, hszTopic, NULL)) == NULL) {
            // connection not established.
            uError = DdeGetLastError(idInst);
            // no need to disconnect, since connect failed (duh)
            }
          else {
            // connection established: send commands
            HGLOBAL     hglb;
            char        *tttt;
            char        szTemp[255];

            Send("[CreateGroup(\"DoomEd\",\"DOOMED.GRP\")]");
            Send("[ShowGroup(\"DOOMED.GRP\",1)]");
            strcpy(szTemp, "[AddItem(");
            strcat(szTemp, szDestDir);
            strcat(szTemp, "DoomEd.Exe, DoomEd 4)]");
            Send(szTemp);
            strcpy(szTemp, "[AddItem(");
            strcat(szTemp, szDestDir);
            strcat(szTemp, "ReadMe.Txt, Read Me)]");
            Send(szTemp);

            DdeDisconnect(hconv);
            MessageBox(hWndMain, "DoomEd has been installed, and a\n"
                                 "group was added to Program Manager.",
                                 "Doomed 4 Setup",
                                 MB_ICONINFORMATION | MB_OK);
            }

          DdeFreeStringHandle(idInst, hszService);
          DdeFreeStringHandle(idInst, hszTopic);
          SetCursor(oldCursor);
          PostMessage(hwnd, WM_COMMAND, ID_FILE_EXIT, 0L);
          EndDialog(hDlg, TRUE);
          break;

        case IDCANCEL:
          PostMessage(hwnd, WM_COMMAND, ID_FILE_EXIT, 0L);
          EndDialog(hDlg, FALSE);
          break;
        }
      break;
                                  
    default:
      return FALSE;
    }
  return TRUE;
}

int nCwRegisterClasses(void)
{
  WNDCLASS   wndclass;
  memset(&wndclass, 0x00, sizeof(WNDCLASS));

  wndclass.style = CS_HREDRAW | CS_VREDRAW | CS_BYTEALIGNWINDOW;
  wndclass.lpfnWndProc = WndProc;
  wndclass.cbClsExtra = 0;
  wndclass.cbWndExtra = 0;
  wndclass.hInstance = hInst;
  wndclass.hIcon = LoadIcon(NULL, IDI_APPLICATION);
  wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
  wndclass.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
  wndclass.lpszMenuName = NULL;
  wndclass.lpszClassName = szAppName;
  if(!RegisterClass(&wndclass))
    return -1;

  return(0);
}

void cwCenter(HWND hWnd, int top)
{
  POINT      pt;
  RECT       swp;
  RECT       rParent;
  int        iwidth;
  int        iheight;

  GetWindowRect(hWnd, &swp);
  GetClientRect(hWndMain, &rParent);

  iwidth = swp.right - swp.left;
  iheight = swp.bottom - swp.top;

  pt.x = (rParent.right - rParent.left) / 2;
  pt.y = (rParent.bottom - rParent.top) / 2;
  ClientToScreen(hWndMain, &pt);

  pt.x = pt.x - (iwidth / 2);
  pt.y = pt.y - (iheight / 2);

  if(top)
    pt.y = pt.y + top;

  MoveWindow(hWnd, pt.x, pt.y, iwidth, iheight, FALSE);
}

void CwUnRegisterClasses(void)
{
  WNDCLASS   wndclass;
  memset(&wndclass, 0x00, sizeof(WNDCLASS));

  UnregisterClass(szAppName, hInst);
}

void CopyFile(void)
{
  // copy szFrom to szTo
  // both are fully qualified with full pathname.
    
  HGLOBAL  hGlb;
  unsigned char __huge *Buf;
  long     numbytes;
  HFILE    fin, fout;
  char     szTemp[128];
  OFSTRUCT ofstruct;
    
  fin = _lopen(szFrom, OF_READ);
  if(fin != HFILE_ERROR) {
    numbytes = _filelength(fin);
    hGlb = GlobalAlloc(GPTR, numbytes);
    Buf = (unsigned char __huge *)GlobalLock(hGlb);
      
    fout = OpenFile(szTo, &ofstruct, OF_CREATE | OF_WRITE);
    if(fout != HFILE_ERROR) {
      _hread(fin, Buf, numbytes);
      _hwrite(fout, Buf, numbytes);
      }
    else {
      sprintf(szTemp, "Could not open file for writing:\n%s", szTo);
      MessageBox(hWndMain, szTemp, "Setup Error", MB_ICONEXCLAMATION | MB_OK);
      Installed = FALSE;
      }
      
    GlobalUnlock(hGlb);
    GlobalFree(hGlb);
    }
  else {
    sprintf(szTemp, "Could not open file for reading:\n%s", szFrom);
    MessageBox(hWndMain, szTemp, "Setup Error", MB_ICONEXCLAMATION | MB_OK);
    Installed = FALSE;
    }

  _lclose(fin);
  _lclose(fout);
  return;
}

HDDEDATA CALLBACK DdeCallback(UINT type, UINT fmt, HCONV hconv,
                              HSZ hsz1, HSZ hsz2, HDDEDATA hData,
                              DWORD dwData1, DWORD dwData2)
{
  // type     = transaction type
  // fmt      = clipboard data format
  // hconv    = handle of conversation
  // hsz1     = handle of string
  // hsz2     = handle of string
  // hData    = handle of global memory object
  // dwData1  = transaction-specific data
  // dwData2  = transaction-specific data
  return hData;
}

