// Steps support for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

// new steps method:
// user creates a rectangle, selects steps, and divides the
// rectangle as required.

#include "DoomEd40.hpp"

static HWND hLow, hHigh, hStep, hNum, hDir, hRun;
static int  HighHeight = 128, LowHeight = 0, StepHeight = 16,
            NumSteps = 8;
static char RunnerTexture[10];

void DoSteps(void)
{
  FARPROC lpfnDlgProc;
  lpfnDlgProc = MakeProcInstance((FARPROC)DialogSteps, hinst);
  if(lpfnDlgProc) {
    DialogBox(hinst,
              MAKEINTRESOURCE(IDD_STEPS),
              hwnd,
              lpfnDlgProc);
    FreeProcInstance(lpfnDlgProc);
    }
   
}

int EXPORT DialogSteps(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam)
{
  int   i, j;
  BOOL  XlateErr = FALSE;
  HWND  wind = NULL;
  switch(wMsg)
    {
    case WM_INITDIALOG:
      hLow  = GetDlgItem(hDlg, IDC_LOWHEIGHT);
      hHigh = GetDlgItem(hDlg, IDC_HIGHHEIGHT);
      hStep = GetDlgItem(hDlg, IDC_STEPHEIGHT);
      hNum  = GetDlgItem(hDlg, IDC_NUMSTEPS);
      hRun  = GetDlgItem(hDlg, IDC_RUNNERTEXTURE);
      hDir  = GetDlgItem(hDlg, IDC_DIRECTION);
      SetDlgItemInt(hDlg, IDC_LOWHEIGHT,  LowHeight, TRUE);
      SetDlgItemInt(hDlg, IDC_HIGHHEIGHT, HighHeight, TRUE);
      SetDlgItemInt(hDlg, IDC_STEPHEIGHT, StepHeight, TRUE);
      SetDlgItemInt(hDlg, IDC_NUMSTEPS,   NumSteps, TRUE);
      ComboBox_ResetContent(hRun);
      for(i = 0; i < TexturesNum; i++) {
        j = ComboBox_AddString(hRun, Texture[i].name);
        ComboBox_SetItemData(hRun, i, j);
        }
      j = ComboBox_FindStringExact(hRun, 0, "STEP4");
      ComboBox_SetCurSel(hRun, j);
      ComboBox_ResetContent(hDir);
      ComboBox_AddString(hDir, "East");  // 0
      ComboBox_AddString(hDir, "North"); // 1
      ComboBox_AddString(hDir, "West");  // 2
      ComboBox_AddString(hDir, "South"); // 3
      if((SelRect.right - SelRect.left) >
         (SelRect.top - SelRect.bottom))
        ComboBox_SetCurSel(hDir, 0);    // east
      else
        ComboBox_SetCurSel(hDir, 1);    // north
      return TRUE;
      break;

    case WM_COMMAND:
      wind = GetFocus();
      switch (wParam)
        {
        case IDC_STEPHEIGHT:
          {
          int gerb = HIWORD(lParam);
          if((gerb == 1024) && (wind == hStep)) {
            HighHeight = GetDlgItemInt(hDlg, IDC_LOWHEIGHT,  &XlateErr, TRUE);
            LowHeight  = GetDlgItemInt(hDlg, IDC_HIGHHEIGHT, &XlateErr, TRUE);
            StepHeight = GetDlgItemInt(hDlg, IDC_STEPHEIGHT, &XlateErr, TRUE);
            if(StepHeight != 0)
              NumSteps = abs((LowHeight - HighHeight) / StepHeight);
            else
              NumSteps = 0;
            SetDlgItemInt(hDlg, IDC_NUMSTEPS, NumSteps, TRUE);
            }
          }
          return TRUE;
          break;

        case IDC_NUMSTEPS:
          {
          int gerb = HIWORD(lParam);
          if((gerb == 1024) && (wind == hNum)) {
            HighHeight = GetDlgItemInt(hDlg, IDC_LOWHEIGHT,  &XlateErr, TRUE);
            LowHeight  = GetDlgItemInt(hDlg, IDC_HIGHHEIGHT, &XlateErr, TRUE);
            NumSteps   = GetDlgItemInt(hDlg, IDC_NUMSTEPS,   &XlateErr, TRUE);
            if(NumSteps != 0)
              StepHeight = abs((LowHeight - HighHeight) / NumSteps);
            else
              StepHeight = 0;
            SetDlgItemInt(hDlg, IDC_STEPHEIGHT, StepHeight, TRUE);
            }
          }
          return TRUE;
          break;
          
        case IDC_LOWHEIGHT:
          {
          int gerb = HIWORD(lParam);
          if((gerb==1024) && (wind == hLow)) {
            HighHeight = GetDlgItemInt(hDlg, IDC_LOWHEIGHT,  &XlateErr, TRUE);
            LowHeight  = GetDlgItemInt(hDlg, IDC_HIGHHEIGHT, &XlateErr, TRUE);
            StepHeight = GetDlgItemInt(hDlg, IDC_STEPHEIGHT, &XlateErr, TRUE);
            if(StepHeight != 0)
              NumSteps = abs((LowHeight - HighHeight) / StepHeight);
            else
              NumSteps = 0;
            SetDlgItemInt(hDlg, IDC_NUMSTEPS, NumSteps, TRUE);
            }
          }
          return TRUE;
          break;

        case IDC_HIGHHEIGHT:
          {
          int gerb = HIWORD(lParam);
          if((gerb==1024) && (wind == hHigh)) {
            HighHeight = GetDlgItemInt(hDlg, IDC_LOWHEIGHT,  &XlateErr, TRUE);
            LowHeight  = GetDlgItemInt(hDlg, IDC_HIGHHEIGHT, &XlateErr, TRUE);
            StepHeight = GetDlgItemInt(hDlg, IDC_STEPHEIGHT, &XlateErr, TRUE);
            if(StepHeight != 0)
              NumSteps = abs((LowHeight - HighHeight) / StepHeight);
            else
              NumSteps = 0;
            SetDlgItemInt(hDlg, IDC_NUMSTEPS, NumSteps, TRUE);
            }
          }
          return TRUE;
          break;

        case IDOK:
          {
          int  stitchy, stitchx1, stitchx2;
          int  CeilStart;
          if(ShowingSectorRectangle) {
            ShowingSectorRectangle = FALSE;
            HDC rDC = GetDC(hwnd);
            int oldROP = SetROP2(rDC, R2_XORPEN);
            SelectBrush(rDC, hBrushNull);
            SelectPen(rDC, hPenSelected);
            // erase selection rectangle
            Rectangle(rDC, SelRect.left, SelRect.top,
                           SelRect.right, SelRect.bottom);
            SetROP2(rDC, oldROP);
            ReleaseDC(hwnd, rDC);
            BottomMessage("");
            }
          UnSelectAllSectors();
          StepHeight = GetDlgItemInt(hDlg, IDC_STEPHEIGHT, &XlateErr, TRUE);
          NumSteps   = GetDlgItemInt(hDlg, IDC_NUMSTEPS,   &XlateErr, TRUE);
          LowHeight  = GetDlgItemInt(hDlg, IDC_LOWHEIGHT,  &XlateErr, TRUE);
          HighHeight = GetDlgItemInt(hDlg, IDC_HIGHHEIGHT, &XlateErr, TRUE);
          int SizeX = (SelRect.right - SelRect.left);
          int SizeY = (SelRect.top - SelRect.bottom);
          int EachStep, CurHeight, CurX = 0, CurY = 0;
          for(i = 0; i < 10; i++)
            RunnerTexture[i] = '\0';
          j = (int)ComboBox_GetItemData(hRun, (ComboBox_GetCurSel(hRun)));
          strcpy(RunnerTexture, Texture[j].name);
          CeilStart = DefaultSectorTop;
          stitchy  = 0;
          stitchx1 = 0;
          stitchx2 = 0;
          // OK, build the stairs...
          // New, far more efficient than 2.6! - GLA - 09/30/94
          switch(ComboBox_GetCurSel(hDir))
            {
            case 0: // east
              EachStep = SizeX / NumSteps;
              CurHeight = LowHeight;
              CurX = SelRect.left;
              for(i = 0; i < NumSteps; i++) {
                int vtx[4], lin[4];
                int sec = SectorNew();
                CopyWall(Sector[sec].Floor, DefaultSectorFloor);
                CopyWall(Sector[sec].Ceil, DefaultSectorCeil);
                Sector[sec].floorZ = CurHeight;
                Sector[sec].ceilZ = max(CeilStart,
                                        CurHeight + 80 + StepHeight);
                for(j = 0; j < 4; j++) {
                  vtx[j] = VertexNew();
                  lin[j] = LineDefSideDefNew();
                  eVertex[vtx[j]].Moving = TRUE;
                  eLineDef[lin[j]].Moving = TRUE;
                  SideDef[LineDef[lin[j]].sidedef1].sector = sec;
                  }
                // create the vertices:
                Vertex[vtx[0]].x = CurX;
                Vertex[vtx[0]].y = SelRect.top;
                Vertex[vtx[1]].x = CurX + EachStep;
                Vertex[vtx[1]].y = SelRect.top;
                Vertex[vtx[2]].x = CurX + EachStep;
                Vertex[vtx[2]].y = SelRect.bottom;
                Vertex[vtx[3]].x = CurX;
                Vertex[vtx[3]].y = SelRect.bottom;
                // create the lines:
                LineDef[lin[0]].from = vtx[0];
                LineDef[lin[0]].to   = vtx[1];
                LineDef[lin[1]].from = vtx[1];
                LineDef[lin[1]].to   = vtx[2];
                LineDef[lin[2]].from = vtx[2];
                LineDef[lin[2]].to   = vtx[3];
                LineDef[lin[3]].from = vtx[3];
                LineDef[lin[3]].to   = vtx[0];
                // adjust the sidedefs:
                // attach runner texture:
                CopyWall(SideDef[LineDef[lin[1]].sidedef1].t2,
                         RunnerTexture);
                // do stitching:
                stitchy = CeilStart - Sector[sec].ceilZ;
                SideDef[LineDef[lin[0]].sidedef1].x = stitchx1;
                SideDef[LineDef[lin[0]].sidedef1].y = stitchy;
                SideDef[LineDef[lin[2]].sidedef1].x = stitchx2;
                SideDef[LineDef[lin[2]].sidedef1].y = stitchy;
                // change for each step:
                CurHeight += StepHeight;
                CurX      += EachStep;
                stitchx1  += EachStep;
                stitchx2  -= EachStep;
                SelectSector(sec);
                }
              // finally: allow join routine to fix it all.
              break;
            case 1: // north
              EachStep = SizeY / NumSteps;
              CurHeight = LowHeight;
              CurY = SelRect.bottom;
              for(i = 0; i < NumSteps; i++) {
                int vtx[4], lin[4];
                int sec = SectorNew();
                CopyWall(Sector[sec].Floor, DefaultSectorFloor);
                CopyWall(Sector[sec].Ceil, DefaultSectorCeil);
                Sector[sec].floorZ = CurHeight;
                Sector[sec].ceilZ = max(CeilStart,
                                        CurHeight + 80 + StepHeight);
                for(j = 0; j < 4; j++) {
                  vtx[j] = VertexNew();
                  lin[j] = LineDefSideDefNew();
                  eVertex[vtx[j]].Moving = TRUE;
                  eLineDef[lin[j]].Moving = TRUE;
                  SideDef[LineDef[lin[j]].sidedef1].sector = sec;
                  }
                // create the vertices:
                Vertex[vtx[0]].x = SelRect.left;
                Vertex[vtx[0]].y = CurY;
                Vertex[vtx[1]].x = SelRect.left;
                Vertex[vtx[1]].y = CurY + EachStep;
                Vertex[vtx[2]].x = SelRect.right;
                Vertex[vtx[2]].y = CurY + EachStep;
                Vertex[vtx[3]].x = SelRect.right;
                Vertex[vtx[3]].y = CurY;
                // create the lines:
                LineDef[lin[0]].from = vtx[0];
                LineDef[lin[0]].to   = vtx[1];
                LineDef[lin[1]].from = vtx[1];
                LineDef[lin[1]].to   = vtx[2];
                LineDef[lin[2]].from = vtx[2];
                LineDef[lin[2]].to   = vtx[3];
                LineDef[lin[3]].from = vtx[3];
                LineDef[lin[3]].to   = vtx[0];
                // adjust the sidedefs:
                // attach runner texture:
                CopyWall(SideDef[LineDef[lin[1]].sidedef1].t2,
                         RunnerTexture);
                // do stitching:
                stitchy = CeilStart - Sector[sec].ceilZ;
                SideDef[LineDef[lin[0]].sidedef1].x = stitchx1;
                SideDef[LineDef[lin[0]].sidedef1].y = stitchy;
                SideDef[LineDef[lin[2]].sidedef1].x = stitchx2;
                SideDef[LineDef[lin[2]].sidedef1].y = stitchy;
                // change for each step:
                CurHeight += StepHeight;
                CurY      += EachStep;
                stitchx1  += EachStep;
                stitchx2  -= EachStep;
                SelectSector(sec);
                }
              break;
            case 2: // west
              EachStep = SizeX / NumSteps;
              CurHeight = LowHeight;
              CurX = SelRect.right;
              for(i = 0; i < NumSteps; i++) {
                int vtx[4], lin[4];
                int sec = SectorNew();
                CopyWall(Sector[sec].Floor, DefaultSectorFloor);
                CopyWall(Sector[sec].Ceil, DefaultSectorCeil);
                Sector[sec].floorZ = CurHeight;
                Sector[sec].ceilZ = max(CeilStart,
                                        CurHeight + 80 + StepHeight);
                for(j = 0; j < 4; j++) {
                  vtx[j] = VertexNew();
                  lin[j] = LineDefSideDefNew();
                  eVertex[vtx[j]].Moving = TRUE;
                  eLineDef[lin[j]].Moving = TRUE;
                  SideDef[LineDef[lin[j]].sidedef1].sector = sec;
                  }
                // create the vertices:
                Vertex[vtx[0]].x = CurX;
                Vertex[vtx[0]].y = SelRect.bottom;
                Vertex[vtx[1]].x = CurX - EachStep;
                Vertex[vtx[1]].y = SelRect.bottom;
                Vertex[vtx[2]].x = CurX - EachStep;
                Vertex[vtx[2]].y = SelRect.top;
                Vertex[vtx[3]].x = CurX;
                Vertex[vtx[3]].y = SelRect.top;
                // create the lines:
                LineDef[lin[0]].from = vtx[0];
                LineDef[lin[0]].to   = vtx[1];
                LineDef[lin[1]].from = vtx[1];
                LineDef[lin[1]].to   = vtx[2];
                LineDef[lin[2]].from = vtx[2];
                LineDef[lin[2]].to   = vtx[3];
                LineDef[lin[3]].from = vtx[3];
                LineDef[lin[3]].to   = vtx[0];
                // adjust the sidedefs:
                // attach runner texture:
                CopyWall(SideDef[LineDef[lin[1]].sidedef1].t2,
                         RunnerTexture);
                // do stitching:
                stitchy = CeilStart - Sector[sec].ceilZ;
                SideDef[LineDef[lin[0]].sidedef1].x = stitchx1;
                SideDef[LineDef[lin[0]].sidedef1].y = stitchy;
                SideDef[LineDef[lin[2]].sidedef1].x = stitchx2;
                SideDef[LineDef[lin[2]].sidedef1].y = stitchy;
                // change for each step:
                CurHeight += StepHeight;
                CurX      -= EachStep;
                stitchx1  -= EachStep;
                stitchx2  += EachStep;
                SelectSector(sec);
                }
              break;
            case 3: // south
              EachStep = SizeY / NumSteps;
              CurHeight = LowHeight;
              CurY = SelRect.top;
              for(i = 0; i < NumSteps; i++) {
                int vtx[4], lin[4];
                int sec = SectorNew();
                CopyWall(Sector[sec].Floor, DefaultSectorFloor);
                CopyWall(Sector[sec].Ceil, DefaultSectorCeil);
                Sector[sec].floorZ = CurHeight;
                Sector[sec].ceilZ = max(CeilStart,
                                        CurHeight + 80 + StepHeight);
                for(j = 0; j < 4; j++) {
                  vtx[j] = VertexNew();
                  lin[j] = LineDefSideDefNew();
                  eVertex[vtx[j]].Moving = TRUE;
                  eLineDef[lin[j]].Moving = TRUE;
                  SideDef[LineDef[lin[j]].sidedef1].sector = sec;
                  }
                // create the vertices:
                Vertex[vtx[0]].x = SelRect.left;
                Vertex[vtx[0]].y = CurY - EachStep;
                Vertex[vtx[1]].x = SelRect.left;
                Vertex[vtx[1]].y = CurY;
                Vertex[vtx[2]].x = SelRect.right;
                Vertex[vtx[2]].y = CurY;
                Vertex[vtx[3]].x = SelRect.right;
                Vertex[vtx[3]].y = CurY - EachStep;
                // create the lines:
                LineDef[lin[0]].from = vtx[0];
                LineDef[lin[0]].to   = vtx[1];
                LineDef[lin[1]].from = vtx[1];
                LineDef[lin[1]].to   = vtx[2];
                LineDef[lin[2]].from = vtx[2];
                LineDef[lin[2]].to   = vtx[3];
                LineDef[lin[3]].from = vtx[3];
                LineDef[lin[3]].to   = vtx[0];
                // adjust the sidedefs:
                // attach runner texture:
                CopyWall(SideDef[LineDef[lin[3]].sidedef1].t2,
                         RunnerTexture);
                // do stitching:
                stitchy = CeilStart - Sector[sec].ceilZ;
                SideDef[LineDef[lin[0]].sidedef1].x = stitchx2;
                SideDef[LineDef[lin[0]].sidedef1].y = stitchy;
                SideDef[LineDef[lin[2]].sidedef1].x = stitchx1;
                SideDef[LineDef[lin[2]].sidedef1].y = stitchy;
                // change for each step:
                CurHeight += StepHeight;
                CurY      -= EachStep;
                stitchx1  += EachStep;
                stitchx2  -= EachStep;
                SelectSector(sec);
                }
              break;
            default:
              break;
            }
          }
          // make them connect:
          ProcessJoins();
          // make it draw:
          InvalidateRect(hwnd, &SelRect, FALSE);
          EndDialog(hDlg, IDOK);
          return TRUE;
          break;

        case IDCANCEL:
          // don't change anything
          if(ShowingSectorRectangle) {
            ShowingSectorRectangle = FALSE;
            HDC rDC = GetDC(hwnd);
            int oldROP = SetROP2(rDC, R2_XORPEN);
            SelectBrush(rDC, hBrushNull);
            SelectPen(rDC, hPenSelected);
            // erase selection rectangle
            Rectangle(rDC, SelRect.left, SelRect.top,
                           SelRect.right, SelRect.bottom);
            SetROP2(rDC, oldROP);
            ReleaseDC(hwnd, rDC);
            BottomMessage("");
            }
          EndDialog(hDlg, IDCANCEL);
          return TRUE;
          break;

        default:
          return FALSE;
          break;
        }
    default:
      return FALSE;
    }
}

