/*
 *  BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
 *  Copyright (C) 1993  Hartmut Schirmer
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *  Contact :                Hartmut Schirmer
 *                           Feldstrasse 118
 *                    D-2300 Kiel 1
 *                           Germany
 *
 *                    No telephone calls please !
 *
 *           NOTE : Please use ZIP 24105 after July 1 1993 !!
 *           
 *
 *  Changes :  940505 (Per Allansson c91peral@und.ida.liu.se)
 *
 *              see 'changes'
 */

#define __BCCGRX_C

#include "bccgrx00.h"
#include <malloc.h>

/* ----------------------------------------------------------------- */

int           __gr_Mode = 0;                    /* actual graphics mode     */
int           __gr_INIT = FALSE;                /* TRUE after initgraph()   */
char          __gr_BGICHR[128];                 /* Path to .chr files       */
int           __gr_MaxMode = 0;                 /* Last available mode      */
int           __gr_Result = grOk;               /* stores error code        */
int           __gr_X, __gr_Y;                   /* graphics cursor pos      */
int           __gr_vpl, __gr_vpt,               /* actual viewport          */
	      __gr_vpr, __gr_vpb;
int           __gr_color;                       /* drawing color            */
int           __gr_colorbg;                     /* background color         */
int           __gr_colorfill;                   /* fill color               */
int           __gr_WR = GrWRITE;                /* Write mode               */
int           __gr_lstyle = SOLID_LINE;         /* Actual line style        */
int           __gr_fpatno = SOLID_FILL;         /* Actual filling pattern   */
int           __gr_Xasp = 10000;                /* Aspect ratio             */
int           __gr_Yasp = 10000;
int           __gr_clip = TRUE;                 /* actual clipping state    */
int           __gr_ADAPTER = GR_VGA;            /* Adapter used             */

short         *__gr_modeindx = NULL;            /* mode # -> driver mode    */
GR_DRIVER_MODE_ENTRY *__gr_DATA;                /* ptr to driver mode data  */
GrPattern     __gr_fillpattern;                 /* GRX filling settings     */
GrLineOption  __gr_Line;                        /* GRX line settings        */

char __gr_fpatterns[][8] = {                    /* BGI fill patterns        */
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},   /* EMPTY_FILL        */
  { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF},   /* SOLID_FILL        */
  { 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00},   /* LINE_FILL         */
  { 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80},   /* LTSLASH_FILL      */
  { 0xE0, 0xC1, 0x83, 0x07, 0x0E, 0x1C, 0x38, 0x70},   /* SLASH_FILL        */
  { 0xF0, 0x78, 0x3C, 0x1E, 0x0F, 0x87, 0xC3, 0xE1},   /* BKSLASH_FILL      */
  { 0xA5, 0xD2, 0x69, 0xB4, 0x5A, 0x2D, 0x96, 0x4B},   /* LTBKSLASH_FILL    */
  { 0xFF, 0x88, 0x88, 0x88, 0xFF, 0x88, 0x88, 0x88},   /* HATCH_FILL        */
  { 0x81, 0x42, 0x24, 0x18, 0x18, 0x24, 0x42, 0x81},   /* XHATCH_FILL       */
  { 0xCC, 0x33, 0xCC, 0x33, 0xCC, 0x33, 0xCC, 0x33},   /* INTERLEAVE_FILL   */
  { 0x80, 0x00, 0x08, 0x00, 0x80, 0x00, 0x08, 0x00},   /* WIDE_DOT_FILL     */
  { 0x88, 0x00, 0x22, 0x00, 0x88, 0x00, 0x22, 0x00},   /* CLOSE_DOT_FILL    */
  { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF}    /* USER_FILL         */
};

int __gr_BGI_w = 640; /* resulution and colors needed to emulate */
int __gr_BGI_h = 480; /* BGI driver modes                        */
int __gr_BGI_c = 16;  /* default : Standard VGA                  */

/* ----------------------------------------------------------------- */

void __gr_set_up_modes(void)
{
  GR_DRIVER_MODE_ENTRY *tm, *gm;
  int mode;
  static int DidInit = FALSE;

  if (DidInit) return;

  MM = 1;
  GrSetMode( GrCurrentMode());                       /* Init grx */
  __gr_ADAPTER = GrAdapterType();
  if (__gr_ADAPTER == GR_S3)
    __gr_ADAPTER = GR_VGA;
  GrGetDriverModes(&tm, &__gr_DATA);
  if (__gr_DATA == NULL) {       /* Will happen with .GRD drivers */
    __gr_modeindx = NULL;
    DidInit = TRUE;
    return;
  }
  gm = __gr_DATA;
  mode = __FIRST_DRIVER_SPECIFIC_MODE-1;
  while (gm->width != 0) {
    if (gm->mode.grn.BIOS_mode != 0xFF)
      ++mode;
    gm += 1;
  }
  __gr_modeindx = (short *) malloc(sizeof(short) * mode);
  if (__gr_modeindx == NULL) {
    DidInit = TRUE;   /* Handle no mem like .GRD driver */
    return;           /* should never (??) occur ...    */
  }
  __gr_modeindx[0] = -1;  /* GR_default_graphics               */
  __gr_modeindx[1] = -2;  /* GR_biggest_noninterlaced_graphics */
  __gr_modeindx[2] = -3;  /* GR_biggest_graphics               */
  __gr_modeindx[3] = -4;  /* BGI emulation                     */
  gm = __gr_DATA;
  mode = __FIRST_DRIVER_SPECIFIC_MODE-1;
  while (gm->width != 0) {
    if (gm->mode.grn.BIOS_mode != 0xFF)
      __gr_modeindx[++mode] = gm-__gr_DATA;
    gm += 1;
  }
  MM = mode;
  DidInit = TRUE;
}

/* ----------------------------------------------------------------- */
void graphdefaults(void)
{
  ERR          = grOk;
  moveto( 0, 0);
  COL = FILL   = GrWhite();
  COLBG        = GrBlack();
  __gr_WR      = GrWRITE;

  _DO_INIT_CHECK;
  GrSetContext( NULL);         /* ViewPort == Full screen */
  VL = VT = 0;
  VR = getmaxx();
  VB = getmaxy();
  __gr_clip = TRUE;

  __gr_lstyle     = SOLID_LINE;
  LNE.lno_pattlen = 0;
  LNE.lno_dashpat = NULL;
  LNE.lno_width   = 1;

  FPATT = SOLID_FILL;
  FILLP.gp_ispixmap    = 0;    /* Bitmap fill pattern */
  FILLP.gp_bmp_data    = (unsigned char *)&__gr_fpatterns[FPATT];
  FILLP.gp_bmp_height  = 8;
  FILLP.gp_bmp_fgcolor = COL;
  FILLP.gp_bmp_bgcolor = COLBG;
}

/* ----------------------------------------------------------------- */
void detectgraph(int *graphdriver,int *graphmode)
{
  __gr_set_up_modes();
  *graphdriver = __gr_ADAPTER;  /* set by _gr_set_up_modes () */
  *graphmode     = 0;           /* Default graphics mode      */
}

/* ----------------------------------------------------------------- */
void setgraphmode(int mode)
{
  GR_DRIVER_MODE_ENTRY *gm;

  _DO_INIT_CHECK;
  switch (mode) {
    case GRX_DEFAULT_GRAPHICS:
      GrSetMode( GR_default_graphics);
      break;
    case GRX_BIGGEST_NONINTERLACED_GRAPHICS:
      GrSetMode( GR_biggest_noninterlaced_graphics);
      break;
    case GRX_BIGGEST_GRAPHICS:
      GrSetMode( GR_biggest_graphics);
      break;
    case GRX_BGI_EMULATION:
      GrSetMode( GR_width_height_color_graphics,
		  __gr_BGI_w, __gr_BGI_h, __gr_BGI_c);
      break;
    default:
      if (mode < __FIRST_DRIVER_SPECIFIC_MODE || mode > MM) {
	ERR = grInvalidMode;
	return;
      }
      gm = __gr_DATA+__gr_modeindx[mode];
      GrSetMode( GR_width_height_color_graphics,
		 gm->width, gm->height, gm->number_of_colors);
      break;
  }
  __gr_Mode = mode;
  graphdefaults();
  GrClearScreen(BLACK);
}

/* ----------------------------------------------------------------- */
void initgraph(int *graphdriver, int *graphmode, char *pathtodriver)
{
  ERR = grOk;
  if (!__gr_INIT) {
    __gr_set_up_modes();
    if (ERR != grOk) return;
    if ( *graphdriver != NATIVE_GRX || *graphmode < 0 || *graphmode > MM)
	*graphmode = 0;
    __gr_INIT = TRUE;
    setgraphmode(*graphmode);
    if (ERR != grOk) {
      __gr_INIT = FALSE;
      return;
    }
  }
  if (*graphmode == 0) *graphdriver = __gr_ADAPTER;
		  else *graphdriver = NATIVE_GRX;
  strcpy( __gr_BGICHR, pathtodriver);
}

