/*
 *  BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
 *  Copyright (C) 1993  Hartmut Schirmer
 *
 *  see bccgrx.c for details
 */

#include "bccgrx00.h"

static struct arccoordstype  ac;

/* ----------------------------------------------------------------- */
void ellipse(int x, int y, int stangle, int endangle, int xradius, int yradius)
{
  _DO_INIT_CHECK;
  GrEllipseArc(x+VL,y+VT,XR(xradius),YR(yradius),stangle*10,endangle*10, COL);
  ac.x      = _grx_arc_xc - VL;
  ac.y      = _grx_arc_yc - VT;
  ac.xstart = _grx_arc_xs - VL;
  ac.ystart = _grx_arc_ys - VT;
  ac.xend   = _grx_arc_xe - VL;
  ac.yend   = _grx_arc_ye - VT;
}

/* ----------------------------------------------------------------- */
void getarccoords(struct arccoordstype  *arccoords)
{
  _DO_INIT_CHECK;
  memcpy( arccoords, &ac, sizeof(ac));
}

