/*----------------------------------------------------------------------------*
 | This file is part of DEU (Doom Editing Utilities), created by the DEU team:|
 | Raphael Quinet, Brendon Wyber, Ted Vessenes and others.  See README.1ST or |
 | the "about" dialog box for full credits.                                   |
 |                                                                            |
 | DEU is an open project: if you think that you can contribute, please join  |
 | the DEU team.  You will be credited for any code (or ideas) included in    |
 | the next version of the program.                                           |
 |                                                                            |
 | If you want to make any modifications and re-distribute them on your own,  |
 | you must follow the conditions of the DEU license.  Read the file LICENSE  |
 | in this directory or README.1ST in the top directory.  If do not have a    |
 | copy of these files, you can request them from any member of the DEU team, |
 | or by mail: Raphael Quinet, Rue des Martyrs 9, B-4550 Nandrin (Belgium).   |
 |                                                                            |
 | This program comes with absolutely no warranty.  Use it at your own risks! |
 *----------------------------------------------------------------------------*

 G_MOUWAT.C - Mouse driver for Watcom C

 Functions written by Aaron Faircloth
*/

/* the includes */
#include "deu.h"
#include <dos.h>
#include <i86.h>
#include "g_gfx.h"
#include "g_mouse.h"

/* mouse interrupt number */
#define MOUSE 0x33

/* the global data */
Bool UseMouse = FALSE;                  /* is there a mouse driver? */


/*
   Initialize the mouse driver.
*/

void InitMouseDriver(void)
{
  union REGS regs;

  regs.w.ax = 0x0000;
  int386(MOUSE, &regs, &regs);
  if (regs.w.ax == 0xffff)
    {
      UseMouse = TRUE; /* mouse */
      /*! change the pointer shape & color */
    }
  else
    UseMouse = FALSE; /* no mouse */
}



/*
   Show the pointer.
*/

void ShowMousePointer(void)
{
  union REGS regs;

  regs.w.ax = 0x0001;
  int386(MOUSE, &regs, &regs);
}



/*
   Hide the pointer.
*/

void HideMousePointer(void)
{
  union REGS regs;

  regs.w.ax = 0x0002;
  int386(MOUSE, &regs, &regs);
}


/*
   Read pointer coordinates.
*/

void GetMouseCoords(UInt16 *x, UInt16 *y, UInt16 *buttons)
{
  union REGS regs;

  regs.w.ax = 0x0003;
  int386(MOUSE, &regs, &regs);
  if (x != NULL)
    *x = regs.w.cx;
  if (y != NULL)
    *y = regs.w.dx;
  if (buttons != NULL)
    *buttons = regs.w.bx;
}


/*
   Change pointer coordinates.
*/

void SetMouseCoords(UInt16 x, UInt16 y)
{
  union REGS regs;

  regs.w.ax = 0x0004;
  regs.w.cx = x;
  regs.w.dx = y;
  int386(MOUSE, &regs, &regs);
}



/*
   Set horizontal and vertical limits (constrain pointer in a box).
*/

void SetMouseLimits(UInt16 x0, UInt16 y0, UInt16 x1, UInt16 y1)
{
  union REGS regs;

  regs.w.ax = 0x0007;
  regs.w.cx = x0;
  regs.w.dx = x1;
  int386(MOUSE, &regs, &regs);
  regs.w.ax = 0x0008;
  regs.w.cx = y0;
  regs.w.dx = y1;
  int386(MOUSE, &regs, &regs);
}



/*
   Reset horizontal and vertical limits.
*/

void ResetMouseLimits(void)
{
  union REGS regs;

  regs.w.ax = 0x0007;
  regs.w.cx = 0;
  regs.w.dx = ScrMaxX;
  int386(MOUSE, &regs, &regs);
  regs.w.ax = 0x0008;
  regs.w.cx = 0;
  regs.w.dx = ScrMaxY;
  int386(MOUSE, &regs, &regs);
}


/* end of file */
