/*! ... under construction ... */
#ifndef NEW_CODE
#error You should not compile this file!  Remove it from the Makefile/Project.
#endif

/*! The new code should be cleaner: no references to other parts of DEU,
    except for the graphics stuff.  This should be a generic interface for
    window systems.
    The extra info needed by the editors is hidden in the "info" field (using
    type casting when necessary).
*/

#ifndef _I_WINDOW_H_
#define _I_WINDOW_H_

#ifndef NEW_CODE
#include "d_misc.h"   /* SelPtr */
#include "w_levels.h" /* LevelPtr */
#endif

/* window types */
#define WINTYPE_NONE    0  /* window does not exist (free slot) */
#define WINTYPE_HEXDUMP 1  /* hex editor for unknown lumps */
#define WINTYPE_MAP     2  /* map editor */
#define WINTYPE_PICTURE 3  /* picture editor (sprite, wall patch, bitmap) */
#define WINTYPE_TEXTURE 4  /* texture editor (assembling wall patches) */

/* window info */
typedef struct
{
#ifdef NEW_CODE
  void *info;    /* pointer to some additional info, depending on the type of
                    window (ex: the map editor casts this to a MapInfoPtr) */
#else
  int type;      /* type of window: see symbols defined above */
  union          /* internal info for the window, depending on its type */
  {
    struct              /* - for WINTYPE_HEXDUMP */
      {
        int      junk;         /*! lump pointer, offset */
      } hexdump;
    struct              /* - for WINTYPE_MAP */
      {
        LevelPtr level;        /* level being edited in this window */
        int      edit_mode;    /* current editing mode (object type) */
        SelPtr   selected;     /* list of selected objects */
        int      grid_scale;   /* scale of the grid (0 = no grid) */
        Bool     grid_shown;   /* TRUE if the grid is drawn */
        Bool     show_rulers;  /* TRUE if the rulers are displayed */
        int      thing_mask;   /* mask for drawing things (D12 D3 D45 !Net) */
      } map;
    struct              /* - for WINTYPE_PICTURE */
      {
        int      junk;         /*! pic. lump ptr, current drawing tool */
      } picture;
    struct              /* - for WINTYPE_TEXTURE */
      {
        int      junk;         /*! tex. lump ptr, current wall patch ptr */
      } texture;
  } info;
#endif

  char *title;   /* title of the window (displayed in the title bar and
                    in the menu of "children" of the main window) */
  Int16 width;   /* width of the window */
  Int16 height;  /* height of the window */

  /*! ... */     /* menu definition (menu bar + pulldown menus) */

  void (*redraw_callback)(int window_num);
                 /* function to be called when the window has to be redrawn */
  void (*action_callback)(int window_num, UInt16 key);
                 /* function to be called when a key is pressed or a mouse
                    button is pressed or released */
  void (*mousem_callback)(int window_num);
                 /* function to be called when the mouse is moved (should
                    be NULL most of the time) */
  Bool (*close_callback)(int window_num);
                 /* function to be called when the user wants to close the
                    window (close aborted if the function returns FALSE) */
} WindowInfo;

/* public variable */
extern WindowInfo win_info[];

/* prototypes */
void InitWindows(void);
int CreateNewWindow(int type, char *title /*! + menu definition */);
void RaiseWindow(int win_num);
void RedrawWindow(int win_num);
Bool CloseWindow(int win_num);

void RegisterRedrawCB(int win_num, void (*redrawCB)(int window_num));
void RegisterActionCB(int win_num, void (*actionCB)(int window_num, UInt16 key));
void RegisterMousemCB(int win_num, void (*mousemCB)(int window_num));
void RegisterCloseCB(int win_num, Bool (*closeCB)(int window_num));

#endif /* _I_WINDOW_H_ */
/* end of file */
