/*----------------------------------------------------------------------------*
 | This file is part of DEU (Doom Editing Utilities), created by the DEU team:|
 | Raphael Quinet, Brendon Wyber, Ted Vessenes and others.  See README.1ST or |
 | the "about" dialog box for full credits.                                   |
 |                                                                            |
 | DEU is an open project: if you think that you can contribute, please join  |
 | the DEU team.  You will be credited for any code (or ideas) included in    |
 | the next version of the program.                                           |
 |                                                                            |
 | If you want to make any modifications and re-distribute them on your own,  |
 | you must follow the conditions of the DEU license.  Read the file LICENSE  |
 | in this directory or README.1ST in the top directory.  If do not have a    |
 | copy of these files, you can request them from any member of the DEU team, |
 | or by mail: Raphael Quinet, Rue des Martyrs 9, B-4550 Nandrin (Belgium).   |
 |                                                                            |
 | This program comes with absolutely no warranty.  Use it at your own risks! |
 *----------------------------------------------------------------------------*

 M_EDMENU.H

*/

#ifndef _M_EDMENU_H_
#define _M_EDMENU_H_

#include "w_levels.h"

/* prototypes */
void CheckLevel(LevelPtr level, Int16 x0, Int16 y0);
void InsertStandardObject(LevelPtr level, Int16 x0, Int16 y0, Int16 xpos, Int16 ypos);
void MiscOperations(LevelPtr level, Int16 x0, Int16 y0, int objtype, SelPtr *list);
void Preferences(Int16 x0, Int16 y0);

Bool Input2Numbers(Int16 x0, Int16 y0, char *name1, char *name2,
                   Int16 v1max, Int16 v2max, Int16 *v1, Int16 *v2);

#endif /* _M_EDMENU_H_ */
/* end of file */
