/*----------------------------------------------------------------------------*
 | This file is part of DEU (Doom Editing Utilities), created by the DEU team:|
 | Raphael Quinet, Brendon Wyber, Ted Vessenes and others.  See README.1ST or |
 | the "about" dialog box for full credits.                                   |
 |                                                                            |
 | DEU is an open project: if you think that you can contribute, please join  |
 | the DEU team.  You will be credited for any code (or ideas) included in    |
 | the next version of the program.                                           |
 |                                                                            |
 | If you want to make any modifications and re-distribute them on your own,  |
 | you must follow the conditions of the DEU license.  Read the file LICENSE  |
 | in this directory or README.1ST in the top directory.  If do not have a    |
 | copy of these files, you can request them from any member of the DEU team, |
 | or by mail: Raphael Quinet, Rue des Martyrs 9, B-4550 Nandrin (Belgium).   |
 |                                                                            |
 | This program comes with absolutely no warranty.  Use it at your own risks! |
 *----------------------------------------------------------------------------*

 M_OBJECT.H

*/

#ifndef _M_OBJECT_H_
#define _M_OBJECT_H_

#include "w_levels.h"

/* prototypes */
void FlipLineDefs(LevelPtr level, SelPtr list, Bool swapvertices);

void DeleteVerticesJoinLineDefs(LevelPtr level, SelPtr list);
void MergeVertices(LevelPtr level, SelPtr *listp);
Bool AutoMergeVertices(LevelPtr level, SelPtr *listp);
void SplitLineDefs(LevelPtr level, SelPtr list);
void SplitSector(LevelPtr level, Int16 vertex1, Int16 vertex2);
void SplitLineDefsAndSector(LevelPtr level, Int16 linedef1, Int16 linedef2);
void MergeSectors(LevelPtr level, SelPtr *listp);
void DeleteLineDefsJoinSectors(LevelPtr level, SelPtr *ldlistp);

void CreateLineDefs(LevelPtr level, SelPtr *vlist);
void CreateSector(LevelPtr level, SelPtr *ldlist);

void MakeDoorFromSector(LevelPtr level, Int16 sector);
void MakeWindowFromSector(LevelPtr level, Int16 sector);
void MakeLiftFromSector(LevelPtr level, Int16 sector);
void DistributeSectorFloors(LevelPtr level, SelPtr obj);
void DistributeSectorCeilings(LevelPtr level, SelPtr obj);
void DistributeSectorLights(LevelPtr level, SelPtr obj);

#endif /* _M_OBJECT_H_ */
/* end of file */
