/*----------------------------------------------------------------------------*
 | This file is part of DEU (Doom Editing Utilities), created by the DEU team:|
 | Raphael Quinet, Brendon Wyber, Ted Vessenes and others.  See README.1ST or |
 | the "about" dialog box for full credits.                                   |
 |                                                                            |
 | DEU is an open project: if you think that you can contribute, please join  |
 | the DEU team.  You will be credited for any code (or ideas) included in    |
 | the next version of the program.                                           |
 |                                                                            |
 | If you want to make any modifications and re-distribute them on your own,  |
 | you must follow the conditions of the DEU license.  Read the file LICENSE  |
 | in this directory or README.1ST in the top directory.  If do not have a    |
 | copy of these files, you can request them from any member of the DEU team, |
 | or by mail: Raphael Quinet, Rue des Martyrs 9, B-4550 Nandrin (Belgium).   |
 |                                                                            |
 | This program comes with absolutely no warranty.  Use it at your own risks! |
 *----------------------------------------------------------------------------*

 W_LEVELS.H

*/

#ifndef _W_LEVELS_H_
#define _W_LEVELS_H_

/* the includes */
#include "w_struct.h"

/* the global variables and typedefs */
struct LevelInfo
{
  /*! The "dir" field should be replaced by something else when the main
      directory is removed from DEU */
  MDirPtr dir;          /* master directory entry for the level (ExMy, MAPnn) */

  UInt16  num_things;   /* number of things */
  TPtr    things;       /* things data */
  UInt16  num_linedefs; /* number of line defs */
  LDPtr   linedefs;     /* line defs data */
  UInt16  num_sidedefs; /* number of side defs */
  SDPtr   sidedefs;     /* side defs data */
  UInt16  num_vertexes; /* number of vertexes */
  VPtr    vertexes;     /* vertex data */
  UInt16  num_sectors;  /* number of sectors */
  SPtr    sectors;      /* sectors data */

  Int16   map_maxX;     /* maximum X value of map */
  Int16   map_maxY;     /* maximum Y value of map */
  Int16   map_minX;     /* minimum X value of map */
  Int16   map_minY;     /* minimum Y value of map */

  Bool    made_changes; /* made changes? */
  Bool    made_map_changes; /* made changes that need rebuilding? */

  char   *undo_operation; /* description of the last operation */
  struct LevelInfo *undo_buffer; /* copy of the level for undo/redo */
};
typedef struct LevelInfo *LevelPtr;

/*! the following variables are likely to change (new texture handling) */
extern UInt16  num_wtexture;    /* number of wall textures */
extern char  **wtexture;        /* array of wall texture names */
extern UInt16  num_ftexture;    /* number of floor/ceiling textures */
extern char  **ftexture;        /* array of texture names */

/* the function prototypes */
LevelPtr CreateNewLevel(char *mapname);
void ForgetLevelData(LevelPtr level);
char *GetLevelMapName(LevelPtr level);
char *GetLevelFileName(LevelPtr level);
LevelPtr LoadLevelData(char *mapname, char *wadfile);
Bool MergeLevelData(LevelPtr level, char *mapname, char *wadfile);
void QuickSaveLevelData(LevelPtr level, char *tmpfile);
void SaveLevelData(LevelPtr level, char *origfile, char *outfile);
/*! the following prototypes are likely to change (new texture handling) */
int  SortTextures(const void *a, const void *b);
void ReadWTextureNames(void);
void ForgetWTextureNames(void);
void ReadFTextureNames(void);
void ForgetFTextureNames(void);

#endif /* _W_LEVELS_H_ */
/* end of file */
